/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBackupPlansResponse extends BackupResponse implements
        ToCopyableBuilder<ListBackupPlansResponse.Builder, ListBackupPlansResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBackupPlansResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<BackupPlansListMember>> BACKUP_PLANS_LIST_FIELD = SdkField
            .<List<BackupPlansListMember>> builder(MarshallingType.LIST)
            .memberName("BackupPlansList")
            .getter(getter(ListBackupPlansResponse::backupPlansList))
            .setter(setter(Builder::backupPlansList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlansList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackupPlansListMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackupPlansListMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            BACKUP_PLANS_LIST_FIELD));

    private final String nextToken;

    private final List<BackupPlansListMember> backupPlansList;

    private ListBackupPlansResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.backupPlansList = builder.backupPlansList;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BackupPlansList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBackupPlansList() {
        return backupPlansList != null && !(backupPlansList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of backup plan list items containing metadata about your saved backup plans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupPlansList} method.
     * </p>
     * 
     * @return An array of backup plan list items containing metadata about your saved backup plans.
     */
    public final List<BackupPlansListMember> backupPlansList() {
        return backupPlansList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupPlansList() ? backupPlansList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupPlansResponse)) {
            return false;
        }
        ListBackupPlansResponse other = (ListBackupPlansResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasBackupPlansList() == other.hasBackupPlansList()
                && Objects.equals(backupPlansList(), other.backupPlansList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBackupPlansResponse").add("NextToken", nextToken())
                .add("BackupPlansList", hasBackupPlansList() ? backupPlansList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "BackupPlansList":
            return Optional.ofNullable(clazz.cast(backupPlansList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupPlansResponse, T> g) {
        return obj -> g.apply((ListBackupPlansResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBackupPlansResponse> {
        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of backup plan list items containing metadata about your saved backup plans.
         * </p>
         * 
         * @param backupPlansList
         *        An array of backup plan list items containing metadata about your saved backup plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlansList(Collection<BackupPlansListMember> backupPlansList);

        /**
         * <p>
         * An array of backup plan list items containing metadata about your saved backup plans.
         * </p>
         * 
         * @param backupPlansList
         *        An array of backup plan list items containing metadata about your saved backup plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlansList(BackupPlansListMember... backupPlansList);

        /**
         * <p>
         * An array of backup plan list items containing metadata about your saved backup plans.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BackupPlansListMember>.Builder} avoiding
         * the need to create one manually via {@link List<BackupPlansListMember>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BackupPlansListMember>.Builder#build()} is called
         * immediately and its result is passed to {@link #backupPlansList(List<BackupPlansListMember>)}.
         * 
         * @param backupPlansList
         *        a consumer that will call methods on {@link List<BackupPlansListMember>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupPlansList(List<BackupPlansListMember>)
         */
        Builder backupPlansList(Consumer<BackupPlansListMember.Builder>... backupPlansList);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<BackupPlansListMember> backupPlansList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupPlansResponse model) {
            super(model);
            nextToken(model.nextToken);
            backupPlansList(model.backupPlansList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BackupPlansListMember.Builder> getBackupPlansList() {
            List<BackupPlansListMember.Builder> result = BackupPlansListCopier.copyToBuilder(this.backupPlansList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackupPlansList(Collection<BackupPlansListMember.BuilderImpl> backupPlansList) {
            this.backupPlansList = BackupPlansListCopier.copyFromBuilder(backupPlansList);
        }

        @Override
        @Transient
        public final Builder backupPlansList(Collection<BackupPlansListMember> backupPlansList) {
            this.backupPlansList = BackupPlansListCopier.copy(backupPlansList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder backupPlansList(BackupPlansListMember... backupPlansList) {
            backupPlansList(Arrays.asList(backupPlansList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder backupPlansList(Consumer<BackupPlansListMember.Builder>... backupPlansList) {
            backupPlansList(Stream.of(backupPlansList).map(c -> BackupPlansListMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBackupPlansResponse build() {
            return new ListBackupPlansResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
