/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReportJobsRequest extends BackupRequest implements
        ToCopyableBuilder<ListReportJobsRequest.Builder, ListReportJobsRequest> {
    private static final SdkField<String> BY_REPORT_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByReportPlanName").getter(getter(ListReportJobsRequest::byReportPlanName))
            .setter(setter(Builder::byReportPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ReportPlanName").build())
            .build();

    private static final SdkField<Instant> BY_CREATION_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ByCreationBefore").getter(getter(ListReportJobsRequest::byCreationBefore))
            .setter(setter(Builder::byCreationBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CreationBefore").build())
            .build();

    private static final SdkField<Instant> BY_CREATION_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ByCreationAfter").getter(getter(ListReportJobsRequest::byCreationAfter))
            .setter(setter(Builder::byCreationAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CreationAfter").build()).build();

    private static final SdkField<String> BY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByStatus").getter(getter(ListReportJobsRequest::byStatus)).setter(setter(Builder::byStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Status").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListReportJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListReportJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BY_REPORT_PLAN_NAME_FIELD,
            BY_CREATION_BEFORE_FIELD, BY_CREATION_AFTER_FIELD, BY_STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String byReportPlanName;

    private final Instant byCreationBefore;

    private final Instant byCreationAfter;

    private final String byStatus;

    private final Integer maxResults;

    private final String nextToken;

    private ListReportJobsRequest(BuilderImpl builder) {
        super(builder);
        this.byReportPlanName = builder.byReportPlanName;
        this.byCreationBefore = builder.byCreationBefore;
        this.byCreationAfter = builder.byCreationAfter;
        this.byStatus = builder.byStatus;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Returns only report jobs with the specified report plan name.
     * </p>
     * 
     * @return Returns only report jobs with the specified report plan name.
     */
    public final String byReportPlanName() {
        return byReportPlanName;
    }

    /**
     * <p>
     * Returns only report jobs that were created before the date and time specified in Unix format and Coordinated
     * Universal Time (UTC). For example, the value 1516925490 represents Friday, January 26, 2018 12:11:30 AM.
     * </p>
     * 
     * @return Returns only report jobs that were created before the date and time specified in Unix format and
     *         Coordinated Universal Time (UTC). For example, the value 1516925490 represents Friday, January 26, 2018
     *         12:11:30 AM.
     */
    public final Instant byCreationBefore() {
        return byCreationBefore;
    }

    /**
     * <p>
     * Returns only report jobs that were created after the date and time specified in Unix format and Coordinated
     * Universal Time (UTC). For example, the value 1516925490 represents Friday, January 26, 2018 12:11:30 AM.
     * </p>
     * 
     * @return Returns only report jobs that were created after the date and time specified in Unix format and
     *         Coordinated Universal Time (UTC). For example, the value 1516925490 represents Friday, January 26, 2018
     *         12:11:30 AM.
     */
    public final Instant byCreationAfter() {
        return byCreationAfter;
    }

    /**
     * <p>
     * Returns only report jobs that are in the specified status. The statuses are:
     * </p>
     * <p>
     * <code>CREATED | RUNNING | COMPLETED | FAILED</code>
     * </p>
     * 
     * @return Returns only report jobs that are in the specified status. The statuses are:</p>
     *         <p>
     *         <code>CREATED | RUNNING | COMPLETED | FAILED</code>
     */
    public final String byStatus() {
        return byStatus;
    }

    /**
     * <p>
     * The number of desired results from 1 to 1000. Optional. If unspecified, the query will return 1 MB of data.
     * </p>
     * 
     * @return The number of desired results from 1 to 1000. Optional. If unspecified, the query will return 1 MB of
     *         data.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(byReportPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(byCreationBefore());
        hashCode = 31 * hashCode + Objects.hashCode(byCreationAfter());
        hashCode = 31 * hashCode + Objects.hashCode(byStatus());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportJobsRequest)) {
            return false;
        }
        ListReportJobsRequest other = (ListReportJobsRequest) obj;
        return Objects.equals(byReportPlanName(), other.byReportPlanName())
                && Objects.equals(byCreationBefore(), other.byCreationBefore())
                && Objects.equals(byCreationAfter(), other.byCreationAfter()) && Objects.equals(byStatus(), other.byStatus())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReportJobsRequest").add("ByReportPlanName", byReportPlanName())
                .add("ByCreationBefore", byCreationBefore()).add("ByCreationAfter", byCreationAfter())
                .add("ByStatus", byStatus()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ByReportPlanName":
            return Optional.ofNullable(clazz.cast(byReportPlanName()));
        case "ByCreationBefore":
            return Optional.ofNullable(clazz.cast(byCreationBefore()));
        case "ByCreationAfter":
            return Optional.ofNullable(clazz.cast(byCreationAfter()));
        case "ByStatus":
            return Optional.ofNullable(clazz.cast(byStatus()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReportJobsRequest, T> g) {
        return obj -> g.apply((ListReportJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListReportJobsRequest> {
        /**
         * <p>
         * Returns only report jobs with the specified report plan name.
         * </p>
         * 
         * @param byReportPlanName
         *        Returns only report jobs with the specified report plan name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byReportPlanName(String byReportPlanName);

        /**
         * <p>
         * Returns only report jobs that were created before the date and time specified in Unix format and Coordinated
         * Universal Time (UTC). For example, the value 1516925490 represents Friday, January 26, 2018 12:11:30 AM.
         * </p>
         * 
         * @param byCreationBefore
         *        Returns only report jobs that were created before the date and time specified in Unix format and
         *        Coordinated Universal Time (UTC). For example, the value 1516925490 represents Friday, January 26,
         *        2018 12:11:30 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byCreationBefore(Instant byCreationBefore);

        /**
         * <p>
         * Returns only report jobs that were created after the date and time specified in Unix format and Coordinated
         * Universal Time (UTC). For example, the value 1516925490 represents Friday, January 26, 2018 12:11:30 AM.
         * </p>
         * 
         * @param byCreationAfter
         *        Returns only report jobs that were created after the date and time specified in Unix format and
         *        Coordinated Universal Time (UTC). For example, the value 1516925490 represents Friday, January 26,
         *        2018 12:11:30 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byCreationAfter(Instant byCreationAfter);

        /**
         * <p>
         * Returns only report jobs that are in the specified status. The statuses are:
         * </p>
         * <p>
         * <code>CREATED | RUNNING | COMPLETED | FAILED</code>
         * </p>
         * 
         * @param byStatus
         *        Returns only report jobs that are in the specified status. The statuses are:</p>
         *        <p>
         *        <code>CREATED | RUNNING | COMPLETED | FAILED</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byStatus(String byStatus);

        /**
         * <p>
         * The number of desired results from 1 to 1000. Optional. If unspecified, the query will return 1 MB of data.
         * </p>
         * 
         * @param maxResults
         *        The number of desired results from 1 to 1000. Optional. If unspecified, the query will return 1 MB of
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String byReportPlanName;

        private Instant byCreationBefore;

        private Instant byCreationAfter;

        private String byStatus;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReportJobsRequest model) {
            super(model);
            byReportPlanName(model.byReportPlanName);
            byCreationBefore(model.byCreationBefore);
            byCreationAfter(model.byCreationAfter);
            byStatus(model.byStatus);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getByReportPlanName() {
            return byReportPlanName;
        }

        public final void setByReportPlanName(String byReportPlanName) {
            this.byReportPlanName = byReportPlanName;
        }

        @Override
        @Transient
        public final Builder byReportPlanName(String byReportPlanName) {
            this.byReportPlanName = byReportPlanName;
            return this;
        }

        public final Instant getByCreationBefore() {
            return byCreationBefore;
        }

        public final void setByCreationBefore(Instant byCreationBefore) {
            this.byCreationBefore = byCreationBefore;
        }

        @Override
        @Transient
        public final Builder byCreationBefore(Instant byCreationBefore) {
            this.byCreationBefore = byCreationBefore;
            return this;
        }

        public final Instant getByCreationAfter() {
            return byCreationAfter;
        }

        public final void setByCreationAfter(Instant byCreationAfter) {
            this.byCreationAfter = byCreationAfter;
        }

        @Override
        @Transient
        public final Builder byCreationAfter(Instant byCreationAfter) {
            this.byCreationAfter = byCreationAfter;
            return this;
        }

        public final String getByStatus() {
            return byStatus;
        }

        public final void setByStatus(String byStatus) {
            this.byStatus = byStatus;
        }

        @Override
        @Transient
        public final Builder byStatus(String byStatus) {
            this.byStatus = byStatus;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReportJobsRequest build() {
            return new ListReportJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
