/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionParameter.Builder, ConditionParameter> {
    private static final SdkField<String> CONDITION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConditionKey").getter(getter(ConditionParameter::conditionKey)).setter(setter(Builder::conditionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionKey").build()).build();

    private static final SdkField<String> CONDITION_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConditionValue").getter(getter(ConditionParameter::conditionValue))
            .setter(setter(Builder::conditionValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_KEY_FIELD,
            CONDITION_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String conditionKey;

    private final String conditionValue;

    private ConditionParameter(BuilderImpl builder) {
        this.conditionKey = builder.conditionKey;
        this.conditionValue = builder.conditionValue;
    }

    /**
     * Returns the value of the ConditionKey property for this object.
     * 
     * @return The value of the ConditionKey property for this object.
     */
    public final String conditionKey() {
        return conditionKey;
    }

    /**
     * Returns the value of the ConditionValue property for this object.
     * 
     * @return The value of the ConditionValue property for this object.
     */
    public final String conditionValue() {
        return conditionValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conditionKey());
        hashCode = 31 * hashCode + Objects.hashCode(conditionValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionParameter)) {
            return false;
        }
        ConditionParameter other = (ConditionParameter) obj;
        return Objects.equals(conditionKey(), other.conditionKey()) && Objects.equals(conditionValue(), other.conditionValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionParameter").add("ConditionKey", conditionKey()).add("ConditionValue", conditionValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConditionKey":
            return Optional.ofNullable(clazz.cast(conditionKey()));
        case "ConditionValue":
            return Optional.ofNullable(clazz.cast(conditionValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConditionParameter, T> g) {
        return obj -> g.apply((ConditionParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionParameter> {
        /**
         * Sets the value of the ConditionKey property for this object.
         *
         * @param conditionKey
         *        The new value for the ConditionKey property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionKey(String conditionKey);

        /**
         * Sets the value of the ConditionValue property for this object.
         *
         * @param conditionValue
         *        The new value for the ConditionValue property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionValue(String conditionValue);
    }

    static final class BuilderImpl implements Builder {
        private String conditionKey;

        private String conditionValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionParameter model) {
            conditionKey(model.conditionKey);
            conditionValue(model.conditionValue);
        }

        public final String getConditionKey() {
            return conditionKey;
        }

        public final void setConditionKey(String conditionKey) {
            this.conditionKey = conditionKey;
        }

        @Override
        @Transient
        public final Builder conditionKey(String conditionKey) {
            this.conditionKey = conditionKey;
            return this;
        }

        public final String getConditionValue() {
            return conditionValue;
        }

        public final void setConditionValue(String conditionValue) {
            this.conditionValue = conditionValue;
        }

        @Override
        @Transient
        public final Builder conditionValue(String conditionValue) {
            this.conditionValue = conditionValue;
            return this;
        }

        @Override
        public ConditionParameter build() {
            return new ConditionParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
