/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLegalHoldRequest extends BackupRequest implements
        ToCopyableBuilder<CreateLegalHoldRequest.Builder, CreateLegalHoldRequest> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(CreateLegalHoldRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateLegalHoldRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken").getter(getter(CreateLegalHoldRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()).build();

    private static final SdkField<RecoveryPointSelection> RECOVERY_POINT_SELECTION_FIELD = SdkField
            .<RecoveryPointSelection> builder(MarshallingType.SDK_POJO).memberName("RecoveryPointSelection")
            .getter(getter(CreateLegalHoldRequest::recoveryPointSelection)).setter(setter(Builder::recoveryPointSelection))
            .constructor(RecoveryPointSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointSelection").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateLegalHoldRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD,
            DESCRIPTION_FIELD, IDEMPOTENCY_TOKEN_FIELD, RECOVERY_POINT_SELECTION_FIELD, TAGS_FIELD));

    private final String title;

    private final String description;

    private final String idempotencyToken;

    private final RecoveryPointSelection recoveryPointSelection;

    private final Map<String, String> tags;

    private CreateLegalHoldRequest(BuilderImpl builder) {
        super(builder);
        this.title = builder.title;
        this.description = builder.description;
        this.idempotencyToken = builder.idempotencyToken;
        this.recoveryPointSelection = builder.recoveryPointSelection;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * This is the string title of the legal hold.
     * </p>
     * 
     * @return This is the string title of the legal hold.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * This is the string description of the legal hold.
     * </p>
     * 
     * @return This is the string description of the legal hold.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * This is a user-chosen string used to distinguish between otherwise identical calls. Retrying a successful request
     * with the same idempotency token results in a success message with no action taken.
     * </p>
     * 
     * @return This is a user-chosen string used to distinguish between otherwise identical calls. Retrying a successful
     *         request with the same idempotency token results in a success message with no action taken.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    /**
     * <p>
     * This specifies criteria to assign a set of resources, such as resource types or backup vaults.
     * </p>
     * 
     * @return This specifies criteria to assign a set of resources, such as resource types or backup vaults.
     */
    public final RecoveryPointSelection recoveryPointSelection() {
        return recoveryPointSelection;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your resources.
     * Allowed characters include UTF-8 letters, numbers, spaces, and the following characters: + - = . _ : /.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your
     *         resources. Allowed characters include UTF-8 letters, numbers, spaces, and the following characters: + - =
     *         . _ : /.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointSelection());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLegalHoldRequest)) {
            return false;
        }
        CreateLegalHoldRequest other = (CreateLegalHoldRequest) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(description(), other.description())
                && Objects.equals(idempotencyToken(), other.idempotencyToken())
                && Objects.equals(recoveryPointSelection(), other.recoveryPointSelection()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLegalHoldRequest").add("Title", title()).add("Description", description())
                .add("IdempotencyToken", idempotencyToken()).add("RecoveryPointSelection", recoveryPointSelection())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        case "RecoveryPointSelection":
            return Optional.ofNullable(clazz.cast(recoveryPointSelection()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLegalHoldRequest, T> g) {
        return obj -> g.apply((CreateLegalHoldRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLegalHoldRequest> {
        /**
         * <p>
         * This is the string title of the legal hold.
         * </p>
         * 
         * @param title
         *        This is the string title of the legal hold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * This is the string description of the legal hold.
         * </p>
         * 
         * @param description
         *        This is the string description of the legal hold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * This is a user-chosen string used to distinguish between otherwise identical calls. Retrying a successful
         * request with the same idempotency token results in a success message with no action taken.
         * </p>
         * 
         * @param idempotencyToken
         *        This is a user-chosen string used to distinguish between otherwise identical calls. Retrying a
         *        successful request with the same idempotency token results in a success message with no action taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        /**
         * <p>
         * This specifies criteria to assign a set of resources, such as resource types or backup vaults.
         * </p>
         * 
         * @param recoveryPointSelection
         *        This specifies criteria to assign a set of resources, such as resource types or backup vaults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointSelection(RecoveryPointSelection recoveryPointSelection);

        /**
         * <p>
         * This specifies criteria to assign a set of resources, such as resource types or backup vaults.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecoveryPointSelection.Builder} avoiding
         * the need to create one manually via {@link RecoveryPointSelection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecoveryPointSelection.Builder#build()} is called immediately and
         * its result is passed to {@link #recoveryPointSelection(RecoveryPointSelection)}.
         * 
         * @param recoveryPointSelection
         *        a consumer that will call methods on {@link RecoveryPointSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recoveryPointSelection(RecoveryPointSelection)
         */
        default Builder recoveryPointSelection(Consumer<RecoveryPointSelection.Builder> recoveryPointSelection) {
            return recoveryPointSelection(RecoveryPointSelection.builder().applyMutation(recoveryPointSelection).build());
        }

        /**
         * <p>
         * Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your
         * resources. Allowed characters include UTF-8 letters, numbers, spaces, and the following characters: + - = . _
         * : /.
         * </p>
         * 
         * @param tags
         *        Optional tags to include. A tag is a key-value pair you can use to manage, filter, and search for your
         *        resources. Allowed characters include UTF-8 letters, numbers, spaces, and the following characters: +
         *        - = . _ : /.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String title;

        private String description;

        private String idempotencyToken;

        private RecoveryPointSelection recoveryPointSelection;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLegalHoldRequest model) {
            super(model);
            title(model.title);
            description(model.description);
            idempotencyToken(model.idempotencyToken);
            recoveryPointSelection(model.recoveryPointSelection);
            tags(model.tags);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final RecoveryPointSelection.Builder getRecoveryPointSelection() {
            return recoveryPointSelection != null ? recoveryPointSelection.toBuilder() : null;
        }

        public final void setRecoveryPointSelection(RecoveryPointSelection.BuilderImpl recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection != null ? recoveryPointSelection.build() : null;
        }

        @Override
        public final Builder recoveryPointSelection(RecoveryPointSelection recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLegalHoldRequest build() {
            return new CreateLegalHoldRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
