/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.LegalHold;
import software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest;
import software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse;

public class ListLegalHoldsIterable
implements SdkIterable<ListLegalHoldsResponse> {
    private final BackupClient client;
    private final ListLegalHoldsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLegalHoldsIterable(BackupClient client, ListLegalHoldsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLegalHoldsResponseFetcher();
    }

    public Iterator<ListLegalHoldsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LegalHold> legalHolds() {
        Function<ListLegalHoldsResponse, Iterator> getIterator = response -> {
            if (response != null && response.legalHolds() != null) {
                return response.legalHolds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLegalHoldsResponseFetcher
    implements SyncPageFetcher<ListLegalHoldsResponse> {
        private ListLegalHoldsResponseFetcher() {
        }

        public boolean hasNextPage(ListLegalHoldsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLegalHoldsResponse nextPage(ListLegalHoldsResponse previousPage) {
            if (previousPage == null) {
                return ListLegalHoldsIterable.this.client.listLegalHolds(ListLegalHoldsIterable.this.firstRequest);
            }
            return ListLegalHoldsIterable.this.client.listLegalHolds((ListLegalHoldsRequest)((Object)ListLegalHoldsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

