/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBackupVaultsRequest extends BackupRequest implements
        ToCopyableBuilder<ListBackupVaultsRequest.Builder, ListBackupVaultsRequest> {
    private static final SdkField<String> BY_VAULT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByVaultType").getter(getter(ListBackupVaultsRequest::byVaultTypeAsString))
            .setter(setter(Builder::byVaultType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("vaultType").build()).build();

    private static final SdkField<Boolean> BY_SHARED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ByShared").getter(getter(ListBackupVaultsRequest::byShared)).setter(setter(Builder::byShared))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("shared").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBackupVaultsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListBackupVaultsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BY_VAULT_TYPE_FIELD,
            BY_SHARED_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String byVaultType;

    private final Boolean byShared;

    private final String nextToken;

    private final Integer maxResults;

    private ListBackupVaultsRequest(BuilderImpl builder) {
        super(builder);
        this.byVaultType = builder.byVaultType;
        this.byShared = builder.byShared;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * This parameter will sort the list of vaults by vault type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byVaultType} will
     * return {@link VaultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byVaultTypeAsString}.
     * </p>
     * 
     * @return This parameter will sort the list of vaults by vault type.
     * @see VaultType
     */
    public final VaultType byVaultType() {
        return VaultType.fromValue(byVaultType);
    }

    /**
     * <p>
     * This parameter will sort the list of vaults by vault type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byVaultType} will
     * return {@link VaultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byVaultTypeAsString}.
     * </p>
     * 
     * @return This parameter will sort the list of vaults by vault type.
     * @see VaultType
     */
    public final String byVaultTypeAsString() {
        return byVaultType;
    }

    /**
     * <p>
     * This parameter will sort the list of vaults by shared vaults.
     * </p>
     * 
     * @return This parameter will sort the list of vaults by shared vaults.
     */
    public final Boolean byShared() {
        return byShared;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to be returned.
     * </p>
     * 
     * @return The maximum number of items to be returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(byVaultTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(byShared());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupVaultsRequest)) {
            return false;
        }
        ListBackupVaultsRequest other = (ListBackupVaultsRequest) obj;
        return Objects.equals(byVaultTypeAsString(), other.byVaultTypeAsString()) && Objects.equals(byShared(), other.byShared())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBackupVaultsRequest").add("ByVaultType", byVaultTypeAsString()).add("ByShared", byShared())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ByVaultType":
            return Optional.ofNullable(clazz.cast(byVaultTypeAsString()));
        case "ByShared":
            return Optional.ofNullable(clazz.cast(byShared()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupVaultsRequest, T> g) {
        return obj -> g.apply((ListBackupVaultsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListBackupVaultsRequest> {
        /**
         * <p>
         * This parameter will sort the list of vaults by vault type.
         * </p>
         * 
         * @param byVaultType
         *        This parameter will sort the list of vaults by vault type.
         * @see VaultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VaultType
         */
        Builder byVaultType(String byVaultType);

        /**
         * <p>
         * This parameter will sort the list of vaults by vault type.
         * </p>
         * 
         * @param byVaultType
         *        This parameter will sort the list of vaults by vault type.
         * @see VaultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VaultType
         */
        Builder byVaultType(VaultType byVaultType);

        /**
         * <p>
         * This parameter will sort the list of vaults by shared vaults.
         * </p>
         * 
         * @param byShared
         *        This parameter will sort the list of vaults by shared vaults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byShared(Boolean byShared);

        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to be returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String byVaultType;

        private Boolean byShared;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupVaultsRequest model) {
            super(model);
            byVaultType(model.byVaultType);
            byShared(model.byShared);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getByVaultType() {
            return byVaultType;
        }

        public final void setByVaultType(String byVaultType) {
            this.byVaultType = byVaultType;
        }

        @Override
        public final Builder byVaultType(String byVaultType) {
            this.byVaultType = byVaultType;
            return this;
        }

        @Override
        public final Builder byVaultType(VaultType byVaultType) {
            this.byVaultType(byVaultType == null ? null : byVaultType.toString());
            return this;
        }

        public final Boolean getByShared() {
            return byShared;
        }

        public final void setByShared(Boolean byShared) {
            this.byShared = byShared;
        }

        @Override
        public final Builder byShared(Boolean byShared) {
            this.byShared = byShared;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBackupVaultsRequest build() {
            return new ListBackupVaultsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
