/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecoveryPointsByLegalHoldResponse extends BackupResponse implements
        ToCopyableBuilder<ListRecoveryPointsByLegalHoldResponse.Builder, ListRecoveryPointsByLegalHoldResponse> {
    private static final SdkField<List<RecoveryPointMember>> RECOVERY_POINTS_FIELD = SdkField
            .<List<RecoveryPointMember>> builder(MarshallingType.LIST)
            .memberName("RecoveryPoints")
            .getter(getter(ListRecoveryPointsByLegalHoldResponse::recoveryPoints))
            .setter(setter(Builder::recoveryPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecoveryPointMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecoveryPointMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRecoveryPointsByLegalHoldResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<RecoveryPointMember> recoveryPoints;

    private final String nextToken;

    private ListRecoveryPointsByLegalHoldResponse(BuilderImpl builder) {
        super(builder);
        this.recoveryPoints = builder.recoveryPoints;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecoveryPoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecoveryPoints() {
        return recoveryPoints != null && !(recoveryPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This is a list of the recovery points returned by <code>ListRecoveryPointsByLegalHold</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecoveryPoints} method.
     * </p>
     * 
     * @return This is a list of the recovery points returned by <code>ListRecoveryPointsByLegalHold</code>.
     */
    public final List<RecoveryPointMember> recoveryPoints() {
        return recoveryPoints;
    }

    /**
     * <p>
     * This return is the next item following a partial list of returned resources.
     * </p>
     * 
     * @return This return is the next item following a partial list of returned resources.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRecoveryPoints() ? recoveryPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecoveryPointsByLegalHoldResponse)) {
            return false;
        }
        ListRecoveryPointsByLegalHoldResponse other = (ListRecoveryPointsByLegalHoldResponse) obj;
        return hasRecoveryPoints() == other.hasRecoveryPoints() && Objects.equals(recoveryPoints(), other.recoveryPoints())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecoveryPointsByLegalHoldResponse")
                .add("RecoveryPoints", hasRecoveryPoints() ? recoveryPoints() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecoveryPoints":
            return Optional.ofNullable(clazz.cast(recoveryPoints()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecoveryPointsByLegalHoldResponse, T> g) {
        return obj -> g.apply((ListRecoveryPointsByLegalHoldResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRecoveryPointsByLegalHoldResponse> {
        /**
         * <p>
         * This is a list of the recovery points returned by <code>ListRecoveryPointsByLegalHold</code>.
         * </p>
         * 
         * @param recoveryPoints
         *        This is a list of the recovery points returned by <code>ListRecoveryPointsByLegalHold</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPoints(Collection<RecoveryPointMember> recoveryPoints);

        /**
         * <p>
         * This is a list of the recovery points returned by <code>ListRecoveryPointsByLegalHold</code>.
         * </p>
         * 
         * @param recoveryPoints
         *        This is a list of the recovery points returned by <code>ListRecoveryPointsByLegalHold</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPoints(RecoveryPointMember... recoveryPoints);

        /**
         * <p>
         * This is a list of the recovery points returned by <code>ListRecoveryPointsByLegalHold</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.RecoveryPointMember.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.backup.model.RecoveryPointMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.RecoveryPointMember.Builder#build()} is called
         * immediately and its result is passed to {@link #recoveryPoints(List<RecoveryPointMember>)}.
         * 
         * @param recoveryPoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.RecoveryPointMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recoveryPoints(java.util.Collection<RecoveryPointMember>)
         */
        Builder recoveryPoints(Consumer<RecoveryPointMember.Builder>... recoveryPoints);

        /**
         * <p>
         * This return is the next item following a partial list of returned resources.
         * </p>
         * 
         * @param nextToken
         *        This return is the next item following a partial list of returned resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private List<RecoveryPointMember> recoveryPoints = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecoveryPointsByLegalHoldResponse model) {
            super(model);
            recoveryPoints(model.recoveryPoints);
            nextToken(model.nextToken);
        }

        public final List<RecoveryPointMember.Builder> getRecoveryPoints() {
            List<RecoveryPointMember.Builder> result = RecoveryPointsListCopier.copyToBuilder(this.recoveryPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecoveryPoints(Collection<RecoveryPointMember.BuilderImpl> recoveryPoints) {
            this.recoveryPoints = RecoveryPointsListCopier.copyFromBuilder(recoveryPoints);
        }

        @Override
        public final Builder recoveryPoints(Collection<RecoveryPointMember> recoveryPoints) {
            this.recoveryPoints = RecoveryPointsListCopier.copy(recoveryPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryPoints(RecoveryPointMember... recoveryPoints) {
            recoveryPoints(Arrays.asList(recoveryPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryPoints(Consumer<RecoveryPointMember.Builder>... recoveryPoints) {
            recoveryPoints(Stream.of(recoveryPoints).map(c -> RecoveryPointMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRecoveryPointsByLegalHoldResponse build() {
            return new ListRecoveryPointsByLegalHoldResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
