/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about a framework. Frameworks contain controls, which evaluate and report on your
 * backup events and resources. Frameworks generate daily compliance results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Framework implements SdkPojo, Serializable, ToCopyableBuilder<Framework.Builder, Framework> {
    private static final SdkField<String> FRAMEWORK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkName").getter(getter(Framework::frameworkName)).setter(setter(Builder::frameworkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkName").build()).build();

    private static final SdkField<String> FRAMEWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkArn").getter(getter(Framework::frameworkArn)).setter(setter(Builder::frameworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkArn").build()).build();

    private static final SdkField<String> FRAMEWORK_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkDescription").getter(getter(Framework::frameworkDescription))
            .setter(setter(Builder::frameworkDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkDescription").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_CONTROLS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfControls").getter(getter(Framework::numberOfControls)).setter(setter(Builder::numberOfControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfControls").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Framework::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStatus").getter(getter(Framework::deploymentStatus)).setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_NAME_FIELD,
            FRAMEWORK_ARN_FIELD, FRAMEWORK_DESCRIPTION_FIELD, NUMBER_OF_CONTROLS_FIELD, CREATION_TIME_FIELD,
            DEPLOYMENT_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String frameworkName;

    private final String frameworkArn;

    private final String frameworkDescription;

    private final Integer numberOfControls;

    private final Instant creationTime;

    private final String deploymentStatus;

    private Framework(BuilderImpl builder) {
        this.frameworkName = builder.frameworkName;
        this.frameworkArn = builder.frameworkArn;
        this.frameworkDescription = builder.frameworkDescription;
        this.numberOfControls = builder.numberOfControls;
        this.creationTime = builder.creationTime;
        this.deploymentStatus = builder.deploymentStatus;
    }

    /**
     * <p>
     * The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting
     * of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     * </p>
     * 
     * @return The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and
     *         consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     */
    public final String frameworkName() {
        return frameworkName;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource
     * type.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
     *         resource type.
     */
    public final String frameworkArn() {
        return frameworkArn;
    }

    /**
     * <p>
     * An optional description of the framework with a maximum 1,024 characters.
     * </p>
     * 
     * @return An optional description of the framework with a maximum 1,024 characters.
     */
    public final String frameworkDescription() {
        return frameworkDescription;
    }

    /**
     * <p>
     * The number of controls contained by the framework.
     * </p>
     * 
     * @return The number of controls contained by the framework.
     */
    public final Integer numberOfControls() {
        return numberOfControls;
    }

    /**
     * <p>
     * The date and time that a framework is created, in ISO 8601 representation. The value of <code>CreationTime</code>
     * is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00 represents the 10th of July 2020 at 3:00
     * PM 8 hours behind UTC.
     * </p>
     * 
     * @return The date and time that a framework is created, in ISO 8601 representation. The value of
     *         <code>CreationTime</code> is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00
     *         represents the 10th of July 2020 at 3:00 PM 8 hours behind UTC.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The deployment status of a framework. The statuses are:
     * </p>
     * <p>
     * <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code>
     * </p>
     * 
     * @return The deployment status of a framework. The statuses are:</p>
     *         <p>
     *         <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code>
     */
    public final String deploymentStatus() {
        return deploymentStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frameworkName());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkDescription());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfControls());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Framework)) {
            return false;
        }
        Framework other = (Framework) obj;
        return Objects.equals(frameworkName(), other.frameworkName()) && Objects.equals(frameworkArn(), other.frameworkArn())
                && Objects.equals(frameworkDescription(), other.frameworkDescription())
                && Objects.equals(numberOfControls(), other.numberOfControls())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(deploymentStatus(), other.deploymentStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Framework").add("FrameworkName", frameworkName()).add("FrameworkArn", frameworkArn())
                .add("FrameworkDescription", frameworkDescription()).add("NumberOfControls", numberOfControls())
                .add("CreationTime", creationTime()).add("DeploymentStatus", deploymentStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FrameworkName":
            return Optional.ofNullable(clazz.cast(frameworkName()));
        case "FrameworkArn":
            return Optional.ofNullable(clazz.cast(frameworkArn()));
        case "FrameworkDescription":
            return Optional.ofNullable(clazz.cast(frameworkDescription()));
        case "NumberOfControls":
            return Optional.ofNullable(clazz.cast(numberOfControls()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "DeploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Framework, T> g) {
        return obj -> g.apply((Framework) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Framework> {
        /**
         * <p>
         * The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and
         * consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * </p>
         * 
         * @param frameworkName
         *        The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and
         *        consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkName(String frameworkName);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
         * resource type.
         * </p>
         * 
         * @param frameworkArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on
         *        the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkArn(String frameworkArn);

        /**
         * <p>
         * An optional description of the framework with a maximum 1,024 characters.
         * </p>
         * 
         * @param frameworkDescription
         *        An optional description of the framework with a maximum 1,024 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkDescription(String frameworkDescription);

        /**
         * <p>
         * The number of controls contained by the framework.
         * </p>
         * 
         * @param numberOfControls
         *        The number of controls contained by the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfControls(Integer numberOfControls);

        /**
         * <p>
         * The date and time that a framework is created, in ISO 8601 representation. The value of
         * <code>CreationTime</code> is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00 represents
         * the 10th of July 2020 at 3:00 PM 8 hours behind UTC.
         * </p>
         * 
         * @param creationTime
         *        The date and time that a framework is created, in ISO 8601 representation. The value of
         *        <code>CreationTime</code> is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00
         *        represents the 10th of July 2020 at 3:00 PM 8 hours behind UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The deployment status of a framework. The statuses are:
         * </p>
         * <p>
         * <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code>
         * </p>
         * 
         * @param deploymentStatus
         *        The deployment status of a framework. The statuses are:</p>
         *        <p>
         *        <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStatus(String deploymentStatus);
    }

    static final class BuilderImpl implements Builder {
        private String frameworkName;

        private String frameworkArn;

        private String frameworkDescription;

        private Integer numberOfControls;

        private Instant creationTime;

        private String deploymentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Framework model) {
            frameworkName(model.frameworkName);
            frameworkArn(model.frameworkArn);
            frameworkDescription(model.frameworkDescription);
            numberOfControls(model.numberOfControls);
            creationTime(model.creationTime);
            deploymentStatus(model.deploymentStatus);
        }

        public final String getFrameworkName() {
            return frameworkName;
        }

        public final void setFrameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
        }

        @Override
        public final Builder frameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
            return this;
        }

        public final String getFrameworkArn() {
            return frameworkArn;
        }

        public final void setFrameworkArn(String frameworkArn) {
            this.frameworkArn = frameworkArn;
        }

        @Override
        public final Builder frameworkArn(String frameworkArn) {
            this.frameworkArn = frameworkArn;
            return this;
        }

        public final String getFrameworkDescription() {
            return frameworkDescription;
        }

        public final void setFrameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
        }

        @Override
        public final Builder frameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
            return this;
        }

        public final Integer getNumberOfControls() {
            return numberOfControls;
        }

        public final void setNumberOfControls(Integer numberOfControls) {
            this.numberOfControls = numberOfControls;
        }

        @Override
        public final Builder numberOfControls(Integer numberOfControls) {
            this.numberOfControls = numberOfControls;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public Framework build() {
            return new Framework(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
