/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.backup.model.AlreadyExistsException;
import software.amazon.awssdk.services.backup.model.BackupException;
import software.amazon.awssdk.services.backup.model.CancelLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.CancelLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.ConflictException;
import software.amazon.awssdk.services.backup.model.CreateBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.CreateBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.CreateBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.CreateFrameworkRequest;
import software.amazon.awssdk.services.backup.model.CreateFrameworkResponse;
import software.amazon.awssdk.services.backup.model.CreateLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.CreateLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.CreateReportPlanRequest;
import software.amazon.awssdk.services.backup.model.CreateReportPlanResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.DeleteFrameworkRequest;
import software.amazon.awssdk.services.backup.model.DeleteFrameworkResponse;
import software.amazon.awssdk.services.backup.model.DeleteRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DeleteRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.DeleteReportPlanRequest;
import software.amazon.awssdk.services.backup.model.DeleteReportPlanResponse;
import software.amazon.awssdk.services.backup.model.DependencyFailureException;
import software.amazon.awssdk.services.backup.model.DescribeBackupJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse;
import software.amazon.awssdk.services.backup.model.DescribeBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.DescribeBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.DescribeCopyJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeCopyJobResponse;
import software.amazon.awssdk.services.backup.model.DescribeFrameworkRequest;
import software.amazon.awssdk.services.backup.model.DescribeFrameworkResponse;
import software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsRequest;
import software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsResponse;
import software.amazon.awssdk.services.backup.model.DescribeProtectedResourceRequest;
import software.amazon.awssdk.services.backup.model.DescribeProtectedResourceResponse;
import software.amazon.awssdk.services.backup.model.DescribeRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DescribeRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.DescribeRegionSettingsRequest;
import software.amazon.awssdk.services.backup.model.DescribeRegionSettingsResponse;
import software.amazon.awssdk.services.backup.model.DescribeReportJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeReportJobResponse;
import software.amazon.awssdk.services.backup.model.DescribeReportPlanRequest;
import software.amazon.awssdk.services.backup.model.DescribeReportPlanResponse;
import software.amazon.awssdk.services.backup.model.DescribeRestoreJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeRestoreJobResponse;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentRequest;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentResponse;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateRequest;
import software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.GetLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.GetLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataRequest;
import software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse;
import software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesRequest;
import software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesResponse;
import software.amazon.awssdk.services.backup.model.InvalidParameterValueException;
import software.amazon.awssdk.services.backup.model.InvalidRequestException;
import software.amazon.awssdk.services.backup.model.InvalidResourceStateException;
import software.amazon.awssdk.services.backup.model.LimitExceededException;
import software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobSummariesResponse;
import software.amazon.awssdk.services.backup.model.ListBackupJobsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlansRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlansResponse;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse;
import software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListCopyJobSummariesResponse;
import software.amazon.awssdk.services.backup.model.ListCopyJobsRequest;
import software.amazon.awssdk.services.backup.model.ListCopyJobsResponse;
import software.amazon.awssdk.services.backup.model.ListFrameworksRequest;
import software.amazon.awssdk.services.backup.model.ListFrameworksResponse;
import software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest;
import software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse;
import software.amazon.awssdk.services.backup.model.ListReportJobsRequest;
import software.amazon.awssdk.services.backup.model.ListReportJobsResponse;
import software.amazon.awssdk.services.backup.model.ListReportPlansRequest;
import software.amazon.awssdk.services.backup.model.ListReportPlansResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse;
import software.amazon.awssdk.services.backup.model.ListTagsRequest;
import software.amazon.awssdk.services.backup.model.ListTagsResponse;
import software.amazon.awssdk.services.backup.model.MissingParameterValueException;
import software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationResponse;
import software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.ResourceNotFoundException;
import software.amazon.awssdk.services.backup.model.ServiceUnavailableException;
import software.amazon.awssdk.services.backup.model.StartBackupJobRequest;
import software.amazon.awssdk.services.backup.model.StartBackupJobResponse;
import software.amazon.awssdk.services.backup.model.StartCopyJobRequest;
import software.amazon.awssdk.services.backup.model.StartCopyJobResponse;
import software.amazon.awssdk.services.backup.model.StartReportJobRequest;
import software.amazon.awssdk.services.backup.model.StartReportJobResponse;
import software.amazon.awssdk.services.backup.model.StartRestoreJobRequest;
import software.amazon.awssdk.services.backup.model.StartRestoreJobResponse;
import software.amazon.awssdk.services.backup.model.StopBackupJobRequest;
import software.amazon.awssdk.services.backup.model.StopBackupJobResponse;
import software.amazon.awssdk.services.backup.model.TagResourceRequest;
import software.amazon.awssdk.services.backup.model.TagResourceResponse;
import software.amazon.awssdk.services.backup.model.UntagResourceRequest;
import software.amazon.awssdk.services.backup.model.UntagResourceResponse;
import software.amazon.awssdk.services.backup.model.UpdateBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.UpdateBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.UpdateFrameworkRequest;
import software.amazon.awssdk.services.backup.model.UpdateFrameworkResponse;
import software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsRequest;
import software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsResponse;
import software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleRequest;
import software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleResponse;
import software.amazon.awssdk.services.backup.model.UpdateRegionSettingsRequest;
import software.amazon.awssdk.services.backup.model.UpdateRegionSettingsResponse;
import software.amazon.awssdk.services.backup.model.UpdateReportPlanRequest;
import software.amazon.awssdk.services.backup.model.UpdateReportPlanResponse;
import software.amazon.awssdk.services.backup.paginators.ListBackupJobSummariesIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable;
import software.amazon.awssdk.services.backup.paginators.ListCopyJobSummariesIterable;
import software.amazon.awssdk.services.backup.paginators.ListCopyJobsIterable;
import software.amazon.awssdk.services.backup.paginators.ListFrameworksIterable;
import software.amazon.awssdk.services.backup.paginators.ListLegalHoldsIterable;
import software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesByBackupVaultIterable;
import software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable;
import software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable;
import software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByLegalHoldIterable;
import software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable;
import software.amazon.awssdk.services.backup.paginators.ListReportJobsIterable;
import software.amazon.awssdk.services.backup.paginators.ListReportPlansIterable;
import software.amazon.awssdk.services.backup.paginators.ListRestoreJobSummariesIterable;
import software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable;
import software.amazon.awssdk.services.backup.paginators.ListTagsIterable;

/**
 * Service client for accessing AWS Backup. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Backup</fullname>
 * <p>
 * Backup is a unified backup service designed to protect Amazon Web Services services and their associated data. Backup
 * simplifies the creation, migration, restoration, and deletion of backups, while also providing reporting and
 * auditing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BackupClient extends AwsClient {
    String SERVICE_NAME = "backup";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "backup";

    /**
     * <p>
     * This action removes the specified legal hold on a recovery point. This action can only be performed by a user
     * with sufficient permissions.
     * </p>
     *
     * @param cancelLegalHoldRequest
     * @return Result of the CancelLegalHold operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidResourceStateException
     *         Backup is already performing an action on this recovery point. It can't perform the action you requested
     *         until the first action finishes. Try again later.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CancelLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CancelLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelLegalHoldResponse cancelLegalHold(CancelLegalHoldRequest cancelLegalHoldRequest)
            throws InvalidParameterValueException, InvalidResourceStateException, MissingParameterValueException,
            ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action removes the specified legal hold on a recovery point. This action can only be performed by a user
     * with sufficient permissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelLegalHoldRequest.Builder} avoiding the need
     * to create one manually via {@link CancelLegalHoldRequest#builder()}
     * </p>
     *
     * @param cancelLegalHoldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CancelLegalHoldRequest.Builder} to create a request.
     * @return Result of the CancelLegalHold operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidResourceStateException
     *         Backup is already performing an action on this recovery point. It can't perform the action you requested
     *         until the first action finishes. Try again later.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CancelLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CancelLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelLegalHoldResponse cancelLegalHold(Consumer<CancelLegalHoldRequest.Builder> cancelLegalHoldRequest)
            throws InvalidParameterValueException, InvalidResourceStateException, MissingParameterValueException,
            ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return cancelLegalHold(CancelLegalHoldRequest.builder().applyMutation(cancelLegalHoldRequest).build());
    }

    /**
     * <p>
     * Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains
     * information that Backup uses to schedule tasks that create recovery points for resources.
     * </p>
     * <p>
     * If you call <code>CreateBackupPlan</code> with a plan that already exists, you receive an
     * <code>AlreadyExistsException</code> exception.
     * </p>
     *
     * @param createBackupPlanRequest
     * @return Result of the CreateBackupPlan operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBackupPlanResponse createBackupPlan(CreateBackupPlanRequest createBackupPlanRequest)
            throws LimitExceededException, AlreadyExistsException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains
     * information that Backup uses to schedule tasks that create recovery points for resources.
     * </p>
     * <p>
     * If you call <code>CreateBackupPlan</code> with a plan that already exists, you receive an
     * <code>AlreadyExistsException</code> exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackupPlanRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBackupPlanRequest#builder()}
     * </p>
     *
     * @param createBackupPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateBackupPlanRequest.Builder} to create a request.
     * @return Result of the CreateBackupPlan operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBackupPlanResponse createBackupPlan(Consumer<CreateBackupPlanRequest.Builder> createBackupPlanRequest)
            throws LimitExceededException, AlreadyExistsException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return createBackupPlan(CreateBackupPlanRequest.builder().applyMutation(createBackupPlanRequest).build());
    }

    /**
     * <p>
     * Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json"
     * >Assigning resources programmatically</a>.
     * </p>
     *
     * @param createBackupSelectionRequest
     * @return Result of the CreateBackupSelection operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBackupSelectionResponse createBackupSelection(CreateBackupSelectionRequest createBackupSelectionRequest)
            throws LimitExceededException, AlreadyExistsException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json"
     * >Assigning resources programmatically</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackupSelectionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBackupSelectionRequest#builder()}
     * </p>
     *
     * @param createBackupSelectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateBackupSelectionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateBackupSelection operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBackupSelectionResponse createBackupSelection(
            Consumer<CreateBackupSelectionRequest.Builder> createBackupSelectionRequest) throws LimitExceededException,
            AlreadyExistsException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        return createBackupSelection(CreateBackupSelectionRequest.builder().applyMutation(createBackupSelectionRequest).build());
    }

    /**
     * <p>
     * Creates a logical container where backups are stored. A <code>CreateBackupVault</code> request includes a name,
     * optionally one or more resource tags, an encryption key, and a request ID.
     * </p>
     * <note>
     * <p>
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     * </p>
     * </note>
     *
     * @param createBackupVaultRequest
     * @return Result of the CreateBackupVault operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBackupVaultResponse createBackupVault(CreateBackupVaultRequest createBackupVaultRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            LimitExceededException, AlreadyExistsException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a logical container where backups are stored. A <code>CreateBackupVault</code> request includes a name,
     * optionally one or more resource tags, an encryption key, and a request ID.
     * </p>
     * <note>
     * <p>
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackupVaultRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBackupVaultRequest#builder()}
     * </p>
     *
     * @param createBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateBackupVaultRequest.Builder} to create a request.
     * @return Result of the CreateBackupVault operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBackupVaultResponse createBackupVault(Consumer<CreateBackupVaultRequest.Builder> createBackupVaultRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            LimitExceededException, AlreadyExistsException, AwsServiceException, SdkClientException, BackupException {
        return createBackupVault(CreateBackupVaultRequest.builder().applyMutation(createBackupVaultRequest).build());
    }

    /**
     * <p>
     * Creates a framework with one or more controls. A framework is a collection of controls that you can use to
     * evaluate your backup practices. By using pre-built customizable controls to define your policies, you can
     * evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.
     * </p>
     *
     * @param createFrameworkRequest
     * @return Result of the CreateFramework operation returned by the service.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFrameworkResponse createFramework(CreateFrameworkRequest createFrameworkRequest) throws AlreadyExistsException,
            LimitExceededException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a framework with one or more controls. A framework is a collection of controls that you can use to
     * evaluate your backup practices. By using pre-built customizable controls to define your policies, you can
     * evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFrameworkRequest.Builder} avoiding the need
     * to create one manually via {@link CreateFrameworkRequest#builder()}
     * </p>
     *
     * @param createFrameworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateFrameworkRequest.Builder} to create a request.
     * @return Result of the CreateFramework operation returned by the service.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFrameworkResponse createFramework(Consumer<CreateFrameworkRequest.Builder> createFrameworkRequest)
            throws AlreadyExistsException, LimitExceededException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return createFramework(CreateFrameworkRequest.builder().applyMutation(createFrameworkRequest).build());
    }

    /**
     * <p>
     * This action creates a legal hold on a recovery point (backup). A legal hold is a restraint on altering or
     * deleting a backup until an authorized user cancels the legal hold. Any actions to delete or disassociate a
     * recovery point will fail with an error if one or more active legal holds are on the recovery point.
     * </p>
     *
     * @param createLegalHoldRequest
     * @return Result of the CreateLegalHold operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLegalHoldResponse createLegalHold(CreateLegalHoldRequest createLegalHoldRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            LimitExceededException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action creates a legal hold on a recovery point (backup). A legal hold is a restraint on altering or
     * deleting a backup until an authorized user cancels the legal hold. Any actions to delete or disassociate a
     * recovery point will fail with an error if one or more active legal holds are on the recovery point.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLegalHoldRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLegalHoldRequest#builder()}
     * </p>
     *
     * @param createLegalHoldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateLegalHoldRequest.Builder} to create a request.
     * @return Result of the CreateLegalHold operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLegalHoldResponse createLegalHold(Consumer<CreateLegalHoldRequest.Builder> createLegalHoldRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            LimitExceededException, AwsServiceException, SdkClientException, BackupException {
        return createLegalHold(CreateLegalHoldRequest.builder().applyMutation(createLegalHoldRequest).build());
    }

    /**
     * <p>
     * This request creates a logical container to where backups may be copied.
     * </p>
     * <p>
     * This request includes a name, the Region, the maximum number of retention days, the minimum number of retention
     * days, and optionally can include tags and a creator request ID.
     * </p>
     * <note>
     * <p>
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     * </p>
     * </note>
     *
     * @param createLogicallyAirGappedBackupVaultRequest
     * @return Result of the CreateLogicallyAirGappedBackupVault operation returned by the service.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateLogicallyAirGappedBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLogicallyAirGappedBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLogicallyAirGappedBackupVaultResponse createLogicallyAirGappedBackupVault(
            CreateLogicallyAirGappedBackupVaultRequest createLogicallyAirGappedBackupVaultRequest) throws AlreadyExistsException,
            InvalidParameterValueException, LimitExceededException, MissingParameterValueException, ServiceUnavailableException,
            InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request creates a logical container to where backups may be copied.
     * </p>
     * <p>
     * This request includes a name, the Region, the maximum number of retention days, the minimum number of retention
     * days, and optionally can include tags and a creator request ID.
     * </p>
     * <note>
     * <p>
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLogicallyAirGappedBackupVaultRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLogicallyAirGappedBackupVaultRequest#builder()}
     * </p>
     *
     * @param createLogicallyAirGappedBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest.Builder} to
     *        create a request.
     * @return Result of the CreateLogicallyAirGappedBackupVault operation returned by the service.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateLogicallyAirGappedBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLogicallyAirGappedBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLogicallyAirGappedBackupVaultResponse createLogicallyAirGappedBackupVault(
            Consumer<CreateLogicallyAirGappedBackupVaultRequest.Builder> createLogicallyAirGappedBackupVaultRequest)
            throws AlreadyExistsException, InvalidParameterValueException, LimitExceededException,
            MissingParameterValueException, ServiceUnavailableException, InvalidRequestException, AwsServiceException,
            SdkClientException, BackupException {
        return createLogicallyAirGappedBackupVault(CreateLogicallyAirGappedBackupVaultRequest.builder()
                .applyMutation(createLogicallyAirGappedBackupVaultRequest).build());
    }

    /**
     * <p>
     * Creates a report plan. A report plan is a document that contains information about the contents of the report and
     * where Backup will deliver it.
     * </p>
     * <p>
     * If you call <code>CreateReportPlan</code> with a plan that already exists, you receive an
     * <code>AlreadyExistsException</code> exception.
     * </p>
     *
     * @param createReportPlanRequest
     * @return Result of the CreateReportPlan operation returned by the service.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateReportPlanResponse createReportPlan(CreateReportPlanRequest createReportPlanRequest)
            throws AlreadyExistsException, LimitExceededException, InvalidParameterValueException, ServiceUnavailableException,
            MissingParameterValueException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a report plan. A report plan is a document that contains information about the contents of the report and
     * where Backup will deliver it.
     * </p>
     * <p>
     * If you call <code>CreateReportPlan</code> with a plan that already exists, you receive an
     * <code>AlreadyExistsException</code> exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReportPlanRequest.Builder} avoiding the need
     * to create one manually via {@link CreateReportPlanRequest#builder()}
     * </p>
     *
     * @param createReportPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateReportPlanRequest.Builder} to create a request.
     * @return Result of the CreateReportPlan operation returned by the service.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateReportPlanResponse createReportPlan(Consumer<CreateReportPlanRequest.Builder> createReportPlanRequest)
            throws AlreadyExistsException, LimitExceededException, InvalidParameterValueException, ServiceUnavailableException,
            MissingParameterValueException, AwsServiceException, SdkClientException, BackupException {
        return createReportPlan(CreateReportPlanRequest.builder().applyMutation(createReportPlanRequest).build());
    }

    /**
     * <p>
     * Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been
     * deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will
     * still exist.
     * </p>
     *
     * @param deleteBackupPlanRequest
     * @return Result of the DeleteBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBackupPlanResponse deleteBackupPlan(DeleteBackupPlanRequest deleteBackupPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been
     * deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will
     * still exist.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupPlanRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBackupPlanRequest#builder()}
     * </p>
     *
     * @param deleteBackupPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteBackupPlanRequest.Builder} to create a request.
     * @return Result of the DeleteBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBackupPlanResponse deleteBackupPlan(Consumer<DeleteBackupPlanRequest.Builder> deleteBackupPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        return deleteBackupPlan(DeleteBackupPlanRequest.builder().applyMutation(deleteBackupPlanRequest).build());
    }

    /**
     * <p>
     * Deletes the resource selection associated with a backup plan that is specified by the <code>SelectionId</code>.
     * </p>
     *
     * @param deleteBackupSelectionRequest
     * @return Result of the DeleteBackupSelection operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBackupSelectionResponse deleteBackupSelection(DeleteBackupSelectionRequest deleteBackupSelectionRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource selection associated with a backup plan that is specified by the <code>SelectionId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupSelectionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBackupSelectionRequest#builder()}
     * </p>
     *
     * @param deleteBackupSelectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteBackupSelectionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteBackupSelection operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBackupSelectionResponse deleteBackupSelection(
            Consumer<DeleteBackupSelectionRequest.Builder> deleteBackupSelectionRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return deleteBackupSelection(DeleteBackupSelectionRequest.builder().applyMutation(deleteBackupSelectionRequest).build());
    }

    /**
     * <p>
     * Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
     * </p>
     *
     * @param deleteBackupVaultRequest
     * @return Result of the DeleteBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBackupVaultResponse deleteBackupVault(DeleteBackupVaultRequest deleteBackupVaultRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupVaultRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBackupVaultRequest#builder()}
     * </p>
     *
     * @param deleteBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteBackupVaultRequest.Builder} to create a request.
     * @return Result of the DeleteBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBackupVaultResponse deleteBackupVault(Consumer<DeleteBackupVaultRequest.Builder> deleteBackupVaultRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        return deleteBackupVault(DeleteBackupVaultRequest.builder().applyMutation(deleteBackupVaultRequest).build());
    }

    /**
     * <p>
     * Deletes the policy document that manages permissions on a backup vault.
     * </p>
     *
     * @param deleteBackupVaultAccessPolicyRequest
     * @return Result of the DeleteBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackupVaultAccessPolicyResponse deleteBackupVaultAccessPolicy(
            DeleteBackupVaultAccessPolicyRequest deleteBackupVaultAccessPolicyRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the policy document that manages permissions on a backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupVaultAccessPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteBackupVaultAccessPolicyRequest#builder()}
     * </p>
     *
     * @param deleteBackupVaultAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackupVaultAccessPolicyResponse deleteBackupVaultAccessPolicy(
            Consumer<DeleteBackupVaultAccessPolicyRequest.Builder> deleteBackupVaultAccessPolicyRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return deleteBackupVaultAccessPolicy(DeleteBackupVaultAccessPolicyRequest.builder()
                .applyMutation(deleteBackupVaultAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes Backup Vault Lock from a backup vault specified by a backup vault name.
     * </p>
     * <p>
     * If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using API operations, and you
     * will receive an <code>InvalidRequestException</code> if you attempt to do so. For more information, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">Vault Lock</a> in the <i>Backup
     * Developer Guide</i>.
     * </p>
     *
     * @param deleteBackupVaultLockConfigurationRequest
     * @return Result of the DeleteBackupVaultLockConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVaultLockConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultLockConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackupVaultLockConfigurationResponse deleteBackupVaultLockConfiguration(
            DeleteBackupVaultLockConfigurationRequest deleteBackupVaultLockConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            InvalidRequestException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes Backup Vault Lock from a backup vault specified by a backup vault name.
     * </p>
     * <p>
     * If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using API operations, and you
     * will receive an <code>InvalidRequestException</code> if you attempt to do so. For more information, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">Vault Lock</a> in the <i>Backup
     * Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupVaultLockConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteBackupVaultLockConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteBackupVaultLockConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteBackupVaultLockConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVaultLockConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultLockConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackupVaultLockConfigurationResponse deleteBackupVaultLockConfiguration(
            Consumer<DeleteBackupVaultLockConfigurationRequest.Builder> deleteBackupVaultLockConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            InvalidRequestException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return deleteBackupVaultLockConfiguration(DeleteBackupVaultLockConfigurationRequest.builder()
                .applyMutation(deleteBackupVaultLockConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes event notifications for the specified backup vault.
     * </p>
     *
     * @param deleteBackupVaultNotificationsRequest
     * @return Result of the DeleteBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackupVaultNotificationsResponse deleteBackupVaultNotifications(
            DeleteBackupVaultNotificationsRequest deleteBackupVaultNotificationsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes event notifications for the specified backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupVaultNotificationsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteBackupVaultNotificationsRequest#builder()}
     * </p>
     *
     * @param deleteBackupVaultNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackupVaultNotificationsResponse deleteBackupVaultNotifications(
            Consumer<DeleteBackupVaultNotificationsRequest.Builder> deleteBackupVaultNotificationsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return deleteBackupVaultNotifications(DeleteBackupVaultNotificationsRequest.builder()
                .applyMutation(deleteBackupVaultNotificationsRequest).build());
    }

    /**
     * <p>
     * Deletes the framework specified by a framework name.
     * </p>
     *
     * @param deleteFrameworkRequest
     * @return Result of the DeleteFramework operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFrameworkResponse deleteFramework(DeleteFrameworkRequest deleteFrameworkRequest)
            throws MissingParameterValueException, InvalidParameterValueException, ServiceUnavailableException,
            ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the framework specified by a framework name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFrameworkRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteFrameworkRequest#builder()}
     * </p>
     *
     * @param deleteFrameworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteFrameworkRequest.Builder} to create a request.
     * @return Result of the DeleteFramework operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFrameworkResponse deleteFramework(Consumer<DeleteFrameworkRequest.Builder> deleteFrameworkRequest)
            throws MissingParameterValueException, InvalidParameterValueException, ServiceUnavailableException,
            ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return deleteFramework(DeleteFrameworkRequest.builder().applyMutation(deleteFrameworkRequest).build());
    }

    /**
     * <p>
     * Deletes the recovery point specified by a recovery point ID.
     * </p>
     * <p>
     * If the recovery point ID belongs to a continuous backup, calling this endpoint deletes the existing continuous
     * backup and stops future continuous backup.
     * </p>
     * <p>
     * When an IAM role's permissions are insufficient to call this API, the service sends back an HTTP 200 response
     * with an empty HTTP body, but the recovery point is not deleted. Instead, it enters an <code>EXPIRED</code> state.
     * </p>
     * <p>
     * <code>EXPIRED</code> recovery points can be deleted with this API once the IAM role has the
     * <code>iam:CreateServiceLinkedRole</code> action. To learn more about adding this role, see <a href=
     * "https://docs.aws.amazon.com/aws-backup/latest/devguide/deleting-backups.html#deleting-backups-troubleshooting">
     * Troubleshooting manual deletions</a>.
     * </p>
     * <p>
     * If the user or role is deleted or the permission within the role is removed, the deletion will not be successful
     * and will enter an <code>EXPIRED</code> state.
     * </p>
     *
     * @param deleteRecoveryPointRequest
     * @return Result of the DeleteRecoveryPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidResourceStateException
     *         Backup is already performing an action on this recovery point. It can't perform the action you requested
     *         until the first action finishes. Try again later.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRecoveryPoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRecoveryPointResponse deleteRecoveryPoint(DeleteRecoveryPointRequest deleteRecoveryPointRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            InvalidResourceStateException, ServiceUnavailableException, InvalidRequestException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the recovery point specified by a recovery point ID.
     * </p>
     * <p>
     * If the recovery point ID belongs to a continuous backup, calling this endpoint deletes the existing continuous
     * backup and stops future continuous backup.
     * </p>
     * <p>
     * When an IAM role's permissions are insufficient to call this API, the service sends back an HTTP 200 response
     * with an empty HTTP body, but the recovery point is not deleted. Instead, it enters an <code>EXPIRED</code> state.
     * </p>
     * <p>
     * <code>EXPIRED</code> recovery points can be deleted with this API once the IAM role has the
     * <code>iam:CreateServiceLinkedRole</code> action. To learn more about adding this role, see <a href=
     * "https://docs.aws.amazon.com/aws-backup/latest/devguide/deleting-backups.html#deleting-backups-troubleshooting">
     * Troubleshooting manual deletions</a>.
     * </p>
     * <p>
     * If the user or role is deleted or the permission within the role is removed, the deletion will not be successful
     * and will enter an <code>EXPIRED</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRecoveryPointRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRecoveryPointRequest#builder()}
     * </p>
     *
     * @param deleteRecoveryPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteRecoveryPointRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRecoveryPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidResourceStateException
     *         Backup is already performing an action on this recovery point. It can't perform the action you requested
     *         until the first action finishes. Try again later.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRecoveryPoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRecoveryPointResponse deleteRecoveryPoint(
            Consumer<DeleteRecoveryPointRequest.Builder> deleteRecoveryPointRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, InvalidResourceStateException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        return deleteRecoveryPoint(DeleteRecoveryPointRequest.builder().applyMutation(deleteRecoveryPointRequest).build());
    }

    /**
     * <p>
     * Deletes the report plan specified by a report plan name.
     * </p>
     *
     * @param deleteReportPlanRequest
     * @return Result of the DeleteReportPlan operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteReportPlanResponse deleteReportPlan(DeleteReportPlanRequest deleteReportPlanRequest)
            throws MissingParameterValueException, InvalidParameterValueException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the report plan specified by a report plan name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReportPlanRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteReportPlanRequest#builder()}
     * </p>
     *
     * @param deleteReportPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteReportPlanRequest.Builder} to create a request.
     * @return Result of the DeleteReportPlan operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteReportPlanResponse deleteReportPlan(Consumer<DeleteReportPlanRequest.Builder> deleteReportPlanRequest)
            throws MissingParameterValueException, InvalidParameterValueException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return deleteReportPlan(DeleteReportPlanRequest.builder().applyMutation(deleteReportPlanRequest).build());
    }

    /**
     * <p>
     * Returns backup job details for the specified <code>BackupJobId</code>.
     * </p>
     *
     * @param describeBackupJobRequest
     * @return Result of the DescribeBackupJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws DependencyFailureException
     *         A dependent Amazon Web Services service or resource returned an error to the Backup service, and the
     *         action cannot be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBackupJobResponse describeBackupJob(DescribeBackupJobRequest describeBackupJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, DependencyFailureException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns backup job details for the specified <code>BackupJobId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBackupJobRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBackupJobRequest#builder()}
     * </p>
     *
     * @param describeBackupJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeBackupJobRequest.Builder} to create a request.
     * @return Result of the DescribeBackupJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws DependencyFailureException
     *         A dependent Amazon Web Services service or resource returned an error to the Backup service, and the
     *         action cannot be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBackupJobResponse describeBackupJob(Consumer<DescribeBackupJobRequest.Builder> describeBackupJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, DependencyFailureException, AwsServiceException, SdkClientException, BackupException {
        return describeBackupJob(DescribeBackupJobRequest.builder().applyMutation(describeBackupJobRequest).build());
    }

    /**
     * <p>
     * Returns metadata about a backup vault specified by its name.
     * </p>
     *
     * @param describeBackupVaultRequest
     * @return Result of the DescribeBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupVault" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeBackupVaultResponse describeBackupVault(DescribeBackupVaultRequest describeBackupVaultRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about a backup vault specified by its name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBackupVaultRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBackupVaultRequest#builder()}
     * </p>
     *
     * @param describeBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeBackupVaultRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupVault" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeBackupVaultResponse describeBackupVault(
            Consumer<DescribeBackupVaultRequest.Builder> describeBackupVaultRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return describeBackupVault(DescribeBackupVaultRequest.builder().applyMutation(describeBackupVaultRequest).build());
    }

    /**
     * <p>
     * Returns metadata associated with creating a copy of a resource.
     * </p>
     *
     * @param describeCopyJobRequest
     * @return Result of the DescribeCopyJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeCopyJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCopyJobResponse describeCopyJob(DescribeCopyJobRequest describeCopyJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata associated with creating a copy of a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCopyJobRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeCopyJobRequest#builder()}
     * </p>
     *
     * @param describeCopyJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeCopyJobRequest.Builder} to create a request.
     * @return Result of the DescribeCopyJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeCopyJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCopyJobResponse describeCopyJob(Consumer<DescribeCopyJobRequest.Builder> describeCopyJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return describeCopyJob(DescribeCopyJobRequest.builder().applyMutation(describeCopyJobRequest).build());
    }

    /**
     * <p>
     * Returns the framework details for the specified <code>FrameworkName</code>.
     * </p>
     *
     * @param describeFrameworkRequest
     * @return Result of the DescribeFramework operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFrameworkResponse describeFramework(DescribeFrameworkRequest describeFrameworkRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the framework details for the specified <code>FrameworkName</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFrameworkRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeFrameworkRequest#builder()}
     * </p>
     *
     * @param describeFrameworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeFrameworkRequest.Builder} to create a request.
     * @return Result of the DescribeFramework operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFrameworkResponse describeFramework(Consumer<DescribeFrameworkRequest.Builder> describeFrameworkRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return describeFramework(DescribeFrameworkRequest.builder().applyMutation(describeFrameworkRequest).build());
    }

    /**
     * <p>
     * Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the
     * account is not a member of an Organizations organization. Example:
     * <code>describe-global-settings --region us-west-2</code>
     * </p>
     *
     * @param describeGlobalSettingsRequest
     * @return Result of the DescribeGlobalSettings operation returned by the service.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeGlobalSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGlobalSettingsResponse describeGlobalSettings(DescribeGlobalSettingsRequest describeGlobalSettingsRequest)
            throws InvalidRequestException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the
     * account is not a member of an Organizations organization. Example:
     * <code>describe-global-settings --region us-west-2</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGlobalSettingsRequest#builder()}
     * </p>
     *
     * @param describeGlobalSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeGlobalSettings operation returned by the service.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeGlobalSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGlobalSettingsResponse describeGlobalSettings(
            Consumer<DescribeGlobalSettingsRequest.Builder> describeGlobalSettingsRequest) throws InvalidRequestException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return describeGlobalSettings(DescribeGlobalSettingsRequest.builder().applyMutation(describeGlobalSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name
     * (ARN), and the Amazon Web Services service type of the saved resource.
     * </p>
     *
     * @param describeProtectedResourceRequest
     * @return Result of the DescribeProtectedResource operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeProtectedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeProtectedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProtectedResourceResponse describeProtectedResource(
            DescribeProtectedResourceRequest describeProtectedResourceRequest) throws MissingParameterValueException,
            InvalidParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name
     * (ARN), and the Amazon Web Services service type of the saved resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProtectedResourceRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeProtectedResourceRequest#builder()}
     * </p>
     *
     * @param describeProtectedResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeProtectedResourceRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeProtectedResource operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeProtectedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeProtectedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProtectedResourceResponse describeProtectedResource(
            Consumer<DescribeProtectedResourceRequest.Builder> describeProtectedResourceRequest)
            throws MissingParameterValueException, InvalidParameterValueException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return describeProtectedResource(DescribeProtectedResourceRequest.builder()
                .applyMutation(describeProtectedResourceRequest).build());
    }

    /**
     * <p>
     * Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
     * </p>
     *
     * @param describeRecoveryPointRequest
     * @return Result of the DescribeRecoveryPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRecoveryPoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecoveryPointResponse describeRecoveryPoint(DescribeRecoveryPointRequest describeRecoveryPointRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecoveryPointRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRecoveryPointRequest#builder()}
     * </p>
     *
     * @param describeRecoveryPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeRecoveryPointRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRecoveryPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRecoveryPoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecoveryPointResponse describeRecoveryPoint(
            Consumer<DescribeRecoveryPointRequest.Builder> describeRecoveryPointRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return describeRecoveryPoint(DescribeRecoveryPointRequest.builder().applyMutation(describeRecoveryPointRequest).build());
    }

    /**
     * <p>
     * Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup
     * tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or
     * scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region.
     * </p>
     *
     * @param describeRegionSettingsRequest
     * @return Result of the DescribeRegionSettings operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeRegionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRegionSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRegionSettingsResponse describeRegionSettings(DescribeRegionSettingsRequest describeRegionSettingsRequest)
            throws ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup
     * tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or
     * scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegionSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRegionSettingsRequest#builder()}
     * </p>
     *
     * @param describeRegionSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeRegionSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRegionSettings operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeRegionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRegionSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRegionSettingsResponse describeRegionSettings(
            Consumer<DescribeRegionSettingsRequest.Builder> describeRegionSettingsRequest) throws ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        return describeRegionSettings(DescribeRegionSettingsRequest.builder().applyMutation(describeRegionSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the details associated with creating a report as specified by its <code>ReportJobId</code>.
     * </p>
     *
     * @param describeReportJobRequest
     * @return Result of the DescribeReportJob operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeReportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeReportJobResponse describeReportJob(DescribeReportJobRequest describeReportJobRequest)
            throws ServiceUnavailableException, MissingParameterValueException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details associated with creating a report as specified by its <code>ReportJobId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReportJobRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeReportJobRequest#builder()}
     * </p>
     *
     * @param describeReportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeReportJobRequest.Builder} to create a request.
     * @return Result of the DescribeReportJob operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeReportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeReportJobResponse describeReportJob(Consumer<DescribeReportJobRequest.Builder> describeReportJobRequest)
            throws ServiceUnavailableException, MissingParameterValueException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        return describeReportJob(DescribeReportJobRequest.builder().applyMutation(describeReportJobRequest).build());
    }

    /**
     * <p>
     * Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.
     * </p>
     *
     * @param describeReportPlanRequest
     * @return Result of the DescribeReportPlan operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeReportPlanResponse describeReportPlan(DescribeReportPlanRequest describeReportPlanRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReportPlanRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReportPlanRequest#builder()}
     * </p>
     *
     * @param describeReportPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeReportPlanRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeReportPlan operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeReportPlanResponse describeReportPlan(Consumer<DescribeReportPlanRequest.Builder> describeReportPlanRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return describeReportPlan(DescribeReportPlanRequest.builder().applyMutation(describeReportPlanRequest).build());
    }

    /**
     * <p>
     * Returns metadata associated with a restore job that is specified by a job ID.
     * </p>
     *
     * @param describeRestoreJobRequest
     * @return Result of the DescribeRestoreJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws DependencyFailureException
     *         A dependent Amazon Web Services service or resource returned an error to the Backup service, and the
     *         action cannot be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeRestoreJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRestoreJobResponse describeRestoreJob(DescribeRestoreJobRequest describeRestoreJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, DependencyFailureException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata associated with a restore job that is specified by a job ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRestoreJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRestoreJobRequest#builder()}
     * </p>
     *
     * @param describeRestoreJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeRestoreJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRestoreJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws DependencyFailureException
     *         A dependent Amazon Web Services service or resource returned an error to the Backup service, and the
     *         action cannot be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeRestoreJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRestoreJobResponse describeRestoreJob(Consumer<DescribeRestoreJobRequest.Builder> describeRestoreJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, DependencyFailureException, AwsServiceException, SdkClientException, BackupException {
        return describeRestoreJob(DescribeRestoreJobRequest.builder().applyMutation(describeRestoreJobRequest).build());
    }

    /**
     * <p>
     * Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup
     * to the source service, such as Amazon RDS. The source service will continue to create and retain continuous
     * backups using the lifecycle that you specified in your original backup plan.
     * </p>
     * <p>
     * Does not support snapshot backup recovery points.
     * </p>
     *
     * @param disassociateRecoveryPointRequest
     * @return Result of the DisassociateRecoveryPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidResourceStateException
     *         Backup is already performing an action on this recovery point. It can't perform the action you requested
     *         until the first action finishes. Try again later.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DisassociateRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateRecoveryPointResponse disassociateRecoveryPoint(
            DisassociateRecoveryPointRequest disassociateRecoveryPointRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, InvalidResourceStateException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup
     * to the source service, such as Amazon RDS. The source service will continue to create and retain continuous
     * backups using the lifecycle that you specified in your original backup plan.
     * </p>
     * <p>
     * Does not support snapshot backup recovery points.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateRecoveryPointRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateRecoveryPointRequest#builder()}
     * </p>
     *
     * @param disassociateRecoveryPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateRecoveryPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidResourceStateException
     *         Backup is already performing an action on this recovery point. It can't perform the action you requested
     *         until the first action finishes. Try again later.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DisassociateRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateRecoveryPointResponse disassociateRecoveryPoint(
            Consumer<DisassociateRecoveryPointRequest.Builder> disassociateRecoveryPointRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            InvalidResourceStateException, ServiceUnavailableException, InvalidRequestException, AwsServiceException,
            SdkClientException, BackupException {
        return disassociateRecoveryPoint(DisassociateRecoveryPointRequest.builder()
                .applyMutation(disassociateRecoveryPointRequest).build());
    }

    /**
     * <p>
     * This action to a specific child (nested) recovery point removes the relationship between the specified recovery
     * point and its parent (composite) recovery point.
     * </p>
     *
     * @param disassociateRecoveryPointFromParentRequest
     * @return Result of the DisassociateRecoveryPointFromParent operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DisassociateRecoveryPointFromParent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPointFromParent"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateRecoveryPointFromParentResponse disassociateRecoveryPointFromParent(
            DisassociateRecoveryPointFromParentRequest disassociateRecoveryPointFromParentRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action to a specific child (nested) recovery point removes the relationship between the specified recovery
     * point and its parent (composite) recovery point.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateRecoveryPointFromParentRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateRecoveryPointFromParentRequest#builder()}
     * </p>
     *
     * @param disassociateRecoveryPointFromParentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateRecoveryPointFromParent operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DisassociateRecoveryPointFromParent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPointFromParent"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateRecoveryPointFromParentResponse disassociateRecoveryPointFromParent(
            Consumer<DisassociateRecoveryPointFromParentRequest.Builder> disassociateRecoveryPointFromParentRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        return disassociateRecoveryPointFromParent(DisassociateRecoveryPointFromParentRequest.builder()
                .applyMutation(disassociateRecoveryPointFromParentRequest).build());
    }

    /**
     * <p>
     * Returns the backup plan that is specified by the plan ID as a backup template.
     * </p>
     *
     * @param exportBackupPlanTemplateRequest
     * @return Result of the ExportBackupPlanTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ExportBackupPlanTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ExportBackupPlanTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportBackupPlanTemplateResponse exportBackupPlanTemplate(
            ExportBackupPlanTemplateRequest exportBackupPlanTemplateRequest) throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the backup plan that is specified by the plan ID as a backup template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportBackupPlanTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link ExportBackupPlanTemplateRequest#builder()}
     * </p>
     *
     * @param exportBackupPlanTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the ExportBackupPlanTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ExportBackupPlanTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ExportBackupPlanTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportBackupPlanTemplateResponse exportBackupPlanTemplate(
            Consumer<ExportBackupPlanTemplateRequest.Builder> exportBackupPlanTemplateRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return exportBackupPlanTemplate(ExportBackupPlanTemplateRequest.builder().applyMutation(exportBackupPlanTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Returns <code>BackupPlan</code> details for the specified <code>BackupPlanId</code>. The details are the body of
     * a backup plan in JSON format, in addition to plan metadata.
     * </p>
     *
     * @param getBackupPlanRequest
     * @return Result of the GetBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBackupPlanResponse getBackupPlan(GetBackupPlanRequest getBackupPlanRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns <code>BackupPlan</code> details for the specified <code>BackupPlanId</code>. The details are the body of
     * a backup plan in JSON format, in addition to plan metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupPlanRequest.Builder} avoiding the need to
     * create one manually via {@link GetBackupPlanRequest#builder()}
     * </p>
     *
     * @param getBackupPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetBackupPlanRequest.Builder} to create a request.
     * @return Result of the GetBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBackupPlanResponse getBackupPlan(Consumer<GetBackupPlanRequest.Builder> getBackupPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return getBackupPlan(GetBackupPlanRequest.builder().applyMutation(getBackupPlanRequest).build());
    }

    /**
     * <p>
     * Returns a valid JSON document specifying a backup plan or an error.
     * </p>
     *
     * @param getBackupPlanFromJsonRequest
     * @return Result of the GetBackupPlanFromJSON operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlanFromJSON
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromJSON" target="_top">AWS
     *      API Documentation</a>
     */
    default GetBackupPlanFromJsonResponse getBackupPlanFromJSON(GetBackupPlanFromJsonRequest getBackupPlanFromJsonRequest)
            throws LimitExceededException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a valid JSON document specifying a backup plan or an error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupPlanFromJsonRequest.Builder} avoiding the
     * need to create one manually via {@link GetBackupPlanFromJsonRequest#builder()}
     * </p>
     *
     * @param getBackupPlanFromJsonRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonRequest.Builder} to create a
     *        request.
     * @return Result of the GetBackupPlanFromJSON operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlanFromJSON
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromJSON" target="_top">AWS
     *      API Documentation</a>
     */
    default GetBackupPlanFromJsonResponse getBackupPlanFromJSON(
            Consumer<GetBackupPlanFromJsonRequest.Builder> getBackupPlanFromJsonRequest) throws LimitExceededException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, InvalidRequestException,
            AwsServiceException, SdkClientException, BackupException {
        return getBackupPlanFromJSON(GetBackupPlanFromJsonRequest.builder().applyMutation(getBackupPlanFromJsonRequest).build());
    }

    /**
     * <p>
     * Returns the template specified by its <code>templateId</code> as a backup plan.
     * </p>
     *
     * @param getBackupPlanFromTemplateRequest
     * @return Result of the GetBackupPlanFromTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlanFromTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackupPlanFromTemplateResponse getBackupPlanFromTemplate(
            GetBackupPlanFromTemplateRequest getBackupPlanFromTemplateRequest) throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the template specified by its <code>templateId</code> as a backup plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupPlanFromTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link GetBackupPlanFromTemplateRequest#builder()}
     * </p>
     *
     * @param getBackupPlanFromTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the GetBackupPlanFromTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlanFromTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackupPlanFromTemplateResponse getBackupPlanFromTemplate(
            Consumer<GetBackupPlanFromTemplateRequest.Builder> getBackupPlanFromTemplateRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return getBackupPlanFromTemplate(GetBackupPlanFromTemplateRequest.builder()
                .applyMutation(getBackupPlanFromTemplateRequest).build());
    }

    /**
     * <p>
     * Returns selection metadata and a document in JSON format that specifies a list of resources that are associated
     * with a backup plan.
     * </p>
     *
     * @param getBackupSelectionRequest
     * @return Result of the GetBackupSelection operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupSelection" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBackupSelectionResponse getBackupSelection(GetBackupSelectionRequest getBackupSelectionRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns selection metadata and a document in JSON format that specifies a list of resources that are associated
     * with a backup plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupSelectionRequest.Builder} avoiding the
     * need to create one manually via {@link GetBackupSelectionRequest#builder()}
     * </p>
     *
     * @param getBackupSelectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest.Builder} to create a
     *        request.
     * @return Result of the GetBackupSelection operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupSelection" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBackupSelectionResponse getBackupSelection(Consumer<GetBackupSelectionRequest.Builder> getBackupSelectionRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return getBackupSelection(GetBackupSelectionRequest.builder().applyMutation(getBackupSelectionRequest).build());
    }

    /**
     * <p>
     * Returns the access policy document that is associated with the named backup vault.
     * </p>
     *
     * @param getBackupVaultAccessPolicyRequest
     * @return Result of the GetBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackupVaultAccessPolicyResponse getBackupVaultAccessPolicy(
            GetBackupVaultAccessPolicyRequest getBackupVaultAccessPolicyRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the access policy document that is associated with the named backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupVaultAccessPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetBackupVaultAccessPolicyRequest#builder()}
     * </p>
     *
     * @param getBackupVaultAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackupVaultAccessPolicyResponse getBackupVaultAccessPolicy(
            Consumer<GetBackupVaultAccessPolicyRequest.Builder> getBackupVaultAccessPolicyRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return getBackupVaultAccessPolicy(GetBackupVaultAccessPolicyRequest.builder()
                .applyMutation(getBackupVaultAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Returns event notifications for the specified backup vault.
     * </p>
     *
     * @param getBackupVaultNotificationsRequest
     * @return Result of the GetBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackupVaultNotificationsResponse getBackupVaultNotifications(
            GetBackupVaultNotificationsRequest getBackupVaultNotificationsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns event notifications for the specified backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupVaultNotificationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetBackupVaultNotificationsRequest#builder()}
     * </p>
     *
     * @param getBackupVaultNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsRequest.Builder} to create
     *        a request.
     * @return Result of the GetBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackupVaultNotificationsResponse getBackupVaultNotifications(
            Consumer<GetBackupVaultNotificationsRequest.Builder> getBackupVaultNotificationsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return getBackupVaultNotifications(GetBackupVaultNotificationsRequest.builder()
                .applyMutation(getBackupVaultNotificationsRequest).build());
    }

    /**
     * <p>
     * This action returns details for a specified legal hold. The details are the body of a legal hold in JSON format,
     * in addition to metadata.
     * </p>
     *
     * @param getLegalHoldRequest
     * @return Result of the GetLegalHold operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLegalHoldResponse getLegalHold(GetLegalHoldRequest getLegalHoldRequest) throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action returns details for a specified legal hold. The details are the body of a legal hold in JSON format,
     * in addition to metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLegalHoldRequest.Builder} avoiding the need to
     * create one manually via {@link GetLegalHoldRequest#builder()}
     * </p>
     *
     * @param getLegalHoldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetLegalHoldRequest.Builder} to create a request.
     * @return Result of the GetLegalHold operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLegalHoldResponse getLegalHold(Consumer<GetLegalHoldRequest.Builder> getLegalHoldRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return getLegalHold(GetLegalHoldRequest.builder().applyMutation(getLegalHoldRequest).build());
    }

    /**
     * <p>
     * Returns a set of metadata key-value pairs that were used to create the backup.
     * </p>
     *
     * @param getRecoveryPointRestoreMetadataRequest
     * @return Result of the GetRecoveryPointRestoreMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetRecoveryPointRestoreMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRecoveryPointRestoreMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecoveryPointRestoreMetadataResponse getRecoveryPointRestoreMetadata(
            GetRecoveryPointRestoreMetadataRequest getRecoveryPointRestoreMetadataRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a set of metadata key-value pairs that were used to create the backup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecoveryPointRestoreMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link GetRecoveryPointRestoreMetadataRequest#builder()}
     * </p>
     *
     * @param getRecoveryPointRestoreMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataRequest.Builder} to
     *        create a request.
     * @return Result of the GetRecoveryPointRestoreMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetRecoveryPointRestoreMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRecoveryPointRestoreMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecoveryPointRestoreMetadataResponse getRecoveryPointRestoreMetadata(
            Consumer<GetRecoveryPointRestoreMetadataRequest.Builder> getRecoveryPointRestoreMetadataRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return getRecoveryPointRestoreMetadata(GetRecoveryPointRestoreMetadataRequest.builder()
                .applyMutation(getRecoveryPointRestoreMetadataRequest).build());
    }

    /**
     * <p>
     * Returns the Amazon Web Services resource types supported by Backup.
     * </p>
     *
     * @param getSupportedResourceTypesRequest
     * @return Result of the GetSupportedResourceTypes operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSupportedResourceTypesResponse getSupportedResourceTypes(
            GetSupportedResourceTypesRequest getSupportedResourceTypesRequest) throws ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the Amazon Web Services resource types supported by Backup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSupportedResourceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link GetSupportedResourceTypesRequest#builder()}
     * </p>
     *
     * @param getSupportedResourceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesRequest.Builder} to create a
     *        request.
     * @return Result of the GetSupportedResourceTypes operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSupportedResourceTypesResponse getSupportedResourceTypes(
            Consumer<GetSupportedResourceTypesRequest.Builder> getSupportedResourceTypesRequest)
            throws ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return getSupportedResourceTypes(GetSupportedResourceTypesRequest.builder()
                .applyMutation(getSupportedResourceTypesRequest).build());
    }

    /**
     * <p>
     * This is a request for a summary of backup jobs created or running within the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     *
     * @param listBackupJobSummariesRequest
     * @return Result of the ListBackupJobSummaries operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupJobSummariesResponse listBackupJobSummaries(ListBackupJobSummariesRequest listBackupJobSummariesRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is a request for a summary of backup jobs created or running within the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupJobSummariesRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupJobSummariesRequest#builder()}
     * </p>
     *
     * @param listBackupJobSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest.Builder} to create a
     *        request.
     * @return Result of the ListBackupJobSummaries operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupJobSummariesResponse listBackupJobSummaries(
            Consumer<ListBackupJobSummariesRequest.Builder> listBackupJobSummariesRequest) throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupJobSummaries(ListBackupJobSummariesRequest.builder().applyMutation(listBackupJobSummariesRequest)
                .build());
    }

    /**
     * <p>
     * This is a request for a summary of backup jobs created or running within the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupJobSummaries(software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobSummariesIterable responses = client.listBackupJobSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupJobSummariesIterable responses = client
     *             .listBackupJobSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupJobSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobSummariesIterable responses = client.listBackupJobSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupJobSummaries(software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBackupJobSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupJobSummariesIterable listBackupJobSummariesPaginator(
            ListBackupJobSummariesRequest listBackupJobSummariesRequest) throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListBackupJobSummariesIterable(this, listBackupJobSummariesRequest);
    }

    /**
     * <p>
     * This is a request for a summary of backup jobs created or running within the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupJobSummaries(software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobSummariesIterable responses = client.listBackupJobSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupJobSummariesIterable responses = client
     *             .listBackupJobSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupJobSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobSummariesIterable responses = client.listBackupJobSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupJobSummaries(software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupJobSummariesRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupJobSummariesRequest#builder()}
     * </p>
     *
     * @param listBackupJobSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupJobSummariesIterable listBackupJobSummariesPaginator(
            Consumer<ListBackupJobSummariesRequest.Builder> listBackupJobSummariesRequest) throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupJobSummariesPaginator(ListBackupJobSummariesRequest.builder()
                .applyMutation(listBackupJobSummariesRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of
     * time, consider using these <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">monitoring tools</a>.
     * </p>
     *
     * @param listBackupJobsRequest
     * @return Result of the ListBackupJobs operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsResponse listBackupJobs(ListBackupJobsRequest listBackupJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of
     * time, consider using these <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">monitoring tools</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBackupJobsRequest#builder()}
     * </p>
     *
     * @param listBackupJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupJobsRequest.Builder} to create a request.
     * @return Result of the ListBackupJobs operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsResponse listBackupJobs(Consumer<ListBackupJobsRequest.Builder> listBackupJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return listBackupJobs(ListBackupJobsRequest.builder().applyMutation(listBackupJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of
     * time, consider using these <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">monitoring tools</a>.
     * </p>
     *
     * @return Result of the ListBackupJobs operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobs
     * @see #listBackupJobs(ListBackupJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsResponse listBackupJobs() throws InvalidParameterValueException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        return listBackupJobs(ListBackupJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of
     * time, consider using these <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">monitoring tools</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobs
     * @see #listBackupJobsPaginator(ListBackupJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsIterable listBackupJobsPaginator() throws InvalidParameterValueException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        return listBackupJobsPaginator(ListBackupJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of
     * time, consider using these <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">monitoring tools</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)} operation.</b>
     * </p>
     *
     * @param listBackupJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsIterable listBackupJobsPaginator(ListBackupJobsRequest listBackupJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return new ListBackupJobsIterable(this, listBackupJobsRequest);
    }

    /**
     * <p>
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of
     * time, consider using these <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">monitoring tools</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBackupJobsRequest#builder()}
     * </p>
     *
     * @param listBackupJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsIterable listBackupJobsPaginator(Consumer<ListBackupJobsRequest.Builder> listBackupJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return listBackupJobsPaginator(ListBackupJobsRequest.builder().applyMutation(listBackupJobsRequest).build());
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     *
     * @param listBackupPlanTemplatesRequest
     * @return Result of the ListBackupPlanTemplates operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackupPlanTemplatesResponse listBackupPlanTemplates(ListBackupPlanTemplatesRequest listBackupPlanTemplatesRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlanTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListBackupPlanTemplatesRequest#builder()}
     * </p>
     *
     * @param listBackupPlanTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest.Builder} to create a
     *        request.
     * @return Result of the ListBackupPlanTemplates operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackupPlanTemplatesResponse listBackupPlanTemplates(
            Consumer<ListBackupPlanTemplatesRequest.Builder> listBackupPlanTemplatesRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return listBackupPlanTemplates(ListBackupPlanTemplatesRequest.builder().applyMutation(listBackupPlanTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     *
     * @return Result of the ListBackupPlanTemplates operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanTemplates
     * @see #listBackupPlanTemplates(ListBackupPlanTemplatesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackupPlanTemplatesResponse listBackupPlanTemplates() throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        return listBackupPlanTemplates(ListBackupPlanTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client.listBackupPlanTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client
     *             .listBackupPlanTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client.listBackupPlanTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanTemplates
     * @see #listBackupPlanTemplatesPaginator(ListBackupPlanTemplatesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackupPlanTemplatesIterable listBackupPlanTemplatesPaginator() throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        return listBackupPlanTemplatesPaginator(ListBackupPlanTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client.listBackupPlanTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client
     *             .listBackupPlanTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client.listBackupPlanTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBackupPlanTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackupPlanTemplatesIterable listBackupPlanTemplatesPaginator(
            ListBackupPlanTemplatesRequest listBackupPlanTemplatesRequest) throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        return new ListBackupPlanTemplatesIterable(this, listBackupPlanTemplatesRequest);
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client.listBackupPlanTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client
     *             .listBackupPlanTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client.listBackupPlanTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlanTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListBackupPlanTemplatesRequest#builder()}
     * </p>
     *
     * @param listBackupPlanTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackupPlanTemplatesIterable listBackupPlanTemplatesPaginator(
            Consumer<ListBackupPlanTemplatesRequest.Builder> listBackupPlanTemplatesRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return listBackupPlanTemplatesPaginator(ListBackupPlanTemplatesRequest.builder()
                .applyMutation(listBackupPlanTemplatesRequest).build());
    }

    /**
     * <p>
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation
     * and deletion dates, plan names, and version IDs.
     * </p>
     *
     * @param listBackupPlanVersionsRequest
     * @return Result of the ListBackupPlanVersions operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanVersionsResponse listBackupPlanVersions(ListBackupPlanVersionsRequest listBackupPlanVersionsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation
     * and deletion dates, plan names, and version IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlanVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupPlanVersionsRequest#builder()}
     * </p>
     *
     * @param listBackupPlanVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListBackupPlanVersions operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanVersionsResponse listBackupPlanVersions(
            Consumer<ListBackupPlanVersionsRequest.Builder> listBackupPlanVersionsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return listBackupPlanVersions(ListBackupPlanVersionsRequest.builder().applyMutation(listBackupPlanVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation
     * and deletion dates, plan names, and version IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlanVersions(software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable responses = client.listBackupPlanVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable responses = client
     *             .listBackupPlanVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable responses = client.listBackupPlanVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanVersions(software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBackupPlanVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanVersionsIterable listBackupPlanVersionsPaginator(
            ListBackupPlanVersionsRequest listBackupPlanVersionsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return new ListBackupPlanVersionsIterable(this, listBackupPlanVersionsRequest);
    }

    /**
     * <p>
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation
     * and deletion dates, plan names, and version IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlanVersions(software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable responses = client.listBackupPlanVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable responses = client
     *             .listBackupPlanVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable responses = client.listBackupPlanVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanVersions(software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlanVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupPlanVersionsRequest#builder()}
     * </p>
     *
     * @param listBackupPlanVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanVersionsIterable listBackupPlanVersionsPaginator(
            Consumer<ListBackupPlanVersionsRequest.Builder> listBackupPlanVersionsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return listBackupPlanVersionsPaginator(ListBackupPlanVersionsRequest.builder()
                .applyMutation(listBackupPlanVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as
     * Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request
     * IDs.
     * </p>
     *
     * @param listBackupPlansRequest
     * @return Result of the ListBackupPlans operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansResponse listBackupPlans(ListBackupPlansRequest listBackupPlansRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as
     * Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request
     * IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackupPlansRequest#builder()}
     * </p>
     *
     * @param listBackupPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupPlansRequest.Builder} to create a request.
     * @return Result of the ListBackupPlans operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansResponse listBackupPlans(Consumer<ListBackupPlansRequest.Builder> listBackupPlansRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupPlans(ListBackupPlansRequest.builder().applyMutation(listBackupPlansRequest).build());
    }

    /**
     * <p>
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as
     * Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request
     * IDs.
     * </p>
     *
     * @return Result of the ListBackupPlans operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlans
     * @see #listBackupPlans(ListBackupPlansRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansResponse listBackupPlans() throws ResourceNotFoundException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupPlans(ListBackupPlansRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as
     * Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request
     * IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client.listBackupPlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client
     *             .listBackupPlansPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client.listBackupPlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlans
     * @see #listBackupPlansPaginator(ListBackupPlansRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansIterable listBackupPlansPaginator() throws ResourceNotFoundException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupPlansPaginator(ListBackupPlansRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as
     * Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request
     * IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client.listBackupPlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client
     *             .listBackupPlansPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client.listBackupPlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation.</b>
     * </p>
     *
     * @param listBackupPlansRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansIterable listBackupPlansPaginator(ListBackupPlansRequest listBackupPlansRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListBackupPlansIterable(this, listBackupPlansRequest);
    }

    /**
     * <p>
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as
     * Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request
     * IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client.listBackupPlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client
     *             .listBackupPlansPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client.listBackupPlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackupPlansRequest#builder()}
     * </p>
     *
     * @param listBackupPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupPlansRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansIterable listBackupPlansPaginator(Consumer<ListBackupPlansRequest.Builder> listBackupPlansRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupPlansPaginator(ListBackupPlansRequest.builder().applyMutation(listBackupPlansRequest).build());
    }

    /**
     * <p>
     * Returns an array containing metadata of the resources associated with the target backup plan.
     * </p>
     *
     * @param listBackupSelectionsRequest
     * @return Result of the ListBackupSelections operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupSelectionsResponse listBackupSelections(ListBackupSelectionsRequest listBackupSelectionsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array containing metadata of the resources associated with the target backup plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupSelectionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupSelectionsRequest#builder()}
     * </p>
     *
     * @param listBackupSelectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListBackupSelections operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupSelectionsResponse listBackupSelections(
            Consumer<ListBackupSelectionsRequest.Builder> listBackupSelectionsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return listBackupSelections(ListBackupSelectionsRequest.builder().applyMutation(listBackupSelectionsRequest).build());
    }

    /**
     * <p>
     * Returns an array containing metadata of the resources associated with the target backup plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupSelections(software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable responses = client.listBackupSelectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable responses = client
     *             .listBackupSelectionsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable responses = client.listBackupSelectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupSelections(software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBackupSelectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupSelectionsIterable listBackupSelectionsPaginator(ListBackupSelectionsRequest listBackupSelectionsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListBackupSelectionsIterable(this, listBackupSelectionsRequest);
    }

    /**
     * <p>
     * Returns an array containing metadata of the resources associated with the target backup plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupSelections(software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable responses = client.listBackupSelectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable responses = client
     *             .listBackupSelectionsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable responses = client.listBackupSelectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupSelections(software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupSelectionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupSelectionsRequest#builder()}
     * </p>
     *
     * @param listBackupSelectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupSelectionsIterable listBackupSelectionsPaginator(
            Consumer<ListBackupSelectionsRequest.Builder> listBackupSelectionsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return listBackupSelectionsPaginator(ListBackupSelectionsRequest.builder().applyMutation(listBackupSelectionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     *
     * @param listBackupVaultsRequest
     * @return Result of the ListBackupVaults operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupVaults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsResponse listBackupVaults(ListBackupVaultsRequest listBackupVaultsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupVaultsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackupVaultsRequest#builder()}
     * </p>
     *
     * @param listBackupVaultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest.Builder} to create a request.
     * @return Result of the ListBackupVaults operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupVaults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsResponse listBackupVaults(Consumer<ListBackupVaultsRequest.Builder> listBackupVaultsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupVaults(ListBackupVaultsRequest.builder().applyMutation(listBackupVaultsRequest).build());
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     *
     * @return Result of the ListBackupVaults operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupVaults
     * @see #listBackupVaults(ListBackupVaultsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsResponse listBackupVaults() throws ResourceNotFoundException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupVaults(ListBackupVaultsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client.listBackupVaultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client
     *             .listBackupVaultsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client.listBackupVaultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupVaults
     * @see #listBackupVaultsPaginator(ListBackupVaultsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsIterable listBackupVaultsPaginator() throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return listBackupVaultsPaginator(ListBackupVaultsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client.listBackupVaultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client
     *             .listBackupVaultsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client.listBackupVaultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation.</b>
     * </p>
     *
     * @param listBackupVaultsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupVaults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsIterable listBackupVaultsPaginator(ListBackupVaultsRequest listBackupVaultsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListBackupVaultsIterable(this, listBackupVaultsRequest);
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client.listBackupVaultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client
     *             .listBackupVaultsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client.listBackupVaultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupVaultsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackupVaultsRequest#builder()}
     * </p>
     *
     * @param listBackupVaultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupVaults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsIterable listBackupVaultsPaginator(Consumer<ListBackupVaultsRequest.Builder> listBackupVaultsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupVaultsPaginator(ListBackupVaultsRequest.builder().applyMutation(listBackupVaultsRequest).build());
    }

    /**
     * <p>
     * This request obtains a list of copy jobs created or running within the the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     *
     * @param listCopyJobSummariesRequest
     * @return Result of the ListCopyJobSummaries operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListCopyJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCopyJobSummariesResponse listCopyJobSummaries(ListCopyJobSummariesRequest listCopyJobSummariesRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request obtains a list of copy jobs created or running within the the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCopyJobSummariesRequest.Builder} avoiding the
     * need to create one manually via {@link ListCopyJobSummariesRequest#builder()}
     * </p>
     *
     * @param listCopyJobSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest.Builder} to create a
     *        request.
     * @return Result of the ListCopyJobSummaries operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListCopyJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCopyJobSummariesResponse listCopyJobSummaries(
            Consumer<ListCopyJobSummariesRequest.Builder> listCopyJobSummariesRequest) throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listCopyJobSummaries(ListCopyJobSummariesRequest.builder().applyMutation(listCopyJobSummariesRequest).build());
    }

    /**
     * <p>
     * This request obtains a list of copy jobs created or running within the the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCopyJobSummaries(software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobSummariesIterable responses = client.listCopyJobSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListCopyJobSummariesIterable responses = client
     *             .listCopyJobSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListCopyJobSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobSummariesIterable responses = client.listCopyJobSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCopyJobSummaries(software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCopyJobSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListCopyJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCopyJobSummariesIterable listCopyJobSummariesPaginator(ListCopyJobSummariesRequest listCopyJobSummariesRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return new ListCopyJobSummariesIterable(this, listCopyJobSummariesRequest);
    }

    /**
     * <p>
     * This request obtains a list of copy jobs created or running within the the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCopyJobSummaries(software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobSummariesIterable responses = client.listCopyJobSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListCopyJobSummariesIterable responses = client
     *             .listCopyJobSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListCopyJobSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobSummariesIterable responses = client.listCopyJobSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCopyJobSummaries(software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCopyJobSummariesRequest.Builder} avoiding the
     * need to create one manually via {@link ListCopyJobSummariesRequest#builder()}
     * </p>
     *
     * @param listCopyJobSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListCopyJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCopyJobSummariesIterable listCopyJobSummariesPaginator(
            Consumer<ListCopyJobSummariesRequest.Builder> listCopyJobSummariesRequest) throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listCopyJobSummariesPaginator(ListCopyJobSummariesRequest.builder().applyMutation(listCopyJobSummariesRequest)
                .build());
    }

    /**
     * <p>
     * Returns metadata about your copy jobs.
     * </p>
     *
     * @param listCopyJobsRequest
     * @return Result of the ListCopyJobs operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListCopyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCopyJobsResponse listCopyJobs(ListCopyJobsRequest listCopyJobsRequest) throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about your copy jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCopyJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCopyJobsRequest#builder()}
     * </p>
     *
     * @param listCopyJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListCopyJobsRequest.Builder} to create a request.
     * @return Result of the ListCopyJobs operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListCopyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCopyJobsResponse listCopyJobs(Consumer<ListCopyJobsRequest.Builder> listCopyJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return listCopyJobs(ListCopyJobsRequest.builder().applyMutation(listCopyJobsRequest).build());
    }

    /**
     * <p>
     * Returns metadata about your copy jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCopyJobs(software.amazon.awssdk.services.backup.model.ListCopyJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobsIterable responses = client.listCopyJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListCopyJobsIterable responses = client.listCopyJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListCopyJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobsIterable responses = client.listCopyJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCopyJobs(software.amazon.awssdk.services.backup.model.ListCopyJobsRequest)} operation.</b>
     * </p>
     *
     * @param listCopyJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListCopyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCopyJobsIterable listCopyJobsPaginator(ListCopyJobsRequest listCopyJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return new ListCopyJobsIterable(this, listCopyJobsRequest);
    }

    /**
     * <p>
     * Returns metadata about your copy jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCopyJobs(software.amazon.awssdk.services.backup.model.ListCopyJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobsIterable responses = client.listCopyJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListCopyJobsIterable responses = client.listCopyJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListCopyJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobsIterable responses = client.listCopyJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCopyJobs(software.amazon.awssdk.services.backup.model.ListCopyJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCopyJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCopyJobsRequest#builder()}
     * </p>
     *
     * @param listCopyJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListCopyJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListCopyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCopyJobsIterable listCopyJobsPaginator(Consumer<ListCopyJobsRequest.Builder> listCopyJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return listCopyJobsPaginator(ListCopyJobsRequest.builder().applyMutation(listCopyJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
     * </p>
     *
     * @param listFrameworksRequest
     * @return Result of the ListFrameworks operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListFrameworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFrameworksResponse listFrameworks(ListFrameworksRequest listFrameworksRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFrameworksRequest.Builder} avoiding the need to
     * create one manually via {@link ListFrameworksRequest#builder()}
     * </p>
     *
     * @param listFrameworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListFrameworksRequest.Builder} to create a request.
     * @return Result of the ListFrameworks operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListFrameworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFrameworksResponse listFrameworks(Consumer<ListFrameworksRequest.Builder> listFrameworksRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return listFrameworks(ListFrameworksRequest.builder().applyMutation(listFrameworksRequest).build());
    }

    /**
     * <p>
     * Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFrameworks(software.amazon.awssdk.services.backup.model.ListFrameworksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListFrameworksIterable responses = client.listFrameworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListFrameworksIterable responses = client.listFrameworksPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListFrameworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListFrameworksIterable responses = client.listFrameworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFrameworks(software.amazon.awssdk.services.backup.model.ListFrameworksRequest)} operation.</b>
     * </p>
     *
     * @param listFrameworksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListFrameworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFrameworksIterable listFrameworksPaginator(ListFrameworksRequest listFrameworksRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return new ListFrameworksIterable(this, listFrameworksRequest);
    }

    /**
     * <p>
     * Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFrameworks(software.amazon.awssdk.services.backup.model.ListFrameworksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListFrameworksIterable responses = client.listFrameworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListFrameworksIterable responses = client.listFrameworksPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListFrameworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListFrameworksIterable responses = client.listFrameworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFrameworks(software.amazon.awssdk.services.backup.model.ListFrameworksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFrameworksRequest.Builder} avoiding the need to
     * create one manually via {@link ListFrameworksRequest#builder()}
     * </p>
     *
     * @param listFrameworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListFrameworksRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListFrameworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFrameworksIterable listFrameworksPaginator(Consumer<ListFrameworksRequest.Builder> listFrameworksRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return listFrameworksPaginator(ListFrameworksRequest.builder().applyMutation(listFrameworksRequest).build());
    }

    /**
     * <p>
     * This action returns metadata about active and previous legal holds.
     * </p>
     *
     * @param listLegalHoldsRequest
     * @return Result of the ListLegalHolds operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListLegalHolds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListLegalHolds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLegalHoldsResponse listLegalHolds(ListLegalHoldsRequest listLegalHoldsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action returns metadata about active and previous legal holds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLegalHoldsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLegalHoldsRequest#builder()}
     * </p>
     *
     * @param listLegalHoldsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest.Builder} to create a request.
     * @return Result of the ListLegalHolds operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListLegalHolds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListLegalHolds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLegalHoldsResponse listLegalHolds(Consumer<ListLegalHoldsRequest.Builder> listLegalHoldsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return listLegalHolds(ListLegalHoldsRequest.builder().applyMutation(listLegalHoldsRequest).build());
    }

    /**
     * <p>
     * This action returns metadata about active and previous legal holds.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLegalHolds(software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListLegalHoldsIterable responses = client.listLegalHoldsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListLegalHoldsIterable responses = client.listLegalHoldsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListLegalHoldsIterable responses = client.listLegalHoldsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLegalHolds(software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest)} operation.</b>
     * </p>
     *
     * @param listLegalHoldsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListLegalHolds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListLegalHolds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLegalHoldsIterable listLegalHoldsPaginator(ListLegalHoldsRequest listLegalHoldsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return new ListLegalHoldsIterable(this, listLegalHoldsRequest);
    }

    /**
     * <p>
     * This action returns metadata about active and previous legal holds.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLegalHolds(software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListLegalHoldsIterable responses = client.listLegalHoldsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListLegalHoldsIterable responses = client.listLegalHoldsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListLegalHoldsIterable responses = client.listLegalHoldsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLegalHolds(software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLegalHoldsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLegalHoldsRequest#builder()}
     * </p>
     *
     * @param listLegalHoldsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListLegalHolds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListLegalHolds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLegalHoldsIterable listLegalHoldsPaginator(Consumer<ListLegalHoldsRequest.Builder> listLegalHoldsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return listLegalHoldsPaginator(ListLegalHoldsRequest.builder().applyMutation(listLegalHoldsRequest).build());
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     *
     * @param listProtectedResourcesRequest
     * @return Result of the ListProtectedResources operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesResponse listProtectedResources(ListProtectedResourcesRequest listProtectedResourcesRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectedResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProtectedResourcesRequest#builder()}
     * </p>
     *
     * @param listProtectedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest.Builder} to create a
     *        request.
     * @return Result of the ListProtectedResources operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesResponse listProtectedResources(
            Consumer<ListProtectedResourcesRequest.Builder> listProtectedResourcesRequest) throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listProtectedResources(ListProtectedResourcesRequest.builder().applyMutation(listProtectedResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     *
     * @return Result of the ListProtectedResources operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResources
     * @see #listProtectedResources(ListProtectedResourcesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesResponse listProtectedResources() throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listProtectedResources(ListProtectedResourcesRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client.listProtectedResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client
     *             .listProtectedResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client.listProtectedResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResources
     * @see #listProtectedResourcesPaginator(ListProtectedResourcesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesIterable listProtectedResourcesPaginator() throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listProtectedResourcesPaginator(ListProtectedResourcesRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client.listProtectedResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client
     *             .listProtectedResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client.listProtectedResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProtectedResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesIterable listProtectedResourcesPaginator(
            ListProtectedResourcesRequest listProtectedResourcesRequest) throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListProtectedResourcesIterable(this, listProtectedResourcesRequest);
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client.listProtectedResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client
     *             .listProtectedResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client.listProtectedResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectedResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProtectedResourcesRequest#builder()}
     * </p>
     *
     * @param listProtectedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesIterable listProtectedResourcesPaginator(
            Consumer<ListProtectedResourcesRequest.Builder> listProtectedResourcesRequest) throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listProtectedResourcesPaginator(ListProtectedResourcesRequest.builder()
                .applyMutation(listProtectedResourcesRequest).build());
    }

    /**
     * <p>
     * This request lists the protected resources corresponding to each backup vault.
     * </p>
     *
     * @param listProtectedResourcesByBackupVaultRequest
     * @return Result of the ListProtectedResourcesByBackupVault operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResourcesByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResourcesByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProtectedResourcesByBackupVaultResponse listProtectedResourcesByBackupVault(
            ListProtectedResourcesByBackupVaultRequest listProtectedResourcesByBackupVaultRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request lists the protected resources corresponding to each backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectedResourcesByBackupVaultRequest.Builder}
     * avoiding the need to create one manually via {@link ListProtectedResourcesByBackupVaultRequest#builder()}
     * </p>
     *
     * @param listProtectedResourcesByBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest.Builder} to
     *        create a request.
     * @return Result of the ListProtectedResourcesByBackupVault operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResourcesByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResourcesByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProtectedResourcesByBackupVaultResponse listProtectedResourcesByBackupVault(
            Consumer<ListProtectedResourcesByBackupVaultRequest.Builder> listProtectedResourcesByBackupVaultRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return listProtectedResourcesByBackupVault(ListProtectedResourcesByBackupVaultRequest.builder()
                .applyMutation(listProtectedResourcesByBackupVaultRequest).build());
    }

    /**
     * <p>
     * This request lists the protected resources corresponding to each backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtectedResourcesByBackupVault(software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesByBackupVaultIterable responses = client.listProtectedResourcesByBackupVaultPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesByBackupVaultIterable responses = client
     *             .listProtectedResourcesByBackupVaultPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesByBackupVaultIterable responses = client.listProtectedResourcesByBackupVaultPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedResourcesByBackupVault(software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProtectedResourcesByBackupVaultRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResourcesByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResourcesByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProtectedResourcesByBackupVaultIterable listProtectedResourcesByBackupVaultPaginator(
            ListProtectedResourcesByBackupVaultRequest listProtectedResourcesByBackupVaultRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return new ListProtectedResourcesByBackupVaultIterable(this, listProtectedResourcesByBackupVaultRequest);
    }

    /**
     * <p>
     * This request lists the protected resources corresponding to each backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtectedResourcesByBackupVault(software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesByBackupVaultIterable responses = client.listProtectedResourcesByBackupVaultPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesByBackupVaultIterable responses = client
     *             .listProtectedResourcesByBackupVaultPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesByBackupVaultIterable responses = client.listProtectedResourcesByBackupVaultPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedResourcesByBackupVault(software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectedResourcesByBackupVaultRequest.Builder}
     * avoiding the need to create one manually via {@link ListProtectedResourcesByBackupVaultRequest#builder()}
     * </p>
     *
     * @param listProtectedResourcesByBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResourcesByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResourcesByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProtectedResourcesByBackupVaultIterable listProtectedResourcesByBackupVaultPaginator(
            Consumer<ListProtectedResourcesByBackupVaultRequest.Builder> listProtectedResourcesByBackupVaultRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return listProtectedResourcesByBackupVaultPaginator(ListProtectedResourcesByBackupVaultRequest.builder()
                .applyMutation(listProtectedResourcesByBackupVaultRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about the recovery points stored in a backup vault.
     * </p>
     *
     * @param listRecoveryPointsByBackupVaultRequest
     * @return Result of the ListRecoveryPointsByBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByBackupVaultResponse listRecoveryPointsByBackupVault(
            ListRecoveryPointsByBackupVaultRequest listRecoveryPointsByBackupVaultRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about the recovery points stored in a backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByBackupVaultRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByBackupVaultRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest.Builder} to
     *        create a request.
     * @return Result of the ListRecoveryPointsByBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByBackupVaultResponse listRecoveryPointsByBackupVault(
            Consumer<ListRecoveryPointsByBackupVaultRequest.Builder> listRecoveryPointsByBackupVaultRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRecoveryPointsByBackupVault(ListRecoveryPointsByBackupVaultRequest.builder()
                .applyMutation(listRecoveryPointsByBackupVaultRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about the recovery points stored in a backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByBackupVault(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable responses = client.listRecoveryPointsByBackupVaultPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable responses = client
     *             .listRecoveryPointsByBackupVaultPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable responses = client.listRecoveryPointsByBackupVaultPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByBackupVault(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecoveryPointsByBackupVaultRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByBackupVaultIterable listRecoveryPointsByBackupVaultPaginator(
            ListRecoveryPointsByBackupVaultRequest listRecoveryPointsByBackupVaultRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return new ListRecoveryPointsByBackupVaultIterable(this, listRecoveryPointsByBackupVaultRequest);
    }

    /**
     * <p>
     * Returns detailed information about the recovery points stored in a backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByBackupVault(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable responses = client.listRecoveryPointsByBackupVaultPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable responses = client
     *             .listRecoveryPointsByBackupVaultPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable responses = client.listRecoveryPointsByBackupVaultPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByBackupVault(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByBackupVaultRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByBackupVaultRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByBackupVaultIterable listRecoveryPointsByBackupVaultPaginator(
            Consumer<ListRecoveryPointsByBackupVaultRequest.Builder> listRecoveryPointsByBackupVaultRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRecoveryPointsByBackupVaultPaginator(ListRecoveryPointsByBackupVaultRequest.builder()
                .applyMutation(listRecoveryPointsByBackupVaultRequest).build());
    }

    /**
     * <p>
     * This action returns recovery point ARNs (Amazon Resource Names) of the specified legal hold.
     * </p>
     *
     * @param listRecoveryPointsByLegalHoldRequest
     * @return Result of the ListRecoveryPointsByLegalHold operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByLegalHold"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByLegalHoldResponse listRecoveryPointsByLegalHold(
            ListRecoveryPointsByLegalHoldRequest listRecoveryPointsByLegalHoldRequest) throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action returns recovery point ARNs (Amazon Resource Names) of the specified legal hold.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByLegalHoldRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByLegalHoldRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByLegalHoldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest.Builder} to
     *        create a request.
     * @return Result of the ListRecoveryPointsByLegalHold operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByLegalHold"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByLegalHoldResponse listRecoveryPointsByLegalHold(
            Consumer<ListRecoveryPointsByLegalHoldRequest.Builder> listRecoveryPointsByLegalHoldRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        return listRecoveryPointsByLegalHold(ListRecoveryPointsByLegalHoldRequest.builder()
                .applyMutation(listRecoveryPointsByLegalHoldRequest).build());
    }

    /**
     * <p>
     * This action returns recovery point ARNs (Amazon Resource Names) of the specified legal hold.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByLegalHold(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByLegalHoldIterable responses = client.listRecoveryPointsByLegalHoldPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByLegalHoldIterable responses = client
     *             .listRecoveryPointsByLegalHoldPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByLegalHoldIterable responses = client.listRecoveryPointsByLegalHoldPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByLegalHold(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecoveryPointsByLegalHoldRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByLegalHold"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByLegalHoldIterable listRecoveryPointsByLegalHoldPaginator(
            ListRecoveryPointsByLegalHoldRequest listRecoveryPointsByLegalHoldRequest) throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListRecoveryPointsByLegalHoldIterable(this, listRecoveryPointsByLegalHoldRequest);
    }

    /**
     * <p>
     * This action returns recovery point ARNs (Amazon Resource Names) of the specified legal hold.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByLegalHold(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByLegalHoldIterable responses = client.listRecoveryPointsByLegalHoldPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByLegalHoldIterable responses = client
     *             .listRecoveryPointsByLegalHoldPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByLegalHoldIterable responses = client.listRecoveryPointsByLegalHoldPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByLegalHold(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByLegalHoldRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByLegalHoldRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByLegalHoldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByLegalHold"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByLegalHoldIterable listRecoveryPointsByLegalHoldPaginator(
            Consumer<ListRecoveryPointsByLegalHoldRequest.Builder> listRecoveryPointsByLegalHoldRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        return listRecoveryPointsByLegalHoldPaginator(ListRecoveryPointsByLegalHoldRequest.builder()
                .applyMutation(listRecoveryPointsByLegalHoldRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource
     * Name (ARN).
     * </p>
     * <note>
     * <p>
     * For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.
     * </p>
     * </note>
     *
     * @param listRecoveryPointsByResourceRequest
     * @return Result of the ListRecoveryPointsByResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByResourceResponse listRecoveryPointsByResource(
            ListRecoveryPointsByResourceRequest listRecoveryPointsByResourceRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource
     * Name (ARN).
     * </p>
     * <note>
     * <p>
     * For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByResourceRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest.Builder} to create
     *        a request.
     * @return Result of the ListRecoveryPointsByResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByResourceResponse listRecoveryPointsByResource(
            Consumer<ListRecoveryPointsByResourceRequest.Builder> listRecoveryPointsByResourceRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRecoveryPointsByResource(ListRecoveryPointsByResourceRequest.builder()
                .applyMutation(listRecoveryPointsByResourceRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource
     * Name (ARN).
     * </p>
     * <note>
     * <p>
     * For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByResource(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable responses = client.listRecoveryPointsByResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable responses = client
     *             .listRecoveryPointsByResourcePaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable responses = client.listRecoveryPointsByResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByResource(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecoveryPointsByResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByResourceIterable listRecoveryPointsByResourcePaginator(
            ListRecoveryPointsByResourceRequest listRecoveryPointsByResourceRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return new ListRecoveryPointsByResourceIterable(this, listRecoveryPointsByResourceRequest);
    }

    /**
     * <p>
     * Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource
     * Name (ARN).
     * </p>
     * <note>
     * <p>
     * For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByResource(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable responses = client.listRecoveryPointsByResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable responses = client
     *             .listRecoveryPointsByResourcePaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable responses = client.listRecoveryPointsByResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByResource(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByResourceRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByResourceIterable listRecoveryPointsByResourcePaginator(
            Consumer<ListRecoveryPointsByResourceRequest.Builder> listRecoveryPointsByResourceRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRecoveryPointsByResourcePaginator(ListRecoveryPointsByResourceRequest.builder()
                .applyMutation(listRecoveryPointsByResourceRequest).build());
    }

    /**
     * <p>
     * Returns details about your report jobs.
     * </p>
     *
     * @param listReportJobsRequest
     * @return Result of the ListReportJobs operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListReportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportJobsResponse listReportJobs(ListReportJobsRequest listReportJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about your report jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListReportJobsRequest#builder()}
     * </p>
     *
     * @param listReportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListReportJobsRequest.Builder} to create a request.
     * @return Result of the ListReportJobs operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListReportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportJobsResponse listReportJobs(Consumer<ListReportJobsRequest.Builder> listReportJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        return listReportJobs(ListReportJobsRequest.builder().applyMutation(listReportJobsRequest).build());
    }

    /**
     * <p>
     * Returns details about your report jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listReportJobs(software.amazon.awssdk.services.backup.model.ListReportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportJobsIterable responses = client.listReportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListReportJobsIterable responses = client.listReportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListReportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportJobsIterable responses = client.listReportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReportJobs(software.amazon.awssdk.services.backup.model.ListReportJobsRequest)} operation.</b>
     * </p>
     *
     * @param listReportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListReportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportJobsIterable listReportJobsPaginator(ListReportJobsRequest listReportJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        return new ListReportJobsIterable(this, listReportJobsRequest);
    }

    /**
     * <p>
     * Returns details about your report jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listReportJobs(software.amazon.awssdk.services.backup.model.ListReportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportJobsIterable responses = client.listReportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListReportJobsIterable responses = client.listReportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListReportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportJobsIterable responses = client.listReportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReportJobs(software.amazon.awssdk.services.backup.model.ListReportJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListReportJobsRequest#builder()}
     * </p>
     *
     * @param listReportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListReportJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListReportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportJobsIterable listReportJobsPaginator(Consumer<ListReportJobsRequest.Builder> listReportJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        return listReportJobsPaginator(ListReportJobsRequest.builder().applyMutation(listReportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of your report plans. For detailed information about a single report plan, use
     * <code>DescribeReportPlan</code>.
     * </p>
     *
     * @param listReportPlansRequest
     * @return Result of the ListReportPlans operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListReportPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportPlansResponse listReportPlans(ListReportPlansRequest listReportPlansRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of your report plans. For detailed information about a single report plan, use
     * <code>DescribeReportPlan</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportPlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListReportPlansRequest#builder()}
     * </p>
     *
     * @param listReportPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListReportPlansRequest.Builder} to create a request.
     * @return Result of the ListReportPlans operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListReportPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportPlansResponse listReportPlans(Consumer<ListReportPlansRequest.Builder> listReportPlansRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return listReportPlans(ListReportPlansRequest.builder().applyMutation(listReportPlansRequest).build());
    }

    /**
     * <p>
     * Returns a list of your report plans. For detailed information about a single report plan, use
     * <code>DescribeReportPlan</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReportPlans(software.amazon.awssdk.services.backup.model.ListReportPlansRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportPlansIterable responses = client.listReportPlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListReportPlansIterable responses = client
     *             .listReportPlansPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListReportPlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportPlansIterable responses = client.listReportPlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReportPlans(software.amazon.awssdk.services.backup.model.ListReportPlansRequest)} operation.</b>
     * </p>
     *
     * @param listReportPlansRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListReportPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportPlansIterable listReportPlansPaginator(ListReportPlansRequest listReportPlansRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return new ListReportPlansIterable(this, listReportPlansRequest);
    }

    /**
     * <p>
     * Returns a list of your report plans. For detailed information about a single report plan, use
     * <code>DescribeReportPlan</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReportPlans(software.amazon.awssdk.services.backup.model.ListReportPlansRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportPlansIterable responses = client.listReportPlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListReportPlansIterable responses = client
     *             .listReportPlansPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListReportPlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportPlansIterable responses = client.listReportPlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReportPlans(software.amazon.awssdk.services.backup.model.ListReportPlansRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportPlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListReportPlansRequest#builder()}
     * </p>
     *
     * @param listReportPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListReportPlansRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListReportPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportPlansIterable listReportPlansPaginator(Consumer<ListReportPlansRequest.Builder> listReportPlansRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return listReportPlansPaginator(ListReportPlansRequest.builder().applyMutation(listReportPlansRequest).build());
    }

    /**
     * <p>
     * This request obtains a summary of restore jobs created or running within the the most recent 30 days. You can
     * include parameters AccountID, State, ResourceType, AggregationPeriod, MaxResults, or NextToken to filter results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     *
     * @param listRestoreJobSummariesRequest
     * @return Result of the ListRestoreJobSummaries operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRestoreJobSummariesResponse listRestoreJobSummaries(ListRestoreJobSummariesRequest listRestoreJobSummariesRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request obtains a summary of restore jobs created or running within the the most recent 30 days. You can
     * include parameters AccountID, State, ResourceType, AggregationPeriod, MaxResults, or NextToken to filter results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreJobSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListRestoreJobSummariesRequest#builder()}
     * </p>
     *
     * @param listRestoreJobSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest.Builder} to create a
     *        request.
     * @return Result of the ListRestoreJobSummaries operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRestoreJobSummariesResponse listRestoreJobSummaries(
            Consumer<ListRestoreJobSummariesRequest.Builder> listRestoreJobSummariesRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return listRestoreJobSummaries(ListRestoreJobSummariesRequest.builder().applyMutation(listRestoreJobSummariesRequest)
                .build());
    }

    /**
     * <p>
     * This request obtains a summary of restore jobs created or running within the the most recent 30 days. You can
     * include parameters AccountID, State, ResourceType, AggregationPeriod, MaxResults, or NextToken to filter results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRestoreJobSummaries(software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobSummariesIterable responses = client.listRestoreJobSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRestoreJobSummariesIterable responses = client
     *             .listRestoreJobSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobSummariesIterable responses = client.listRestoreJobSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobSummaries(software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRestoreJobSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRestoreJobSummariesIterable listRestoreJobSummariesPaginator(
            ListRestoreJobSummariesRequest listRestoreJobSummariesRequest) throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListRestoreJobSummariesIterable(this, listRestoreJobSummariesRequest);
    }

    /**
     * <p>
     * This request obtains a summary of restore jobs created or running within the the most recent 30 days. You can
     * include parameters AccountID, State, ResourceType, AggregationPeriod, MaxResults, or NextToken to filter results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRestoreJobSummaries(software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobSummariesIterable responses = client.listRestoreJobSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRestoreJobSummariesIterable responses = client
     *             .listRestoreJobSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobSummariesIterable responses = client.listRestoreJobSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobSummaries(software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreJobSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListRestoreJobSummariesRequest#builder()}
     * </p>
     *
     * @param listRestoreJobSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRestoreJobSummariesIterable listRestoreJobSummariesPaginator(
            Consumer<ListRestoreJobSummariesRequest.Builder> listRestoreJobSummariesRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return listRestoreJobSummariesPaginator(ListRestoreJobSummariesRequest.builder()
                .applyMutation(listRestoreJobSummariesRequest).build());
    }

    /**
     * <p>
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery
     * process.
     * </p>
     *
     * @param listRestoreJobsRequest
     * @return Result of the ListRestoreJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsResponse listRestoreJobs(ListRestoreJobsRequest listRestoreJobsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery
     * process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRestoreJobsRequest#builder()}
     * </p>
     *
     * @param listRestoreJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest.Builder} to create a request.
     * @return Result of the ListRestoreJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsResponse listRestoreJobs(Consumer<ListRestoreJobsRequest.Builder> listRestoreJobsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRestoreJobs(ListRestoreJobsRequest.builder().applyMutation(listRestoreJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery
     * process.
     * </p>
     *
     * @return Result of the ListRestoreJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobs
     * @see #listRestoreJobs(ListRestoreJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsResponse listRestoreJobs() throws ResourceNotFoundException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRestoreJobs(ListRestoreJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery
     * process.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client.listRestoreJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client
     *             .listRestoreJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client.listRestoreJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobs
     * @see #listRestoreJobsPaginator(ListRestoreJobsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsIterable listRestoreJobsPaginator() throws ResourceNotFoundException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRestoreJobsPaginator(ListRestoreJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery
     * process.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client.listRestoreJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client
     *             .listRestoreJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client.listRestoreJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation.</b>
     * </p>
     *
     * @param listRestoreJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsIterable listRestoreJobsPaginator(ListRestoreJobsRequest listRestoreJobsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return new ListRestoreJobsIterable(this, listRestoreJobsRequest);
    }

    /**
     * <p>
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery
     * process.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client.listRestoreJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client
     *             .listRestoreJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client.listRestoreJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRestoreJobsRequest#builder()}
     * </p>
     *
     * @param listRestoreJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsIterable listRestoreJobsPaginator(Consumer<ListRestoreJobsRequest.Builder> listRestoreJobsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRestoreJobsPaginator(ListRestoreJobsRequest.builder().applyMutation(listRestoreJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     * </p>
     * <p>
     * <code>ListTags</code> only works for resource types that support full Backup management of their backups. Those
     * resource types are listed in the "Full Backup management" section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     * </p>
     * <p>
     * <code>ListTags</code> only works for resource types that support full Backup management of their backups. Those
     * resource types are listed in the "Full Backup management" section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListTagsRequest.Builder} to create a request.
     * @return Result of the ListTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     * </p>
     * <p>
     * <code>ListTags</code> only works for resource types that support full Backup management of their backups. Those
     * resource types are listed in the "Full Backup management" section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.backup.model.ListTagsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.backup.model.ListTagsRequest)} operation.</b>
     * </p>
     *
     * @param listTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsIterable listTagsPaginator(ListTagsRequest listTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return new ListTagsIterable(this, listTagsRequest);
    }

    /**
     * <p>
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     * </p>
     * <p>
     * <code>ListTags</code> only works for resource types that support full Backup management of their backups. Those
     * resource types are listed in the "Full Backup management" section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.backup.model.ListTagsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.backup.model.ListTagsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListTagsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsIterable listTagsPaginator(Consumer<ListTagsRequest.Builder> listTagsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listTagsPaginator(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a
     * backup vault name and an access policy document in JSON format.
     * </p>
     *
     * @param putBackupVaultAccessPolicyRequest
     * @return Result of the PutBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.PutBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutBackupVaultAccessPolicyResponse putBackupVaultAccessPolicy(
            PutBackupVaultAccessPolicyRequest putBackupVaultAccessPolicyRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a
     * backup vault name and an access policy document in JSON format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBackupVaultAccessPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link PutBackupVaultAccessPolicyRequest#builder()}
     * </p>
     *
     * @param putBackupVaultAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.PutBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutBackupVaultAccessPolicyResponse putBackupVaultAccessPolicy(
            Consumer<PutBackupVaultAccessPolicyRequest.Builder> putBackupVaultAccessPolicyRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return putBackupVaultAccessPolicy(PutBackupVaultAccessPolicyRequest.builder()
                .applyMutation(putBackupVaultAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or
     * created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the
     * retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a
     * minimum and maximum retention period for future backup and copy jobs that target a backup vault.
     * </p>
     * <note>
     * <p>
     * Backup Vault Lock has been assessed by Cohasset Associates for use in environments that are subject to SEC 17a-4,
     * CFTC, and FINRA regulations. For more information about how Backup Vault Lock relates to these regulations, see
     * the <a href="samples/cohassetreport.zip">Cohasset Associates Compliance Assessment.</a>
     * </p>
     * </note>
     *
     * @param putBackupVaultLockConfigurationRequest
     * @return Result of the PutBackupVaultLockConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.PutBackupVaultLockConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultLockConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutBackupVaultLockConfigurationResponse putBackupVaultLockConfiguration(
            PutBackupVaultLockConfigurationRequest putBackupVaultLockConfigurationRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, InvalidRequestException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or
     * created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the
     * retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a
     * minimum and maximum retention period for future backup and copy jobs that target a backup vault.
     * </p>
     * <note>
     * <p>
     * Backup Vault Lock has been assessed by Cohasset Associates for use in environments that are subject to SEC 17a-4,
     * CFTC, and FINRA regulations. For more information about how Backup Vault Lock relates to these regulations, see
     * the <a href="samples/cohassetreport.zip">Cohasset Associates Compliance Assessment.</a>
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBackupVaultLockConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutBackupVaultLockConfigurationRequest#builder()}
     * </p>
     *
     * @param putBackupVaultLockConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the PutBackupVaultLockConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.PutBackupVaultLockConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultLockConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutBackupVaultLockConfigurationResponse putBackupVaultLockConfiguration(
            Consumer<PutBackupVaultLockConfigurationRequest.Builder> putBackupVaultLockConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            InvalidRequestException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return putBackupVaultLockConfiguration(PutBackupVaultLockConfigurationRequest.builder()
                .applyMutation(putBackupVaultLockConfigurationRequest).build());
    }

    /**
     * <p>
     * Turns on notifications on a backup vault for the specified topic and events.
     * </p>
     *
     * @param putBackupVaultNotificationsRequest
     * @return Result of the PutBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.PutBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default PutBackupVaultNotificationsResponse putBackupVaultNotifications(
            PutBackupVaultNotificationsRequest putBackupVaultNotificationsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Turns on notifications on a backup vault for the specified topic and events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBackupVaultNotificationsRequest.Builder}
     * avoiding the need to create one manually via {@link PutBackupVaultNotificationsRequest#builder()}
     * </p>
     *
     * @param putBackupVaultNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsRequest.Builder} to create
     *        a request.
     * @return Result of the PutBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.PutBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default PutBackupVaultNotificationsResponse putBackupVaultNotifications(
            Consumer<PutBackupVaultNotificationsRequest.Builder> putBackupVaultNotificationsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return putBackupVaultNotifications(PutBackupVaultNotificationsRequest.builder()
                .applyMutation(putBackupVaultNotificationsRequest).build());
    }

    /**
     * <p>
     * Starts an on-demand backup job for the specified resource.
     * </p>
     *
     * @param startBackupJobRequest
     * @return Result of the StartBackupJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartBackupJobResponse startBackupJob(StartBackupJobRequest startBackupJobRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, InvalidRequestException, ServiceUnavailableException,
            LimitExceededException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an on-demand backup job for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartBackupJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartBackupJobRequest#builder()}
     * </p>
     *
     * @param startBackupJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.StartBackupJobRequest.Builder} to create a request.
     * @return Result of the StartBackupJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartBackupJobResponse startBackupJob(Consumer<StartBackupJobRequest.Builder> startBackupJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            InvalidRequestException, ServiceUnavailableException, LimitExceededException, AwsServiceException,
            SdkClientException, BackupException {
        return startBackupJob(StartBackupJobRequest.builder().applyMutation(startBackupJobRequest).build());
    }

    /**
     * <p>
     * Starts a job to create a one-time copy of the specified resource.
     * </p>
     * <p>
     * Does not support continuous backups.
     * </p>
     *
     * @param startCopyJobRequest
     * @return Result of the StartCopyJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartCopyJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartCopyJobResponse startCopyJob(StartCopyJobRequest startCopyJobRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException,
            InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a job to create a one-time copy of the specified resource.
     * </p>
     * <p>
     * Does not support continuous backups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCopyJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartCopyJobRequest#builder()}
     * </p>
     *
     * @param startCopyJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.StartCopyJobRequest.Builder} to create a request.
     * @return Result of the StartCopyJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartCopyJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartCopyJobResponse startCopyJob(Consumer<StartCopyJobRequest.Builder> startCopyJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, LimitExceededException, InvalidRequestException, AwsServiceException,
            SdkClientException, BackupException {
        return startCopyJob(StartCopyJobRequest.builder().applyMutation(startCopyJobRequest).build());
    }

    /**
     * <p>
     * Starts an on-demand report job for the specified report plan.
     * </p>
     *
     * @param startReportJobRequest
     * @return Result of the StartReportJob operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartReportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartReportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartReportJobResponse startReportJob(StartReportJobRequest startReportJobRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, MissingParameterValueException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an on-demand report job for the specified report plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReportJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartReportJobRequest#builder()}
     * </p>
     *
     * @param startReportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.StartReportJobRequest.Builder} to create a request.
     * @return Result of the StartReportJob operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartReportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartReportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartReportJobResponse startReportJob(Consumer<StartReportJobRequest.Builder> startReportJobRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, MissingParameterValueException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return startReportJob(StartReportJobRequest.builder().applyMutation(startReportJobRequest).build());
    }

    /**
     * <p>
     * Recovers the saved resource identified by an Amazon Resource Name (ARN).
     * </p>
     *
     * @param startRestoreJobRequest
     * @return Result of the StartRestoreJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartRestoreJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartRestoreJobResponse startRestoreJob(StartRestoreJobRequest startRestoreJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Recovers the saved resource identified by an Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRestoreJobRequest.Builder} avoiding the need
     * to create one manually via {@link StartRestoreJobRequest#builder()}
     * </p>
     *
     * @param startRestoreJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.StartRestoreJobRequest.Builder} to create a request.
     * @return Result of the StartRestoreJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartRestoreJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartRestoreJobResponse startRestoreJob(Consumer<StartRestoreJobRequest.Builder> startRestoreJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        return startRestoreJob(StartRestoreJobRequest.builder().applyMutation(startRestoreJobRequest).build());
    }

    /**
     * <p>
     * Attempts to cancel a job to create a one-time backup of a resource.
     * </p>
     * <p>
     * This action is not supported for the following services: Amazon FSx for Windows File Server, Amazon FSx for
     * Lustre, FSx for ONTAP , Amazon FSx for OpenZFS, Amazon DocumentDB (with MongoDB compatibility), Amazon RDS,
     * Amazon Aurora, and Amazon Neptune.
     * </p>
     *
     * @param stopBackupJobRequest
     * @return Result of the StopBackupJob operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StopBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StopBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StopBackupJobResponse stopBackupJob(StopBackupJobRequest stopBackupJobRequest) throws MissingParameterValueException,
            ResourceNotFoundException, InvalidParameterValueException, InvalidRequestException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to cancel a job to create a one-time backup of a resource.
     * </p>
     * <p>
     * This action is not supported for the following services: Amazon FSx for Windows File Server, Amazon FSx for
     * Lustre, FSx for ONTAP , Amazon FSx for OpenZFS, Amazon DocumentDB (with MongoDB compatibility), Amazon RDS,
     * Amazon Aurora, and Amazon Neptune.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopBackupJobRequest.Builder} avoiding the need to
     * create one manually via {@link StopBackupJobRequest#builder()}
     * </p>
     *
     * @param stopBackupJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.StopBackupJobRequest.Builder} to create a request.
     * @return Result of the StopBackupJob operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StopBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StopBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StopBackupJobResponse stopBackupJob(Consumer<StopBackupJobRequest.Builder> stopBackupJobRequest)
            throws MissingParameterValueException, ResourceNotFoundException, InvalidParameterValueException,
            InvalidRequestException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return stopBackupJob(StopBackupJobRequest.builder().applyMutation(stopBackupJobRequest).build());
    }

    /**
     * <p>
     * Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN).
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException,
            AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, LimitExceededException, AwsServiceException, SdkClientException, BackupException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN)
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing backup plan identified by its <code>backupPlanId</code> with the input document in JSON
     * format. The new version is uniquely identified by a <code>VersionId</code>.
     * </p>
     *
     * @param updateBackupPlanRequest
     * @return Result of the UpdateBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBackupPlanResponse updateBackupPlan(UpdateBackupPlanRequest updateBackupPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing backup plan identified by its <code>backupPlanId</code> with the input document in JSON
     * format. The new version is uniquely identified by a <code>VersionId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBackupPlanRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBackupPlanRequest#builder()}
     * </p>
     *
     * @param updateBackupPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UpdateBackupPlanRequest.Builder} to create a request.
     * @return Result of the UpdateBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBackupPlanResponse updateBackupPlan(Consumer<UpdateBackupPlanRequest.Builder> updateBackupPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return updateBackupPlan(UpdateBackupPlanRequest.builder().applyMutation(updateBackupPlanRequest).build());
    }

    /**
     * <p>
     * Updates an existing framework identified by its <code>FrameworkName</code> with the input document in JSON
     * format.
     * </p>
     *
     * @param updateFrameworkRequest
     * @return Result of the UpdateFramework operation returned by the service.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFrameworkResponse updateFramework(UpdateFrameworkRequest updateFrameworkRequest) throws AlreadyExistsException,
            ResourceNotFoundException, LimitExceededException, InvalidParameterValueException, MissingParameterValueException,
            ConflictException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing framework identified by its <code>FrameworkName</code> with the input document in JSON
     * format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFrameworkRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateFrameworkRequest#builder()}
     * </p>
     *
     * @param updateFrameworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UpdateFrameworkRequest.Builder} to create a request.
     * @return Result of the UpdateFramework operation returned by the service.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFrameworkResponse updateFramework(Consumer<UpdateFrameworkRequest.Builder> updateFrameworkRequest)
            throws AlreadyExistsException, ResourceNotFoundException, LimitExceededException, InvalidParameterValueException,
            MissingParameterValueException, ConflictException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return updateFramework(UpdateFrameworkRequest.builder().applyMutation(updateFrameworkRequest).build());
    }

    /**
     * <p>
     * Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the
     * account is not an Organizations management account. Use the <code>DescribeGlobalSettings</code> API to determine
     * the current settings.
     * </p>
     *
     * @param updateGlobalSettingsRequest
     * @return Result of the UpdateGlobalSettings operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateGlobalSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateGlobalSettingsResponse updateGlobalSettings(UpdateGlobalSettingsRequest updateGlobalSettingsRequest)
            throws ServiceUnavailableException, MissingParameterValueException, InvalidParameterValueException,
            InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the
     * account is not an Organizations management account. Use the <code>DescribeGlobalSettings</code> API to determine
     * the current settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGlobalSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGlobalSettingsRequest#builder()}
     * </p>
     *
     * @param updateGlobalSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateGlobalSettings operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateGlobalSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateGlobalSettingsResponse updateGlobalSettings(
            Consumer<UpdateGlobalSettingsRequest.Builder> updateGlobalSettingsRequest) throws ServiceUnavailableException,
            MissingParameterValueException, InvalidParameterValueException, InvalidRequestException, AwsServiceException,
            SdkClientException, BackupException {
        return updateGlobalSettings(UpdateGlobalSettingsRequest.builder().applyMutation(updateGlobalSettingsRequest).build());
    }

    /**
     * <p>
     * Sets the transition lifecycle of a recovery point.
     * </p>
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
     * “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to
     * cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * <p>
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage"
     * section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table. Backup ignores this expression for other resource types.
     * </p>
     * <p>
     * This operation does not support continuous backups.
     * </p>
     *
     * @param updateRecoveryPointLifecycleRequest
     * @return Result of the UpdateRecoveryPointLifecycle operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateRecoveryPointLifecycle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRecoveryPointLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRecoveryPointLifecycleResponse updateRecoveryPointLifecycle(
            UpdateRecoveryPointLifecycleRequest updateRecoveryPointLifecycleRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, InvalidRequestException, MissingParameterValueException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the transition lifecycle of a recovery point.
     * </p>
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
     * “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to
     * cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * <p>
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage"
     * section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table. Backup ignores this expression for other resource types.
     * </p>
     * <p>
     * This operation does not support continuous backups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRecoveryPointLifecycleRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateRecoveryPointLifecycleRequest#builder()}
     * </p>
     *
     * @param updateRecoveryPointLifecycleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateRecoveryPointLifecycle operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateRecoveryPointLifecycle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRecoveryPointLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRecoveryPointLifecycleResponse updateRecoveryPointLifecycle(
            Consumer<UpdateRecoveryPointLifecycleRequest.Builder> updateRecoveryPointLifecycleRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, InvalidRequestException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return updateRecoveryPointLifecycle(UpdateRecoveryPointLifecycleRequest.builder()
                .applyMutation(updateRecoveryPointLifecycleRequest).build());
    }

    /**
     * <p>
     * Updates the current service opt-in settings for the Region. If service-opt-in is enabled for a service, Backup
     * tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or
     * scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region. Use the
     * <code>DescribeRegionSettings</code> API to determine the resource types that are supported.
     * </p>
     *
     * @param updateRegionSettingsRequest
     * @return Result of the UpdateRegionSettings operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateRegionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRegionSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateRegionSettingsResponse updateRegionSettings(UpdateRegionSettingsRequest updateRegionSettingsRequest)
            throws ServiceUnavailableException, MissingParameterValueException, InvalidParameterValueException,
            AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the current service opt-in settings for the Region. If service-opt-in is enabled for a service, Backup
     * tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or
     * scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region. Use the
     * <code>DescribeRegionSettings</code> API to determine the resource types that are supported.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRegionSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRegionSettingsRequest#builder()}
     * </p>
     *
     * @param updateRegionSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UpdateRegionSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRegionSettings operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateRegionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRegionSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateRegionSettingsResponse updateRegionSettings(
            Consumer<UpdateRegionSettingsRequest.Builder> updateRegionSettingsRequest) throws ServiceUnavailableException,
            MissingParameterValueException, InvalidParameterValueException, AwsServiceException, SdkClientException,
            BackupException {
        return updateRegionSettings(UpdateRegionSettingsRequest.builder().applyMutation(updateRegionSettingsRequest).build());
    }

    /**
     * <p>
     * Updates an existing report plan identified by its <code>ReportPlanName</code> with the input document in JSON
     * format.
     * </p>
     *
     * @param updateReportPlanRequest
     * @return Result of the UpdateReportPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateReportPlanResponse updateReportPlan(UpdateReportPlanRequest updateReportPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, ServiceUnavailableException,
            MissingParameterValueException, ConflictException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing report plan identified by its <code>ReportPlanName</code> with the input document in JSON
     * format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReportPlanRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateReportPlanRequest#builder()}
     * </p>
     *
     * @param updateReportPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UpdateReportPlanRequest.Builder} to create a request.
     * @return Result of the UpdateReportPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateReportPlanResponse updateReportPlan(Consumer<UpdateReportPlanRequest.Builder> updateReportPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, ServiceUnavailableException,
            MissingParameterValueException, ConflictException, AwsServiceException, SdkClientException, BackupException {
        return updateReportPlan(UpdateReportPlanRequest.builder().applyMutation(updateReportPlanRequest).build());
    }

    /**
     * Create a {@link BackupClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BackupClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BackupClient}.
     */
    static BackupClientBuilder builder() {
        return new DefaultBackupClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default BackupServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
