/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains metadata about a restore testing selection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTestingSelectionForGet implements SdkPojo, Serializable,
        ToCopyableBuilder<RestoreTestingSelectionForGet.Builder, RestoreTestingSelectionForGet> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(RestoreTestingSelectionForGet::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(RestoreTestingSelectionForGet::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(RestoreTestingSelectionForGet::iamRoleArn))
            .setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<List<String>> PROTECTED_RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProtectedResourceArns")
            .getter(getter(RestoreTestingSelectionForGet::protectedResourceArns))
            .setter(setter(Builder::protectedResourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProtectedResourceConditions> PROTECTED_RESOURCE_CONDITIONS_FIELD = SdkField
            .<ProtectedResourceConditions> builder(MarshallingType.SDK_POJO)
            .memberName("ProtectedResourceConditions")
            .getter(getter(RestoreTestingSelectionForGet::protectedResourceConditions))
            .setter(setter(Builder::protectedResourceConditions))
            .constructor(ProtectedResourceConditions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceConditions")
                    .build()).build();

    private static final SdkField<String> PROTECTED_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectedResourceType").getter(getter(RestoreTestingSelectionForGet::protectedResourceType))
            .setter(setter(Builder::protectedResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceType").build())
            .build();

    private static final SdkField<Map<String, String>> RESTORE_METADATA_OVERRIDES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("RestoreMetadataOverrides")
            .getter(getter(RestoreTestingSelectionForGet::restoreMetadataOverrides))
            .setter(setter(Builder::restoreMetadataOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreMetadataOverrides").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanName").getter(getter(RestoreTestingSelectionForGet::restoreTestingPlanName))
            .setter(setter(Builder::restoreTestingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanName").build())
            .build();

    private static final SdkField<String> RESTORE_TESTING_SELECTION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingSelectionName")
            .getter(getter(RestoreTestingSelectionForGet::restoreTestingSelectionName))
            .setter(setter(Builder::restoreTestingSelectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingSelectionName")
                    .build()).build();

    private static final SdkField<Integer> VALIDATION_WINDOW_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ValidationWindowHours").getter(getter(RestoreTestingSelectionForGet::validationWindowHours))
            .setter(setter(Builder::validationWindowHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationWindowHours").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            CREATOR_REQUEST_ID_FIELD, IAM_ROLE_ARN_FIELD, PROTECTED_RESOURCE_ARNS_FIELD, PROTECTED_RESOURCE_CONDITIONS_FIELD,
            PROTECTED_RESOURCE_TYPE_FIELD, RESTORE_METADATA_OVERRIDES_FIELD, RESTORE_TESTING_PLAN_NAME_FIELD,
            RESTORE_TESTING_SELECTION_NAME_FIELD, VALIDATION_WINDOW_HOURS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final String creatorRequestId;

    private final String iamRoleArn;

    private final List<String> protectedResourceArns;

    private final ProtectedResourceConditions protectedResourceConditions;

    private final String protectedResourceType;

    private final Map<String, String> restoreMetadataOverrides;

    private final String restoreTestingPlanName;

    private final String restoreTestingSelectionName;

    private final Integer validationWindowHours;

    private RestoreTestingSelectionForGet(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.creatorRequestId = builder.creatorRequestId;
        this.iamRoleArn = builder.iamRoleArn;
        this.protectedResourceArns = builder.protectedResourceArns;
        this.protectedResourceConditions = builder.protectedResourceConditions;
        this.protectedResourceType = builder.protectedResourceType;
        this.restoreMetadataOverrides = builder.restoreMetadataOverrides;
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
        this.restoreTestingSelectionName = builder.restoreTestingSelectionName;
        this.validationWindowHours = builder.validationWindowHours;
    }

    /**
     * <p>
     * The date and time that a restore testing selection was created, in Unix format and Coordinated Universal Time
     * (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     * represents Friday, January 26, 201812:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a restore testing selection was created, in Unix format and Coordinated Universal
     *         Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 201812:11:30.087 AM.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * This identifies the request and allows failed requests to be retried without the risk of running the operation
     * twice. If the request includes a <code>CreatorRequestId</code> that matches an existing backup plan, that plan is
     * returned. This parameter is optional.
     * </p>
     * <p>
     * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     * </p>
     * 
     * @return This identifies the request and allows failed requests to be retried without the risk of running the
     *         operation twice. If the request includes a <code>CreatorRequestId</code> that matches an existing backup
     *         plan, that plan is returned. This parameter is optional.</p>
     *         <p>
     *         If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example:
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for
     *         example:<code>arn:aws:iam::123456789012:role/S3Access</code>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProtectedResourceArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProtectedResourceArns() {
        return protectedResourceArns != null && !(protectedResourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can include specific ARNs, such as <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you
     * can include a wildcard: <code>ProtectedResourceArns: ["*"]</code>, but not both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtectedResourceArns} method.
     * </p>
     * 
     * @return You can include specific ARNs, such as <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code>
     *         or you can include a wildcard: <code>ProtectedResourceArns: ["*"]</code>, but not both.
     */
    public final List<String> protectedResourceArns() {
        return protectedResourceArns;
    }

    /**
     * <p>
     * In a resource testing selection, this parameter filters by specific conditions such as <code>StringEquals</code>
     * or <code>StringNotEquals</code>.
     * </p>
     * 
     * @return In a resource testing selection, this parameter filters by specific conditions such as
     *         <code>StringEquals</code> or <code>StringNotEquals</code>.
     */
    public final ProtectedResourceConditions protectedResourceConditions() {
        return protectedResourceConditions;
    }

    /**
     * <p>
     * The type of Amazon Web Services resource included in a resource testing selection; for example, an Amazon EBS
     * volume or an Amazon RDS database.
     * </p>
     * 
     * @return The type of Amazon Web Services resource included in a resource testing selection; for example, an Amazon
     *         EBS volume or an Amazon RDS database.
     */
    public final String protectedResourceType() {
        return protectedResourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the RestoreMetadataOverrides property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRestoreMetadataOverrides() {
        return restoreMetadataOverrides != null && !(restoreMetadataOverrides instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code>
     * in the body of <code>RestoreTestingSelection</code>. Key values are not case sensitive.
     * </p>
     * <p>
     * See the complete list of <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html">restore
     * testing inferred metadata</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestoreMetadataOverrides} method.
     * </p>
     * 
     * @return You can override certain restore metadata keys by including the parameter
     *         <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code>. Key values are
     *         not case sensitive.</p>
     *         <p>
     *         See the complete list of <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html"
     *         >restore testing inferred metadata</a>.
     */
    public final Map<String, String> restoreMetadataOverrides() {
        return restoreMetadataOverrides;
    }

    /**
     * <p>
     * The RestoreTestingPlanName is a unique string that is the name of the restore testing plan.
     * </p>
     * 
     * @return The RestoreTestingPlanName is a unique string that is the name of the restore testing plan.
     */
    public final String restoreTestingPlanName() {
        return restoreTestingPlanName;
    }

    /**
     * <p>
     * This is the unique name of the restore testing selection that belongs to the related restore testing plan.
     * </p>
     * 
     * @return This is the unique name of the restore testing selection that belongs to the related restore testing
     *         plan.
     */
    public final String restoreTestingSelectionName() {
        return restoreTestingSelectionName;
    }

    /**
     * <p>
     * This is amount of hours (1 to 168) available to run a validation script on the data. The data will be deleted
     * upon the completion of the validation script or the end of the specified retention period, whichever comes first.
     * </p>
     * 
     * @return This is amount of hours (1 to 168) available to run a validation script on the data. The data will be
     *         deleted upon the completion of the validation script or the end of the specified retention period,
     *         whichever comes first.
     */
    public final Integer validationWindowHours() {
        return validationWindowHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasProtectedResourceArns() ? protectedResourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(protectedResourceConditions());
        hashCode = 31 * hashCode + Objects.hashCode(protectedResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasRestoreMetadataOverrides() ? restoreMetadataOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingSelectionName());
        hashCode = 31 * hashCode + Objects.hashCode(validationWindowHours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTestingSelectionForGet)) {
            return false;
        }
        RestoreTestingSelectionForGet other = (RestoreTestingSelectionForGet) obj;
        return Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && hasProtectedResourceArns() == other.hasProtectedResourceArns()
                && Objects.equals(protectedResourceArns(), other.protectedResourceArns())
                && Objects.equals(protectedResourceConditions(), other.protectedResourceConditions())
                && Objects.equals(protectedResourceType(), other.protectedResourceType())
                && hasRestoreMetadataOverrides() == other.hasRestoreMetadataOverrides()
                && Objects.equals(restoreMetadataOverrides(), other.restoreMetadataOverrides())
                && Objects.equals(restoreTestingPlanName(), other.restoreTestingPlanName())
                && Objects.equals(restoreTestingSelectionName(), other.restoreTestingSelectionName())
                && Objects.equals(validationWindowHours(), other.validationWindowHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreTestingSelectionForGet").add("CreationTime", creationTime())
                .add("CreatorRequestId", creatorRequestId()).add("IamRoleArn", iamRoleArn())
                .add("ProtectedResourceArns", hasProtectedResourceArns() ? protectedResourceArns() : null)
                .add("ProtectedResourceConditions", protectedResourceConditions())
                .add("ProtectedResourceType", protectedResourceType())
                .add("RestoreMetadataOverrides", restoreMetadataOverrides() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RestoreTestingPlanName", restoreTestingPlanName())
                .add("RestoreTestingSelectionName", restoreTestingSelectionName())
                .add("ValidationWindowHours", validationWindowHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "ProtectedResourceArns":
            return Optional.ofNullable(clazz.cast(protectedResourceArns()));
        case "ProtectedResourceConditions":
            return Optional.ofNullable(clazz.cast(protectedResourceConditions()));
        case "ProtectedResourceType":
            return Optional.ofNullable(clazz.cast(protectedResourceType()));
        case "RestoreMetadataOverrides":
            return Optional.ofNullable(clazz.cast(restoreMetadataOverrides()));
        case "RestoreTestingPlanName":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanName()));
        case "RestoreTestingSelectionName":
            return Optional.ofNullable(clazz.cast(restoreTestingSelectionName()));
        case "ValidationWindowHours":
            return Optional.ofNullable(clazz.cast(validationWindowHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTestingSelectionForGet, T> g) {
        return obj -> g.apply((RestoreTestingSelectionForGet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestoreTestingSelectionForGet> {
        /**
         * <p>
         * The date and time that a restore testing selection was created, in Unix format and Coordinated Universal Time
         * (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
         * 1516925490.087 represents Friday, January 26, 201812:11:30.087 AM.
         * </p>
         * 
         * @param creationTime
         *        The date and time that a restore testing selection was created, in Unix format and Coordinated
         *        Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example,
         *        the value 1516925490.087 represents Friday, January 26, 201812:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * This identifies the request and allows failed requests to be retried without the risk of running the
         * operation twice. If the request includes a <code>CreatorRequestId</code> that matches an existing backup
         * plan, that plan is returned. This parameter is optional.
         * </p>
         * <p>
         * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         * </p>
         * 
         * @param creatorRequestId
         *        This identifies the request and allows failed requests to be retried without the risk of running the
         *        operation twice. If the request includes a <code>CreatorRequestId</code> that matches an existing
         *        backup plan, that plan is returned. This parameter is optional.</p>
         *        <p>
         *        If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example:
         * <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for
         *        example:<code>arn:aws:iam::123456789012:role/S3Access</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * You can include specific ARNs, such as <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or
         * you can include a wildcard: <code>ProtectedResourceArns: ["*"]</code>, but not both.
         * </p>
         * 
         * @param protectedResourceArns
         *        You can include specific ARNs, such as
         *        <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard:
         *        <code>ProtectedResourceArns: ["*"]</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResourceArns(Collection<String> protectedResourceArns);

        /**
         * <p>
         * You can include specific ARNs, such as <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or
         * you can include a wildcard: <code>ProtectedResourceArns: ["*"]</code>, but not both.
         * </p>
         * 
         * @param protectedResourceArns
         *        You can include specific ARNs, such as
         *        <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard:
         *        <code>ProtectedResourceArns: ["*"]</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResourceArns(String... protectedResourceArns);

        /**
         * <p>
         * In a resource testing selection, this parameter filters by specific conditions such as
         * <code>StringEquals</code> or <code>StringNotEquals</code>.
         * </p>
         * 
         * @param protectedResourceConditions
         *        In a resource testing selection, this parameter filters by specific conditions such as
         *        <code>StringEquals</code> or <code>StringNotEquals</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResourceConditions(ProtectedResourceConditions protectedResourceConditions);

        /**
         * <p>
         * In a resource testing selection, this parameter filters by specific conditions such as
         * <code>StringEquals</code> or <code>StringNotEquals</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedResourceConditions.Builder}
         * avoiding the need to create one manually via {@link ProtectedResourceConditions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedResourceConditions.Builder#build()} is called
         * immediately and its result is passed to {@link #protectedResourceConditions(ProtectedResourceConditions)}.
         * 
         * @param protectedResourceConditions
         *        a consumer that will call methods on {@link ProtectedResourceConditions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectedResourceConditions(ProtectedResourceConditions)
         */
        default Builder protectedResourceConditions(Consumer<ProtectedResourceConditions.Builder> protectedResourceConditions) {
            return protectedResourceConditions(ProtectedResourceConditions.builder().applyMutation(protectedResourceConditions)
                    .build());
        }

        /**
         * <p>
         * The type of Amazon Web Services resource included in a resource testing selection; for example, an Amazon EBS
         * volume or an Amazon RDS database.
         * </p>
         * 
         * @param protectedResourceType
         *        The type of Amazon Web Services resource included in a resource testing selection; for example, an
         *        Amazon EBS volume or an Amazon RDS database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResourceType(String protectedResourceType);

        /**
         * <p>
         * You can override certain restore metadata keys by including the parameter
         * <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code>. Key values are not
         * case sensitive.
         * </p>
         * <p>
         * See the complete list of <a
         * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html">restore
         * testing inferred metadata</a>.
         * </p>
         * 
         * @param restoreMetadataOverrides
         *        You can override certain restore metadata keys by including the parameter
         *        <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code>. Key values
         *        are not case sensitive.</p>
         *        <p>
         *        See the complete list of <a
         *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html"
         *        >restore testing inferred metadata</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreMetadataOverrides(Map<String, String> restoreMetadataOverrides);

        /**
         * <p>
         * The RestoreTestingPlanName is a unique string that is the name of the restore testing plan.
         * </p>
         * 
         * @param restoreTestingPlanName
         *        The RestoreTestingPlanName is a unique string that is the name of the restore testing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanName(String restoreTestingPlanName);

        /**
         * <p>
         * This is the unique name of the restore testing selection that belongs to the related restore testing plan.
         * </p>
         * 
         * @param restoreTestingSelectionName
         *        This is the unique name of the restore testing selection that belongs to the related restore testing
         *        plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingSelectionName(String restoreTestingSelectionName);

        /**
         * <p>
         * This is amount of hours (1 to 168) available to run a validation script on the data. The data will be deleted
         * upon the completion of the validation script or the end of the specified retention period, whichever comes
         * first.
         * </p>
         * 
         * @param validationWindowHours
         *        This is amount of hours (1 to 168) available to run a validation script on the data. The data will be
         *        deleted upon the completion of the validation script or the end of the specified retention period,
         *        whichever comes first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationWindowHours(Integer validationWindowHours);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String creatorRequestId;

        private String iamRoleArn;

        private List<String> protectedResourceArns = DefaultSdkAutoConstructList.getInstance();

        private ProtectedResourceConditions protectedResourceConditions;

        private String protectedResourceType;

        private Map<String, String> restoreMetadataOverrides = DefaultSdkAutoConstructMap.getInstance();

        private String restoreTestingPlanName;

        private String restoreTestingSelectionName;

        private Integer validationWindowHours;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTestingSelectionForGet model) {
            creationTime(model.creationTime);
            creatorRequestId(model.creatorRequestId);
            iamRoleArn(model.iamRoleArn);
            protectedResourceArns(model.protectedResourceArns);
            protectedResourceConditions(model.protectedResourceConditions);
            protectedResourceType(model.protectedResourceType);
            restoreMetadataOverrides(model.restoreMetadataOverrides);
            restoreTestingPlanName(model.restoreTestingPlanName);
            restoreTestingSelectionName(model.restoreTestingSelectionName);
            validationWindowHours(model.validationWindowHours);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Collection<String> getProtectedResourceArns() {
            if (protectedResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return protectedResourceArns;
        }

        public final void setProtectedResourceArns(Collection<String> protectedResourceArns) {
            this.protectedResourceArns = _stringListCopier.copy(protectedResourceArns);
        }

        @Override
        public final Builder protectedResourceArns(Collection<String> protectedResourceArns) {
            this.protectedResourceArns = _stringListCopier.copy(protectedResourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedResourceArns(String... protectedResourceArns) {
            protectedResourceArns(Arrays.asList(protectedResourceArns));
            return this;
        }

        public final ProtectedResourceConditions.Builder getProtectedResourceConditions() {
            return protectedResourceConditions != null ? protectedResourceConditions.toBuilder() : null;
        }

        public final void setProtectedResourceConditions(ProtectedResourceConditions.BuilderImpl protectedResourceConditions) {
            this.protectedResourceConditions = protectedResourceConditions != null ? protectedResourceConditions.build() : null;
        }

        @Override
        public final Builder protectedResourceConditions(ProtectedResourceConditions protectedResourceConditions) {
            this.protectedResourceConditions = protectedResourceConditions;
            return this;
        }

        public final String getProtectedResourceType() {
            return protectedResourceType;
        }

        public final void setProtectedResourceType(String protectedResourceType) {
            this.protectedResourceType = protectedResourceType;
        }

        @Override
        public final Builder protectedResourceType(String protectedResourceType) {
            this.protectedResourceType = protectedResourceType;
            return this;
        }

        public final Map<String, String> getRestoreMetadataOverrides() {
            if (restoreMetadataOverrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return restoreMetadataOverrides;
        }

        public final void setRestoreMetadataOverrides(Map<String, String> restoreMetadataOverrides) {
            this.restoreMetadataOverrides = SensitiveStringMapCopier.copy(restoreMetadataOverrides);
        }

        @Override
        public final Builder restoreMetadataOverrides(Map<String, String> restoreMetadataOverrides) {
            this.restoreMetadataOverrides = SensitiveStringMapCopier.copy(restoreMetadataOverrides);
            return this;
        }

        public final String getRestoreTestingPlanName() {
            return restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        public final String getRestoreTestingSelectionName() {
            return restoreTestingSelectionName;
        }

        public final void setRestoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
        }

        @Override
        public final Builder restoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
            return this;
        }

        public final Integer getValidationWindowHours() {
            return validationWindowHours;
        }

        public final void setValidationWindowHours(Integer validationWindowHours) {
            this.validationWindowHours = validationWindowHours;
        }

        @Override
        public final Builder validationWindowHours(Integer validationWindowHours) {
            this.validationWindowHours = validationWindowHours;
            return this;
        }

        @Override
        public RestoreTestingSelectionForGet build() {
            return new RestoreTestingSelectionForGet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
