/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.backup.internal.BackupServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.backup.model.AlreadyExistsException;
import software.amazon.awssdk.services.backup.model.BackupException;
import software.amazon.awssdk.services.backup.model.CancelLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.CancelLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.ConflictException;
import software.amazon.awssdk.services.backup.model.CreateBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.CreateBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.CreateBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.CreateFrameworkRequest;
import software.amazon.awssdk.services.backup.model.CreateFrameworkResponse;
import software.amazon.awssdk.services.backup.model.CreateLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.CreateLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.CreateReportPlanRequest;
import software.amazon.awssdk.services.backup.model.CreateReportPlanResponse;
import software.amazon.awssdk.services.backup.model.CreateRestoreTestingPlanRequest;
import software.amazon.awssdk.services.backup.model.CreateRestoreTestingPlanResponse;
import software.amazon.awssdk.services.backup.model.CreateRestoreTestingSelectionRequest;
import software.amazon.awssdk.services.backup.model.CreateRestoreTestingSelectionResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.DeleteFrameworkRequest;
import software.amazon.awssdk.services.backup.model.DeleteFrameworkResponse;
import software.amazon.awssdk.services.backup.model.DeleteRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DeleteRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.DeleteReportPlanRequest;
import software.amazon.awssdk.services.backup.model.DeleteReportPlanResponse;
import software.amazon.awssdk.services.backup.model.DeleteRestoreTestingPlanRequest;
import software.amazon.awssdk.services.backup.model.DeleteRestoreTestingPlanResponse;
import software.amazon.awssdk.services.backup.model.DeleteRestoreTestingSelectionRequest;
import software.amazon.awssdk.services.backup.model.DeleteRestoreTestingSelectionResponse;
import software.amazon.awssdk.services.backup.model.DependencyFailureException;
import software.amazon.awssdk.services.backup.model.DescribeBackupJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse;
import software.amazon.awssdk.services.backup.model.DescribeBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.DescribeBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.DescribeCopyJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeCopyJobResponse;
import software.amazon.awssdk.services.backup.model.DescribeFrameworkRequest;
import software.amazon.awssdk.services.backup.model.DescribeFrameworkResponse;
import software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsRequest;
import software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsResponse;
import software.amazon.awssdk.services.backup.model.DescribeProtectedResourceRequest;
import software.amazon.awssdk.services.backup.model.DescribeProtectedResourceResponse;
import software.amazon.awssdk.services.backup.model.DescribeRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DescribeRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.DescribeRegionSettingsRequest;
import software.amazon.awssdk.services.backup.model.DescribeRegionSettingsResponse;
import software.amazon.awssdk.services.backup.model.DescribeReportJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeReportJobResponse;
import software.amazon.awssdk.services.backup.model.DescribeReportPlanRequest;
import software.amazon.awssdk.services.backup.model.DescribeReportPlanResponse;
import software.amazon.awssdk.services.backup.model.DescribeRestoreJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeRestoreJobResponse;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentRequest;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentResponse;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateRequest;
import software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.GetLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.GetLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataRequest;
import software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse;
import software.amazon.awssdk.services.backup.model.GetRestoreJobMetadataRequest;
import software.amazon.awssdk.services.backup.model.GetRestoreJobMetadataResponse;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingInferredMetadataRequest;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingInferredMetadataResponse;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingPlanRequest;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingPlanResponse;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingSelectionRequest;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingSelectionResponse;
import software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesRequest;
import software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesResponse;
import software.amazon.awssdk.services.backup.model.InvalidParameterValueException;
import software.amazon.awssdk.services.backup.model.InvalidRequestException;
import software.amazon.awssdk.services.backup.model.InvalidResourceStateException;
import software.amazon.awssdk.services.backup.model.LimitExceededException;
import software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobSummariesResponse;
import software.amazon.awssdk.services.backup.model.ListBackupJobsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlansRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlansResponse;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse;
import software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListCopyJobSummariesResponse;
import software.amazon.awssdk.services.backup.model.ListCopyJobsRequest;
import software.amazon.awssdk.services.backup.model.ListCopyJobsResponse;
import software.amazon.awssdk.services.backup.model.ListFrameworksRequest;
import software.amazon.awssdk.services.backup.model.ListFrameworksResponse;
import software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest;
import software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse;
import software.amazon.awssdk.services.backup.model.ListReportJobsRequest;
import software.amazon.awssdk.services.backup.model.ListReportJobsResponse;
import software.amazon.awssdk.services.backup.model.ListReportPlansRequest;
import software.amazon.awssdk.services.backup.model.ListReportPlansResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsResponse;
import software.amazon.awssdk.services.backup.model.ListTagsRequest;
import software.amazon.awssdk.services.backup.model.ListTagsResponse;
import software.amazon.awssdk.services.backup.model.MissingParameterValueException;
import software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationResponse;
import software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.PutRestoreValidationResultRequest;
import software.amazon.awssdk.services.backup.model.PutRestoreValidationResultResponse;
import software.amazon.awssdk.services.backup.model.ResourceNotFoundException;
import software.amazon.awssdk.services.backup.model.ServiceUnavailableException;
import software.amazon.awssdk.services.backup.model.StartBackupJobRequest;
import software.amazon.awssdk.services.backup.model.StartBackupJobResponse;
import software.amazon.awssdk.services.backup.model.StartCopyJobRequest;
import software.amazon.awssdk.services.backup.model.StartCopyJobResponse;
import software.amazon.awssdk.services.backup.model.StartReportJobRequest;
import software.amazon.awssdk.services.backup.model.StartReportJobResponse;
import software.amazon.awssdk.services.backup.model.StartRestoreJobRequest;
import software.amazon.awssdk.services.backup.model.StartRestoreJobResponse;
import software.amazon.awssdk.services.backup.model.StopBackupJobRequest;
import software.amazon.awssdk.services.backup.model.StopBackupJobResponse;
import software.amazon.awssdk.services.backup.model.TagResourceRequest;
import software.amazon.awssdk.services.backup.model.TagResourceResponse;
import software.amazon.awssdk.services.backup.model.UntagResourceRequest;
import software.amazon.awssdk.services.backup.model.UntagResourceResponse;
import software.amazon.awssdk.services.backup.model.UpdateBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.UpdateBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.UpdateFrameworkRequest;
import software.amazon.awssdk.services.backup.model.UpdateFrameworkResponse;
import software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsRequest;
import software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsResponse;
import software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleRequest;
import software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleResponse;
import software.amazon.awssdk.services.backup.model.UpdateRegionSettingsRequest;
import software.amazon.awssdk.services.backup.model.UpdateRegionSettingsResponse;
import software.amazon.awssdk.services.backup.model.UpdateReportPlanRequest;
import software.amazon.awssdk.services.backup.model.UpdateReportPlanResponse;
import software.amazon.awssdk.services.backup.model.UpdateRestoreTestingPlanRequest;
import software.amazon.awssdk.services.backup.model.UpdateRestoreTestingPlanResponse;
import software.amazon.awssdk.services.backup.model.UpdateRestoreTestingSelectionRequest;
import software.amazon.awssdk.services.backup.model.UpdateRestoreTestingSelectionResponse;
import software.amazon.awssdk.services.backup.transform.CancelLegalHoldRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateBackupPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateBackupSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateFrameworkRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateLegalHoldRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateLogicallyAirGappedBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateReportPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateRestoreTestingPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateRestoreTestingSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupVaultLockConfigurationRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteFrameworkRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteReportPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteRestoreTestingPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteRestoreTestingSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeBackupJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeCopyJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeFrameworkRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeGlobalSettingsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeProtectedResourceRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeRegionSettingsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeReportJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeReportPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeRestoreJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DisassociateRecoveryPointFromParentRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DisassociateRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ExportBackupPlanTemplateRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupPlanFromJsonRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupPlanFromTemplateRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetLegalHoldRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetRecoveryPointRestoreMetadataRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetRestoreJobMetadataRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetRestoreTestingInferredMetadataRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetRestoreTestingPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetRestoreTestingSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetSupportedResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupJobSummariesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupJobsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupPlanTemplatesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupPlanVersionsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupPlansRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupSelectionsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupVaultsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListCopyJobSummariesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListCopyJobsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListFrameworksRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListLegalHoldsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListProtectedResourcesByBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListProtectedResourcesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRecoveryPointsByBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRecoveryPointsByLegalHoldRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRecoveryPointsByResourceRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListReportJobsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListReportPlansRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRestoreJobSummariesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRestoreJobsByProtectedResourceRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRestoreJobsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRestoreTestingPlansRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRestoreTestingSelectionsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.PutBackupVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.PutBackupVaultLockConfigurationRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.PutBackupVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.PutRestoreValidationResultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.StartBackupJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.StartCopyJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.StartReportJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.StartRestoreJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.StopBackupJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateBackupPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateFrameworkRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateGlobalSettingsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateRecoveryPointLifecycleRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateRegionSettingsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateReportPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateRestoreTestingPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateRestoreTestingSelectionRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link BackupAsyncClient}.
 *
 * @see BackupAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultBackupAsyncClient implements BackupAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultBackupAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultBackupAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * This action removes the specified legal hold on a recovery point. This action can only be performed by a user
     * with sufficient permissions.
     * </p>
     *
     * @param cancelLegalHoldRequest
     * @return A Java Future containing the result of the CancelLegalHold operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidResourceStateException Backup is already performing an action on this recovery point. It can't
     *         perform the action you requested until the first action finishes. Try again later.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CancelLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CancelLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelLegalHoldResponse> cancelLegalHold(CancelLegalHoldRequest cancelLegalHoldRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelLegalHoldRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelLegalHoldRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelLegalHold");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelLegalHoldResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelLegalHoldResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelLegalHoldResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelLegalHoldRequest, CancelLegalHoldResponse>()
                            .withOperationName("CancelLegalHold").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelLegalHoldRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelLegalHoldRequest));
            CompletableFuture<CancelLegalHoldResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains
     * information that Backup uses to schedule tasks that create recovery points for resources.
     * </p>
     * <p>
     * If you call <code>CreateBackupPlan</code> with a plan that already exists, you receive an
     * <code>AlreadyExistsException</code> exception.
     * </p>
     *
     * @param createBackupPlanRequest
     * @return A Java Future containing the result of the CreateBackupPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBackupPlanResponse> createBackupPlan(CreateBackupPlanRequest createBackupPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBackupPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBackupPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBackupPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBackupPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBackupPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBackupPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBackupPlanRequest, CreateBackupPlanResponse>()
                            .withOperationName("CreateBackupPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBackupPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBackupPlanRequest));
            CompletableFuture<CreateBackupPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json"
     * >Assigning resources programmatically</a>.
     * </p>
     *
     * @param createBackupSelectionRequest
     * @return A Java Future containing the result of the CreateBackupSelection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBackupSelectionResponse> createBackupSelection(
            CreateBackupSelectionRequest createBackupSelectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBackupSelectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBackupSelectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBackupSelection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBackupSelectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBackupSelectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBackupSelectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBackupSelectionRequest, CreateBackupSelectionResponse>()
                            .withOperationName("CreateBackupSelection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBackupSelectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBackupSelectionRequest));
            CompletableFuture<CreateBackupSelectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a logical container where backups are stored. A <code>CreateBackupVault</code> request includes a name,
     * optionally one or more resource tags, an encryption key, and a request ID.
     * </p>
     * <note>
     * <p>
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     * </p>
     * </note>
     *
     * @param createBackupVaultRequest
     * @return A Java Future containing the result of the CreateBackupVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBackupVaultResponse> createBackupVault(CreateBackupVaultRequest createBackupVaultRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBackupVaultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBackupVaultRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBackupVault");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBackupVaultResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBackupVaultResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBackupVaultResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBackupVaultRequest, CreateBackupVaultResponse>()
                            .withOperationName("CreateBackupVault").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateBackupVaultRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createBackupVaultRequest));
            CompletableFuture<CreateBackupVaultResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a framework with one or more controls. A framework is a collection of controls that you can use to
     * evaluate your backup practices. By using pre-built customizable controls to define your policies, you can
     * evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.
     * </p>
     *
     * @param createFrameworkRequest
     * @return A Java Future containing the result of the CreateFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateFramework" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFrameworkResponse> createFramework(CreateFrameworkRequest createFrameworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFrameworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFrameworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFramework");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFrameworkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFrameworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFrameworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFrameworkRequest, CreateFrameworkResponse>()
                            .withOperationName("CreateFramework").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateFrameworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFrameworkRequest));
            CompletableFuture<CreateFrameworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action creates a legal hold on a recovery point (backup). A legal hold is a restraint on altering or
     * deleting a backup until an authorized user cancels the legal hold. Any actions to delete or disassociate a
     * recovery point will fail with an error if one or more active legal holds are on the recovery point.
     * </p>
     *
     * @param createLegalHoldRequest
     * @return A Java Future containing the result of the CreateLegalHold operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLegalHoldResponse> createLegalHold(CreateLegalHoldRequest createLegalHoldRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLegalHoldRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLegalHoldRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLegalHold");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLegalHoldResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateLegalHoldResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateLegalHoldResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLegalHoldRequest, CreateLegalHoldResponse>()
                            .withOperationName("CreateLegalHold").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLegalHoldRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createLegalHoldRequest));
            CompletableFuture<CreateLegalHoldResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This request creates a logical container to where backups may be copied.
     * </p>
     * <p>
     * This request includes a name, the Region, the maximum number of retention days, the minimum number of retention
     * days, and optionally can include tags and a creator request ID.
     * </p>
     * <note>
     * <p>
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     * </p>
     * </note>
     *
     * @param createLogicallyAirGappedBackupVaultRequest
     * @return A Java Future containing the result of the CreateLogicallyAirGappedBackupVault operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateLogicallyAirGappedBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLogicallyAirGappedBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLogicallyAirGappedBackupVaultResponse> createLogicallyAirGappedBackupVault(
            CreateLogicallyAirGappedBackupVaultRequest createLogicallyAirGappedBackupVaultRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLogicallyAirGappedBackupVaultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createLogicallyAirGappedBackupVaultRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLogicallyAirGappedBackupVault");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLogicallyAirGappedBackupVaultResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateLogicallyAirGappedBackupVaultResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateLogicallyAirGappedBackupVaultResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLogicallyAirGappedBackupVaultRequest, CreateLogicallyAirGappedBackupVaultResponse>()
                            .withOperationName("CreateLogicallyAirGappedBackupVault").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLogicallyAirGappedBackupVaultRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createLogicallyAirGappedBackupVaultRequest));
            CompletableFuture<CreateLogicallyAirGappedBackupVaultResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a report plan. A report plan is a document that contains information about the contents of the report and
     * where Backup will deliver it.
     * </p>
     * <p>
     * If you call <code>CreateReportPlan</code> with a plan that already exists, you receive an
     * <code>AlreadyExistsException</code> exception.
     * </p>
     *
     * @param createReportPlanRequest
     * @return A Java Future containing the result of the CreateReportPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReportPlanResponse> createReportPlan(CreateReportPlanRequest createReportPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReportPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReportPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReportPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateReportPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateReportPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateReportPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateReportPlanRequest, CreateReportPlanResponse>()
                            .withOperationName("CreateReportPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateReportPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createReportPlanRequest));
            CompletableFuture<CreateReportPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This is the first of two steps to create a restore testing plan; once this request is successful, finish the
     * procedure with request CreateRestoreTestingSelection.
     * </p>
     * <p>
     * You must include the parameter RestoreTestingPlan. You may optionally include CreatorRequestId and Tags.
     * </p>
     *
     * @param createRestoreTestingPlanRequest
     * @return A Java Future containing the result of the CreateRestoreTestingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateRestoreTestingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRestoreTestingPlanResponse> createRestoreTestingPlan(
            CreateRestoreTestingPlanRequest createRestoreTestingPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRestoreTestingPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRestoreTestingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRestoreTestingPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRestoreTestingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRestoreTestingPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRestoreTestingPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRestoreTestingPlanRequest, CreateRestoreTestingPlanResponse>()
                            .withOperationName("CreateRestoreTestingPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRestoreTestingPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRestoreTestingPlanRequest));
            CompletableFuture<CreateRestoreTestingPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This request can be sent after CreateRestoreTestingPlan request returns successfully. This is the second part of
     * creating a resource testing plan, and it must be completed sequentially.
     * </p>
     * <p>
     * This consists of <code>RestoreTestingSelectionName</code>, <code>ProtectedResourceType</code>, and one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ProtectedResourceArns</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ProtectedResourceConditions</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each protected resource type can have one single value.
     * </p>
     * <p>
     * A restore testing selection can include a wildcard value ("*") for <code>ProtectedResourceArns</code> along with
     * <code>ProtectedResourceConditions</code>. Alternatively, you can include up to 30 specific protected resource
     * ARNs in <code>ProtectedResourceArns</code>.
     * </p>
     * <p>
     * Cannot select by both protected resource types AND specific ARNs. Request will fail if both are included.
     * </p>
     *
     * @param createRestoreTestingSelectionRequest
     * @return A Java Future containing the result of the CreateRestoreTestingSelection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRestoreTestingSelectionResponse> createRestoreTestingSelection(
            CreateRestoreTestingSelectionRequest createRestoreTestingSelectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRestoreTestingSelectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createRestoreTestingSelectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRestoreTestingSelection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRestoreTestingSelectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRestoreTestingSelectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRestoreTestingSelectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRestoreTestingSelectionRequest, CreateRestoreTestingSelectionResponse>()
                            .withOperationName("CreateRestoreTestingSelection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRestoreTestingSelectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRestoreTestingSelectionRequest));
            CompletableFuture<CreateRestoreTestingSelectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been
     * deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will
     * still exist.
     * </p>
     *
     * @param deleteBackupPlanRequest
     * @return A Java Future containing the result of the DeleteBackupPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBackupPlanResponse> deleteBackupPlan(DeleteBackupPlanRequest deleteBackupPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackupPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBackupPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackupPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBackupPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBackupPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBackupPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBackupPlanRequest, DeleteBackupPlanResponse>()
                            .withOperationName("DeleteBackupPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBackupPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBackupPlanRequest));
            CompletableFuture<DeleteBackupPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the resource selection associated with a backup plan that is specified by the <code>SelectionId</code>.
     * </p>
     *
     * @param deleteBackupSelectionRequest
     * @return A Java Future containing the result of the DeleteBackupSelection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBackupSelectionResponse> deleteBackupSelection(
            DeleteBackupSelectionRequest deleteBackupSelectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackupSelectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBackupSelectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackupSelection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBackupSelectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBackupSelectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBackupSelectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBackupSelectionRequest, DeleteBackupSelectionResponse>()
                            .withOperationName("DeleteBackupSelection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBackupSelectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBackupSelectionRequest));
            CompletableFuture<DeleteBackupSelectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
     * </p>
     *
     * @param deleteBackupVaultRequest
     * @return A Java Future containing the result of the DeleteBackupVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBackupVaultResponse> deleteBackupVault(DeleteBackupVaultRequest deleteBackupVaultRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackupVaultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBackupVaultRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackupVault");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBackupVaultResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBackupVaultResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBackupVaultResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBackupVaultRequest, DeleteBackupVaultResponse>()
                            .withOperationName("DeleteBackupVault").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBackupVaultRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBackupVaultRequest));
            CompletableFuture<DeleteBackupVaultResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the policy document that manages permissions on a backup vault.
     * </p>
     *
     * @param deleteBackupVaultAccessPolicyRequest
     * @return A Java Future containing the result of the DeleteBackupVaultAccessPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBackupVaultAccessPolicyResponse> deleteBackupVaultAccessPolicy(
            DeleteBackupVaultAccessPolicyRequest deleteBackupVaultAccessPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackupVaultAccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteBackupVaultAccessPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackupVaultAccessPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBackupVaultAccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBackupVaultAccessPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBackupVaultAccessPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBackupVaultAccessPolicyRequest, DeleteBackupVaultAccessPolicyResponse>()
                            .withOperationName("DeleteBackupVaultAccessPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBackupVaultAccessPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBackupVaultAccessPolicyRequest));
            CompletableFuture<DeleteBackupVaultAccessPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes Backup Vault Lock from a backup vault specified by a backup vault name.
     * </p>
     * <p>
     * If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using API operations, and you
     * will receive an <code>InvalidRequestException</code> if you attempt to do so. For more information, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">Vault Lock</a> in the <i>Backup
     * Developer Guide</i>.
     * </p>
     *
     * @param deleteBackupVaultLockConfigurationRequest
     * @return A Java Future containing the result of the DeleteBackupVaultLockConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupVaultLockConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultLockConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBackupVaultLockConfigurationResponse> deleteBackupVaultLockConfiguration(
            DeleteBackupVaultLockConfigurationRequest deleteBackupVaultLockConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackupVaultLockConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteBackupVaultLockConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackupVaultLockConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBackupVaultLockConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteBackupVaultLockConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBackupVaultLockConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBackupVaultLockConfigurationRequest, DeleteBackupVaultLockConfigurationResponse>()
                            .withOperationName("DeleteBackupVaultLockConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBackupVaultLockConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBackupVaultLockConfigurationRequest));
            CompletableFuture<DeleteBackupVaultLockConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes event notifications for the specified backup vault.
     * </p>
     *
     * @param deleteBackupVaultNotificationsRequest
     * @return A Java Future containing the result of the DeleteBackupVaultNotifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBackupVaultNotificationsResponse> deleteBackupVaultNotifications(
            DeleteBackupVaultNotificationsRequest deleteBackupVaultNotificationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackupVaultNotificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteBackupVaultNotificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackupVaultNotifications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBackupVaultNotificationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBackupVaultNotificationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBackupVaultNotificationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBackupVaultNotificationsRequest, DeleteBackupVaultNotificationsResponse>()
                            .withOperationName("DeleteBackupVaultNotifications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteBackupVaultNotificationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteBackupVaultNotificationsRequest));
            CompletableFuture<DeleteBackupVaultNotificationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the framework specified by a framework name.
     * </p>
     *
     * @param deleteFrameworkRequest
     * @return A Java Future containing the result of the DeleteFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteFramework" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFrameworkResponse> deleteFramework(DeleteFrameworkRequest deleteFrameworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFrameworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFrameworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFramework");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFrameworkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFrameworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFrameworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFrameworkRequest, DeleteFrameworkResponse>()
                            .withOperationName("DeleteFramework").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteFrameworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFrameworkRequest));
            CompletableFuture<DeleteFrameworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the recovery point specified by a recovery point ID.
     * </p>
     * <p>
     * If the recovery point ID belongs to a continuous backup, calling this endpoint deletes the existing continuous
     * backup and stops future continuous backup.
     * </p>
     * <p>
     * When an IAM role's permissions are insufficient to call this API, the service sends back an HTTP 200 response
     * with an empty HTTP body, but the recovery point is not deleted. Instead, it enters an <code>EXPIRED</code> state.
     * </p>
     * <p>
     * <code>EXPIRED</code> recovery points can be deleted with this API once the IAM role has the
     * <code>iam:CreateServiceLinkedRole</code> action. To learn more about adding this role, see <a href=
     * "https://docs.aws.amazon.com/aws-backup/latest/devguide/deleting-backups.html#deleting-backups-troubleshooting">
     * Troubleshooting manual deletions</a>.
     * </p>
     * <p>
     * If the user or role is deleted or the permission within the role is removed, the deletion will not be successful
     * and will enter an <code>EXPIRED</code> state.
     * </p>
     *
     * @param deleteRecoveryPointRequest
     * @return A Java Future containing the result of the DeleteRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidResourceStateException Backup is already performing an action on this recovery point. It can't
     *         perform the action you requested until the first action finishes. Try again later.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRecoveryPoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRecoveryPointResponse> deleteRecoveryPoint(
            DeleteRecoveryPointRequest deleteRecoveryPointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRecoveryPointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRecoveryPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRecoveryPoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRecoveryPointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRecoveryPointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRecoveryPointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRecoveryPointRequest, DeleteRecoveryPointResponse>()
                            .withOperationName("DeleteRecoveryPoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRecoveryPointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRecoveryPointRequest));
            CompletableFuture<DeleteRecoveryPointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the report plan specified by a report plan name.
     * </p>
     *
     * @param deleteReportPlanRequest
     * @return A Java Future containing the result of the DeleteReportPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteReportPlanResponse> deleteReportPlan(DeleteReportPlanRequest deleteReportPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReportPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReportPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReportPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteReportPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteReportPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteReportPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteReportPlanRequest, DeleteReportPlanResponse>()
                            .withOperationName("DeleteReportPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteReportPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteReportPlanRequest));
            CompletableFuture<DeleteReportPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This request deletes the specified restore testing plan.
     * </p>
     * <p>
     * Deletion can only successfully occur if all associated restore testing selections are deleted first.
     * </p>
     *
     * @param deleteRestoreTestingPlanRequest
     * @return A Java Future containing the result of the DeleteRestoreTestingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRestoreTestingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRestoreTestingPlanResponse> deleteRestoreTestingPlan(
            DeleteRestoreTestingPlanRequest deleteRestoreTestingPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRestoreTestingPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRestoreTestingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRestoreTestingPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRestoreTestingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRestoreTestingPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRestoreTestingPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRestoreTestingPlanRequest, DeleteRestoreTestingPlanResponse>()
                            .withOperationName("DeleteRestoreTestingPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRestoreTestingPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRestoreTestingPlanRequest));
            CompletableFuture<DeleteRestoreTestingPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Input the Restore Testing Plan name and Restore Testing Selection name.
     * </p>
     * <p>
     * All testing selections associated with a restore testing plan must be deleted before the restore testing plan can
     * be deleted.
     * </p>
     *
     * @param deleteRestoreTestingSelectionRequest
     * @return A Java Future containing the result of the DeleteRestoreTestingSelection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRestoreTestingSelectionResponse> deleteRestoreTestingSelection(
            DeleteRestoreTestingSelectionRequest deleteRestoreTestingSelectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRestoreTestingSelectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteRestoreTestingSelectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRestoreTestingSelection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRestoreTestingSelectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRestoreTestingSelectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRestoreTestingSelectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRestoreTestingSelectionRequest, DeleteRestoreTestingSelectionResponse>()
                            .withOperationName("DeleteRestoreTestingSelection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRestoreTestingSelectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRestoreTestingSelectionRequest));
            CompletableFuture<DeleteRestoreTestingSelectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns backup job details for the specified <code>BackupJobId</code>.
     * </p>
     *
     * @param describeBackupJobRequest
     * @return A Java Future containing the result of the DescribeBackupJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>DependencyFailureException A dependent Amazon Web Services service or resource returned an error to
     *         the Backup service, and the action cannot be completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBackupJobResponse> describeBackupJob(DescribeBackupJobRequest describeBackupJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBackupJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBackupJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBackupJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBackupJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBackupJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeBackupJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBackupJobRequest, DescribeBackupJobResponse>()
                            .withOperationName("DescribeBackupJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeBackupJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeBackupJobRequest));
            CompletableFuture<DescribeBackupJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns metadata about a backup vault specified by its name.
     * </p>
     *
     * @param describeBackupVaultRequest
     * @return A Java Future containing the result of the DescribeBackupVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupVault" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBackupVaultResponse> describeBackupVault(
            DescribeBackupVaultRequest describeBackupVaultRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBackupVaultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBackupVaultRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBackupVault");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBackupVaultResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBackupVaultResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeBackupVaultResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBackupVaultRequest, DescribeBackupVaultResponse>()
                            .withOperationName("DescribeBackupVault").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeBackupVaultRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeBackupVaultRequest));
            CompletableFuture<DescribeBackupVaultResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns metadata associated with creating a copy of a resource.
     * </p>
     *
     * @param describeCopyJobRequest
     * @return A Java Future containing the result of the DescribeCopyJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeCopyJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCopyJobResponse> describeCopyJob(DescribeCopyJobRequest describeCopyJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCopyJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCopyJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCopyJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCopyJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCopyJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeCopyJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCopyJobRequest, DescribeCopyJobResponse>()
                            .withOperationName("DescribeCopyJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCopyJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCopyJobRequest));
            CompletableFuture<DescribeCopyJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the framework details for the specified <code>FrameworkName</code>.
     * </p>
     *
     * @param describeFrameworkRequest
     * @return A Java Future containing the result of the DescribeFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeFramework" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFrameworkResponse> describeFramework(DescribeFrameworkRequest describeFrameworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFrameworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFrameworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFramework");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFrameworkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFrameworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFrameworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFrameworkRequest, DescribeFrameworkResponse>()
                            .withOperationName("DescribeFramework").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeFrameworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFrameworkRequest));
            CompletableFuture<DescribeFrameworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the
     * account is not a member of an Organizations organization. Example:
     * <code>describe-global-settings --region us-west-2</code>
     * </p>
     *
     * @param describeGlobalSettingsRequest
     * @return A Java Future containing the result of the DescribeGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeGlobalSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGlobalSettingsResponse> describeGlobalSettings(
            DescribeGlobalSettingsRequest describeGlobalSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGlobalSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGlobalSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGlobalSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGlobalSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeGlobalSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeGlobalSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGlobalSettingsRequest, DescribeGlobalSettingsResponse>()
                            .withOperationName("DescribeGlobalSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeGlobalSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeGlobalSettingsRequest));
            CompletableFuture<DescribeGlobalSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name
     * (ARN), and the Amazon Web Services service type of the saved resource.
     * </p>
     *
     * @param describeProtectedResourceRequest
     * @return A Java Future containing the result of the DescribeProtectedResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeProtectedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeProtectedResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeProtectedResourceResponse> describeProtectedResource(
            DescribeProtectedResourceRequest describeProtectedResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeProtectedResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProtectedResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProtectedResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeProtectedResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeProtectedResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeProtectedResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeProtectedResourceRequest, DescribeProtectedResourceResponse>()
                            .withOperationName("DescribeProtectedResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeProtectedResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeProtectedResourceRequest));
            CompletableFuture<DescribeProtectedResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
     * </p>
     *
     * @param describeRecoveryPointRequest
     * @return A Java Future containing the result of the DescribeRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRecoveryPoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRecoveryPointResponse> describeRecoveryPoint(
            DescribeRecoveryPointRequest describeRecoveryPointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRecoveryPointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRecoveryPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRecoveryPoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRecoveryPointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRecoveryPointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRecoveryPointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRecoveryPointRequest, DescribeRecoveryPointResponse>()
                            .withOperationName("DescribeRecoveryPoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRecoveryPointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRecoveryPointRequest));
            CompletableFuture<DescribeRecoveryPointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup
     * tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or
     * scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region.
     * </p>
     *
     * @param describeRegionSettingsRequest
     * @return A Java Future containing the result of the DescribeRegionSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeRegionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRegionSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRegionSettingsResponse> describeRegionSettings(
            DescribeRegionSettingsRequest describeRegionSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRegionSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRegionSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRegionSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRegionSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRegionSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRegionSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRegionSettingsRequest, DescribeRegionSettingsResponse>()
                            .withOperationName("DescribeRegionSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRegionSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRegionSettingsRequest));
            CompletableFuture<DescribeRegionSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the details associated with creating a report as specified by its <code>ReportJobId</code>.
     * </p>
     *
     * @param describeReportJobRequest
     * @return A Java Future containing the result of the DescribeReportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeReportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReportJobResponse> describeReportJob(DescribeReportJobRequest describeReportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeReportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeReportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReportJobRequest, DescribeReportJobResponse>()
                            .withOperationName("DescribeReportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReportJobRequest));
            CompletableFuture<DescribeReportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.
     * </p>
     *
     * @param describeReportPlanRequest
     * @return A Java Future containing the result of the DescribeReportPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReportPlanResponse> describeReportPlan(DescribeReportPlanRequest describeReportPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReportPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReportPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReportPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReportPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeReportPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeReportPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReportPlanRequest, DescribeReportPlanResponse>()
                            .withOperationName("DescribeReportPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReportPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReportPlanRequest));
            CompletableFuture<DescribeReportPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns metadata associated with a restore job that is specified by a job ID.
     * </p>
     *
     * @param describeRestoreJobRequest
     * @return A Java Future containing the result of the DescribeRestoreJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>DependencyFailureException A dependent Amazon Web Services service or resource returned an error to
     *         the Backup service, and the action cannot be completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeRestoreJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRestoreJobResponse> describeRestoreJob(DescribeRestoreJobRequest describeRestoreJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRestoreJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRestoreJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRestoreJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRestoreJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRestoreJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeRestoreJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRestoreJobRequest, DescribeRestoreJobResponse>()
                            .withOperationName("DescribeRestoreJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRestoreJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRestoreJobRequest));
            CompletableFuture<DescribeRestoreJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup
     * to the source service, such as Amazon RDS. The source service will continue to create and retain continuous
     * backups using the lifecycle that you specified in your original backup plan.
     * </p>
     * <p>
     * Does not support snapshot backup recovery points.
     * </p>
     *
     * @param disassociateRecoveryPointRequest
     * @return A Java Future containing the result of the DisassociateRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidResourceStateException Backup is already performing an action on this recovery point. It can't
     *         perform the action you requested until the first action finishes. Try again later.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DisassociateRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateRecoveryPointResponse> disassociateRecoveryPoint(
            DisassociateRecoveryPointRequest disassociateRecoveryPointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateRecoveryPointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateRecoveryPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateRecoveryPoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateRecoveryPointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateRecoveryPointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateRecoveryPointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateRecoveryPointRequest, DisassociateRecoveryPointResponse>()
                            .withOperationName("DisassociateRecoveryPoint").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateRecoveryPointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateRecoveryPointRequest));
            CompletableFuture<DisassociateRecoveryPointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action to a specific child (nested) recovery point removes the relationship between the specified recovery
     * point and its parent (composite) recovery point.
     * </p>
     *
     * @param disassociateRecoveryPointFromParentRequest
     * @return A Java Future containing the result of the DisassociateRecoveryPointFromParent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DisassociateRecoveryPointFromParent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPointFromParent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateRecoveryPointFromParentResponse> disassociateRecoveryPointFromParent(
            DisassociateRecoveryPointFromParentRequest disassociateRecoveryPointFromParentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateRecoveryPointFromParentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateRecoveryPointFromParentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateRecoveryPointFromParent");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateRecoveryPointFromParentResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateRecoveryPointFromParentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateRecoveryPointFromParentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateRecoveryPointFromParentRequest, DisassociateRecoveryPointFromParentResponse>()
                            .withOperationName("DisassociateRecoveryPointFromParent").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateRecoveryPointFromParentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateRecoveryPointFromParentRequest));
            CompletableFuture<DisassociateRecoveryPointFromParentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the backup plan that is specified by the plan ID as a backup template.
     * </p>
     *
     * @param exportBackupPlanTemplateRequest
     * @return A Java Future containing the result of the ExportBackupPlanTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ExportBackupPlanTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ExportBackupPlanTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ExportBackupPlanTemplateResponse> exportBackupPlanTemplate(
            ExportBackupPlanTemplateRequest exportBackupPlanTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(exportBackupPlanTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, exportBackupPlanTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportBackupPlanTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ExportBackupPlanTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ExportBackupPlanTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ExportBackupPlanTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ExportBackupPlanTemplateRequest, ExportBackupPlanTemplateResponse>()
                            .withOperationName("ExportBackupPlanTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ExportBackupPlanTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(exportBackupPlanTemplateRequest));
            CompletableFuture<ExportBackupPlanTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns <code>BackupPlan</code> details for the specified <code>BackupPlanId</code>. The details are the body of
     * a backup plan in JSON format, in addition to plan metadata.
     * </p>
     *
     * @param getBackupPlanRequest
     * @return A Java Future containing the result of the GetBackupPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBackupPlanResponse> getBackupPlan(GetBackupPlanRequest getBackupPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackupPlanRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackupPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackupPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBackupPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetBackupPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBackupPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBackupPlanRequest, GetBackupPlanResponse>()
                            .withOperationName("GetBackupPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBackupPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBackupPlanRequest));
            CompletableFuture<GetBackupPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a valid JSON document specifying a backup plan or an error.
     * </p>
     *
     * @param getBackupPlanFromJsonRequest
     * @return A Java Future containing the result of the GetBackupPlanFromJSON operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupPlanFromJSON
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromJSON" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBackupPlanFromJsonResponse> getBackupPlanFromJSON(
            GetBackupPlanFromJsonRequest getBackupPlanFromJsonRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackupPlanFromJsonRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackupPlanFromJsonRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackupPlanFromJSON");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBackupPlanFromJsonResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBackupPlanFromJsonResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBackupPlanFromJsonResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBackupPlanFromJsonRequest, GetBackupPlanFromJsonResponse>()
                            .withOperationName("GetBackupPlanFromJSON").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBackupPlanFromJsonRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBackupPlanFromJsonRequest));
            CompletableFuture<GetBackupPlanFromJsonResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the template specified by its <code>templateId</code> as a backup plan.
     * </p>
     *
     * @param getBackupPlanFromTemplateRequest
     * @return A Java Future containing the result of the GetBackupPlanFromTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupPlanFromTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBackupPlanFromTemplateResponse> getBackupPlanFromTemplate(
            GetBackupPlanFromTemplateRequest getBackupPlanFromTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackupPlanFromTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackupPlanFromTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackupPlanFromTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBackupPlanFromTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBackupPlanFromTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBackupPlanFromTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBackupPlanFromTemplateRequest, GetBackupPlanFromTemplateResponse>()
                            .withOperationName("GetBackupPlanFromTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBackupPlanFromTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBackupPlanFromTemplateRequest));
            CompletableFuture<GetBackupPlanFromTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns selection metadata and a document in JSON format that specifies a list of resources that are associated
     * with a backup plan.
     * </p>
     *
     * @param getBackupSelectionRequest
     * @return A Java Future containing the result of the GetBackupSelection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupSelection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBackupSelectionResponse> getBackupSelection(GetBackupSelectionRequest getBackupSelectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackupSelectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackupSelectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackupSelection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBackupSelectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBackupSelectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBackupSelectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBackupSelectionRequest, GetBackupSelectionResponse>()
                            .withOperationName("GetBackupSelection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBackupSelectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBackupSelectionRequest));
            CompletableFuture<GetBackupSelectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the access policy document that is associated with the named backup vault.
     * </p>
     *
     * @param getBackupVaultAccessPolicyRequest
     * @return A Java Future containing the result of the GetBackupVaultAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBackupVaultAccessPolicyResponse> getBackupVaultAccessPolicy(
            GetBackupVaultAccessPolicyRequest getBackupVaultAccessPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackupVaultAccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackupVaultAccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackupVaultAccessPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBackupVaultAccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBackupVaultAccessPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBackupVaultAccessPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBackupVaultAccessPolicyRequest, GetBackupVaultAccessPolicyResponse>()
                            .withOperationName("GetBackupVaultAccessPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBackupVaultAccessPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBackupVaultAccessPolicyRequest));
            CompletableFuture<GetBackupVaultAccessPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns event notifications for the specified backup vault.
     * </p>
     *
     * @param getBackupVaultNotificationsRequest
     * @return A Java Future containing the result of the GetBackupVaultNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBackupVaultNotificationsResponse> getBackupVaultNotifications(
            GetBackupVaultNotificationsRequest getBackupVaultNotificationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackupVaultNotificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackupVaultNotificationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackupVaultNotifications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBackupVaultNotificationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBackupVaultNotificationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBackupVaultNotificationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBackupVaultNotificationsRequest, GetBackupVaultNotificationsResponse>()
                            .withOperationName("GetBackupVaultNotifications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetBackupVaultNotificationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getBackupVaultNotificationsRequest));
            CompletableFuture<GetBackupVaultNotificationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action returns details for a specified legal hold. The details are the body of a legal hold in JSON format,
     * in addition to metadata.
     * </p>
     *
     * @param getLegalHoldRequest
     * @return A Java Future containing the result of the GetLegalHold operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetLegalHoldResponse> getLegalHold(GetLegalHoldRequest getLegalHoldRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLegalHoldRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLegalHoldRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLegalHold");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLegalHoldResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetLegalHoldResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLegalHoldResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLegalHoldRequest, GetLegalHoldResponse>()
                            .withOperationName("GetLegalHold").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetLegalHoldRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getLegalHoldRequest));
            CompletableFuture<GetLegalHoldResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a set of metadata key-value pairs that were used to create the backup.
     * </p>
     *
     * @param getRecoveryPointRestoreMetadataRequest
     * @return A Java Future containing the result of the GetRecoveryPointRestoreMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRecoveryPointRestoreMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRecoveryPointRestoreMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRecoveryPointRestoreMetadataResponse> getRecoveryPointRestoreMetadata(
            GetRecoveryPointRestoreMetadataRequest getRecoveryPointRestoreMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRecoveryPointRestoreMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRecoveryPointRestoreMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecoveryPointRestoreMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRecoveryPointRestoreMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRecoveryPointRestoreMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRecoveryPointRestoreMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRecoveryPointRestoreMetadataRequest, GetRecoveryPointRestoreMetadataResponse>()
                            .withOperationName("GetRecoveryPointRestoreMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRecoveryPointRestoreMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRecoveryPointRestoreMetadataRequest));
            CompletableFuture<GetRecoveryPointRestoreMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This request returns the metadata for the specified restore job.
     * </p>
     *
     * @param getRestoreJobMetadataRequest
     * @return A Java Future containing the result of the GetRestoreJobMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRestoreJobMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreJobMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRestoreJobMetadataResponse> getRestoreJobMetadata(
            GetRestoreJobMetadataRequest getRestoreJobMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRestoreJobMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRestoreJobMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRestoreJobMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRestoreJobMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRestoreJobMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRestoreJobMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRestoreJobMetadataRequest, GetRestoreJobMetadataResponse>()
                            .withOperationName("GetRestoreJobMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRestoreJobMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRestoreJobMetadataRequest));
            CompletableFuture<GetRestoreJobMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This request returns the minimal required set of metadata needed to start a restore job with secure default
     * settings. <code>BackupVaultName</code> and <code>RecoveryPointArn</code> are required parameters.
     * <code>BackupVaultAccountId</code> is an optional parameter.
     * </p>
     *
     * @param getRestoreTestingInferredMetadataRequest
     * @return A Java Future containing the result of the GetRestoreTestingInferredMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRestoreTestingInferredMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingInferredMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRestoreTestingInferredMetadataResponse> getRestoreTestingInferredMetadata(
            GetRestoreTestingInferredMetadataRequest getRestoreTestingInferredMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRestoreTestingInferredMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRestoreTestingInferredMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRestoreTestingInferredMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRestoreTestingInferredMetadataResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetRestoreTestingInferredMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRestoreTestingInferredMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRestoreTestingInferredMetadataRequest, GetRestoreTestingInferredMetadataResponse>()
                            .withOperationName("GetRestoreTestingInferredMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRestoreTestingInferredMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRestoreTestingInferredMetadataRequest));
            CompletableFuture<GetRestoreTestingInferredMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns <code>RestoreTestingPlan</code> details for the specified <code>RestoreTestingPlanName</code>. The
     * details are the body of a restore testing plan in JSON format, in addition to plan metadata.
     * </p>
     *
     * @param getRestoreTestingPlanRequest
     * @return A Java Future containing the result of the GetRestoreTestingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRestoreTestingPlanResponse> getRestoreTestingPlan(
            GetRestoreTestingPlanRequest getRestoreTestingPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRestoreTestingPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRestoreTestingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRestoreTestingPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRestoreTestingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRestoreTestingPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRestoreTestingPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRestoreTestingPlanRequest, GetRestoreTestingPlanResponse>()
                            .withOperationName("GetRestoreTestingPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRestoreTestingPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRestoreTestingPlanRequest));
            CompletableFuture<GetRestoreTestingPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns RestoreTestingSelection, which displays resources and elements of the restore testing plan.
     * </p>
     *
     * @param getRestoreTestingSelectionRequest
     * @return A Java Future containing the result of the GetRestoreTestingSelection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRestoreTestingSelectionResponse> getRestoreTestingSelection(
            GetRestoreTestingSelectionRequest getRestoreTestingSelectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRestoreTestingSelectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRestoreTestingSelectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRestoreTestingSelection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRestoreTestingSelectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRestoreTestingSelectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRestoreTestingSelectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRestoreTestingSelectionRequest, GetRestoreTestingSelectionResponse>()
                            .withOperationName("GetRestoreTestingSelection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRestoreTestingSelectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRestoreTestingSelectionRequest));
            CompletableFuture<GetRestoreTestingSelectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the Amazon Web Services resource types supported by Backup.
     * </p>
     *
     * @param getSupportedResourceTypesRequest
     * @return A Java Future containing the result of the GetSupportedResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSupportedResourceTypesResponse> getSupportedResourceTypes(
            GetSupportedResourceTypesRequest getSupportedResourceTypesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSupportedResourceTypesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSupportedResourceTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSupportedResourceTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSupportedResourceTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSupportedResourceTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSupportedResourceTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSupportedResourceTypesRequest, GetSupportedResourceTypesResponse>()
                            .withOperationName("GetSupportedResourceTypes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSupportedResourceTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSupportedResourceTypesRequest));
            CompletableFuture<GetSupportedResourceTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This is a request for a summary of backup jobs created or running within the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     *
     * @param listBackupJobSummariesRequest
     * @return A Java Future containing the result of the ListBackupJobSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBackupJobSummariesResponse> listBackupJobSummaries(
            ListBackupJobSummariesRequest listBackupJobSummariesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackupJobSummariesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackupJobSummariesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackupJobSummaries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBackupJobSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBackupJobSummariesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBackupJobSummariesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBackupJobSummariesRequest, ListBackupJobSummariesResponse>()
                            .withOperationName("ListBackupJobSummaries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBackupJobSummariesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBackupJobSummariesRequest));
            CompletableFuture<ListBackupJobSummariesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of
     * time, consider using these <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">monitoring tools</a>.
     * </p>
     *
     * @param listBackupJobsRequest
     * @return A Java Future containing the result of the ListBackupJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListBackupJobsResponse> listBackupJobs(ListBackupJobsRequest listBackupJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackupJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackupJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackupJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBackupJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBackupJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBackupJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBackupJobsRequest, ListBackupJobsResponse>()
                            .withOperationName("ListBackupJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBackupJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBackupJobsRequest));
            CompletableFuture<ListBackupJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     *
     * @param listBackupPlanTemplatesRequest
     * @return A Java Future containing the result of the ListBackupPlanTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlanTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBackupPlanTemplatesResponse> listBackupPlanTemplates(
            ListBackupPlanTemplatesRequest listBackupPlanTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackupPlanTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackupPlanTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackupPlanTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBackupPlanTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBackupPlanTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBackupPlanTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBackupPlanTemplatesRequest, ListBackupPlanTemplatesResponse>()
                            .withOperationName("ListBackupPlanTemplates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBackupPlanTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBackupPlanTemplatesRequest));
            CompletableFuture<ListBackupPlanTemplatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation
     * and deletion dates, plan names, and version IDs.
     * </p>
     *
     * @param listBackupPlanVersionsRequest
     * @return A Java Future containing the result of the ListBackupPlanVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlanVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBackupPlanVersionsResponse> listBackupPlanVersions(
            ListBackupPlanVersionsRequest listBackupPlanVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackupPlanVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackupPlanVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackupPlanVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBackupPlanVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBackupPlanVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBackupPlanVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBackupPlanVersionsRequest, ListBackupPlanVersionsResponse>()
                            .withOperationName("ListBackupPlanVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBackupPlanVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBackupPlanVersionsRequest));
            CompletableFuture<ListBackupPlanVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as
     * Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request
     * IDs.
     * </p>
     *
     * @param listBackupPlansRequest
     * @return A Java Future containing the result of the ListBackupPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListBackupPlansResponse> listBackupPlans(ListBackupPlansRequest listBackupPlansRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackupPlansRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackupPlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackupPlans");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBackupPlansResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBackupPlansResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBackupPlansResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBackupPlansRequest, ListBackupPlansResponse>()
                            .withOperationName("ListBackupPlans").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBackupPlansRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBackupPlansRequest));
            CompletableFuture<ListBackupPlansResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array containing metadata of the resources associated with the target backup plan.
     * </p>
     *
     * @param listBackupSelectionsRequest
     * @return A Java Future containing the result of the ListBackupSelections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBackupSelectionsResponse> listBackupSelections(
            ListBackupSelectionsRequest listBackupSelectionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackupSelectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackupSelectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackupSelections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBackupSelectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBackupSelectionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBackupSelectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBackupSelectionsRequest, ListBackupSelectionsResponse>()
                            .withOperationName("ListBackupSelections").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBackupSelectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBackupSelectionsRequest));
            CompletableFuture<ListBackupSelectionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     *
     * @param listBackupVaultsRequest
     * @return A Java Future containing the result of the ListBackupVaults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupVaults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListBackupVaultsResponse> listBackupVaults(ListBackupVaultsRequest listBackupVaultsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackupVaultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackupVaultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackupVaults");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBackupVaultsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBackupVaultsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBackupVaultsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBackupVaultsRequest, ListBackupVaultsResponse>()
                            .withOperationName("ListBackupVaults").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListBackupVaultsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listBackupVaultsRequest));
            CompletableFuture<ListBackupVaultsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This request obtains a list of copy jobs created or running within the the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     *
     * @param listCopyJobSummariesRequest
     * @return A Java Future containing the result of the ListCopyJobSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListCopyJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCopyJobSummariesResponse> listCopyJobSummaries(
            ListCopyJobSummariesRequest listCopyJobSummariesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCopyJobSummariesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCopyJobSummariesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCopyJobSummaries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCopyJobSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCopyJobSummariesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCopyJobSummariesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCopyJobSummariesRequest, ListCopyJobSummariesResponse>()
                            .withOperationName("ListCopyJobSummaries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCopyJobSummariesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCopyJobSummariesRequest));
            CompletableFuture<ListCopyJobSummariesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns metadata about your copy jobs.
     * </p>
     *
     * @param listCopyJobsRequest
     * @return A Java Future containing the result of the ListCopyJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListCopyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListCopyJobsResponse> listCopyJobs(ListCopyJobsRequest listCopyJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCopyJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCopyJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCopyJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCopyJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListCopyJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCopyJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCopyJobsRequest, ListCopyJobsResponse>()
                            .withOperationName("ListCopyJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCopyJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCopyJobsRequest));
            CompletableFuture<ListCopyJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
     * </p>
     *
     * @param listFrameworksRequest
     * @return A Java Future containing the result of the ListFrameworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListFrameworks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFrameworksResponse> listFrameworks(ListFrameworksRequest listFrameworksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFrameworksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFrameworksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFrameworks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFrameworksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFrameworksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFrameworksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFrameworksRequest, ListFrameworksResponse>()
                            .withOperationName("ListFrameworks").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListFrameworksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFrameworksRequest));
            CompletableFuture<ListFrameworksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action returns metadata about active and previous legal holds.
     * </p>
     *
     * @param listLegalHoldsRequest
     * @return A Java Future containing the result of the ListLegalHolds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListLegalHolds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListLegalHolds" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListLegalHoldsResponse> listLegalHolds(ListLegalHoldsRequest listLegalHoldsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLegalHoldsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLegalHoldsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLegalHolds");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLegalHoldsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLegalHoldsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListLegalHoldsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLegalHoldsRequest, ListLegalHoldsResponse>()
                            .withOperationName("ListLegalHolds").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListLegalHoldsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listLegalHoldsRequest));
            CompletableFuture<ListLegalHoldsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     *
     * @param listProtectedResourcesRequest
     * @return A Java Future containing the result of the ListProtectedResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListProtectedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListProtectedResourcesResponse> listProtectedResources(
            ListProtectedResourcesRequest listProtectedResourcesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProtectedResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProtectedResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProtectedResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProtectedResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListProtectedResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListProtectedResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProtectedResourcesRequest, ListProtectedResourcesResponse>()
                            .withOperationName("ListProtectedResources").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListProtectedResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listProtectedResourcesRequest));
            CompletableFuture<ListProtectedResourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This request lists the protected resources corresponding to each backup vault.
     * </p>
     *
     * @param listProtectedResourcesByBackupVaultRequest
     * @return A Java Future containing the result of the ListProtectedResourcesByBackupVault operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListProtectedResourcesByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResourcesByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListProtectedResourcesByBackupVaultResponse> listProtectedResourcesByBackupVault(
            ListProtectedResourcesByBackupVaultRequest listProtectedResourcesByBackupVaultRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProtectedResourcesByBackupVaultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listProtectedResourcesByBackupVaultRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProtectedResourcesByBackupVault");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListProtectedResourcesByBackupVaultResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListProtectedResourcesByBackupVaultResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListProtectedResourcesByBackupVaultResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListProtectedResourcesByBackupVaultRequest, ListProtectedResourcesByBackupVaultResponse>()
                            .withOperationName("ListProtectedResourcesByBackupVault").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListProtectedResourcesByBackupVaultRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listProtectedResourcesByBackupVaultRequest));
            CompletableFuture<ListProtectedResourcesByBackupVaultResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns detailed information about the recovery points stored in a backup vault.
     * </p>
     *
     * @param listRecoveryPointsByBackupVaultRequest
     * @return A Java Future containing the result of the ListRecoveryPointsByBackupVault operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRecoveryPointsByBackupVaultResponse> listRecoveryPointsByBackupVault(
            ListRecoveryPointsByBackupVaultRequest listRecoveryPointsByBackupVaultRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRecoveryPointsByBackupVaultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listRecoveryPointsByBackupVaultRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecoveryPointsByBackupVault");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRecoveryPointsByBackupVaultResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRecoveryPointsByBackupVaultResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRecoveryPointsByBackupVaultResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRecoveryPointsByBackupVaultRequest, ListRecoveryPointsByBackupVaultResponse>()
                            .withOperationName("ListRecoveryPointsByBackupVault").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRecoveryPointsByBackupVaultRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRecoveryPointsByBackupVaultRequest));
            CompletableFuture<ListRecoveryPointsByBackupVaultResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This action returns recovery point ARNs (Amazon Resource Names) of the specified legal hold.
     * </p>
     *
     * @param listRecoveryPointsByLegalHoldRequest
     * @return A Java Future containing the result of the ListRecoveryPointsByLegalHold operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByLegalHold"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRecoveryPointsByLegalHoldResponse> listRecoveryPointsByLegalHold(
            ListRecoveryPointsByLegalHoldRequest listRecoveryPointsByLegalHoldRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRecoveryPointsByLegalHoldRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listRecoveryPointsByLegalHoldRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecoveryPointsByLegalHold");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRecoveryPointsByLegalHoldResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRecoveryPointsByLegalHoldResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRecoveryPointsByLegalHoldResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRecoveryPointsByLegalHoldRequest, ListRecoveryPointsByLegalHoldResponse>()
                            .withOperationName("ListRecoveryPointsByLegalHold").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRecoveryPointsByLegalHoldRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRecoveryPointsByLegalHoldRequest));
            CompletableFuture<ListRecoveryPointsByLegalHoldResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource
     * Name (ARN).
     * </p>
     * <note>
     * <p>
     * For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.
     * </p>
     * </note>
     *
     * @param listRecoveryPointsByResourceRequest
     * @return A Java Future containing the result of the ListRecoveryPointsByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRecoveryPointsByResourceResponse> listRecoveryPointsByResource(
            ListRecoveryPointsByResourceRequest listRecoveryPointsByResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRecoveryPointsByResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecoveryPointsByResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecoveryPointsByResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRecoveryPointsByResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRecoveryPointsByResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRecoveryPointsByResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRecoveryPointsByResourceRequest, ListRecoveryPointsByResourceResponse>()
                            .withOperationName("ListRecoveryPointsByResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRecoveryPointsByResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRecoveryPointsByResourceRequest));
            CompletableFuture<ListRecoveryPointsByResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns details about your report jobs.
     * </p>
     *
     * @param listReportJobsRequest
     * @return A Java Future containing the result of the ListReportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListReportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListReportJobsResponse> listReportJobs(ListReportJobsRequest listReportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListReportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReportJobsRequest, ListReportJobsResponse>()
                            .withOperationName("ListReportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listReportJobsRequest));
            CompletableFuture<ListReportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of your report plans. For detailed information about a single report plan, use
     * <code>DescribeReportPlan</code>.
     * </p>
     *
     * @param listReportPlansRequest
     * @return A Java Future containing the result of the ListReportPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListReportPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportPlans" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListReportPlansResponse> listReportPlans(ListReportPlansRequest listReportPlansRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReportPlansRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReportPlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReportPlans");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReportPlansResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReportPlansResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListReportPlansResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReportPlansRequest, ListReportPlansResponse>()
                            .withOperationName("ListReportPlans").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReportPlansRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listReportPlansRequest));
            CompletableFuture<ListReportPlansResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This request obtains a summary of restore jobs created or running within the the most recent 30 days. You can
     * include parameters AccountID, State, ResourceType, AggregationPeriod, MaxResults, or NextToken to filter results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     *
     * @param listRestoreJobSummariesRequest
     * @return A Java Future containing the result of the ListRestoreJobSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRestoreJobSummariesResponse> listRestoreJobSummaries(
            ListRestoreJobSummariesRequest listRestoreJobSummariesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRestoreJobSummariesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRestoreJobSummariesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRestoreJobSummaries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRestoreJobSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRestoreJobSummariesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRestoreJobSummariesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRestoreJobSummariesRequest, ListRestoreJobSummariesResponse>()
                            .withOperationName("ListRestoreJobSummaries").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRestoreJobSummariesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRestoreJobSummariesRequest));
            CompletableFuture<ListRestoreJobSummariesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery
     * process.
     * </p>
     *
     * @param listRestoreJobsRequest
     * @return A Java Future containing the result of the ListRestoreJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListRestoreJobsResponse> listRestoreJobs(ListRestoreJobsRequest listRestoreJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRestoreJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRestoreJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRestoreJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRestoreJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRestoreJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRestoreJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRestoreJobsRequest, ListRestoreJobsResponse>()
                            .withOperationName("ListRestoreJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRestoreJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRestoreJobsRequest));
            CompletableFuture<ListRestoreJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This returns restore jobs that contain the specified protected resource.
     * </p>
     * <p>
     * You must include <code>ResourceArn</code>. You can optionally include <code>NextToken</code>,
     * <code>ByStatus</code>, <code>MaxResults</code>, <code>ByRecoveryPointCreationDateAfter</code> , and
     * <code>ByRecoveryPointCreationDateBefore</code>.
     * </p>
     *
     * @param listRestoreJobsByProtectedResourceRequest
     * @return A Java Future containing the result of the ListRestoreJobsByProtectedResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobsByProtectedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobsByProtectedResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRestoreJobsByProtectedResourceResponse> listRestoreJobsByProtectedResource(
            ListRestoreJobsByProtectedResourceRequest listRestoreJobsByProtectedResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRestoreJobsByProtectedResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listRestoreJobsByProtectedResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRestoreJobsByProtectedResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRestoreJobsByProtectedResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListRestoreJobsByProtectedResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRestoreJobsByProtectedResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRestoreJobsByProtectedResourceRequest, ListRestoreJobsByProtectedResourceResponse>()
                            .withOperationName("ListRestoreJobsByProtectedResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRestoreJobsByProtectedResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRestoreJobsByProtectedResourceRequest));
            CompletableFuture<ListRestoreJobsByProtectedResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of restore testing plans.
     * </p>
     *
     * @param listRestoreTestingPlansRequest
     * @return A Java Future containing the result of the ListRestoreTestingPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreTestingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRestoreTestingPlansResponse> listRestoreTestingPlans(
            ListRestoreTestingPlansRequest listRestoreTestingPlansRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRestoreTestingPlansRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRestoreTestingPlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRestoreTestingPlans");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRestoreTestingPlansResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRestoreTestingPlansResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRestoreTestingPlansResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRestoreTestingPlansRequest, ListRestoreTestingPlansResponse>()
                            .withOperationName("ListRestoreTestingPlans").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRestoreTestingPlansRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRestoreTestingPlansRequest));
            CompletableFuture<ListRestoreTestingPlansResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of restore testing selections. Can be filtered by <code>MaxResults</code> and
     * <code>RestoreTestingPlanName</code>.
     * </p>
     *
     * @param listRestoreTestingSelectionsRequest
     * @return A Java Future containing the result of the ListRestoreTestingSelections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreTestingSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingSelections"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRestoreTestingSelectionsResponse> listRestoreTestingSelections(
            ListRestoreTestingSelectionsRequest listRestoreTestingSelectionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRestoreTestingSelectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRestoreTestingSelectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRestoreTestingSelections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRestoreTestingSelectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListRestoreTestingSelectionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListRestoreTestingSelectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRestoreTestingSelectionsRequest, ListRestoreTestingSelectionsResponse>()
                            .withOperationName("ListRestoreTestingSelections").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRestoreTestingSelectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRestoreTestingSelectionsRequest));
            CompletableFuture<ListRestoreTestingSelectionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     * </p>
     * <p>
     * <code>ListTags</code> only works for resource types that support full Backup management of their backups. Those
     * resource types are listed in the "Full Backup management" section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table.
     * </p>
     *
     * @param listTagsRequest
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>().withOperationName("ListTags")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsRequest));
            CompletableFuture<ListTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a
     * backup vault name and an access policy document in JSON format.
     * </p>
     *
     * @param putBackupVaultAccessPolicyRequest
     * @return A Java Future containing the result of the PutBackupVaultAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.PutBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutBackupVaultAccessPolicyResponse> putBackupVaultAccessPolicy(
            PutBackupVaultAccessPolicyRequest putBackupVaultAccessPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putBackupVaultAccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putBackupVaultAccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBackupVaultAccessPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutBackupVaultAccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutBackupVaultAccessPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutBackupVaultAccessPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutBackupVaultAccessPolicyRequest, PutBackupVaultAccessPolicyResponse>()
                            .withOperationName("PutBackupVaultAccessPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutBackupVaultAccessPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putBackupVaultAccessPolicyRequest));
            CompletableFuture<PutBackupVaultAccessPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or
     * created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the
     * retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a
     * minimum and maximum retention period for future backup and copy jobs that target a backup vault.
     * </p>
     * <note>
     * <p>
     * Backup Vault Lock has been assessed by Cohasset Associates for use in environments that are subject to SEC 17a-4,
     * CFTC, and FINRA regulations. For more information about how Backup Vault Lock relates to these regulations, see
     * the <a href="samples/cohassetreport.zip">Cohasset Associates Compliance Assessment.</a>
     * </p>
     * </note>
     *
     * @param putBackupVaultLockConfigurationRequest
     * @return A Java Future containing the result of the PutBackupVaultLockConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.PutBackupVaultLockConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultLockConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutBackupVaultLockConfigurationResponse> putBackupVaultLockConfiguration(
            PutBackupVaultLockConfigurationRequest putBackupVaultLockConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putBackupVaultLockConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putBackupVaultLockConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBackupVaultLockConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutBackupVaultLockConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutBackupVaultLockConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutBackupVaultLockConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutBackupVaultLockConfigurationRequest, PutBackupVaultLockConfigurationResponse>()
                            .withOperationName("PutBackupVaultLockConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutBackupVaultLockConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putBackupVaultLockConfigurationRequest));
            CompletableFuture<PutBackupVaultLockConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Turns on notifications on a backup vault for the specified topic and events.
     * </p>
     *
     * @param putBackupVaultNotificationsRequest
     * @return A Java Future containing the result of the PutBackupVaultNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.PutBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutBackupVaultNotificationsResponse> putBackupVaultNotifications(
            PutBackupVaultNotificationsRequest putBackupVaultNotificationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putBackupVaultNotificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putBackupVaultNotificationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBackupVaultNotifications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutBackupVaultNotificationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutBackupVaultNotificationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutBackupVaultNotificationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutBackupVaultNotificationsRequest, PutBackupVaultNotificationsResponse>()
                            .withOperationName("PutBackupVaultNotifications").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutBackupVaultNotificationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putBackupVaultNotificationsRequest));
            CompletableFuture<PutBackupVaultNotificationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This request allows you to send your independent self-run restore test validation results.
     * <code>RestoreJobId</code> and <code>ValidationStatus</code> are required. Optionally, you can input a
     * <code>ValidationStatusMessage</code>.
     * </p>
     *
     * @param putRestoreValidationResultRequest
     * @return A Java Future containing the result of the PutRestoreValidationResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.PutRestoreValidationResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutRestoreValidationResult"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutRestoreValidationResultResponse> putRestoreValidationResult(
            PutRestoreValidationResultRequest putRestoreValidationResultRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putRestoreValidationResultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRestoreValidationResultRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRestoreValidationResult");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutRestoreValidationResultResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutRestoreValidationResultResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutRestoreValidationResultResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutRestoreValidationResultRequest, PutRestoreValidationResultResponse>()
                            .withOperationName("PutRestoreValidationResult").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutRestoreValidationResultRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putRestoreValidationResultRequest));
            CompletableFuture<PutRestoreValidationResultResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an on-demand backup job for the specified resource.
     * </p>
     *
     * @param startBackupJobRequest
     * @return A Java Future containing the result of the StartBackupJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StartBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartBackupJobResponse> startBackupJob(StartBackupJobRequest startBackupJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startBackupJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startBackupJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartBackupJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartBackupJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartBackupJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartBackupJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartBackupJobRequest, StartBackupJobResponse>()
                            .withOperationName("StartBackupJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartBackupJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startBackupJobRequest));
            CompletableFuture<StartBackupJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a job to create a one-time copy of the specified resource.
     * </p>
     * <p>
     * Does not support continuous backups.
     * </p>
     *
     * @param startCopyJobRequest
     * @return A Java Future containing the result of the StartCopyJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StartCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartCopyJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartCopyJobResponse> startCopyJob(StartCopyJobRequest startCopyJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startCopyJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startCopyJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartCopyJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartCopyJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartCopyJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartCopyJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartCopyJobRequest, StartCopyJobResponse>()
                            .withOperationName("StartCopyJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartCopyJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startCopyJobRequest));
            CompletableFuture<StartCopyJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an on-demand report job for the specified report plan.
     * </p>
     *
     * @param startReportJobRequest
     * @return A Java Future containing the result of the StartReportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StartReportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartReportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartReportJobResponse> startReportJob(StartReportJobRequest startReportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartReportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartReportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartReportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartReportJobRequest, StartReportJobResponse>()
                            .withOperationName("StartReportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartReportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startReportJobRequest));
            CompletableFuture<StartReportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Recovers the saved resource identified by an Amazon Resource Name (ARN).
     * </p>
     *
     * @param startRestoreJobRequest
     * @return A Java Future containing the result of the StartRestoreJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StartRestoreJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartRestoreJobResponse> startRestoreJob(StartRestoreJobRequest startRestoreJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startRestoreJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startRestoreJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartRestoreJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartRestoreJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartRestoreJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartRestoreJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartRestoreJobRequest, StartRestoreJobResponse>()
                            .withOperationName("StartRestoreJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartRestoreJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startRestoreJobRequest));
            CompletableFuture<StartRestoreJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attempts to cancel a job to create a one-time backup of a resource.
     * </p>
     * <p>
     * This action is not supported for the following services: Amazon FSx for Windows File Server, Amazon FSx for
     * Lustre, FSx for ONTAP , Amazon FSx for OpenZFS, Amazon DocumentDB (with MongoDB compatibility), Amazon RDS,
     * Amazon Aurora, and Amazon Neptune.
     * </p>
     *
     * @param stopBackupJobRequest
     * @return A Java Future containing the result of the StopBackupJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StopBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StopBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopBackupJobResponse> stopBackupJob(StopBackupJobRequest stopBackupJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopBackupJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopBackupJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopBackupJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopBackupJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StopBackupJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopBackupJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopBackupJobRequest, StopBackupJobResponse>()
                            .withOperationName("StopBackupJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopBackupJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopBackupJobRequest));
            CompletableFuture<StopBackupJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN).
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN)
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing backup plan identified by its <code>backupPlanId</code> with the input document in JSON
     * format. The new version is uniquely identified by a <code>VersionId</code>.
     * </p>
     *
     * @param updateBackupPlanRequest
     * @return A Java Future containing the result of the UpdateBackupPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBackupPlanResponse> updateBackupPlan(UpdateBackupPlanRequest updateBackupPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBackupPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBackupPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBackupPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBackupPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBackupPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBackupPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBackupPlanRequest, UpdateBackupPlanResponse>()
                            .withOperationName("UpdateBackupPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateBackupPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateBackupPlanRequest));
            CompletableFuture<UpdateBackupPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing framework identified by its <code>FrameworkName</code> with the input document in JSON
     * format.
     * </p>
     *
     * @param updateFrameworkRequest
     * @return A Java Future containing the result of the UpdateFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateFramework" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFrameworkResponse> updateFramework(UpdateFrameworkRequest updateFrameworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFrameworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFrameworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFramework");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFrameworkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFrameworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFrameworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFrameworkRequest, UpdateFrameworkResponse>()
                            .withOperationName("UpdateFramework").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateFrameworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFrameworkRequest));
            CompletableFuture<UpdateFrameworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the
     * account is not an Organizations management account. Use the <code>DescribeGlobalSettings</code> API to determine
     * the current settings.
     * </p>
     *
     * @param updateGlobalSettingsRequest
     * @return A Java Future containing the result of the UpdateGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateGlobalSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGlobalSettingsResponse> updateGlobalSettings(
            UpdateGlobalSettingsRequest updateGlobalSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGlobalSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGlobalSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGlobalSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGlobalSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateGlobalSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGlobalSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGlobalSettingsRequest, UpdateGlobalSettingsResponse>()
                            .withOperationName("UpdateGlobalSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateGlobalSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateGlobalSettingsRequest));
            CompletableFuture<UpdateGlobalSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the transition lifecycle of a recovery point.
     * </p>
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
     * “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to
     * cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * <p>
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage"
     * section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table. Backup ignores this expression for other resource types.
     * </p>
     * <p>
     * This operation does not support continuous backups.
     * </p>
     *
     * @param updateRecoveryPointLifecycleRequest
     * @return A Java Future containing the result of the UpdateRecoveryPointLifecycle operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateRecoveryPointLifecycle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRecoveryPointLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRecoveryPointLifecycleResponse> updateRecoveryPointLifecycle(
            UpdateRecoveryPointLifecycleRequest updateRecoveryPointLifecycleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRecoveryPointLifecycleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRecoveryPointLifecycleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRecoveryPointLifecycle");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRecoveryPointLifecycleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRecoveryPointLifecycleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRecoveryPointLifecycleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRecoveryPointLifecycleRequest, UpdateRecoveryPointLifecycleResponse>()
                            .withOperationName("UpdateRecoveryPointLifecycle").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRecoveryPointLifecycleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRecoveryPointLifecycleRequest));
            CompletableFuture<UpdateRecoveryPointLifecycleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the current service opt-in settings for the Region. If service-opt-in is enabled for a service, Backup
     * tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or
     * scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region. Use the
     * <code>DescribeRegionSettings</code> API to determine the resource types that are supported.
     * </p>
     *
     * @param updateRegionSettingsRequest
     * @return A Java Future containing the result of the UpdateRegionSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateRegionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRegionSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRegionSettingsResponse> updateRegionSettings(
            UpdateRegionSettingsRequest updateRegionSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRegionSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRegionSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRegionSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRegionSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRegionSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRegionSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRegionSettingsRequest, UpdateRegionSettingsResponse>()
                            .withOperationName("UpdateRegionSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRegionSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRegionSettingsRequest));
            CompletableFuture<UpdateRegionSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing report plan identified by its <code>ReportPlanName</code> with the input document in JSON
     * format.
     * </p>
     *
     * @param updateReportPlanRequest
     * @return A Java Future containing the result of the UpdateReportPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateReportPlanResponse> updateReportPlan(UpdateReportPlanRequest updateReportPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateReportPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateReportPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateReportPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateReportPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateReportPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateReportPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateReportPlanRequest, UpdateReportPlanResponse>()
                            .withOperationName("UpdateReportPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateReportPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateReportPlanRequest));
            CompletableFuture<UpdateReportPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This request will send changes to your specified restore testing plan. <code>RestoreTestingPlanName</code> cannot
     * be updated after it is created.
     * </p>
     * <p>
     * <code>RecoveryPointSelection</code> can contain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Algorithm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExcludeVaults</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IncludeVaults</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RecoveryPointTypes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SelectionWindowDays</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateRestoreTestingPlanRequest
     * @return A Java Future containing the result of the UpdateRestoreTestingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRestoreTestingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRestoreTestingPlanResponse> updateRestoreTestingPlan(
            UpdateRestoreTestingPlanRequest updateRestoreTestingPlanRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRestoreTestingPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRestoreTestingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRestoreTestingPlan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRestoreTestingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRestoreTestingPlanResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRestoreTestingPlanResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRestoreTestingPlanRequest, UpdateRestoreTestingPlanResponse>()
                            .withOperationName("UpdateRestoreTestingPlan").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRestoreTestingPlanRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRestoreTestingPlanRequest));
            CompletableFuture<UpdateRestoreTestingPlanResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Most elements except the <code>RestoreTestingSelectionName</code> can be updated with this request.
     * </p>
     * <p>
     * <code>RestoreTestingSelection</code> can use either protected resource ARNs or conditions, but not both. That is,
     * if your selection has <code>ProtectedResourceArns</code>, requesting an update with the parameter
     * <code>ProtectedResourceConditions</code> will be unsuccessful.
     * </p>
     *
     * @param updateRestoreTestingSelectionRequest
     * @return A Java Future containing the result of the UpdateRestoreTestingSelection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRestoreTestingSelectionResponse> updateRestoreTestingSelection(
            UpdateRestoreTestingSelectionRequest updateRestoreTestingSelectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRestoreTestingSelectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateRestoreTestingSelectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRestoreTestingSelection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRestoreTestingSelectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRestoreTestingSelectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRestoreTestingSelectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRestoreTestingSelectionRequest, UpdateRestoreTestingSelectionResponse>()
                            .withOperationName("UpdateRestoreTestingSelection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRestoreTestingSelectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRestoreTestingSelectionRequest));
            CompletableFuture<UpdateRestoreTestingSelectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final BackupServiceClientConfiguration serviceClientConfiguration() {
        return new BackupServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(BackupException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MissingParameterValueException")
                                .exceptionBuilderSupplier(MissingParameterValueException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DependencyFailureException")
                                .exceptionBuilderSupplier(DependencyFailureException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AlreadyExistsException")
                                .exceptionBuilderSupplier(AlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResourceStateException")
                                .exceptionBuilderSupplier(InvalidResourceStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        BackupServiceClientConfigurationBuilder serviceConfigBuilder = new BackupServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
