/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRestoreTestingSelectionRequest extends BackupRequest implements
        ToCopyableBuilder<UpdateRestoreTestingSelectionRequest.Builder, UpdateRestoreTestingSelectionRequest> {
    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanName").getter(getter(UpdateRestoreTestingSelectionRequest::restoreTestingPlanName))
            .setter(setter(Builder::restoreTestingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("RestoreTestingPlanName").build())
            .build();

    private static final SdkField<RestoreTestingSelectionForUpdate> RESTORE_TESTING_SELECTION_FIELD = SdkField
            .<RestoreTestingSelectionForUpdate> builder(MarshallingType.SDK_POJO).memberName("RestoreTestingSelection")
            .getter(getter(UpdateRestoreTestingSelectionRequest::restoreTestingSelection))
            .setter(setter(Builder::restoreTestingSelection)).constructor(RestoreTestingSelectionForUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingSelection").build())
            .build();

    private static final SdkField<String> RESTORE_TESTING_SELECTION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("RestoreTestingSelectionName")
            .getter(getter(UpdateRestoreTestingSelectionRequest::restoreTestingSelectionName))
            .setter(setter(Builder::restoreTestingSelectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("RestoreTestingSelectionName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESTORE_TESTING_PLAN_NAME_FIELD, RESTORE_TESTING_SELECTION_FIELD, RESTORE_TESTING_SELECTION_NAME_FIELD));

    private final String restoreTestingPlanName;

    private final RestoreTestingSelectionForUpdate restoreTestingSelection;

    private final String restoreTestingSelectionName;

    private UpdateRestoreTestingSelectionRequest(BuilderImpl builder) {
        super(builder);
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
        this.restoreTestingSelection = builder.restoreTestingSelection;
        this.restoreTestingSelectionName = builder.restoreTestingSelectionName;
    }

    /**
     * <p>
     * The restore testing plan name is required to update the indicated testing plan.
     * </p>
     * 
     * @return The restore testing plan name is required to update the indicated testing plan.
     */
    public final String restoreTestingPlanName() {
        return restoreTestingPlanName;
    }

    /**
     * <p>
     * To update your restore testing selection, you can use either protected resource ARNs or conditions, but not both.
     * That is, if your selection has <code>ProtectedResourceArns</code>, requesting an update with the parameter
     * <code>ProtectedResourceConditions</code> will be unsuccessful.
     * </p>
     * 
     * @return To update your restore testing selection, you can use either protected resource ARNs or conditions, but
     *         not both. That is, if your selection has <code>ProtectedResourceArns</code>, requesting an update with
     *         the parameter <code>ProtectedResourceConditions</code> will be unsuccessful.
     */
    public final RestoreTestingSelectionForUpdate restoreTestingSelection() {
        return restoreTestingSelection;
    }

    /**
     * <p>
     * This is the required restore testing selection name of the restore testing selection you wish to update.
     * </p>
     * 
     * @return This is the required restore testing selection name of the restore testing selection you wish to update.
     */
    public final String restoreTestingSelectionName() {
        return restoreTestingSelectionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingSelection());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingSelectionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRestoreTestingSelectionRequest)) {
            return false;
        }
        UpdateRestoreTestingSelectionRequest other = (UpdateRestoreTestingSelectionRequest) obj;
        return Objects.equals(restoreTestingPlanName(), other.restoreTestingPlanName())
                && Objects.equals(restoreTestingSelection(), other.restoreTestingSelection())
                && Objects.equals(restoreTestingSelectionName(), other.restoreTestingSelectionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRestoreTestingSelectionRequest").add("RestoreTestingPlanName", restoreTestingPlanName())
                .add("RestoreTestingSelection", restoreTestingSelection())
                .add("RestoreTestingSelectionName", restoreTestingSelectionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestoreTestingPlanName":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanName()));
        case "RestoreTestingSelection":
            return Optional.ofNullable(clazz.cast(restoreTestingSelection()));
        case "RestoreTestingSelectionName":
            return Optional.ofNullable(clazz.cast(restoreTestingSelectionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRestoreTestingSelectionRequest, T> g) {
        return obj -> g.apply((UpdateRestoreTestingSelectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRestoreTestingSelectionRequest> {
        /**
         * <p>
         * The restore testing plan name is required to update the indicated testing plan.
         * </p>
         * 
         * @param restoreTestingPlanName
         *        The restore testing plan name is required to update the indicated testing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanName(String restoreTestingPlanName);

        /**
         * <p>
         * To update your restore testing selection, you can use either protected resource ARNs or conditions, but not
         * both. That is, if your selection has <code>ProtectedResourceArns</code>, requesting an update with the
         * parameter <code>ProtectedResourceConditions</code> will be unsuccessful.
         * </p>
         * 
         * @param restoreTestingSelection
         *        To update your restore testing selection, you can use either protected resource ARNs or conditions,
         *        but not both. That is, if your selection has <code>ProtectedResourceArns</code>, requesting an update
         *        with the parameter <code>ProtectedResourceConditions</code> will be unsuccessful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingSelection(RestoreTestingSelectionForUpdate restoreTestingSelection);

        /**
         * <p>
         * To update your restore testing selection, you can use either protected resource ARNs or conditions, but not
         * both. That is, if your selection has <code>ProtectedResourceArns</code>, requesting an update with the
         * parameter <code>ProtectedResourceConditions</code> will be unsuccessful.
         * </p>
         * This is a convenience method that creates an instance of the {@link RestoreTestingSelectionForUpdate.Builder}
         * avoiding the need to create one manually via {@link RestoreTestingSelectionForUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RestoreTestingSelectionForUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #restoreTestingSelection(RestoreTestingSelectionForUpdate)}.
         * 
         * @param restoreTestingSelection
         *        a consumer that will call methods on {@link RestoreTestingSelectionForUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreTestingSelection(RestoreTestingSelectionForUpdate)
         */
        default Builder restoreTestingSelection(Consumer<RestoreTestingSelectionForUpdate.Builder> restoreTestingSelection) {
            return restoreTestingSelection(RestoreTestingSelectionForUpdate.builder().applyMutation(restoreTestingSelection)
                    .build());
        }

        /**
         * <p>
         * This is the required restore testing selection name of the restore testing selection you wish to update.
         * </p>
         * 
         * @param restoreTestingSelectionName
         *        This is the required restore testing selection name of the restore testing selection you wish to
         *        update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingSelectionName(String restoreTestingSelectionName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String restoreTestingPlanName;

        private RestoreTestingSelectionForUpdate restoreTestingSelection;

        private String restoreTestingSelectionName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRestoreTestingSelectionRequest model) {
            super(model);
            restoreTestingPlanName(model.restoreTestingPlanName);
            restoreTestingSelection(model.restoreTestingSelection);
            restoreTestingSelectionName(model.restoreTestingSelectionName);
        }

        public final String getRestoreTestingPlanName() {
            return restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        public final RestoreTestingSelectionForUpdate.Builder getRestoreTestingSelection() {
            return restoreTestingSelection != null ? restoreTestingSelection.toBuilder() : null;
        }

        public final void setRestoreTestingSelection(RestoreTestingSelectionForUpdate.BuilderImpl restoreTestingSelection) {
            this.restoreTestingSelection = restoreTestingSelection != null ? restoreTestingSelection.build() : null;
        }

        @Override
        public final Builder restoreTestingSelection(RestoreTestingSelectionForUpdate restoreTestingSelection) {
            this.restoreTestingSelection = restoreTestingSelection;
            return this;
        }

        public final String getRestoreTestingSelectionName() {
            return restoreTestingSelectionName;
        }

        public final void setRestoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
        }

        @Override
        public final Builder restoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRestoreTestingSelectionRequest build() {
            return new UpdateRestoreTestingSelectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
