/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecoveryPointRestoreMetadataResponse extends BackupResponse implements
        ToCopyableBuilder<GetRecoveryPointRestoreMetadataResponse.Builder, GetRecoveryPointRestoreMetadataResponse> {
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultArn").getter(getter(GetRecoveryPointRestoreMetadataResponse::backupVaultArn))
            .setter(setter(Builder::backupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()).build();

    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(GetRecoveryPointRestoreMetadataResponse::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<Map<String, String>> RESTORE_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("RestoreMetadata")
            .getter(getter(GetRecoveryPointRestoreMetadataResponse::restoreMetadata))
            .setter(setter(Builder::restoreMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(GetRecoveryPointRestoreMetadataResponse::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_ARN_FIELD,
            RECOVERY_POINT_ARN_FIELD, RESTORE_METADATA_FIELD, RESOURCE_TYPE_FIELD));

    private final String backupVaultArn;

    private final String recoveryPointArn;

    private final Map<String, String> restoreMetadata;

    private final String resourceType;

    private GetRecoveryPointRestoreMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.backupVaultArn = builder.backupVaultArn;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.restoreMetadata = builder.restoreMetadata;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a backup vault; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies a backup vault; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     */
    public final String backupVaultArn() {
        return backupVaultArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies a recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the RestoreMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRestoreMetadata() {
        return restoreMetadata != null && !(restoreMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The set of metadata key-value pairs that describe the original configuration of the backed-up resource. These
     * values vary depending on the service that is being restored.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestoreMetadata} method.
     * </p>
     * 
     * @return The set of metadata key-value pairs that describe the original configuration of the backed-up resource.
     *         These values vary depending on the service that is being restored.
     */
    public final Map<String, String> restoreMetadata() {
        return restoreMetadata;
    }

    /**
     * <p>
     * This is the resource type associated with the recovery point.
     * </p>
     * 
     * @return This is the resource type associated with the recovery point.
     */
    public final String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRestoreMetadata() ? restoreMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecoveryPointRestoreMetadataResponse)) {
            return false;
        }
        GetRecoveryPointRestoreMetadataResponse other = (GetRecoveryPointRestoreMetadataResponse) obj;
        return Objects.equals(backupVaultArn(), other.backupVaultArn())
                && Objects.equals(recoveryPointArn(), other.recoveryPointArn())
                && hasRestoreMetadata() == other.hasRestoreMetadata()
                && Objects.equals(restoreMetadata(), other.restoreMetadata())
                && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecoveryPointRestoreMetadataResponse").add("BackupVaultArn", backupVaultArn())
                .add("RecoveryPointArn", recoveryPointArn())
                .add("RestoreMetadata", restoreMetadata() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ResourceType", resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultArn":
            return Optional.ofNullable(clazz.cast(backupVaultArn()));
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "RestoreMetadata":
            return Optional.ofNullable(clazz.cast(restoreMetadata()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecoveryPointRestoreMetadataResponse, T> g) {
        return obj -> g.apply((GetRecoveryPointRestoreMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecoveryPointRestoreMetadataResponse> {
        /**
         * <p>
         * An ARN that uniquely identifies a backup vault; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
         * </p>
         * 
         * @param backupVaultArn
         *        An ARN that uniquely identifies a backup vault; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultArn(String backupVaultArn);

        /**
         * <p>
         * An ARN that uniquely identifies a recovery point; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param recoveryPointArn
         *        An ARN that uniquely identifies a recovery point; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * The set of metadata key-value pairs that describe the original configuration of the backed-up resource. These
         * values vary depending on the service that is being restored.
         * </p>
         * 
         * @param restoreMetadata
         *        The set of metadata key-value pairs that describe the original configuration of the backed-up
         *        resource. These values vary depending on the service that is being restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreMetadata(Map<String, String> restoreMetadata);

        /**
         * <p>
         * This is the resource type associated with the recovery point.
         * </p>
         * 
         * @param resourceType
         *        This is the resource type associated with the recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String backupVaultArn;

        private String recoveryPointArn;

        private Map<String, String> restoreMetadata = DefaultSdkAutoConstructMap.getInstance();

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecoveryPointRestoreMetadataResponse model) {
            super(model);
            backupVaultArn(model.backupVaultArn);
            recoveryPointArn(model.recoveryPointArn);
            restoreMetadata(model.restoreMetadata);
            resourceType(model.resourceType);
        }

        public final String getBackupVaultArn() {
            return backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final Map<String, String> getRestoreMetadata() {
            if (restoreMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return restoreMetadata;
        }

        public final void setRestoreMetadata(Map<String, String> restoreMetadata) {
            this.restoreMetadata = MetadataCopier.copy(restoreMetadata);
        }

        @Override
        public final Builder restoreMetadata(Map<String, String> restoreMetadata) {
            this.restoreMetadata = MetadataCopier.copy(restoreMetadata);
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public GetRecoveryPointRestoreMetadataResponse build() {
            return new GetRecoveryPointRestoreMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
