/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the restore testing plan that Backup used to initiate the restore job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreJobCreator implements SdkPojo, Serializable,
        ToCopyableBuilder<RestoreJobCreator.Builder, RestoreJobCreator> {
    private static final SdkField<String> RESTORE_TESTING_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanArn").getter(getter(RestoreJobCreator::restoreTestingPlanArn))
            .setter(setter(Builder::restoreTestingPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESTORE_TESTING_PLAN_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String restoreTestingPlanArn;

    private RestoreJobCreator(BuilderImpl builder) {
        this.restoreTestingPlanArn = builder.restoreTestingPlanArn;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.
     */
    public final String restoreTestingPlanArn() {
        return restoreTestingPlanArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreJobCreator)) {
            return false;
        }
        RestoreJobCreator other = (RestoreJobCreator) obj;
        return Objects.equals(restoreTestingPlanArn(), other.restoreTestingPlanArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreJobCreator").add("RestoreTestingPlanArn", restoreTestingPlanArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestoreTestingPlanArn":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreJobCreator, T> g) {
        return obj -> g.apply((RestoreJobCreator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestoreJobCreator> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.
         * </p>
         * 
         * @param restoreTestingPlanArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanArn(String restoreTestingPlanArn);
    }

    static final class BuilderImpl implements Builder {
        private String restoreTestingPlanArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreJobCreator model) {
            restoreTestingPlanArn(model.restoreTestingPlanArn);
        }

        public final String getRestoreTestingPlanArn() {
            return restoreTestingPlanArn;
        }

        public final void setRestoreTestingPlanArn(String restoreTestingPlanArn) {
            this.restoreTestingPlanArn = restoreTestingPlanArn;
        }

        @Override
        public final Builder restoreTestingPlanArn(String restoreTestingPlanArn) {
            this.restoreTestingPlanArn = restoreTestingPlanArn;
            return this;
        }

        @Override
        public RestoreJobCreator build() {
            return new RestoreJobCreator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
