/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLogicallyAirGappedBackupVaultResponse extends BackupResponse implements
        ToCopyableBuilder<CreateLogicallyAirGappedBackupVaultResponse.Builder, CreateLogicallyAirGappedBackupVaultResponse> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(CreateLogicallyAirGappedBackupVaultResponse::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultArn").getter(getter(CreateLogicallyAirGappedBackupVaultResponse::backupVaultArn))
            .setter(setter(Builder::backupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(CreateLogicallyAirGappedBackupVaultResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> VAULT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VaultState").getter(getter(CreateLogicallyAirGappedBackupVaultResponse::vaultStateAsString))
            .setter(setter(Builder::vaultState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD,
            BACKUP_VAULT_ARN_FIELD, CREATION_DATE_FIELD, VAULT_STATE_FIELD));

    private final String backupVaultName;

    private final String backupVaultArn;

    private final Instant creationDate;

    private final String vaultState;

    private CreateLogicallyAirGappedBackupVaultResponse(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultArn = builder.backupVaultArn;
        this.creationDate = builder.creationDate;
        this.vaultState = builder.vaultState;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Logically air-gapped backup vaults are identified by
     * names that are unique to the account used to create them and the Region where they are created. They consist of
     * lowercase letters, numbers, and hyphens.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Logically air-gapped backup vaults are
     *         identified by names that are unique to the account used to create them and the Region where they are
     *         created. They consist of lowercase letters, numbers, and hyphens.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * This is the ARN (Amazon Resource Name) of the vault being created.
     * </p>
     * 
     * @return This is the ARN (Amazon Resource Name) of the vault being created.
     */
    public final String backupVaultArn() {
        return backupVaultArn;
    }

    /**
     * <p>
     * The date and time when the vault was created.
     * </p>
     * <p>
     * This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example, the
     * value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time when the vault was created.</p>
     *         <p>
     *         This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
     *         example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * This is the current state of the vault.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vaultState} will
     * return {@link VaultState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vaultStateAsString}.
     * </p>
     * 
     * @return This is the current state of the vault.
     * @see VaultState
     */
    public final VaultState vaultState() {
        return VaultState.fromValue(vaultState);
    }

    /**
     * <p>
     * This is the current state of the vault.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vaultState} will
     * return {@link VaultState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vaultStateAsString}.
     * </p>
     * 
     * @return This is the current state of the vault.
     * @see VaultState
     */
    public final String vaultStateAsString() {
        return vaultState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(vaultStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLogicallyAirGappedBackupVaultResponse)) {
            return false;
        }
        CreateLogicallyAirGappedBackupVaultResponse other = (CreateLogicallyAirGappedBackupVaultResponse) obj;
        return Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(backupVaultArn(), other.backupVaultArn())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(vaultStateAsString(), other.vaultStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLogicallyAirGappedBackupVaultResponse").add("BackupVaultName", backupVaultName())
                .add("BackupVaultArn", backupVaultArn()).add("CreationDate", creationDate())
                .add("VaultState", vaultStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "BackupVaultArn":
            return Optional.ofNullable(clazz.cast(backupVaultArn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "VaultState":
            return Optional.ofNullable(clazz.cast(vaultStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLogicallyAirGappedBackupVaultResponse, T> g) {
        return obj -> g.apply((CreateLogicallyAirGappedBackupVaultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLogicallyAirGappedBackupVaultResponse> {
        /**
         * <p>
         * The name of a logical container where backups are stored. Logically air-gapped backup vaults are identified
         * by names that are unique to the account used to create them and the Region where they are created. They
         * consist of lowercase letters, numbers, and hyphens.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Logically air-gapped backup vaults are
         *        identified by names that are unique to the account used to create them and the Region where they are
         *        created. They consist of lowercase letters, numbers, and hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * This is the ARN (Amazon Resource Name) of the vault being created.
         * </p>
         * 
         * @param backupVaultArn
         *        This is the ARN (Amazon Resource Name) of the vault being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultArn(String backupVaultArn);

        /**
         * <p>
         * The date and time when the vault was created.
         * </p>
         * <p>
         * This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For example,
         * the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationDate
         *        The date and time when the vault was created.</p>
         *        <p>
         *        This value is in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
         *        example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * This is the current state of the vault.
         * </p>
         * 
         * @param vaultState
         *        This is the current state of the vault.
         * @see VaultState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VaultState
         */
        Builder vaultState(String vaultState);

        /**
         * <p>
         * This is the current state of the vault.
         * </p>
         * 
         * @param vaultState
         *        This is the current state of the vault.
         * @see VaultState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VaultState
         */
        Builder vaultState(VaultState vaultState);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String backupVaultName;

        private String backupVaultArn;

        private Instant creationDate;

        private String vaultState;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLogicallyAirGappedBackupVaultResponse model) {
            super(model);
            backupVaultName(model.backupVaultName);
            backupVaultArn(model.backupVaultArn);
            creationDate(model.creationDate);
            vaultState(model.vaultState);
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getBackupVaultArn() {
            return backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getVaultState() {
            return vaultState;
        }

        public final void setVaultState(String vaultState) {
            this.vaultState = vaultState;
        }

        @Override
        public final Builder vaultState(String vaultState) {
            this.vaultState = vaultState;
            return this;
        }

        @Override
        public final Builder vaultState(VaultState vaultState) {
            this.vaultState(vaultState == null ? null : vaultState.toString());
            return this;
        }

        @Override
        public CreateLogicallyAirGappedBackupVaultResponse build() {
            return new CreateLogicallyAirGappedBackupVaultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
