/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFrameworkResponse extends BackupResponse implements
        ToCopyableBuilder<DescribeFrameworkResponse.Builder, DescribeFrameworkResponse> {
    private static final SdkField<String> FRAMEWORK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkName").getter(getter(DescribeFrameworkResponse::frameworkName))
            .setter(setter(Builder::frameworkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkName").build()).build();

    private static final SdkField<String> FRAMEWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkArn").getter(getter(DescribeFrameworkResponse::frameworkArn))
            .setter(setter(Builder::frameworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkArn").build()).build();

    private static final SdkField<String> FRAMEWORK_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkDescription").getter(getter(DescribeFrameworkResponse::frameworkDescription))
            .setter(setter(Builder::frameworkDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkDescription").build())
            .build();

    private static final SdkField<List<FrameworkControl>> FRAMEWORK_CONTROLS_FIELD = SdkField
            .<List<FrameworkControl>> builder(MarshallingType.LIST)
            .memberName("FrameworkControls")
            .getter(getter(DescribeFrameworkResponse::frameworkControls))
            .setter(setter(Builder::frameworkControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkControls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FrameworkControl> builder(MarshallingType.SDK_POJO)
                                            .constructor(FrameworkControl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeFrameworkResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentStatus").getter(getter(DescribeFrameworkResponse::deploymentStatus))
            .setter(setter(Builder::deploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()).build();

    private static final SdkField<String> FRAMEWORK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkStatus").getter(getter(DescribeFrameworkResponse::frameworkStatus))
            .setter(setter(Builder::frameworkStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkStatus").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken").getter(getter(DescribeFrameworkResponse::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_NAME_FIELD,
            FRAMEWORK_ARN_FIELD, FRAMEWORK_DESCRIPTION_FIELD, FRAMEWORK_CONTROLS_FIELD, CREATION_TIME_FIELD,
            DEPLOYMENT_STATUS_FIELD, FRAMEWORK_STATUS_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private final String frameworkName;

    private final String frameworkArn;

    private final String frameworkDescription;

    private final List<FrameworkControl> frameworkControls;

    private final Instant creationTime;

    private final String deploymentStatus;

    private final String frameworkStatus;

    private final String idempotencyToken;

    private DescribeFrameworkResponse(BuilderImpl builder) {
        super(builder);
        this.frameworkName = builder.frameworkName;
        this.frameworkArn = builder.frameworkArn;
        this.frameworkDescription = builder.frameworkDescription;
        this.frameworkControls = builder.frameworkControls;
        this.creationTime = builder.creationTime;
        this.deploymentStatus = builder.deploymentStatus;
        this.frameworkStatus = builder.frameworkStatus;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The unique name of a framework.
     * </p>
     * 
     * @return The unique name of a framework.
     */
    public final String frameworkName() {
        return frameworkName;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource
     * type.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
     *         resource type.
     */
    public final String frameworkArn() {
        return frameworkArn;
    }

    /**
     * <p>
     * An optional description of the framework.
     * </p>
     * 
     * @return An optional description of the framework.
     */
    public final String frameworkDescription() {
        return frameworkDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the FrameworkControls property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFrameworkControls() {
        return frameworkControls != null && !(frameworkControls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the controls that make up the framework. Each control in the list has a name, input parameters, and
     * scope.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFrameworkControls} method.
     * </p>
     * 
     * @return A list of the controls that make up the framework. Each control in the list has a name, input parameters,
     *         and scope.
     */
    public final List<FrameworkControl> frameworkControls() {
        return frameworkControls;
    }

    /**
     * <p>
     * The date and time that a framework is created, in ISO 8601 representation. The value of <code>CreationTime</code>
     * is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00 represents the 10th of July 2020 at 3:00
     * PM 8 hours behind UTC.
     * </p>
     * 
     * @return The date and time that a framework is created, in ISO 8601 representation. The value of
     *         <code>CreationTime</code> is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00
     *         represents the 10th of July 2020 at 3:00 PM 8 hours behind UTC.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The deployment status of a framework. The statuses are:
     * </p>
     * <p>
     * <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code>
     * </p>
     * 
     * @return The deployment status of a framework. The statuses are:</p>
     *         <p>
     *         <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code>
     */
    public final String deploymentStatus() {
        return deploymentStatus;
    }

    /**
     * <p>
     * A framework consists of one or more controls. Each control governs a resource, such as backup plans, backup
     * selections, backup vaults, or recovery points. You can also turn Config recording on or off for each resource.
     * The statuses are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> when recording is turned on for all resources governed by the framework.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PARTIALLY_ACTIVE</code> when recording is turned off for at least one resource governed by the framework.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INACTIVE</code> when recording is turned off for all resources governed by the framework.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNAVAILABLE</code> when Backup is unable to validate recording status at this time.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A framework consists of one or more controls. Each control governs a resource, such as backup plans,
     *         backup selections, backup vaults, or recovery points. You can also turn Config recording on or off for
     *         each resource. The statuses are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> when recording is turned on for all resources governed by the framework.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PARTIALLY_ACTIVE</code> when recording is turned off for at least one resource governed by the
     *         framework.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INACTIVE</code> when recording is turned off for all resources governed by the framework.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNAVAILABLE</code> when Backup is unable to validate recording status at this time.
     *         </p>
     *         </li>
     */
    public final String frameworkStatus() {
        return frameworkStatus;
    }

    /**
     * <p>
     * A customer-chosen string that you can use to distinguish between otherwise identical calls to
     * <code>DescribeFrameworkOutput</code>. Retrying a successful request with the same idempotency token results in a
     * success message with no action taken.
     * </p>
     * 
     * @return A customer-chosen string that you can use to distinguish between otherwise identical calls to
     *         <code>DescribeFrameworkOutput</code>. Retrying a successful request with the same idempotency token
     *         results in a success message with no action taken.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(frameworkName());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasFrameworkControls() ? frameworkControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkStatus());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFrameworkResponse)) {
            return false;
        }
        DescribeFrameworkResponse other = (DescribeFrameworkResponse) obj;
        return Objects.equals(frameworkName(), other.frameworkName()) && Objects.equals(frameworkArn(), other.frameworkArn())
                && Objects.equals(frameworkDescription(), other.frameworkDescription())
                && hasFrameworkControls() == other.hasFrameworkControls()
                && Objects.equals(frameworkControls(), other.frameworkControls())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(deploymentStatus(), other.deploymentStatus())
                && Objects.equals(frameworkStatus(), other.frameworkStatus())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFrameworkResponse").add("FrameworkName", frameworkName())
                .add("FrameworkArn", frameworkArn()).add("FrameworkDescription", frameworkDescription())
                .add("FrameworkControls", hasFrameworkControls() ? frameworkControls() : null)
                .add("CreationTime", creationTime()).add("DeploymentStatus", deploymentStatus())
                .add("FrameworkStatus", frameworkStatus()).add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FrameworkName":
            return Optional.ofNullable(clazz.cast(frameworkName()));
        case "FrameworkArn":
            return Optional.ofNullable(clazz.cast(frameworkArn()));
        case "FrameworkDescription":
            return Optional.ofNullable(clazz.cast(frameworkDescription()));
        case "FrameworkControls":
            return Optional.ofNullable(clazz.cast(frameworkControls()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "DeploymentStatus":
            return Optional.ofNullable(clazz.cast(deploymentStatus()));
        case "FrameworkStatus":
            return Optional.ofNullable(clazz.cast(frameworkStatus()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFrameworkResponse, T> g) {
        return obj -> g.apply((DescribeFrameworkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFrameworkResponse> {
        /**
         * <p>
         * The unique name of a framework.
         * </p>
         * 
         * @param frameworkName
         *        The unique name of a framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkName(String frameworkName);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
         * resource type.
         * </p>
         * 
         * @param frameworkArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on
         *        the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkArn(String frameworkArn);

        /**
         * <p>
         * An optional description of the framework.
         * </p>
         * 
         * @param frameworkDescription
         *        An optional description of the framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkDescription(String frameworkDescription);

        /**
         * <p>
         * A list of the controls that make up the framework. Each control in the list has a name, input parameters, and
         * scope.
         * </p>
         * 
         * @param frameworkControls
         *        A list of the controls that make up the framework. Each control in the list has a name, input
         *        parameters, and scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkControls(Collection<FrameworkControl> frameworkControls);

        /**
         * <p>
         * A list of the controls that make up the framework. Each control in the list has a name, input parameters, and
         * scope.
         * </p>
         * 
         * @param frameworkControls
         *        A list of the controls that make up the framework. Each control in the list has a name, input
         *        parameters, and scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkControls(FrameworkControl... frameworkControls);

        /**
         * <p>
         * A list of the controls that make up the framework. Each control in the list has a name, input parameters, and
         * scope.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.FrameworkControl.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.backup.model.FrameworkControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.FrameworkControl.Builder#build()} is called immediately
         * and its result is passed to {@link #frameworkControls(List<FrameworkControl>)}.
         * 
         * @param frameworkControls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.FrameworkControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameworkControls(java.util.Collection<FrameworkControl>)
         */
        Builder frameworkControls(Consumer<FrameworkControl.Builder>... frameworkControls);

        /**
         * <p>
         * The date and time that a framework is created, in ISO 8601 representation. The value of
         * <code>CreationTime</code> is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00 represents
         * the 10th of July 2020 at 3:00 PM 8 hours behind UTC.
         * </p>
         * 
         * @param creationTime
         *        The date and time that a framework is created, in ISO 8601 representation. The value of
         *        <code>CreationTime</code> is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00
         *        represents the 10th of July 2020 at 3:00 PM 8 hours behind UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The deployment status of a framework. The statuses are:
         * </p>
         * <p>
         * <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code>
         * </p>
         * 
         * @param deploymentStatus
         *        The deployment status of a framework. The statuses are:</p>
         *        <p>
         *        <code>CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * A framework consists of one or more controls. Each control governs a resource, such as backup plans, backup
         * selections, backup vaults, or recovery points. You can also turn Config recording on or off for each
         * resource. The statuses are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> when recording is turned on for all resources governed by the framework.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PARTIALLY_ACTIVE</code> when recording is turned off for at least one resource governed by the
         * framework.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INACTIVE</code> when recording is turned off for all resources governed by the framework.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNAVAILABLE</code> when Backup is unable to validate recording status at this time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param frameworkStatus
         *        A framework consists of one or more controls. Each control governs a resource, such as backup plans,
         *        backup selections, backup vaults, or recovery points. You can also turn Config recording on or off for
         *        each resource. The statuses are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> when recording is turned on for all resources governed by the framework.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PARTIALLY_ACTIVE</code> when recording is turned off for at least one resource governed by the
         *        framework.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INACTIVE</code> when recording is turned off for all resources governed by the framework.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNAVAILABLE</code> when Backup is unable to validate recording status at this time.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkStatus(String frameworkStatus);

        /**
         * <p>
         * A customer-chosen string that you can use to distinguish between otherwise identical calls to
         * <code>DescribeFrameworkOutput</code>. Retrying a successful request with the same idempotency token results
         * in a success message with no action taken.
         * </p>
         * 
         * @param idempotencyToken
         *        A customer-chosen string that you can use to distinguish between otherwise identical calls to
         *        <code>DescribeFrameworkOutput</code>. Retrying a successful request with the same idempotency token
         *        results in a success message with no action taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String frameworkName;

        private String frameworkArn;

        private String frameworkDescription;

        private List<FrameworkControl> frameworkControls = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private String deploymentStatus;

        private String frameworkStatus;

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFrameworkResponse model) {
            super(model);
            frameworkName(model.frameworkName);
            frameworkArn(model.frameworkArn);
            frameworkDescription(model.frameworkDescription);
            frameworkControls(model.frameworkControls);
            creationTime(model.creationTime);
            deploymentStatus(model.deploymentStatus);
            frameworkStatus(model.frameworkStatus);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getFrameworkName() {
            return frameworkName;
        }

        public final void setFrameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
        }

        @Override
        public final Builder frameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
            return this;
        }

        public final String getFrameworkArn() {
            return frameworkArn;
        }

        public final void setFrameworkArn(String frameworkArn) {
            this.frameworkArn = frameworkArn;
        }

        @Override
        public final Builder frameworkArn(String frameworkArn) {
            this.frameworkArn = frameworkArn;
            return this;
        }

        public final String getFrameworkDescription() {
            return frameworkDescription;
        }

        public final void setFrameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
        }

        @Override
        public final Builder frameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
            return this;
        }

        public final List<FrameworkControl.Builder> getFrameworkControls() {
            List<FrameworkControl.Builder> result = FrameworkControlsCopier.copyToBuilder(this.frameworkControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFrameworkControls(Collection<FrameworkControl.BuilderImpl> frameworkControls) {
            this.frameworkControls = FrameworkControlsCopier.copyFromBuilder(frameworkControls);
        }

        @Override
        public final Builder frameworkControls(Collection<FrameworkControl> frameworkControls) {
            this.frameworkControls = FrameworkControlsCopier.copy(frameworkControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworkControls(FrameworkControl... frameworkControls) {
            frameworkControls(Arrays.asList(frameworkControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworkControls(Consumer<FrameworkControl.Builder>... frameworkControls) {
            frameworkControls(Stream.of(frameworkControls).map(c -> FrameworkControl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        public final String getFrameworkStatus() {
            return frameworkStatus;
        }

        public final void setFrameworkStatus(String frameworkStatus) {
            this.frameworkStatus = frameworkStatus;
        }

        @Override
        public final Builder frameworkStatus(String frameworkStatus) {
            this.frameworkStatus = frameworkStatus;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public DescribeFrameworkResponse build() {
            return new DescribeFrameworkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
