/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCopyJobSummariesRequest extends BackupRequest implements
        ToCopyableBuilder<ListCopyJobSummariesRequest.Builder, ListCopyJobSummariesRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ListCopyJobSummariesRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AccountId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ListCopyJobSummariesRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("State").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ListCopyJobSummariesRequest::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ResourceType").build()).build();

    private static final SdkField<String> MESSAGE_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageCategory").getter(getter(ListCopyJobSummariesRequest::messageCategory))
            .setter(setter(Builder::messageCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MessageCategory").build())
            .build();

    private static final SdkField<String> AGGREGATION_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AggregationPeriod").getter(getter(ListCopyJobSummariesRequest::aggregationPeriodAsString))
            .setter(setter(Builder::aggregationPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AggregationPeriod").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListCopyJobSummariesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCopyJobSummariesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, STATE_FIELD,
            RESOURCE_TYPE_FIELD, MESSAGE_CATEGORY_FIELD, AGGREGATION_PERIOD_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String accountId;

    private final String state;

    private final String resourceType;

    private final String messageCategory;

    private final String aggregationPeriod;

    private final Integer maxResults;

    private final String nextToken;

    private ListCopyJobSummariesRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.state = builder.state;
        this.resourceType = builder.resourceType;
        this.messageCategory = builder.messageCategory;
        this.aggregationPeriod = builder.aggregationPeriod;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Returns the job count for the specified account.
     * </p>
     * <p>
     * If the request is sent from a member account or an account not part of Amazon Web Services Organizations, jobs
     * within requestor's account will be returned.
     * </p>
     * <p>
     * Root, admin, and delegated administrator accounts can use the value ANY to return job counts from every account
     * in the organization.
     * </p>
     * <p>
     * <code>AGGREGATE_ALL</code> aggregates job counts from all accounts within the authenticated organization, then
     * returns the sum.
     * </p>
     * 
     * @return Returns the job count for the specified account.</p>
     *         <p>
     *         If the request is sent from a member account or an account not part of Amazon Web Services Organizations,
     *         jobs within requestor's account will be returned.
     *         </p>
     *         <p>
     *         Root, admin, and delegated administrator accounts can use the value ANY to return job counts from every
     *         account in the organization.
     *         </p>
     *         <p>
     *         <code>AGGREGATE_ALL</code> aggregates job counts from all accounts within the authenticated organization,
     *         then returns the sum.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * This parameter returns the job count for jobs with the specified state.
     * </p>
     * <p>
     * The the value ANY returns count of all states.
     * </p>
     * <p>
     * <code>AGGREGATE_ALL</code> aggregates job counts for all states and returns the sum.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CopyJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return This parameter returns the job count for jobs with the specified state.</p>
     *         <p>
     *         The the value ANY returns count of all states.
     *         </p>
     *         <p>
     *         <code>AGGREGATE_ALL</code> aggregates job counts for all states and returns the sum.
     * @see CopyJobStatus
     */
    public final CopyJobStatus state() {
        return CopyJobStatus.fromValue(state);
    }

    /**
     * <p>
     * This parameter returns the job count for jobs with the specified state.
     * </p>
     * <p>
     * The the value ANY returns count of all states.
     * </p>
     * <p>
     * <code>AGGREGATE_ALL</code> aggregates job counts for all states and returns the sum.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CopyJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return This parameter returns the job count for jobs with the specified state.</p>
     *         <p>
     *         The the value ANY returns count of all states.
     *         </p>
     *         <p>
     *         <code>AGGREGATE_ALL</code> aggregates job counts for all states and returns the sum.
     * @see CopyJobStatus
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Returns the job count for the specified resource type. Use request <code>GetSupportedResourceTypes</code> to
     * obtain strings for supported resource types.
     * </p>
     * <p>
     * The the value ANY returns count of all resource types.
     * </p>
     * <p>
     * <code>AGGREGATE_ALL</code> aggregates job counts for all resource types and returns the sum.
     * </p>
     * <p>
     * The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon EBS)
     * volume or an Amazon Relational Database Service (Amazon RDS) database.
     * </p>
     * 
     * @return Returns the job count for the specified resource type. Use request <code>GetSupportedResourceTypes</code>
     *         to obtain strings for supported resource types.</p>
     *         <p>
     *         The the value ANY returns count of all resource types.
     *         </p>
     *         <p>
     *         <code>AGGREGATE_ALL</code> aggregates job counts for all resource types and returns the sum.
     *         </p>
     *         <p>
     *         The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store
     *         (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * This parameter returns the job count for the specified message category.
     * </p>
     * <p>
     * Example accepted strings include <code>AccessDenied</code>, <code>Success</code>, and
     * <code>InvalidParameters</code>. See <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a list of
     * accepted MessageCategory strings.
     * </p>
     * <p>
     * The the value ANY returns count of all message categories.
     * </p>
     * <p>
     * <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.
     * </p>
     * 
     * @return This parameter returns the job count for the specified message category.</p>
     *         <p>
     *         Example accepted strings include <code>AccessDenied</code>, <code>Success</code>, and
     *         <code>InvalidParameters</code>. See <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a list
     *         of accepted MessageCategory strings.
     *         </p>
     *         <p>
     *         The the value ANY returns count of all message categories.
     *         </p>
     *         <p>
     *         <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.
     */
    public final String messageCategory() {
        return messageCategory;
    }

    /**
     * <p>
     * This is the period that sets the boundaries for returned results.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ONE_DAY</code> for daily job count for the prior 14 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SEVEN_DAYS</code> for the aggregated job count for the prior 7 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FOURTEEN_DAYS</code> for aggregated job count for prior 14 days.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregationPeriod}
     * will return {@link AggregationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregationPeriodAsString}.
     * </p>
     * 
     * @return This is the period that sets the boundaries for returned results.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ONE_DAY</code> for daily job count for the prior 14 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SEVEN_DAYS</code> for the aggregated job count for the prior 7 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FOURTEEN_DAYS</code> for aggregated job count for prior 14 days.
     *         </p>
     *         </li>
     * @see AggregationPeriod
     */
    public final AggregationPeriod aggregationPeriod() {
        return AggregationPeriod.fromValue(aggregationPeriod);
    }

    /**
     * <p>
     * This is the period that sets the boundaries for returned results.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ONE_DAY</code> for daily job count for the prior 14 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SEVEN_DAYS</code> for the aggregated job count for the prior 7 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FOURTEEN_DAYS</code> for aggregated job count for prior 14 days.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregationPeriod}
     * will return {@link AggregationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregationPeriodAsString}.
     * </p>
     * 
     * @return This is the period that sets the boundaries for returned results.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ONE_DAY</code> for daily job count for the prior 14 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SEVEN_DAYS</code> for the aggregated job count for the prior 7 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FOURTEEN_DAYS</code> for aggregated job count for prior 14 days.
     *         </p>
     *         </li>
     * @see AggregationPeriod
     */
    public final String aggregationPeriodAsString() {
        return aggregationPeriod;
    }

    /**
     * <p>
     * This parameter sets the maximum number of items to be returned.
     * </p>
     * <p>
     * The value is an integer. Range of accepted values is from 1 to 500.
     * </p>
     * 
     * @return This parameter sets the maximum number of items to be returned.</p>
     *         <p>
     *         The value is an integer. Range of accepted values is from 1 to 500.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The next item following a partial list of returned resources. For example, if a request is made to return
     * <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned resources. For example, if a request is made to return
     *         <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in
     *         your list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(messageCategory());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCopyJobSummariesRequest)) {
            return false;
        }
        ListCopyJobSummariesRequest other = (ListCopyJobSummariesRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(messageCategory(), other.messageCategory())
                && Objects.equals(aggregationPeriodAsString(), other.aggregationPeriodAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCopyJobSummariesRequest").add("AccountId", accountId()).add("State", stateAsString())
                .add("ResourceType", resourceType()).add("MessageCategory", messageCategory())
                .add("AggregationPeriod", aggregationPeriodAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "MessageCategory":
            return Optional.ofNullable(clazz.cast(messageCategory()));
        case "AggregationPeriod":
            return Optional.ofNullable(clazz.cast(aggregationPeriodAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCopyJobSummariesRequest, T> g) {
        return obj -> g.apply((ListCopyJobSummariesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCopyJobSummariesRequest> {
        /**
         * <p>
         * Returns the job count for the specified account.
         * </p>
         * <p>
         * If the request is sent from a member account or an account not part of Amazon Web Services Organizations,
         * jobs within requestor's account will be returned.
         * </p>
         * <p>
         * Root, admin, and delegated administrator accounts can use the value ANY to return job counts from every
         * account in the organization.
         * </p>
         * <p>
         * <code>AGGREGATE_ALL</code> aggregates job counts from all accounts within the authenticated organization,
         * then returns the sum.
         * </p>
         * 
         * @param accountId
         *        Returns the job count for the specified account.</p>
         *        <p>
         *        If the request is sent from a member account or an account not part of Amazon Web Services
         *        Organizations, jobs within requestor's account will be returned.
         *        </p>
         *        <p>
         *        Root, admin, and delegated administrator accounts can use the value ANY to return job counts from
         *        every account in the organization.
         *        </p>
         *        <p>
         *        <code>AGGREGATE_ALL</code> aggregates job counts from all accounts within the authenticated
         *        organization, then returns the sum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * This parameter returns the job count for jobs with the specified state.
         * </p>
         * <p>
         * The the value ANY returns count of all states.
         * </p>
         * <p>
         * <code>AGGREGATE_ALL</code> aggregates job counts for all states and returns the sum.
         * </p>
         * 
         * @param state
         *        This parameter returns the job count for jobs with the specified state.</p>
         *        <p>
         *        The the value ANY returns count of all states.
         *        </p>
         *        <p>
         *        <code>AGGREGATE_ALL</code> aggregates job counts for all states and returns the sum.
         * @see CopyJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CopyJobStatus
         */
        Builder state(String state);

        /**
         * <p>
         * This parameter returns the job count for jobs with the specified state.
         * </p>
         * <p>
         * The the value ANY returns count of all states.
         * </p>
         * <p>
         * <code>AGGREGATE_ALL</code> aggregates job counts for all states and returns the sum.
         * </p>
         * 
         * @param state
         *        This parameter returns the job count for jobs with the specified state.</p>
         *        <p>
         *        The the value ANY returns count of all states.
         *        </p>
         *        <p>
         *        <code>AGGREGATE_ALL</code> aggregates job counts for all states and returns the sum.
         * @see CopyJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CopyJobStatus
         */
        Builder state(CopyJobStatus state);

        /**
         * <p>
         * Returns the job count for the specified resource type. Use request <code>GetSupportedResourceTypes</code> to
         * obtain strings for supported resource types.
         * </p>
         * <p>
         * The the value ANY returns count of all resource types.
         * </p>
         * <p>
         * <code>AGGREGATE_ALL</code> aggregates job counts for all resource types and returns the sum.
         * </p>
         * <p>
         * The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store (Amazon
         * EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
         * </p>
         * 
         * @param resourceType
         *        Returns the job count for the specified resource type. Use request
         *        <code>GetSupportedResourceTypes</code> to obtain strings for supported resource types.</p>
         *        <p>
         *        The the value ANY returns count of all resource types.
         *        </p>
         *        <p>
         *        <code>AGGREGATE_ALL</code> aggregates job counts for all resource types and returns the sum.
         *        </p>
         *        <p>
         *        The type of Amazon Web Services resource to be backed up; for example, an Amazon Elastic Block Store
         *        (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * This parameter returns the job count for the specified message category.
         * </p>
         * <p>
         * Example accepted strings include <code>AccessDenied</code>, <code>Success</code>, and
         * <code>InvalidParameters</code>. See <a
         * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a list of
         * accepted MessageCategory strings.
         * </p>
         * <p>
         * The the value ANY returns count of all message categories.
         * </p>
         * <p>
         * <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.
         * </p>
         * 
         * @param messageCategory
         *        This parameter returns the job count for the specified message category.</p>
         *        <p>
         *        Example accepted strings include <code>AccessDenied</code>, <code>Success</code>, and
         *        <code>InvalidParameters</code>. See <a
         *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a
         *        list of accepted MessageCategory strings.
         *        </p>
         *        <p>
         *        The the value ANY returns count of all message categories.
         *        </p>
         *        <p>
         *        <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageCategory(String messageCategory);

        /**
         * <p>
         * This is the period that sets the boundaries for returned results.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ONE_DAY</code> for daily job count for the prior 14 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SEVEN_DAYS</code> for the aggregated job count for the prior 7 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FOURTEEN_DAYS</code> for aggregated job count for prior 14 days.
         * </p>
         * </li>
         * </ul>
         * 
         * @param aggregationPeriod
         *        This is the period that sets the boundaries for returned results.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ONE_DAY</code> for daily job count for the prior 14 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SEVEN_DAYS</code> for the aggregated job count for the prior 7 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FOURTEEN_DAYS</code> for aggregated job count for prior 14 days.
         *        </p>
         *        </li>
         * @see AggregationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationPeriod
         */
        Builder aggregationPeriod(String aggregationPeriod);

        /**
         * <p>
         * This is the period that sets the boundaries for returned results.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ONE_DAY</code> for daily job count for the prior 14 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SEVEN_DAYS</code> for the aggregated job count for the prior 7 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FOURTEEN_DAYS</code> for aggregated job count for prior 14 days.
         * </p>
         * </li>
         * </ul>
         * 
         * @param aggregationPeriod
         *        This is the period that sets the boundaries for returned results.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ONE_DAY</code> for daily job count for the prior 14 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SEVEN_DAYS</code> for the aggregated job count for the prior 7 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FOURTEEN_DAYS</code> for aggregated job count for prior 14 days.
         *        </p>
         *        </li>
         * @see AggregationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationPeriod
         */
        Builder aggregationPeriod(AggregationPeriod aggregationPeriod);

        /**
         * <p>
         * This parameter sets the maximum number of items to be returned.
         * </p>
         * <p>
         * The value is an integer. Range of accepted values is from 1 to 500.
         * </p>
         * 
         * @param maxResults
         *        This parameter sets the maximum number of items to be returned.</p>
         *        <p>
         *        The value is an integer. Range of accepted values is from 1 to 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The next item following a partial list of returned resources. For example, if a request is made to return
         * <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your
         * list starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned resources. For example, if a request is made to
         *        return <code>MaxResults</code> number of resources, <code>NextToken</code> allows you to return more
         *        items in your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String accountId;

        private String state;

        private String resourceType;

        private String messageCategory;

        private String aggregationPeriod;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCopyJobSummariesRequest model) {
            super(model);
            accountId(model.accountId);
            state(model.state);
            resourceType(model.resourceType);
            messageCategory(model.messageCategory);
            aggregationPeriod(model.aggregationPeriod);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CopyJobStatus state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getMessageCategory() {
            return messageCategory;
        }

        public final void setMessageCategory(String messageCategory) {
            this.messageCategory = messageCategory;
        }

        @Override
        public final Builder messageCategory(String messageCategory) {
            this.messageCategory = messageCategory;
            return this;
        }

        public final String getAggregationPeriod() {
            return aggregationPeriod;
        }

        public final void setAggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        @Override
        public final Builder aggregationPeriod(AggregationPeriod aggregationPeriod) {
            this.aggregationPeriod(aggregationPeriod == null ? null : aggregationPeriod.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCopyJobSummariesRequest build() {
            return new ListCopyJobSummariesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
