/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRestoreTestingPlansResponse extends BackupResponse implements
        ToCopyableBuilder<ListRestoreTestingPlansResponse.Builder, ListRestoreTestingPlansResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRestoreTestingPlansResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<RestoreTestingPlanForList>> RESTORE_TESTING_PLANS_FIELD = SdkField
            .<List<RestoreTestingPlanForList>> builder(MarshallingType.LIST)
            .memberName("RestoreTestingPlans")
            .getter(getter(ListRestoreTestingPlansResponse::restoreTestingPlans))
            .setter(setter(Builder::restoreTestingPlans))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlans").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RestoreTestingPlanForList> builder(MarshallingType.SDK_POJO)
                                            .constructor(RestoreTestingPlanForList::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESTORE_TESTING_PLANS_FIELD));

    private final String nextToken;

    private final List<RestoreTestingPlanForList> restoreTestingPlans;

    private ListRestoreTestingPlansResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.restoreTestingPlans = builder.restoreTestingPlans;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the nexttoken.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the nexttoken.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RestoreTestingPlans property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRestoreTestingPlans() {
        return restoreTestingPlans != null && !(restoreTestingPlans instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This is a returned list of restore testing plans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestoreTestingPlans} method.
     * </p>
     * 
     * @return This is a returned list of restore testing plans.
     */
    public final List<RestoreTestingPlanForList> restoreTestingPlans() {
        return restoreTestingPlans;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRestoreTestingPlans() ? restoreTestingPlans() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRestoreTestingPlansResponse)) {
            return false;
        }
        ListRestoreTestingPlansResponse other = (ListRestoreTestingPlansResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasRestoreTestingPlans() == other.hasRestoreTestingPlans()
                && Objects.equals(restoreTestingPlans(), other.restoreTestingPlans());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRestoreTestingPlansResponse").add("NextToken", nextToken())
                .add("RestoreTestingPlans", hasRestoreTestingPlans() ? restoreTestingPlans() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RestoreTestingPlans":
            return Optional.ofNullable(clazz.cast(restoreTestingPlans()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRestoreTestingPlansResponse, T> g) {
        return obj -> g.apply((ListRestoreTestingPlansResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRestoreTestingPlansResponse> {
        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the nexttoken.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the nexttoken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * This is a returned list of restore testing plans.
         * </p>
         * 
         * @param restoreTestingPlans
         *        This is a returned list of restore testing plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlans(Collection<RestoreTestingPlanForList> restoreTestingPlans);

        /**
         * <p>
         * This is a returned list of restore testing plans.
         * </p>
         * 
         * @param restoreTestingPlans
         *        This is a returned list of restore testing plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlans(RestoreTestingPlanForList... restoreTestingPlans);

        /**
         * <p>
         * This is a returned list of restore testing plans.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.RestoreTestingPlanForList.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.backup.model.RestoreTestingPlanForList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.RestoreTestingPlanForList.Builder#build()} is called
         * immediately and its result is passed to {@link #restoreTestingPlans(List<RestoreTestingPlanForList>)}.
         * 
         * @param restoreTestingPlans
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.RestoreTestingPlanForList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreTestingPlans(java.util.Collection<RestoreTestingPlanForList>)
         */
        Builder restoreTestingPlans(Consumer<RestoreTestingPlanForList.Builder>... restoreTestingPlans);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RestoreTestingPlanForList> restoreTestingPlans = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRestoreTestingPlansResponse model) {
            super(model);
            nextToken(model.nextToken);
            restoreTestingPlans(model.restoreTestingPlans);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RestoreTestingPlanForList.Builder> getRestoreTestingPlans() {
            List<RestoreTestingPlanForList.Builder> result = RestoreTestingPlansCopier.copyToBuilder(this.restoreTestingPlans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRestoreTestingPlans(Collection<RestoreTestingPlanForList.BuilderImpl> restoreTestingPlans) {
            this.restoreTestingPlans = RestoreTestingPlansCopier.copyFromBuilder(restoreTestingPlans);
        }

        @Override
        public final Builder restoreTestingPlans(Collection<RestoreTestingPlanForList> restoreTestingPlans) {
            this.restoreTestingPlans = RestoreTestingPlansCopier.copy(restoreTestingPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreTestingPlans(RestoreTestingPlanForList... restoreTestingPlans) {
            restoreTestingPlans(Arrays.asList(restoreTestingPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreTestingPlans(Consumer<RestoreTestingPlanForList.Builder>... restoreTestingPlans) {
            restoreTestingPlans(Stream.of(restoreTestingPlans)
                    .map(c -> RestoreTestingPlanForList.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRestoreTestingPlansResponse build() {
            return new ListRestoreTestingPlansResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
