/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata about a restore job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreJobsListMember implements SdkPojo, Serializable,
        ToCopyableBuilder<RestoreJobsListMember.Builder, RestoreJobsListMember> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(RestoreJobsListMember::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> RESTORE_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreJobId").getter(getter(RestoreJobsListMember::restoreJobId)).setter(setter(Builder::restoreJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreJobId").build()).build();

    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(RestoreJobsListMember::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(RestoreJobsListMember::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionDate").getter(getter(RestoreJobsListMember::completionDate))
            .setter(setter(Builder::completionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RestoreJobsListMember::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(RestoreJobsListMember::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> PERCENT_DONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PercentDone").getter(getter(RestoreJobsListMember::percentDone)).setter(setter(Builder::percentDone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentDone").build()).build();

    private static final SdkField<Long> BACKUP_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BackupSizeInBytes").getter(getter(RestoreJobsListMember::backupSizeInBytes))
            .setter(setter(Builder::backupSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeInBytes").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(RestoreJobsListMember::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<Long> EXPECTED_COMPLETION_TIME_MINUTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ExpectedCompletionTimeMinutes")
            .getter(getter(RestoreJobsListMember::expectedCompletionTimeMinutes))
            .setter(setter(Builder::expectedCompletionTimeMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedCompletionTimeMinutes")
                    .build()).build();

    private static final SdkField<String> CREATED_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedResourceArn").getter(getter(RestoreJobsListMember::createdResourceArn))
            .setter(setter(Builder::createdResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedResourceArn").build())
            .build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(RestoreJobsListMember::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Instant> RECOVERY_POINT_CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("RecoveryPointCreationDate")
            .getter(getter(RestoreJobsListMember::recoveryPointCreationDate)).setter(setter(Builder::recoveryPointCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointCreationDate").build())
            .build();

    private static final SdkField<RestoreJobCreator> CREATED_BY_FIELD = SdkField
            .<RestoreJobCreator> builder(MarshallingType.SDK_POJO).memberName("CreatedBy")
            .getter(getter(RestoreJobsListMember::createdBy)).setter(setter(Builder::createdBy))
            .constructor(RestoreJobCreator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationStatus").getter(getter(RestoreJobsListMember::validationStatusAsString))
            .setter(setter(Builder::validationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatus").build()).build();

    private static final SdkField<String> VALIDATION_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationStatusMessage").getter(getter(RestoreJobsListMember::validationStatusMessage))
            .setter(setter(Builder::validationStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatusMessage").build())
            .build();

    private static final SdkField<String> DELETION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeletionStatus").getter(getter(RestoreJobsListMember::deletionStatusAsString))
            .setter(setter(Builder::deletionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionStatus").build()).build();

    private static final SdkField<String> DELETION_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeletionStatusMessage").getter(getter(RestoreJobsListMember::deletionStatusMessage))
            .setter(setter(Builder::deletionStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionStatusMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            RESTORE_JOB_ID_FIELD, RECOVERY_POINT_ARN_FIELD, CREATION_DATE_FIELD, COMPLETION_DATE_FIELD, STATUS_FIELD,
            STATUS_MESSAGE_FIELD, PERCENT_DONE_FIELD, BACKUP_SIZE_IN_BYTES_FIELD, IAM_ROLE_ARN_FIELD,
            EXPECTED_COMPLETION_TIME_MINUTES_FIELD, CREATED_RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD,
            RECOVERY_POINT_CREATION_DATE_FIELD, CREATED_BY_FIELD, VALIDATION_STATUS_FIELD, VALIDATION_STATUS_MESSAGE_FIELD,
            DELETION_STATUS_FIELD, DELETION_STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String restoreJobId;

    private final String recoveryPointArn;

    private final Instant creationDate;

    private final Instant completionDate;

    private final String status;

    private final String statusMessage;

    private final String percentDone;

    private final Long backupSizeInBytes;

    private final String iamRoleArn;

    private final Long expectedCompletionTimeMinutes;

    private final String createdResourceArn;

    private final String resourceType;

    private final Instant recoveryPointCreationDate;

    private final RestoreJobCreator createdBy;

    private final String validationStatus;

    private final String validationStatusMessage;

    private final String deletionStatus;

    private final String deletionStatusMessage;

    private RestoreJobsListMember(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.restoreJobId = builder.restoreJobId;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.percentDone = builder.percentDone;
        this.backupSizeInBytes = builder.backupSizeInBytes;
        this.iamRoleArn = builder.iamRoleArn;
        this.expectedCompletionTimeMinutes = builder.expectedCompletionTimeMinutes;
        this.createdResourceArn = builder.createdResourceArn;
        this.resourceType = builder.resourceType;
        this.recoveryPointCreationDate = builder.recoveryPointCreationDate;
        this.createdBy = builder.createdBy;
        this.validationStatus = builder.validationStatus;
        this.validationStatusMessage = builder.validationStatusMessage;
        this.deletionStatus = builder.deletionStatus;
        this.deletionStatusMessage = builder.deletionStatusMessage;
    }

    /**
     * <p>
     * The account ID that owns the restore job.
     * </p>
     * 
     * @return The account ID that owns the restore job.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Uniquely identifies the job that restores a recovery point.
     * </p>
     * 
     * @return Uniquely identifies the job that restores a recovery point.
     */
    public final String restoreJobId() {
        return restoreJobId;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies a recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * The date and time a restore job is created, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a restore job is created, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time
     * (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value
     * 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a job to restore a recovery point is completed, in Unix format and Coordinated
     *         Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example,
     *         the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant completionDate() {
        return completionDate;
    }

    /**
     * <p>
     * A status code specifying the state of the job initiated by Backup to restore a recovery point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RestoreJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status code specifying the state of the job initiated by Backup to restore a recovery point.
     * @see RestoreJobStatus
     */
    public final RestoreJobStatus status() {
        return RestoreJobStatus.fromValue(status);
    }

    /**
     * <p>
     * A status code specifying the state of the job initiated by Backup to restore a recovery point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RestoreJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status code specifying the state of the job initiated by Backup to restore a recovery point.
     * @see RestoreJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A detailed message explaining the status of the job to restore a recovery point.
     * </p>
     * 
     * @return A detailed message explaining the status of the job to restore a recovery point.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Contains an estimated percentage complete of a job at the time the job status was queried.
     * </p>
     * 
     * @return Contains an estimated percentage complete of a job at the time the job status was queried.
     */
    public final String percentDone() {
        return percentDone;
    }

    /**
     * <p>
     * The size, in bytes, of the restored resource.
     * </p>
     * 
     * @return The size, in bytes, of the restored resource.
     */
    public final Long backupSizeInBytes() {
        return backupSizeInBytes;
    }

    /**
     * <p>
     * Specifies the IAM role ARN used to create the target recovery point; for example,
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @return Specifies the IAM role ARN used to create the target recovery point; for example,
     *         <code>arn:aws:iam::123456789012:role/S3Access</code>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The amount of time in minutes that a job restoring a recovery point is expected to take.
     * </p>
     * 
     * @return The amount of time in minutes that a job restoring a recovery point is expected to take.
     */
    public final Long expectedCompletionTimeMinutes() {
        return expectedCompletionTimeMinutes;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource
     * type.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
     *         resource type.
     */
    public final String createdResourceArn() {
        return createdResourceArn;
    }

    /**
     * <p>
     * The resource type of the listed restore jobs; for example, an Amazon Elastic Block Store (Amazon EBS) volume or
     * an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS)
     * backups, the only supported resource type is Amazon EC2.
     * </p>
     * 
     * @return The resource type of the listed restore jobs; for example, an Amazon Elastic Block Store (Amazon EBS)
     *         volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy
     *         Service (VSS) backups, the only supported resource type is Amazon EC2.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The date on which a recovery point was created.
     * </p>
     * 
     * @return The date on which a recovery point was created.
     */
    public final Instant recoveryPointCreationDate() {
        return recoveryPointCreationDate;
    }

    /**
     * <p>
     * Contains identifying information about the creation of a restore job.
     * </p>
     * 
     * @return Contains identifying information about the creation of a restore job.
     */
    public final RestoreJobCreator createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * This is the status of validation run on the indicated restore job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link RestoreValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return This is the status of validation run on the indicated restore job.
     * @see RestoreValidationStatus
     */
    public final RestoreValidationStatus validationStatus() {
        return RestoreValidationStatus.fromValue(validationStatus);
    }

    /**
     * <p>
     * This is the status of validation run on the indicated restore job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link RestoreValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return This is the status of validation run on the indicated restore job.
     * @see RestoreValidationStatus
     */
    public final String validationStatusAsString() {
        return validationStatus;
    }

    /**
     * <p>
     * This describes the status of validation run on the indicated restore job.
     * </p>
     * 
     * @return This describes the status of validation run on the indicated restore job.
     */
    public final String validationStatusMessage() {
        return validationStatusMessage;
    }

    /**
     * <p>
     * This notes the status of the data generated by the restore test. The status may be <code>Deleting</code>,
     * <code>Failed</code>, or <code>Successful</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deletionStatus}
     * will return {@link RestoreDeletionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deletionStatusAsString}.
     * </p>
     * 
     * @return This notes the status of the data generated by the restore test. The status may be <code>Deleting</code>,
     *         <code>Failed</code>, or <code>Successful</code>.
     * @see RestoreDeletionStatus
     */
    public final RestoreDeletionStatus deletionStatus() {
        return RestoreDeletionStatus.fromValue(deletionStatus);
    }

    /**
     * <p>
     * This notes the status of the data generated by the restore test. The status may be <code>Deleting</code>,
     * <code>Failed</code>, or <code>Successful</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deletionStatus}
     * will return {@link RestoreDeletionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deletionStatusAsString}.
     * </p>
     * 
     * @return This notes the status of the data generated by the restore test. The status may be <code>Deleting</code>,
     *         <code>Failed</code>, or <code>Successful</code>.
     * @see RestoreDeletionStatus
     */
    public final String deletionStatusAsString() {
        return deletionStatus;
    }

    /**
     * <p>
     * This describes the restore job deletion status.
     * </p>
     * 
     * @return This describes the restore job deletion status.
     */
    public final String deletionStatusMessage() {
        return deletionStatusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(restoreJobId());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(percentDone());
        hashCode = 31 * hashCode + Objects.hashCode(backupSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(expectedCompletionTimeMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(createdResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(validationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validationStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(deletionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deletionStatusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreJobsListMember)) {
            return false;
        }
        RestoreJobsListMember other = (RestoreJobsListMember) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(restoreJobId(), other.restoreJobId())
                && Objects.equals(recoveryPointArn(), other.recoveryPointArn())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(completionDate(), other.completionDate())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(percentDone(), other.percentDone())
                && Objects.equals(backupSizeInBytes(), other.backupSizeInBytes())
                && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(expectedCompletionTimeMinutes(), other.expectedCompletionTimeMinutes())
                && Objects.equals(createdResourceArn(), other.createdResourceArn())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(recoveryPointCreationDate(), other.recoveryPointCreationDate())
                && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(validationStatusAsString(), other.validationStatusAsString())
                && Objects.equals(validationStatusMessage(), other.validationStatusMessage())
                && Objects.equals(deletionStatusAsString(), other.deletionStatusAsString())
                && Objects.equals(deletionStatusMessage(), other.deletionStatusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreJobsListMember").add("AccountId", accountId()).add("RestoreJobId", restoreJobId())
                .add("RecoveryPointArn", recoveryPointArn()).add("CreationDate", creationDate())
                .add("CompletionDate", completionDate()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("PercentDone", percentDone()).add("BackupSizeInBytes", backupSizeInBytes()).add("IamRoleArn", iamRoleArn())
                .add("ExpectedCompletionTimeMinutes", expectedCompletionTimeMinutes())
                .add("CreatedResourceArn", createdResourceArn()).add("ResourceType", resourceType())
                .add("RecoveryPointCreationDate", recoveryPointCreationDate()).add("CreatedBy", createdBy())
                .add("ValidationStatus", validationStatusAsString()).add("ValidationStatusMessage", validationStatusMessage())
                .add("DeletionStatus", deletionStatusAsString()).add("DeletionStatusMessage", deletionStatusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "RestoreJobId":
            return Optional.ofNullable(clazz.cast(restoreJobId()));
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "CompletionDate":
            return Optional.ofNullable(clazz.cast(completionDate()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "PercentDone":
            return Optional.ofNullable(clazz.cast(percentDone()));
        case "BackupSizeInBytes":
            return Optional.ofNullable(clazz.cast(backupSizeInBytes()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "ExpectedCompletionTimeMinutes":
            return Optional.ofNullable(clazz.cast(expectedCompletionTimeMinutes()));
        case "CreatedResourceArn":
            return Optional.ofNullable(clazz.cast(createdResourceArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "RecoveryPointCreationDate":
            return Optional.ofNullable(clazz.cast(recoveryPointCreationDate()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "ValidationStatus":
            return Optional.ofNullable(clazz.cast(validationStatusAsString()));
        case "ValidationStatusMessage":
            return Optional.ofNullable(clazz.cast(validationStatusMessage()));
        case "DeletionStatus":
            return Optional.ofNullable(clazz.cast(deletionStatusAsString()));
        case "DeletionStatusMessage":
            return Optional.ofNullable(clazz.cast(deletionStatusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreJobsListMember, T> g) {
        return obj -> g.apply((RestoreJobsListMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestoreJobsListMember> {
        /**
         * <p>
         * The account ID that owns the restore job.
         * </p>
         * 
         * @param accountId
         *        The account ID that owns the restore job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Uniquely identifies the job that restores a recovery point.
         * </p>
         * 
         * @param restoreJobId
         *        Uniquely identifies the job that restores a recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreJobId(String restoreJobId);

        /**
         * <p>
         * An ARN that uniquely identifies a recovery point; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param recoveryPointArn
         *        An ARN that uniquely identifies a recovery point; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * The date and time a restore job is created, in Unix format and Coordinated Universal Time (UTC). The value of
         * <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationDate
         *        The date and time a restore job is created, in Unix format and Coordinated Universal Time (UTC). The
         *        value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         *        represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time a job to restore a recovery point is completed, in Unix format and Coordinated Universal
         * Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value
         * 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param completionDate
         *        The date and time a job to restore a recovery point is completed, in Unix format and Coordinated
         *        Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For
         *        example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionDate(Instant completionDate);

        /**
         * <p>
         * A status code specifying the state of the job initiated by Backup to restore a recovery point.
         * </p>
         * 
         * @param status
         *        A status code specifying the state of the job initiated by Backup to restore a recovery point.
         * @see RestoreJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestoreJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A status code specifying the state of the job initiated by Backup to restore a recovery point.
         * </p>
         * 
         * @param status
         *        A status code specifying the state of the job initiated by Backup to restore a recovery point.
         * @see RestoreJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestoreJobStatus
         */
        Builder status(RestoreJobStatus status);

        /**
         * <p>
         * A detailed message explaining the status of the job to restore a recovery point.
         * </p>
         * 
         * @param statusMessage
         *        A detailed message explaining the status of the job to restore a recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Contains an estimated percentage complete of a job at the time the job status was queried.
         * </p>
         * 
         * @param percentDone
         *        Contains an estimated percentage complete of a job at the time the job status was queried.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentDone(String percentDone);

        /**
         * <p>
         * The size, in bytes, of the restored resource.
         * </p>
         * 
         * @param backupSizeInBytes
         *        The size, in bytes, of the restored resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSizeInBytes(Long backupSizeInBytes);

        /**
         * <p>
         * Specifies the IAM role ARN used to create the target recovery point; for example,
         * <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * </p>
         * 
         * @param iamRoleArn
         *        Specifies the IAM role ARN used to create the target recovery point; for example,
         *        <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The amount of time in minutes that a job restoring a recovery point is expected to take.
         * </p>
         * 
         * @param expectedCompletionTimeMinutes
         *        The amount of time in minutes that a job restoring a recovery point is expected to take.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedCompletionTimeMinutes(Long expectedCompletionTimeMinutes);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
         * resource type.
         * </p>
         * 
         * @param createdResourceArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on
         *        the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdResourceArn(String createdResourceArn);

        /**
         * <p>
         * The resource type of the listed restore jobs; for example, an Amazon Elastic Block Store (Amazon EBS) volume
         * or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS)
         * backups, the only supported resource type is Amazon EC2.
         * </p>
         * 
         * @param resourceType
         *        The resource type of the listed restore jobs; for example, an Amazon Elastic Block Store (Amazon EBS)
         *        volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy
         *        Service (VSS) backups, the only supported resource type is Amazon EC2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The date on which a recovery point was created.
         * </p>
         * 
         * @param recoveryPointCreationDate
         *        The date on which a recovery point was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointCreationDate(Instant recoveryPointCreationDate);

        /**
         * <p>
         * Contains identifying information about the creation of a restore job.
         * </p>
         * 
         * @param createdBy
         *        Contains identifying information about the creation of a restore job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(RestoreJobCreator createdBy);

        /**
         * <p>
         * Contains identifying information about the creation of a restore job.
         * </p>
         * This is a convenience method that creates an instance of the {@link RestoreJobCreator.Builder} avoiding the
         * need to create one manually via {@link RestoreJobCreator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RestoreJobCreator.Builder#build()} is called immediately and its
         * result is passed to {@link #createdBy(RestoreJobCreator)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link RestoreJobCreator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(RestoreJobCreator)
         */
        default Builder createdBy(Consumer<RestoreJobCreator.Builder> createdBy) {
            return createdBy(RestoreJobCreator.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * This is the status of validation run on the indicated restore job.
         * </p>
         * 
         * @param validationStatus
         *        This is the status of validation run on the indicated restore job.
         * @see RestoreValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestoreValidationStatus
         */
        Builder validationStatus(String validationStatus);

        /**
         * <p>
         * This is the status of validation run on the indicated restore job.
         * </p>
         * 
         * @param validationStatus
         *        This is the status of validation run on the indicated restore job.
         * @see RestoreValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestoreValidationStatus
         */
        Builder validationStatus(RestoreValidationStatus validationStatus);

        /**
         * <p>
         * This describes the status of validation run on the indicated restore job.
         * </p>
         * 
         * @param validationStatusMessage
         *        This describes the status of validation run on the indicated restore job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationStatusMessage(String validationStatusMessage);

        /**
         * <p>
         * This notes the status of the data generated by the restore test. The status may be <code>Deleting</code>,
         * <code>Failed</code>, or <code>Successful</code>.
         * </p>
         * 
         * @param deletionStatus
         *        This notes the status of the data generated by the restore test. The status may be
         *        <code>Deleting</code>, <code>Failed</code>, or <code>Successful</code>.
         * @see RestoreDeletionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestoreDeletionStatus
         */
        Builder deletionStatus(String deletionStatus);

        /**
         * <p>
         * This notes the status of the data generated by the restore test. The status may be <code>Deleting</code>,
         * <code>Failed</code>, or <code>Successful</code>.
         * </p>
         * 
         * @param deletionStatus
         *        This notes the status of the data generated by the restore test. The status may be
         *        <code>Deleting</code>, <code>Failed</code>, or <code>Successful</code>.
         * @see RestoreDeletionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestoreDeletionStatus
         */
        Builder deletionStatus(RestoreDeletionStatus deletionStatus);

        /**
         * <p>
         * This describes the restore job deletion status.
         * </p>
         * 
         * @param deletionStatusMessage
         *        This describes the restore job deletion status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionStatusMessage(String deletionStatusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String restoreJobId;

        private String recoveryPointArn;

        private Instant creationDate;

        private Instant completionDate;

        private String status;

        private String statusMessage;

        private String percentDone;

        private Long backupSizeInBytes;

        private String iamRoleArn;

        private Long expectedCompletionTimeMinutes;

        private String createdResourceArn;

        private String resourceType;

        private Instant recoveryPointCreationDate;

        private RestoreJobCreator createdBy;

        private String validationStatus;

        private String validationStatusMessage;

        private String deletionStatus;

        private String deletionStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreJobsListMember model) {
            accountId(model.accountId);
            restoreJobId(model.restoreJobId);
            recoveryPointArn(model.recoveryPointArn);
            creationDate(model.creationDate);
            completionDate(model.completionDate);
            status(model.status);
            statusMessage(model.statusMessage);
            percentDone(model.percentDone);
            backupSizeInBytes(model.backupSizeInBytes);
            iamRoleArn(model.iamRoleArn);
            expectedCompletionTimeMinutes(model.expectedCompletionTimeMinutes);
            createdResourceArn(model.createdResourceArn);
            resourceType(model.resourceType);
            recoveryPointCreationDate(model.recoveryPointCreationDate);
            createdBy(model.createdBy);
            validationStatus(model.validationStatus);
            validationStatusMessage(model.validationStatusMessage);
            deletionStatus(model.deletionStatus);
            deletionStatusMessage(model.deletionStatusMessage);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRestoreJobId() {
            return restoreJobId;
        }

        public final void setRestoreJobId(String restoreJobId) {
            this.restoreJobId = restoreJobId;
        }

        @Override
        public final Builder restoreJobId(String restoreJobId) {
            this.restoreJobId = restoreJobId;
            return this;
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getCompletionDate() {
            return completionDate;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RestoreJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getPercentDone() {
            return percentDone;
        }

        public final void setPercentDone(String percentDone) {
            this.percentDone = percentDone;
        }

        @Override
        public final Builder percentDone(String percentDone) {
            this.percentDone = percentDone;
            return this;
        }

        public final Long getBackupSizeInBytes() {
            return backupSizeInBytes;
        }

        public final void setBackupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
        }

        @Override
        public final Builder backupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Long getExpectedCompletionTimeMinutes() {
            return expectedCompletionTimeMinutes;
        }

        public final void setExpectedCompletionTimeMinutes(Long expectedCompletionTimeMinutes) {
            this.expectedCompletionTimeMinutes = expectedCompletionTimeMinutes;
        }

        @Override
        public final Builder expectedCompletionTimeMinutes(Long expectedCompletionTimeMinutes) {
            this.expectedCompletionTimeMinutes = expectedCompletionTimeMinutes;
            return this;
        }

        public final String getCreatedResourceArn() {
            return createdResourceArn;
        }

        public final void setCreatedResourceArn(String createdResourceArn) {
            this.createdResourceArn = createdResourceArn;
        }

        @Override
        public final Builder createdResourceArn(String createdResourceArn) {
            this.createdResourceArn = createdResourceArn;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Instant getRecoveryPointCreationDate() {
            return recoveryPointCreationDate;
        }

        public final void setRecoveryPointCreationDate(Instant recoveryPointCreationDate) {
            this.recoveryPointCreationDate = recoveryPointCreationDate;
        }

        @Override
        public final Builder recoveryPointCreationDate(Instant recoveryPointCreationDate) {
            this.recoveryPointCreationDate = recoveryPointCreationDate;
            return this;
        }

        public final RestoreJobCreator.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(RestoreJobCreator.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(RestoreJobCreator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getValidationStatus() {
            return validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(RestoreValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        public final String getValidationStatusMessage() {
            return validationStatusMessage;
        }

        public final void setValidationStatusMessage(String validationStatusMessage) {
            this.validationStatusMessage = validationStatusMessage;
        }

        @Override
        public final Builder validationStatusMessage(String validationStatusMessage) {
            this.validationStatusMessage = validationStatusMessage;
            return this;
        }

        public final String getDeletionStatus() {
            return deletionStatus;
        }

        public final void setDeletionStatus(String deletionStatus) {
            this.deletionStatus = deletionStatus;
        }

        @Override
        public final Builder deletionStatus(String deletionStatus) {
            this.deletionStatus = deletionStatus;
            return this;
        }

        @Override
        public final Builder deletionStatus(RestoreDeletionStatus deletionStatus) {
            this.deletionStatus(deletionStatus == null ? null : deletionStatus.toString());
            return this;
        }

        public final String getDeletionStatusMessage() {
            return deletionStatusMessage;
        }

        public final void setDeletionStatusMessage(String deletionStatusMessage) {
            this.deletionStatusMessage = deletionStatusMessage;
        }

        @Override
        public final Builder deletionStatusMessage(String deletionStatusMessage) {
            this.deletionStatusMessage = deletionStatusMessage;
            return this;
        }

        @Override
        public RestoreJobsListMember build() {
            return new RestoreJobsListMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
