/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.backup.model.CancelLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.CancelLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.CreateBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.CreateBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.CreateBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.CreateFrameworkRequest;
import software.amazon.awssdk.services.backup.model.CreateFrameworkResponse;
import software.amazon.awssdk.services.backup.model.CreateLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.CreateLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.CreateReportPlanRequest;
import software.amazon.awssdk.services.backup.model.CreateReportPlanResponse;
import software.amazon.awssdk.services.backup.model.CreateRestoreTestingPlanRequest;
import software.amazon.awssdk.services.backup.model.CreateRestoreTestingPlanResponse;
import software.amazon.awssdk.services.backup.model.CreateRestoreTestingSelectionRequest;
import software.amazon.awssdk.services.backup.model.CreateRestoreTestingSelectionResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.DeleteFrameworkRequest;
import software.amazon.awssdk.services.backup.model.DeleteFrameworkResponse;
import software.amazon.awssdk.services.backup.model.DeleteRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DeleteRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.DeleteReportPlanRequest;
import software.amazon.awssdk.services.backup.model.DeleteReportPlanResponse;
import software.amazon.awssdk.services.backup.model.DeleteRestoreTestingPlanRequest;
import software.amazon.awssdk.services.backup.model.DeleteRestoreTestingPlanResponse;
import software.amazon.awssdk.services.backup.model.DeleteRestoreTestingSelectionRequest;
import software.amazon.awssdk.services.backup.model.DeleteRestoreTestingSelectionResponse;
import software.amazon.awssdk.services.backup.model.DescribeBackupJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse;
import software.amazon.awssdk.services.backup.model.DescribeBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.DescribeBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.DescribeCopyJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeCopyJobResponse;
import software.amazon.awssdk.services.backup.model.DescribeFrameworkRequest;
import software.amazon.awssdk.services.backup.model.DescribeFrameworkResponse;
import software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsRequest;
import software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsResponse;
import software.amazon.awssdk.services.backup.model.DescribeProtectedResourceRequest;
import software.amazon.awssdk.services.backup.model.DescribeProtectedResourceResponse;
import software.amazon.awssdk.services.backup.model.DescribeRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DescribeRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.DescribeRegionSettingsRequest;
import software.amazon.awssdk.services.backup.model.DescribeRegionSettingsResponse;
import software.amazon.awssdk.services.backup.model.DescribeReportJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeReportJobResponse;
import software.amazon.awssdk.services.backup.model.DescribeReportPlanRequest;
import software.amazon.awssdk.services.backup.model.DescribeReportPlanResponse;
import software.amazon.awssdk.services.backup.model.DescribeRestoreJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeRestoreJobResponse;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentRequest;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentResponse;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateRequest;
import software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.GetLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.GetLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataRequest;
import software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse;
import software.amazon.awssdk.services.backup.model.GetRestoreJobMetadataRequest;
import software.amazon.awssdk.services.backup.model.GetRestoreJobMetadataResponse;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingInferredMetadataRequest;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingInferredMetadataResponse;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingPlanRequest;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingPlanResponse;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingSelectionRequest;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingSelectionResponse;
import software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesRequest;
import software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesResponse;
import software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobSummariesResponse;
import software.amazon.awssdk.services.backup.model.ListBackupJobsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlansRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlansResponse;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse;
import software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListCopyJobSummariesResponse;
import software.amazon.awssdk.services.backup.model.ListCopyJobsRequest;
import software.amazon.awssdk.services.backup.model.ListCopyJobsResponse;
import software.amazon.awssdk.services.backup.model.ListFrameworksRequest;
import software.amazon.awssdk.services.backup.model.ListFrameworksResponse;
import software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest;
import software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse;
import software.amazon.awssdk.services.backup.model.ListReportJobsRequest;
import software.amazon.awssdk.services.backup.model.ListReportJobsResponse;
import software.amazon.awssdk.services.backup.model.ListReportPlansRequest;
import software.amazon.awssdk.services.backup.model.ListReportPlansResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsResponse;
import software.amazon.awssdk.services.backup.model.ListTagsRequest;
import software.amazon.awssdk.services.backup.model.ListTagsResponse;
import software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationResponse;
import software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.PutRestoreValidationResultRequest;
import software.amazon.awssdk.services.backup.model.PutRestoreValidationResultResponse;
import software.amazon.awssdk.services.backup.model.StartBackupJobRequest;
import software.amazon.awssdk.services.backup.model.StartBackupJobResponse;
import software.amazon.awssdk.services.backup.model.StartCopyJobRequest;
import software.amazon.awssdk.services.backup.model.StartCopyJobResponse;
import software.amazon.awssdk.services.backup.model.StartReportJobRequest;
import software.amazon.awssdk.services.backup.model.StartReportJobResponse;
import software.amazon.awssdk.services.backup.model.StartRestoreJobRequest;
import software.amazon.awssdk.services.backup.model.StartRestoreJobResponse;
import software.amazon.awssdk.services.backup.model.StopBackupJobRequest;
import software.amazon.awssdk.services.backup.model.StopBackupJobResponse;
import software.amazon.awssdk.services.backup.model.TagResourceRequest;
import software.amazon.awssdk.services.backup.model.TagResourceResponse;
import software.amazon.awssdk.services.backup.model.UntagResourceRequest;
import software.amazon.awssdk.services.backup.model.UntagResourceResponse;
import software.amazon.awssdk.services.backup.model.UpdateBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.UpdateBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.UpdateFrameworkRequest;
import software.amazon.awssdk.services.backup.model.UpdateFrameworkResponse;
import software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsRequest;
import software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsResponse;
import software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleRequest;
import software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleResponse;
import software.amazon.awssdk.services.backup.model.UpdateRegionSettingsRequest;
import software.amazon.awssdk.services.backup.model.UpdateRegionSettingsResponse;
import software.amazon.awssdk.services.backup.model.UpdateReportPlanRequest;
import software.amazon.awssdk.services.backup.model.UpdateReportPlanResponse;
import software.amazon.awssdk.services.backup.model.UpdateRestoreTestingPlanRequest;
import software.amazon.awssdk.services.backup.model.UpdateRestoreTestingPlanResponse;
import software.amazon.awssdk.services.backup.model.UpdateRestoreTestingSelectionRequest;
import software.amazon.awssdk.services.backup.model.UpdateRestoreTestingSelectionResponse;
import software.amazon.awssdk.services.backup.paginators.ListBackupJobSummariesPublisher;
import software.amazon.awssdk.services.backup.paginators.ListBackupJobsPublisher;
import software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesPublisher;
import software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsPublisher;
import software.amazon.awssdk.services.backup.paginators.ListBackupPlansPublisher;
import software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsPublisher;
import software.amazon.awssdk.services.backup.paginators.ListBackupVaultsPublisher;
import software.amazon.awssdk.services.backup.paginators.ListCopyJobSummariesPublisher;
import software.amazon.awssdk.services.backup.paginators.ListCopyJobsPublisher;
import software.amazon.awssdk.services.backup.paginators.ListFrameworksPublisher;
import software.amazon.awssdk.services.backup.paginators.ListLegalHoldsPublisher;
import software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesByBackupVaultPublisher;
import software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesPublisher;
import software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultPublisher;
import software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByLegalHoldPublisher;
import software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourcePublisher;
import software.amazon.awssdk.services.backup.paginators.ListReportJobsPublisher;
import software.amazon.awssdk.services.backup.paginators.ListReportPlansPublisher;
import software.amazon.awssdk.services.backup.paginators.ListRestoreJobSummariesPublisher;
import software.amazon.awssdk.services.backup.paginators.ListRestoreJobsByProtectedResourcePublisher;
import software.amazon.awssdk.services.backup.paginators.ListRestoreJobsPublisher;
import software.amazon.awssdk.services.backup.paginators.ListRestoreTestingPlansPublisher;
import software.amazon.awssdk.services.backup.paginators.ListRestoreTestingSelectionsPublisher;
import software.amazon.awssdk.services.backup.paginators.ListTagsPublisher;

/**
 * Service client for accessing AWS Backup asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>Backup</fullname>
 * <p>
 * Backup is a unified backup service designed to protect Amazon Web Services services and their associated data. Backup
 * simplifies the creation, migration, restoration, and deletion of backups, while also providing reporting and
 * auditing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BackupAsyncClient extends AwsClient {
    String SERVICE_NAME = "backup";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "backup";

    /**
     * <p>
     * This action removes the specified legal hold on a recovery point. This action can only be performed by a user
     * with sufficient permissions.
     * </p>
     *
     * @param cancelLegalHoldRequest
     * @return A Java Future containing the result of the CancelLegalHold operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidResourceStateException Backup is already performing an action on this recovery point. It can't
     *         perform the action you requested until the first action finishes. Try again later.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CancelLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CancelLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelLegalHoldResponse> cancelLegalHold(CancelLegalHoldRequest cancelLegalHoldRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action removes the specified legal hold on a recovery point. This action can only be performed by a user
     * with sufficient permissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelLegalHoldRequest.Builder} avoiding the need
     * to create one manually via {@link CancelLegalHoldRequest#builder()}
     * </p>
     *
     * @param cancelLegalHoldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CancelLegalHoldRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelLegalHold operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidResourceStateException Backup is already performing an action on this recovery point. It can't
     *         perform the action you requested until the first action finishes. Try again later.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CancelLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CancelLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelLegalHoldResponse> cancelLegalHold(
            Consumer<CancelLegalHoldRequest.Builder> cancelLegalHoldRequest) {
        return cancelLegalHold(CancelLegalHoldRequest.builder().applyMutation(cancelLegalHoldRequest).build());
    }

    /**
     * <p>
     * Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains
     * information that Backup uses to schedule tasks that create recovery points for resources.
     * </p>
     * <p>
     * If you call <code>CreateBackupPlan</code> with a plan that already exists, you receive an
     * <code>AlreadyExistsException</code> exception.
     * </p>
     *
     * @param createBackupPlanRequest
     * @return A Java Future containing the result of the CreateBackupPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBackupPlanResponse> createBackupPlan(CreateBackupPlanRequest createBackupPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains
     * information that Backup uses to schedule tasks that create recovery points for resources.
     * </p>
     * <p>
     * If you call <code>CreateBackupPlan</code> with a plan that already exists, you receive an
     * <code>AlreadyExistsException</code> exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackupPlanRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBackupPlanRequest#builder()}
     * </p>
     *
     * @param createBackupPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateBackupPlanRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateBackupPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBackupPlanResponse> createBackupPlan(
            Consumer<CreateBackupPlanRequest.Builder> createBackupPlanRequest) {
        return createBackupPlan(CreateBackupPlanRequest.builder().applyMutation(createBackupPlanRequest).build());
    }

    /**
     * <p>
     * Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json"
     * >Assigning resources programmatically</a>.
     * </p>
     *
     * @param createBackupSelectionRequest
     * @return A Java Future containing the result of the CreateBackupSelection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBackupSelectionResponse> createBackupSelection(
            CreateBackupSelectionRequest createBackupSelectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json"
     * >Assigning resources programmatically</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackupSelectionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBackupSelectionRequest#builder()}
     * </p>
     *
     * @param createBackupSelectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateBackupSelectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateBackupSelection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBackupSelectionResponse> createBackupSelection(
            Consumer<CreateBackupSelectionRequest.Builder> createBackupSelectionRequest) {
        return createBackupSelection(CreateBackupSelectionRequest.builder().applyMutation(createBackupSelectionRequest).build());
    }

    /**
     * <p>
     * Creates a logical container where backups are stored. A <code>CreateBackupVault</code> request includes a name,
     * optionally one or more resource tags, an encryption key, and a request ID.
     * </p>
     * <note>
     * <p>
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     * </p>
     * </note>
     *
     * @param createBackupVaultRequest
     * @return A Java Future containing the result of the CreateBackupVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBackupVaultResponse> createBackupVault(CreateBackupVaultRequest createBackupVaultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a logical container where backups are stored. A <code>CreateBackupVault</code> request includes a name,
     * optionally one or more resource tags, an encryption key, and a request ID.
     * </p>
     * <note>
     * <p>
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackupVaultRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBackupVaultRequest#builder()}
     * </p>
     *
     * @param createBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateBackupVaultRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateBackupVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBackupVaultResponse> createBackupVault(
            Consumer<CreateBackupVaultRequest.Builder> createBackupVaultRequest) {
        return createBackupVault(CreateBackupVaultRequest.builder().applyMutation(createBackupVaultRequest).build());
    }

    /**
     * <p>
     * Creates a framework with one or more controls. A framework is a collection of controls that you can use to
     * evaluate your backup practices. By using pre-built customizable controls to define your policies, you can
     * evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.
     * </p>
     *
     * @param createFrameworkRequest
     * @return A Java Future containing the result of the CreateFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFrameworkResponse> createFramework(CreateFrameworkRequest createFrameworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a framework with one or more controls. A framework is a collection of controls that you can use to
     * evaluate your backup practices. By using pre-built customizable controls to define your policies, you can
     * evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFrameworkRequest.Builder} avoiding the need
     * to create one manually via {@link CreateFrameworkRequest#builder()}
     * </p>
     *
     * @param createFrameworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateFrameworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFrameworkResponse> createFramework(
            Consumer<CreateFrameworkRequest.Builder> createFrameworkRequest) {
        return createFramework(CreateFrameworkRequest.builder().applyMutation(createFrameworkRequest).build());
    }

    /**
     * <p>
     * This action creates a legal hold on a recovery point (backup). A legal hold is a restraint on altering or
     * deleting a backup until an authorized user cancels the legal hold. Any actions to delete or disassociate a
     * recovery point will fail with an error if one or more active legal holds are on the recovery point.
     * </p>
     *
     * @param createLegalHoldRequest
     * @return A Java Future containing the result of the CreateLegalHold operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLegalHoldResponse> createLegalHold(CreateLegalHoldRequest createLegalHoldRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action creates a legal hold on a recovery point (backup). A legal hold is a restraint on altering or
     * deleting a backup until an authorized user cancels the legal hold. Any actions to delete or disassociate a
     * recovery point will fail with an error if one or more active legal holds are on the recovery point.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLegalHoldRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLegalHoldRequest#builder()}
     * </p>
     *
     * @param createLegalHoldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateLegalHoldRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateLegalHold operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLegalHoldResponse> createLegalHold(
            Consumer<CreateLegalHoldRequest.Builder> createLegalHoldRequest) {
        return createLegalHold(CreateLegalHoldRequest.builder().applyMutation(createLegalHoldRequest).build());
    }

    /**
     * <p>
     * This request creates a logical container to where backups may be copied.
     * </p>
     * <p>
     * This request includes a name, the Region, the maximum number of retention days, the minimum number of retention
     * days, and optionally can include tags and a creator request ID.
     * </p>
     * <note>
     * <p>
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     * </p>
     * </note>
     *
     * @param createLogicallyAirGappedBackupVaultRequest
     * @return A Java Future containing the result of the CreateLogicallyAirGappedBackupVault operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateLogicallyAirGappedBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLogicallyAirGappedBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLogicallyAirGappedBackupVaultResponse> createLogicallyAirGappedBackupVault(
            CreateLogicallyAirGappedBackupVaultRequest createLogicallyAirGappedBackupVaultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request creates a logical container to where backups may be copied.
     * </p>
     * <p>
     * This request includes a name, the Region, the maximum number of retention days, the minimum number of retention
     * days, and optionally can include tags and a creator request ID.
     * </p>
     * <note>
     * <p>
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLogicallyAirGappedBackupVaultRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLogicallyAirGappedBackupVaultRequest#builder()}
     * </p>
     *
     * @param createLogicallyAirGappedBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateLogicallyAirGappedBackupVault operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateLogicallyAirGappedBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLogicallyAirGappedBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLogicallyAirGappedBackupVaultResponse> createLogicallyAirGappedBackupVault(
            Consumer<CreateLogicallyAirGappedBackupVaultRequest.Builder> createLogicallyAirGappedBackupVaultRequest) {
        return createLogicallyAirGappedBackupVault(CreateLogicallyAirGappedBackupVaultRequest.builder()
                .applyMutation(createLogicallyAirGappedBackupVaultRequest).build());
    }

    /**
     * <p>
     * Creates a report plan. A report plan is a document that contains information about the contents of the report and
     * where Backup will deliver it.
     * </p>
     * <p>
     * If you call <code>CreateReportPlan</code> with a plan that already exists, you receive an
     * <code>AlreadyExistsException</code> exception.
     * </p>
     *
     * @param createReportPlanRequest
     * @return A Java Future containing the result of the CreateReportPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateReportPlanResponse> createReportPlan(CreateReportPlanRequest createReportPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a report plan. A report plan is a document that contains information about the contents of the report and
     * where Backup will deliver it.
     * </p>
     * <p>
     * If you call <code>CreateReportPlan</code> with a plan that already exists, you receive an
     * <code>AlreadyExistsException</code> exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReportPlanRequest.Builder} avoiding the need
     * to create one manually via {@link CreateReportPlanRequest#builder()}
     * </p>
     *
     * @param createReportPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateReportPlanRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateReportPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateReportPlanResponse> createReportPlan(
            Consumer<CreateReportPlanRequest.Builder> createReportPlanRequest) {
        return createReportPlan(CreateReportPlanRequest.builder().applyMutation(createReportPlanRequest).build());
    }

    /**
     * <p>
     * This is the first of two steps to create a restore testing plan; once this request is successful, finish the
     * procedure with request CreateRestoreTestingSelection.
     * </p>
     * <p>
     * You must include the parameter RestoreTestingPlan. You may optionally include CreatorRequestId and Tags.
     * </p>
     *
     * @param createRestoreTestingPlanRequest
     * @return A Java Future containing the result of the CreateRestoreTestingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateRestoreTestingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRestoreTestingPlanResponse> createRestoreTestingPlan(
            CreateRestoreTestingPlanRequest createRestoreTestingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is the first of two steps to create a restore testing plan; once this request is successful, finish the
     * procedure with request CreateRestoreTestingSelection.
     * </p>
     * <p>
     * You must include the parameter RestoreTestingPlan. You may optionally include CreatorRequestId and Tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRestoreTestingPlanRequest.Builder} avoiding
     * the need to create one manually via {@link CreateRestoreTestingPlanRequest#builder()}
     * </p>
     *
     * @param createRestoreTestingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateRestoreTestingPlanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRestoreTestingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateRestoreTestingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRestoreTestingPlanResponse> createRestoreTestingPlan(
            Consumer<CreateRestoreTestingPlanRequest.Builder> createRestoreTestingPlanRequest) {
        return createRestoreTestingPlan(CreateRestoreTestingPlanRequest.builder().applyMutation(createRestoreTestingPlanRequest)
                .build());
    }

    /**
     * <p>
     * This request can be sent after CreateRestoreTestingPlan request returns successfully. This is the second part of
     * creating a resource testing plan, and it must be completed sequentially.
     * </p>
     * <p>
     * This consists of <code>RestoreTestingSelectionName</code>, <code>ProtectedResourceType</code>, and one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ProtectedResourceArns</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ProtectedResourceConditions</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each protected resource type can have one single value.
     * </p>
     * <p>
     * A restore testing selection can include a wildcard value ("*") for <code>ProtectedResourceArns</code> along with
     * <code>ProtectedResourceConditions</code>. Alternatively, you can include up to 30 specific protected resource
     * ARNs in <code>ProtectedResourceArns</code>.
     * </p>
     * <p>
     * Cannot select by both protected resource types AND specific ARNs. Request will fail if both are included.
     * </p>
     *
     * @param createRestoreTestingSelectionRequest
     * @return A Java Future containing the result of the CreateRestoreTestingSelection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRestoreTestingSelectionResponse> createRestoreTestingSelection(
            CreateRestoreTestingSelectionRequest createRestoreTestingSelectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request can be sent after CreateRestoreTestingPlan request returns successfully. This is the second part of
     * creating a resource testing plan, and it must be completed sequentially.
     * </p>
     * <p>
     * This consists of <code>RestoreTestingSelectionName</code>, <code>ProtectedResourceType</code>, and one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ProtectedResourceArns</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ProtectedResourceConditions</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each protected resource type can have one single value.
     * </p>
     * <p>
     * A restore testing selection can include a wildcard value ("*") for <code>ProtectedResourceArns</code> along with
     * <code>ProtectedResourceConditions</code>. Alternatively, you can include up to 30 specific protected resource
     * ARNs in <code>ProtectedResourceArns</code>.
     * </p>
     * <p>
     * Cannot select by both protected resource types AND specific ARNs. Request will fail if both are included.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRestoreTestingSelectionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRestoreTestingSelectionRequest#builder()}
     * </p>
     *
     * @param createRestoreTestingSelectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.CreateRestoreTestingSelectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateRestoreTestingSelection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.CreateRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRestoreTestingSelectionResponse> createRestoreTestingSelection(
            Consumer<CreateRestoreTestingSelectionRequest.Builder> createRestoreTestingSelectionRequest) {
        return createRestoreTestingSelection(CreateRestoreTestingSelectionRequest.builder()
                .applyMutation(createRestoreTestingSelectionRequest).build());
    }

    /**
     * <p>
     * Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been
     * deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will
     * still exist.
     * </p>
     *
     * @param deleteBackupPlanRequest
     * @return A Java Future containing the result of the DeleteBackupPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBackupPlanResponse> deleteBackupPlan(DeleteBackupPlanRequest deleteBackupPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been
     * deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will
     * still exist.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupPlanRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBackupPlanRequest#builder()}
     * </p>
     *
     * @param deleteBackupPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteBackupPlanRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBackupPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBackupPlanResponse> deleteBackupPlan(
            Consumer<DeleteBackupPlanRequest.Builder> deleteBackupPlanRequest) {
        return deleteBackupPlan(DeleteBackupPlanRequest.builder().applyMutation(deleteBackupPlanRequest).build());
    }

    /**
     * <p>
     * Deletes the resource selection associated with a backup plan that is specified by the <code>SelectionId</code>.
     * </p>
     *
     * @param deleteBackupSelectionRequest
     * @return A Java Future containing the result of the DeleteBackupSelection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBackupSelectionResponse> deleteBackupSelection(
            DeleteBackupSelectionRequest deleteBackupSelectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource selection associated with a backup plan that is specified by the <code>SelectionId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupSelectionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBackupSelectionRequest#builder()}
     * </p>
     *
     * @param deleteBackupSelectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteBackupSelectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteBackupSelection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBackupSelectionResponse> deleteBackupSelection(
            Consumer<DeleteBackupSelectionRequest.Builder> deleteBackupSelectionRequest) {
        return deleteBackupSelection(DeleteBackupSelectionRequest.builder().applyMutation(deleteBackupSelectionRequest).build());
    }

    /**
     * <p>
     * Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
     * </p>
     *
     * @param deleteBackupVaultRequest
     * @return A Java Future containing the result of the DeleteBackupVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBackupVaultResponse> deleteBackupVault(DeleteBackupVaultRequest deleteBackupVaultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupVaultRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBackupVaultRequest#builder()}
     * </p>
     *
     * @param deleteBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteBackupVaultRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBackupVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBackupVaultResponse> deleteBackupVault(
            Consumer<DeleteBackupVaultRequest.Builder> deleteBackupVaultRequest) {
        return deleteBackupVault(DeleteBackupVaultRequest.builder().applyMutation(deleteBackupVaultRequest).build());
    }

    /**
     * <p>
     * Deletes the policy document that manages permissions on a backup vault.
     * </p>
     *
     * @param deleteBackupVaultAccessPolicyRequest
     * @return A Java Future containing the result of the DeleteBackupVaultAccessPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBackupVaultAccessPolicyResponse> deleteBackupVaultAccessPolicy(
            DeleteBackupVaultAccessPolicyRequest deleteBackupVaultAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the policy document that manages permissions on a backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupVaultAccessPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteBackupVaultAccessPolicyRequest#builder()}
     * </p>
     *
     * @param deleteBackupVaultAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteBackupVaultAccessPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBackupVaultAccessPolicyResponse> deleteBackupVaultAccessPolicy(
            Consumer<DeleteBackupVaultAccessPolicyRequest.Builder> deleteBackupVaultAccessPolicyRequest) {
        return deleteBackupVaultAccessPolicy(DeleteBackupVaultAccessPolicyRequest.builder()
                .applyMutation(deleteBackupVaultAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes Backup Vault Lock from a backup vault specified by a backup vault name.
     * </p>
     * <p>
     * If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using API operations, and you
     * will receive an <code>InvalidRequestException</code> if you attempt to do so. For more information, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">Vault Lock</a> in the <i>Backup
     * Developer Guide</i>.
     * </p>
     *
     * @param deleteBackupVaultLockConfigurationRequest
     * @return A Java Future containing the result of the DeleteBackupVaultLockConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupVaultLockConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultLockConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBackupVaultLockConfigurationResponse> deleteBackupVaultLockConfiguration(
            DeleteBackupVaultLockConfigurationRequest deleteBackupVaultLockConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes Backup Vault Lock from a backup vault specified by a backup vault name.
     * </p>
     * <p>
     * If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using API operations, and you
     * will receive an <code>InvalidRequestException</code> if you attempt to do so. For more information, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">Vault Lock</a> in the <i>Backup
     * Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupVaultLockConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteBackupVaultLockConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteBackupVaultLockConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteBackupVaultLockConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupVaultLockConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultLockConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBackupVaultLockConfigurationResponse> deleteBackupVaultLockConfiguration(
            Consumer<DeleteBackupVaultLockConfigurationRequest.Builder> deleteBackupVaultLockConfigurationRequest) {
        return deleteBackupVaultLockConfiguration(DeleteBackupVaultLockConfigurationRequest.builder()
                .applyMutation(deleteBackupVaultLockConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes event notifications for the specified backup vault.
     * </p>
     *
     * @param deleteBackupVaultNotificationsRequest
     * @return A Java Future containing the result of the DeleteBackupVaultNotifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBackupVaultNotificationsResponse> deleteBackupVaultNotifications(
            DeleteBackupVaultNotificationsRequest deleteBackupVaultNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes event notifications for the specified backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupVaultNotificationsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteBackupVaultNotificationsRequest#builder()}
     * </p>
     *
     * @param deleteBackupVaultNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteBackupVaultNotifications operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBackupVaultNotificationsResponse> deleteBackupVaultNotifications(
            Consumer<DeleteBackupVaultNotificationsRequest.Builder> deleteBackupVaultNotificationsRequest) {
        return deleteBackupVaultNotifications(DeleteBackupVaultNotificationsRequest.builder()
                .applyMutation(deleteBackupVaultNotificationsRequest).build());
    }

    /**
     * <p>
     * Deletes the framework specified by a framework name.
     * </p>
     *
     * @param deleteFrameworkRequest
     * @return A Java Future containing the result of the DeleteFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFrameworkResponse> deleteFramework(DeleteFrameworkRequest deleteFrameworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the framework specified by a framework name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFrameworkRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteFrameworkRequest#builder()}
     * </p>
     *
     * @param deleteFrameworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteFrameworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFrameworkResponse> deleteFramework(
            Consumer<DeleteFrameworkRequest.Builder> deleteFrameworkRequest) {
        return deleteFramework(DeleteFrameworkRequest.builder().applyMutation(deleteFrameworkRequest).build());
    }

    /**
     * <p>
     * Deletes the recovery point specified by a recovery point ID.
     * </p>
     * <p>
     * If the recovery point ID belongs to a continuous backup, calling this endpoint deletes the existing continuous
     * backup and stops future continuous backup.
     * </p>
     * <p>
     * When an IAM role's permissions are insufficient to call this API, the service sends back an HTTP 200 response
     * with an empty HTTP body, but the recovery point is not deleted. Instead, it enters an <code>EXPIRED</code> state.
     * </p>
     * <p>
     * <code>EXPIRED</code> recovery points can be deleted with this API once the IAM role has the
     * <code>iam:CreateServiceLinkedRole</code> action. To learn more about adding this role, see <a href=
     * "https://docs.aws.amazon.com/aws-backup/latest/devguide/deleting-backups.html#deleting-backups-troubleshooting">
     * Troubleshooting manual deletions</a>.
     * </p>
     * <p>
     * If the user or role is deleted or the permission within the role is removed, the deletion will not be successful
     * and will enter an <code>EXPIRED</code> state.
     * </p>
     *
     * @param deleteRecoveryPointRequest
     * @return A Java Future containing the result of the DeleteRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidResourceStateException Backup is already performing an action on this recovery point. It can't
     *         perform the action you requested until the first action finishes. Try again later.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRecoveryPoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRecoveryPointResponse> deleteRecoveryPoint(
            DeleteRecoveryPointRequest deleteRecoveryPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the recovery point specified by a recovery point ID.
     * </p>
     * <p>
     * If the recovery point ID belongs to a continuous backup, calling this endpoint deletes the existing continuous
     * backup and stops future continuous backup.
     * </p>
     * <p>
     * When an IAM role's permissions are insufficient to call this API, the service sends back an HTTP 200 response
     * with an empty HTTP body, but the recovery point is not deleted. Instead, it enters an <code>EXPIRED</code> state.
     * </p>
     * <p>
     * <code>EXPIRED</code> recovery points can be deleted with this API once the IAM role has the
     * <code>iam:CreateServiceLinkedRole</code> action. To learn more about adding this role, see <a href=
     * "https://docs.aws.amazon.com/aws-backup/latest/devguide/deleting-backups.html#deleting-backups-troubleshooting">
     * Troubleshooting manual deletions</a>.
     * </p>
     * <p>
     * If the user or role is deleted or the permission within the role is removed, the deletion will not be successful
     * and will enter an <code>EXPIRED</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRecoveryPointRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRecoveryPointRequest#builder()}
     * </p>
     *
     * @param deleteRecoveryPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteRecoveryPointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidResourceStateException Backup is already performing an action on this recovery point. It can't
     *         perform the action you requested until the first action finishes. Try again later.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRecoveryPoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRecoveryPointResponse> deleteRecoveryPoint(
            Consumer<DeleteRecoveryPointRequest.Builder> deleteRecoveryPointRequest) {
        return deleteRecoveryPoint(DeleteRecoveryPointRequest.builder().applyMutation(deleteRecoveryPointRequest).build());
    }

    /**
     * <p>
     * Deletes the report plan specified by a report plan name.
     * </p>
     *
     * @param deleteReportPlanRequest
     * @return A Java Future containing the result of the DeleteReportPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReportPlanResponse> deleteReportPlan(DeleteReportPlanRequest deleteReportPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the report plan specified by a report plan name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReportPlanRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteReportPlanRequest#builder()}
     * </p>
     *
     * @param deleteReportPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteReportPlanRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteReportPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReportPlanResponse> deleteReportPlan(
            Consumer<DeleteReportPlanRequest.Builder> deleteReportPlanRequest) {
        return deleteReportPlan(DeleteReportPlanRequest.builder().applyMutation(deleteReportPlanRequest).build());
    }

    /**
     * <p>
     * This request deletes the specified restore testing plan.
     * </p>
     * <p>
     * Deletion can only successfully occur if all associated restore testing selections are deleted first.
     * </p>
     *
     * @param deleteRestoreTestingPlanRequest
     * @return A Java Future containing the result of the DeleteRestoreTestingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRestoreTestingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRestoreTestingPlanResponse> deleteRestoreTestingPlan(
            DeleteRestoreTestingPlanRequest deleteRestoreTestingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request deletes the specified restore testing plan.
     * </p>
     * <p>
     * Deletion can only successfully occur if all associated restore testing selections are deleted first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRestoreTestingPlanRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteRestoreTestingPlanRequest#builder()}
     * </p>
     *
     * @param deleteRestoreTestingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteRestoreTestingPlanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRestoreTestingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRestoreTestingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRestoreTestingPlanResponse> deleteRestoreTestingPlan(
            Consumer<DeleteRestoreTestingPlanRequest.Builder> deleteRestoreTestingPlanRequest) {
        return deleteRestoreTestingPlan(DeleteRestoreTestingPlanRequest.builder().applyMutation(deleteRestoreTestingPlanRequest)
                .build());
    }

    /**
     * <p>
     * Input the Restore Testing Plan name and Restore Testing Selection name.
     * </p>
     * <p>
     * All testing selections associated with a restore testing plan must be deleted before the restore testing plan can
     * be deleted.
     * </p>
     *
     * @param deleteRestoreTestingSelectionRequest
     * @return A Java Future containing the result of the DeleteRestoreTestingSelection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRestoreTestingSelectionResponse> deleteRestoreTestingSelection(
            DeleteRestoreTestingSelectionRequest deleteRestoreTestingSelectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Input the Restore Testing Plan name and Restore Testing Selection name.
     * </p>
     * <p>
     * All testing selections associated with a restore testing plan must be deleted before the restore testing plan can
     * be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRestoreTestingSelectionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRestoreTestingSelectionRequest#builder()}
     * </p>
     *
     * @param deleteRestoreTestingSelectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DeleteRestoreTestingSelectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRestoreTestingSelection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DeleteRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRestoreTestingSelectionResponse> deleteRestoreTestingSelection(
            Consumer<DeleteRestoreTestingSelectionRequest.Builder> deleteRestoreTestingSelectionRequest) {
        return deleteRestoreTestingSelection(DeleteRestoreTestingSelectionRequest.builder()
                .applyMutation(deleteRestoreTestingSelectionRequest).build());
    }

    /**
     * <p>
     * Returns backup job details for the specified <code>BackupJobId</code>.
     * </p>
     *
     * @param describeBackupJobRequest
     * @return A Java Future containing the result of the DescribeBackupJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>DependencyFailureException A dependent Amazon Web Services service or resource returned an error to
     *         the Backup service, and the action cannot be completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBackupJobResponse> describeBackupJob(DescribeBackupJobRequest describeBackupJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns backup job details for the specified <code>BackupJobId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBackupJobRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBackupJobRequest#builder()}
     * </p>
     *
     * @param describeBackupJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeBackupJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeBackupJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>DependencyFailureException A dependent Amazon Web Services service or resource returned an error to
     *         the Backup service, and the action cannot be completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBackupJobResponse> describeBackupJob(
            Consumer<DescribeBackupJobRequest.Builder> describeBackupJobRequest) {
        return describeBackupJob(DescribeBackupJobRequest.builder().applyMutation(describeBackupJobRequest).build());
    }

    /**
     * <p>
     * Returns metadata about a backup vault specified by its name.
     * </p>
     *
     * @param describeBackupVaultRequest
     * @return A Java Future containing the result of the DescribeBackupVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupVault" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeBackupVaultResponse> describeBackupVault(
            DescribeBackupVaultRequest describeBackupVaultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about a backup vault specified by its name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBackupVaultRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBackupVaultRequest#builder()}
     * </p>
     *
     * @param describeBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeBackupVaultRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeBackupVault operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupVault" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeBackupVaultResponse> describeBackupVault(
            Consumer<DescribeBackupVaultRequest.Builder> describeBackupVaultRequest) {
        return describeBackupVault(DescribeBackupVaultRequest.builder().applyMutation(describeBackupVaultRequest).build());
    }

    /**
     * <p>
     * Returns metadata associated with creating a copy of a resource.
     * </p>
     *
     * @param describeCopyJobRequest
     * @return A Java Future containing the result of the DescribeCopyJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeCopyJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeCopyJobResponse> describeCopyJob(DescribeCopyJobRequest describeCopyJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata associated with creating a copy of a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCopyJobRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeCopyJobRequest#builder()}
     * </p>
     *
     * @param describeCopyJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeCopyJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeCopyJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeCopyJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeCopyJobResponse> describeCopyJob(
            Consumer<DescribeCopyJobRequest.Builder> describeCopyJobRequest) {
        return describeCopyJob(DescribeCopyJobRequest.builder().applyMutation(describeCopyJobRequest).build());
    }

    /**
     * <p>
     * Returns the framework details for the specified <code>FrameworkName</code>.
     * </p>
     *
     * @param describeFrameworkRequest
     * @return A Java Future containing the result of the DescribeFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFrameworkResponse> describeFramework(DescribeFrameworkRequest describeFrameworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the framework details for the specified <code>FrameworkName</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFrameworkRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeFrameworkRequest#builder()}
     * </p>
     *
     * @param describeFrameworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeFrameworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeFrameworkResponse> describeFramework(
            Consumer<DescribeFrameworkRequest.Builder> describeFrameworkRequest) {
        return describeFramework(DescribeFrameworkRequest.builder().applyMutation(describeFrameworkRequest).build());
    }

    /**
     * <p>
     * Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the
     * account is not a member of an Organizations organization. Example:
     * <code>describe-global-settings --region us-west-2</code>
     * </p>
     *
     * @param describeGlobalSettingsRequest
     * @return A Java Future containing the result of the DescribeGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeGlobalSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalSettingsResponse> describeGlobalSettings(
            DescribeGlobalSettingsRequest describeGlobalSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the
     * account is not a member of an Organizations organization. Example:
     * <code>describe-global-settings --region us-west-2</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGlobalSettingsRequest#builder()}
     * </p>
     *
     * @param describeGlobalSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeGlobalSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalSettingsResponse> describeGlobalSettings(
            Consumer<DescribeGlobalSettingsRequest.Builder> describeGlobalSettingsRequest) {
        return describeGlobalSettings(DescribeGlobalSettingsRequest.builder().applyMutation(describeGlobalSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name
     * (ARN), and the Amazon Web Services service type of the saved resource.
     * </p>
     *
     * @param describeProtectedResourceRequest
     * @return A Java Future containing the result of the DescribeProtectedResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeProtectedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeProtectedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProtectedResourceResponse> describeProtectedResource(
            DescribeProtectedResourceRequest describeProtectedResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name
     * (ARN), and the Amazon Web Services service type of the saved resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProtectedResourceRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeProtectedResourceRequest#builder()}
     * </p>
     *
     * @param describeProtectedResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeProtectedResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeProtectedResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeProtectedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeProtectedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProtectedResourceResponse> describeProtectedResource(
            Consumer<DescribeProtectedResourceRequest.Builder> describeProtectedResourceRequest) {
        return describeProtectedResource(DescribeProtectedResourceRequest.builder()
                .applyMutation(describeProtectedResourceRequest).build());
    }

    /**
     * <p>
     * Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
     * </p>
     *
     * @param describeRecoveryPointRequest
     * @return A Java Future containing the result of the DescribeRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRecoveryPoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeRecoveryPointResponse> describeRecoveryPoint(
            DescribeRecoveryPointRequest describeRecoveryPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecoveryPointRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRecoveryPointRequest#builder()}
     * </p>
     *
     * @param describeRecoveryPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeRecoveryPointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRecoveryPoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeRecoveryPointResponse> describeRecoveryPoint(
            Consumer<DescribeRecoveryPointRequest.Builder> describeRecoveryPointRequest) {
        return describeRecoveryPoint(DescribeRecoveryPointRequest.builder().applyMutation(describeRecoveryPointRequest).build());
    }

    /**
     * <p>
     * Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup
     * tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or
     * scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region.
     * </p>
     *
     * @param describeRegionSettingsRequest
     * @return A Java Future containing the result of the DescribeRegionSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeRegionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRegionSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeRegionSettingsResponse> describeRegionSettings(
            DescribeRegionSettingsRequest describeRegionSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup
     * tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or
     * scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegionSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRegionSettingsRequest#builder()}
     * </p>
     *
     * @param describeRegionSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeRegionSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRegionSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeRegionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRegionSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeRegionSettingsResponse> describeRegionSettings(
            Consumer<DescribeRegionSettingsRequest.Builder> describeRegionSettingsRequest) {
        return describeRegionSettings(DescribeRegionSettingsRequest.builder().applyMutation(describeRegionSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the details associated with creating a report as specified by its <code>ReportJobId</code>.
     * </p>
     *
     * @param describeReportJobRequest
     * @return A Java Future containing the result of the DescribeReportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeReportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeReportJobResponse> describeReportJob(DescribeReportJobRequest describeReportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details associated with creating a report as specified by its <code>ReportJobId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReportJobRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeReportJobRequest#builder()}
     * </p>
     *
     * @param describeReportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeReportJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeReportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeReportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeReportJobResponse> describeReportJob(
            Consumer<DescribeReportJobRequest.Builder> describeReportJobRequest) {
        return describeReportJob(DescribeReportJobRequest.builder().applyMutation(describeReportJobRequest).build());
    }

    /**
     * <p>
     * Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.
     * </p>
     *
     * @param describeReportPlanRequest
     * @return A Java Future containing the result of the DescribeReportPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeReportPlanResponse> describeReportPlan(DescribeReportPlanRequest describeReportPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReportPlanRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReportPlanRequest#builder()}
     * </p>
     *
     * @param describeReportPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeReportPlanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeReportPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeReportPlanResponse> describeReportPlan(
            Consumer<DescribeReportPlanRequest.Builder> describeReportPlanRequest) {
        return describeReportPlan(DescribeReportPlanRequest.builder().applyMutation(describeReportPlanRequest).build());
    }

    /**
     * <p>
     * Returns metadata associated with a restore job that is specified by a job ID.
     * </p>
     *
     * @param describeRestoreJobRequest
     * @return A Java Future containing the result of the DescribeRestoreJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>DependencyFailureException A dependent Amazon Web Services service or resource returned an error to
     *         the Backup service, and the action cannot be completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeRestoreJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRestoreJobResponse> describeRestoreJob(DescribeRestoreJobRequest describeRestoreJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata associated with a restore job that is specified by a job ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRestoreJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRestoreJobRequest#builder()}
     * </p>
     *
     * @param describeRestoreJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DescribeRestoreJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeRestoreJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>DependencyFailureException A dependent Amazon Web Services service or resource returned an error to
     *         the Backup service, and the action cannot be completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DescribeRestoreJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRestoreJobResponse> describeRestoreJob(
            Consumer<DescribeRestoreJobRequest.Builder> describeRestoreJobRequest) {
        return describeRestoreJob(DescribeRestoreJobRequest.builder().applyMutation(describeRestoreJobRequest).build());
    }

    /**
     * <p>
     * Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup
     * to the source service, such as Amazon RDS. The source service will continue to create and retain continuous
     * backups using the lifecycle that you specified in your original backup plan.
     * </p>
     * <p>
     * Does not support snapshot backup recovery points.
     * </p>
     *
     * @param disassociateRecoveryPointRequest
     * @return A Java Future containing the result of the DisassociateRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidResourceStateException Backup is already performing an action on this recovery point. It can't
     *         perform the action you requested until the first action finishes. Try again later.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DisassociateRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateRecoveryPointResponse> disassociateRecoveryPoint(
            DisassociateRecoveryPointRequest disassociateRecoveryPointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup
     * to the source service, such as Amazon RDS. The source service will continue to create and retain continuous
     * backups using the lifecycle that you specified in your original backup plan.
     * </p>
     * <p>
     * Does not support snapshot backup recovery points.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateRecoveryPointRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateRecoveryPointRequest#builder()}
     * </p>
     *
     * @param disassociateRecoveryPointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateRecoveryPoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidResourceStateException Backup is already performing an action on this recovery point. It can't
     *         perform the action you requested until the first action finishes. Try again later.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DisassociateRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateRecoveryPointResponse> disassociateRecoveryPoint(
            Consumer<DisassociateRecoveryPointRequest.Builder> disassociateRecoveryPointRequest) {
        return disassociateRecoveryPoint(DisassociateRecoveryPointRequest.builder()
                .applyMutation(disassociateRecoveryPointRequest).build());
    }

    /**
     * <p>
     * This action to a specific child (nested) recovery point removes the relationship between the specified recovery
     * point and its parent (composite) recovery point.
     * </p>
     *
     * @param disassociateRecoveryPointFromParentRequest
     * @return A Java Future containing the result of the DisassociateRecoveryPointFromParent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DisassociateRecoveryPointFromParent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPointFromParent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateRecoveryPointFromParentResponse> disassociateRecoveryPointFromParent(
            DisassociateRecoveryPointFromParentRequest disassociateRecoveryPointFromParentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action to a specific child (nested) recovery point removes the relationship between the specified recovery
     * point and its parent (composite) recovery point.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateRecoveryPointFromParentRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateRecoveryPointFromParentRequest#builder()}
     * </p>
     *
     * @param disassociateRecoveryPointFromParentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateRecoveryPointFromParent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.DisassociateRecoveryPointFromParent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPointFromParent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateRecoveryPointFromParentResponse> disassociateRecoveryPointFromParent(
            Consumer<DisassociateRecoveryPointFromParentRequest.Builder> disassociateRecoveryPointFromParentRequest) {
        return disassociateRecoveryPointFromParent(DisassociateRecoveryPointFromParentRequest.builder()
                .applyMutation(disassociateRecoveryPointFromParentRequest).build());
    }

    /**
     * <p>
     * Returns the backup plan that is specified by the plan ID as a backup template.
     * </p>
     *
     * @param exportBackupPlanTemplateRequest
     * @return A Java Future containing the result of the ExportBackupPlanTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ExportBackupPlanTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ExportBackupPlanTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportBackupPlanTemplateResponse> exportBackupPlanTemplate(
            ExportBackupPlanTemplateRequest exportBackupPlanTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the backup plan that is specified by the plan ID as a backup template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportBackupPlanTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link ExportBackupPlanTemplateRequest#builder()}
     * </p>
     *
     * @param exportBackupPlanTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExportBackupPlanTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ExportBackupPlanTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ExportBackupPlanTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportBackupPlanTemplateResponse> exportBackupPlanTemplate(
            Consumer<ExportBackupPlanTemplateRequest.Builder> exportBackupPlanTemplateRequest) {
        return exportBackupPlanTemplate(ExportBackupPlanTemplateRequest.builder().applyMutation(exportBackupPlanTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Returns <code>BackupPlan</code> details for the specified <code>BackupPlanId</code>. The details are the body of
     * a backup plan in JSON format, in addition to plan metadata.
     * </p>
     *
     * @param getBackupPlanRequest
     * @return A Java Future containing the result of the GetBackupPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBackupPlanResponse> getBackupPlan(GetBackupPlanRequest getBackupPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns <code>BackupPlan</code> details for the specified <code>BackupPlanId</code>. The details are the body of
     * a backup plan in JSON format, in addition to plan metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupPlanRequest.Builder} avoiding the need to
     * create one manually via {@link GetBackupPlanRequest#builder()}
     * </p>
     *
     * @param getBackupPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetBackupPlanRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetBackupPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBackupPlanResponse> getBackupPlan(Consumer<GetBackupPlanRequest.Builder> getBackupPlanRequest) {
        return getBackupPlan(GetBackupPlanRequest.builder().applyMutation(getBackupPlanRequest).build());
    }

    /**
     * <p>
     * Returns a valid JSON document specifying a backup plan or an error.
     * </p>
     *
     * @param getBackupPlanFromJsonRequest
     * @return A Java Future containing the result of the GetBackupPlanFromJSON operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupPlanFromJSON
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromJSON" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetBackupPlanFromJsonResponse> getBackupPlanFromJSON(
            GetBackupPlanFromJsonRequest getBackupPlanFromJsonRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a valid JSON document specifying a backup plan or an error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupPlanFromJsonRequest.Builder} avoiding the
     * need to create one manually via {@link GetBackupPlanFromJsonRequest#builder()}
     * </p>
     *
     * @param getBackupPlanFromJsonRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetBackupPlanFromJSON operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupPlanFromJSON
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromJSON" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetBackupPlanFromJsonResponse> getBackupPlanFromJSON(
            Consumer<GetBackupPlanFromJsonRequest.Builder> getBackupPlanFromJsonRequest) {
        return getBackupPlanFromJSON(GetBackupPlanFromJsonRequest.builder().applyMutation(getBackupPlanFromJsonRequest).build());
    }

    /**
     * <p>
     * Returns the template specified by its <code>templateId</code> as a backup plan.
     * </p>
     *
     * @param getBackupPlanFromTemplateRequest
     * @return A Java Future containing the result of the GetBackupPlanFromTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupPlanFromTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBackupPlanFromTemplateResponse> getBackupPlanFromTemplate(
            GetBackupPlanFromTemplateRequest getBackupPlanFromTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the template specified by its <code>templateId</code> as a backup plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupPlanFromTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link GetBackupPlanFromTemplateRequest#builder()}
     * </p>
     *
     * @param getBackupPlanFromTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetBackupPlanFromTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupPlanFromTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBackupPlanFromTemplateResponse> getBackupPlanFromTemplate(
            Consumer<GetBackupPlanFromTemplateRequest.Builder> getBackupPlanFromTemplateRequest) {
        return getBackupPlanFromTemplate(GetBackupPlanFromTemplateRequest.builder()
                .applyMutation(getBackupPlanFromTemplateRequest).build());
    }

    /**
     * <p>
     * Returns selection metadata and a document in JSON format that specifies a list of resources that are associated
     * with a backup plan.
     * </p>
     *
     * @param getBackupSelectionRequest
     * @return A Java Future containing the result of the GetBackupSelection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupSelection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBackupSelectionResponse> getBackupSelection(GetBackupSelectionRequest getBackupSelectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns selection metadata and a document in JSON format that specifies a list of resources that are associated
     * with a backup plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupSelectionRequest.Builder} avoiding the
     * need to create one manually via {@link GetBackupSelectionRequest#builder()}
     * </p>
     *
     * @param getBackupSelectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetBackupSelection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupSelection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBackupSelectionResponse> getBackupSelection(
            Consumer<GetBackupSelectionRequest.Builder> getBackupSelectionRequest) {
        return getBackupSelection(GetBackupSelectionRequest.builder().applyMutation(getBackupSelectionRequest).build());
    }

    /**
     * <p>
     * Returns the access policy document that is associated with the named backup vault.
     * </p>
     *
     * @param getBackupVaultAccessPolicyRequest
     * @return A Java Future containing the result of the GetBackupVaultAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBackupVaultAccessPolicyResponse> getBackupVaultAccessPolicy(
            GetBackupVaultAccessPolicyRequest getBackupVaultAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the access policy document that is associated with the named backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupVaultAccessPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetBackupVaultAccessPolicyRequest#builder()}
     * </p>
     *
     * @param getBackupVaultAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetBackupVaultAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBackupVaultAccessPolicyResponse> getBackupVaultAccessPolicy(
            Consumer<GetBackupVaultAccessPolicyRequest.Builder> getBackupVaultAccessPolicyRequest) {
        return getBackupVaultAccessPolicy(GetBackupVaultAccessPolicyRequest.builder()
                .applyMutation(getBackupVaultAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Returns event notifications for the specified backup vault.
     * </p>
     *
     * @param getBackupVaultNotificationsRequest
     * @return A Java Future containing the result of the GetBackupVaultNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBackupVaultNotificationsResponse> getBackupVaultNotifications(
            GetBackupVaultNotificationsRequest getBackupVaultNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns event notifications for the specified backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupVaultNotificationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetBackupVaultNotificationsRequest#builder()}
     * </p>
     *
     * @param getBackupVaultNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetBackupVaultNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBackupVaultNotificationsResponse> getBackupVaultNotifications(
            Consumer<GetBackupVaultNotificationsRequest.Builder> getBackupVaultNotificationsRequest) {
        return getBackupVaultNotifications(GetBackupVaultNotificationsRequest.builder()
                .applyMutation(getBackupVaultNotificationsRequest).build());
    }

    /**
     * <p>
     * This action returns details for a specified legal hold. The details are the body of a legal hold in JSON format,
     * in addition to metadata.
     * </p>
     *
     * @param getLegalHoldRequest
     * @return A Java Future containing the result of the GetLegalHold operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLegalHoldResponse> getLegalHold(GetLegalHoldRequest getLegalHoldRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action returns details for a specified legal hold. The details are the body of a legal hold in JSON format,
     * in addition to metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLegalHoldRequest.Builder} avoiding the need to
     * create one manually via {@link GetLegalHoldRequest#builder()}
     * </p>
     *
     * @param getLegalHoldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetLegalHoldRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLegalHold operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLegalHoldResponse> getLegalHold(Consumer<GetLegalHoldRequest.Builder> getLegalHoldRequest) {
        return getLegalHold(GetLegalHoldRequest.builder().applyMutation(getLegalHoldRequest).build());
    }

    /**
     * <p>
     * Returns a set of metadata key-value pairs that were used to create the backup.
     * </p>
     *
     * @param getRecoveryPointRestoreMetadataRequest
     * @return A Java Future containing the result of the GetRecoveryPointRestoreMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRecoveryPointRestoreMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRecoveryPointRestoreMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecoveryPointRestoreMetadataResponse> getRecoveryPointRestoreMetadata(
            GetRecoveryPointRestoreMetadataRequest getRecoveryPointRestoreMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a set of metadata key-value pairs that were used to create the backup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecoveryPointRestoreMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link GetRecoveryPointRestoreMetadataRequest#builder()}
     * </p>
     *
     * @param getRecoveryPointRestoreMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRecoveryPointRestoreMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRecoveryPointRestoreMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRecoveryPointRestoreMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecoveryPointRestoreMetadataResponse> getRecoveryPointRestoreMetadata(
            Consumer<GetRecoveryPointRestoreMetadataRequest.Builder> getRecoveryPointRestoreMetadataRequest) {
        return getRecoveryPointRestoreMetadata(GetRecoveryPointRestoreMetadataRequest.builder()
                .applyMutation(getRecoveryPointRestoreMetadataRequest).build());
    }

    /**
     * <p>
     * This request returns the metadata for the specified restore job.
     * </p>
     *
     * @param getRestoreJobMetadataRequest
     * @return A Java Future containing the result of the GetRestoreJobMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRestoreJobMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreJobMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetRestoreJobMetadataResponse> getRestoreJobMetadata(
            GetRestoreJobMetadataRequest getRestoreJobMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request returns the metadata for the specified restore job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRestoreJobMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link GetRestoreJobMetadataRequest#builder()}
     * </p>
     *
     * @param getRestoreJobMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetRestoreJobMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRestoreJobMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRestoreJobMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreJobMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetRestoreJobMetadataResponse> getRestoreJobMetadata(
            Consumer<GetRestoreJobMetadataRequest.Builder> getRestoreJobMetadataRequest) {
        return getRestoreJobMetadata(GetRestoreJobMetadataRequest.builder().applyMutation(getRestoreJobMetadataRequest).build());
    }

    /**
     * <p>
     * This request returns the minimal required set of metadata needed to start a restore job with secure default
     * settings. <code>BackupVaultName</code> and <code>RecoveryPointArn</code> are required parameters.
     * <code>BackupVaultAccountId</code> is an optional parameter.
     * </p>
     *
     * @param getRestoreTestingInferredMetadataRequest
     * @return A Java Future containing the result of the GetRestoreTestingInferredMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRestoreTestingInferredMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingInferredMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRestoreTestingInferredMetadataResponse> getRestoreTestingInferredMetadata(
            GetRestoreTestingInferredMetadataRequest getRestoreTestingInferredMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request returns the minimal required set of metadata needed to start a restore job with secure default
     * settings. <code>BackupVaultName</code> and <code>RecoveryPointArn</code> are required parameters.
     * <code>BackupVaultAccountId</code> is an optional parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRestoreTestingInferredMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link GetRestoreTestingInferredMetadataRequest#builder()}
     * </p>
     *
     * @param getRestoreTestingInferredMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetRestoreTestingInferredMetadataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetRestoreTestingInferredMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRestoreTestingInferredMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingInferredMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRestoreTestingInferredMetadataResponse> getRestoreTestingInferredMetadata(
            Consumer<GetRestoreTestingInferredMetadataRequest.Builder> getRestoreTestingInferredMetadataRequest) {
        return getRestoreTestingInferredMetadata(GetRestoreTestingInferredMetadataRequest.builder()
                .applyMutation(getRestoreTestingInferredMetadataRequest).build());
    }

    /**
     * <p>
     * Returns <code>RestoreTestingPlan</code> details for the specified <code>RestoreTestingPlanName</code>. The
     * details are the body of a restore testing plan in JSON format, in addition to plan metadata.
     * </p>
     *
     * @param getRestoreTestingPlanRequest
     * @return A Java Future containing the result of the GetRestoreTestingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetRestoreTestingPlanResponse> getRestoreTestingPlan(
            GetRestoreTestingPlanRequest getRestoreTestingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns <code>RestoreTestingPlan</code> details for the specified <code>RestoreTestingPlanName</code>. The
     * details are the body of a restore testing plan in JSON format, in addition to plan metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRestoreTestingPlanRequest.Builder} avoiding the
     * need to create one manually via {@link GetRestoreTestingPlanRequest#builder()}
     * </p>
     *
     * @param getRestoreTestingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetRestoreTestingPlanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRestoreTestingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetRestoreTestingPlanResponse> getRestoreTestingPlan(
            Consumer<GetRestoreTestingPlanRequest.Builder> getRestoreTestingPlanRequest) {
        return getRestoreTestingPlan(GetRestoreTestingPlanRequest.builder().applyMutation(getRestoreTestingPlanRequest).build());
    }

    /**
     * <p>
     * Returns RestoreTestingSelection, which displays resources and elements of the restore testing plan.
     * </p>
     *
     * @param getRestoreTestingSelectionRequest
     * @return A Java Future containing the result of the GetRestoreTestingSelection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRestoreTestingSelectionResponse> getRestoreTestingSelection(
            GetRestoreTestingSelectionRequest getRestoreTestingSelectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns RestoreTestingSelection, which displays resources and elements of the restore testing plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRestoreTestingSelectionRequest.Builder} avoiding
     * the need to create one manually via {@link GetRestoreTestingSelectionRequest#builder()}
     * </p>
     *
     * @param getRestoreTestingSelectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetRestoreTestingSelectionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRestoreTestingSelection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRestoreTestingSelectionResponse> getRestoreTestingSelection(
            Consumer<GetRestoreTestingSelectionRequest.Builder> getRestoreTestingSelectionRequest) {
        return getRestoreTestingSelection(GetRestoreTestingSelectionRequest.builder()
                .applyMutation(getRestoreTestingSelectionRequest).build());
    }

    /**
     * <p>
     * Returns the Amazon Web Services resource types supported by Backup.
     * </p>
     *
     * @param getSupportedResourceTypesRequest
     * @return A Java Future containing the result of the GetSupportedResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSupportedResourceTypesResponse> getSupportedResourceTypes(
            GetSupportedResourceTypesRequest getSupportedResourceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the Amazon Web Services resource types supported by Backup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSupportedResourceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link GetSupportedResourceTypesRequest#builder()}
     * </p>
     *
     * @param getSupportedResourceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSupportedResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.GetSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSupportedResourceTypesResponse> getSupportedResourceTypes(
            Consumer<GetSupportedResourceTypesRequest.Builder> getSupportedResourceTypesRequest) {
        return getSupportedResourceTypes(GetSupportedResourceTypesRequest.builder()
                .applyMutation(getSupportedResourceTypesRequest).build());
    }

    /**
     * <p>
     * This is a request for a summary of backup jobs created or running within the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     *
     * @param listBackupJobSummariesRequest
     * @return A Java Future containing the result of the ListBackupJobSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBackupJobSummariesResponse> listBackupJobSummaries(
            ListBackupJobSummariesRequest listBackupJobSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is a request for a summary of backup jobs created or running within the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupJobSummariesRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupJobSummariesRequest#builder()}
     * </p>
     *
     * @param listBackupJobSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBackupJobSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBackupJobSummariesResponse> listBackupJobSummaries(
            Consumer<ListBackupJobSummariesRequest.Builder> listBackupJobSummariesRequest) {
        return listBackupJobSummaries(ListBackupJobSummariesRequest.builder().applyMutation(listBackupJobSummariesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupJobSummaries(software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobSummariesPublisher publisher = client.listBackupJobSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobSummariesPublisher publisher = client.listBackupJobSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupJobSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupJobSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupJobSummaries(software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBackupJobSummariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupJobSummariesPublisher listBackupJobSummariesPaginator(
            ListBackupJobSummariesRequest listBackupJobSummariesRequest) {
        return new ListBackupJobSummariesPublisher(this, listBackupJobSummariesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupJobSummaries(software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobSummariesPublisher publisher = client.listBackupJobSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobSummariesPublisher publisher = client.listBackupJobSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupJobSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupJobSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupJobSummaries(software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupJobSummariesRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupJobSummariesRequest#builder()}
     * </p>
     *
     * @param listBackupJobSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupJobSummariesPublisher listBackupJobSummariesPaginator(
            Consumer<ListBackupJobSummariesRequest.Builder> listBackupJobSummariesRequest) {
        return listBackupJobSummariesPaginator(ListBackupJobSummariesRequest.builder()
                .applyMutation(listBackupJobSummariesRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of
     * time, consider using these <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">monitoring tools</a>.
     * </p>
     *
     * @param listBackupJobsRequest
     * @return A Java Future containing the result of the ListBackupJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBackupJobsResponse> listBackupJobs(ListBackupJobsRequest listBackupJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of
     * time, consider using these <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">monitoring tools</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBackupJobsRequest#builder()}
     * </p>
     *
     * @param listBackupJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBackupJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBackupJobsResponse> listBackupJobs(Consumer<ListBackupJobsRequest.Builder> listBackupJobsRequest) {
        return listBackupJobs(ListBackupJobsRequest.builder().applyMutation(listBackupJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of
     * time, consider using these <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">monitoring tools</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListBackupJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBackupJobsResponse> listBackupJobs() {
        return listBackupJobs(ListBackupJobsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsPublisher publisher = client.listBackupJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsPublisher publisher = client.listBackupJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsPublisher listBackupJobsPaginator() {
        return listBackupJobsPaginator(ListBackupJobsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsPublisher publisher = client.listBackupJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsPublisher publisher = client.listBackupJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)} operation.</b>
     * </p>
     *
     * @param listBackupJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsPublisher listBackupJobsPaginator(ListBackupJobsRequest listBackupJobsRequest) {
        return new ListBackupJobsPublisher(this, listBackupJobsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsPublisher publisher = client.listBackupJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsPublisher publisher = client.listBackupJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBackupJobsRequest#builder()}
     * </p>
     *
     * @param listBackupJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupJobsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsPublisher listBackupJobsPaginator(Consumer<ListBackupJobsRequest.Builder> listBackupJobsRequest) {
        return listBackupJobsPaginator(ListBackupJobsRequest.builder().applyMutation(listBackupJobsRequest).build());
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     *
     * @param listBackupPlanTemplatesRequest
     * @return A Java Future containing the result of the ListBackupPlanTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlanTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBackupPlanTemplatesResponse> listBackupPlanTemplates(
            ListBackupPlanTemplatesRequest listBackupPlanTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlanTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListBackupPlanTemplatesRequest#builder()}
     * </p>
     *
     * @param listBackupPlanTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBackupPlanTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlanTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBackupPlanTemplatesResponse> listBackupPlanTemplates(
            Consumer<ListBackupPlanTemplatesRequest.Builder> listBackupPlanTemplatesRequest) {
        return listBackupPlanTemplates(ListBackupPlanTemplatesRequest.builder().applyMutation(listBackupPlanTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     *
     * @return A Java Future containing the result of the ListBackupPlanTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlanTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBackupPlanTemplatesResponse> listBackupPlanTemplates() {
        return listBackupPlanTemplates(ListBackupPlanTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesPublisher publisher = client.listBackupPlanTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesPublisher publisher = client.listBackupPlanTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlanTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackupPlanTemplatesPublisher listBackupPlanTemplatesPaginator() {
        return listBackupPlanTemplatesPaginator(ListBackupPlanTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesPublisher publisher = client.listBackupPlanTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesPublisher publisher = client.listBackupPlanTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBackupPlanTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlanTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackupPlanTemplatesPublisher listBackupPlanTemplatesPaginator(
            ListBackupPlanTemplatesRequest listBackupPlanTemplatesRequest) {
        return new ListBackupPlanTemplatesPublisher(this, listBackupPlanTemplatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesPublisher publisher = client.listBackupPlanTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesPublisher publisher = client.listBackupPlanTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlanTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListBackupPlanTemplatesRequest#builder()}
     * </p>
     *
     * @param listBackupPlanTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlanTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackupPlanTemplatesPublisher listBackupPlanTemplatesPaginator(
            Consumer<ListBackupPlanTemplatesRequest.Builder> listBackupPlanTemplatesRequest) {
        return listBackupPlanTemplatesPaginator(ListBackupPlanTemplatesRequest.builder()
                .applyMutation(listBackupPlanTemplatesRequest).build());
    }

    /**
     * <p>
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation
     * and deletion dates, plan names, and version IDs.
     * </p>
     *
     * @param listBackupPlanVersionsRequest
     * @return A Java Future containing the result of the ListBackupPlanVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlanVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBackupPlanVersionsResponse> listBackupPlanVersions(
            ListBackupPlanVersionsRequest listBackupPlanVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation
     * and deletion dates, plan names, and version IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlanVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupPlanVersionsRequest#builder()}
     * </p>
     *
     * @param listBackupPlanVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBackupPlanVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlanVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBackupPlanVersionsResponse> listBackupPlanVersions(
            Consumer<ListBackupPlanVersionsRequest.Builder> listBackupPlanVersionsRequest) {
        return listBackupPlanVersions(ListBackupPlanVersionsRequest.builder().applyMutation(listBackupPlanVersionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupPlanVersions(software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsPublisher publisher = client.listBackupPlanVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsPublisher publisher = client.listBackupPlanVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanVersions(software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBackupPlanVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlanVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanVersionsPublisher listBackupPlanVersionsPaginator(
            ListBackupPlanVersionsRequest listBackupPlanVersionsRequest) {
        return new ListBackupPlanVersionsPublisher(this, listBackupPlanVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupPlanVersions(software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsPublisher publisher = client.listBackupPlanVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsPublisher publisher = client.listBackupPlanVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanVersions(software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlanVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupPlanVersionsRequest#builder()}
     * </p>
     *
     * @param listBackupPlanVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlanVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanVersionsPublisher listBackupPlanVersionsPaginator(
            Consumer<ListBackupPlanVersionsRequest.Builder> listBackupPlanVersionsRequest) {
        return listBackupPlanVersionsPaginator(ListBackupPlanVersionsRequest.builder()
                .applyMutation(listBackupPlanVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as
     * Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request
     * IDs.
     * </p>
     *
     * @param listBackupPlansRequest
     * @return A Java Future containing the result of the ListBackupPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBackupPlansResponse> listBackupPlans(ListBackupPlansRequest listBackupPlansRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as
     * Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request
     * IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackupPlansRequest#builder()}
     * </p>
     *
     * @param listBackupPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupPlansRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBackupPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBackupPlansResponse> listBackupPlans(
            Consumer<ListBackupPlansRequest.Builder> listBackupPlansRequest) {
        return listBackupPlans(ListBackupPlansRequest.builder().applyMutation(listBackupPlansRequest).build());
    }

    /**
     * <p>
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as
     * Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request
     * IDs.
     * </p>
     *
     * @return A Java Future containing the result of the ListBackupPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBackupPlansResponse> listBackupPlans() {
        return listBackupPlans(ListBackupPlansRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansPublisher publisher = client.listBackupPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansPublisher publisher = client.listBackupPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansPublisher listBackupPlansPaginator() {
        return listBackupPlansPaginator(ListBackupPlansRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansPublisher publisher = client.listBackupPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansPublisher publisher = client.listBackupPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation.</b>
     * </p>
     *
     * @param listBackupPlansRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansPublisher listBackupPlansPaginator(ListBackupPlansRequest listBackupPlansRequest) {
        return new ListBackupPlansPublisher(this, listBackupPlansRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansPublisher publisher = client.listBackupPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansPublisher publisher = client.listBackupPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackupPlansRequest#builder()}
     * </p>
     *
     * @param listBackupPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupPlansRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansPublisher listBackupPlansPaginator(Consumer<ListBackupPlansRequest.Builder> listBackupPlansRequest) {
        return listBackupPlansPaginator(ListBackupPlansRequest.builder().applyMutation(listBackupPlansRequest).build());
    }

    /**
     * <p>
     * Returns an array containing metadata of the resources associated with the target backup plan.
     * </p>
     *
     * @param listBackupSelectionsRequest
     * @return A Java Future containing the result of the ListBackupSelections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBackupSelectionsResponse> listBackupSelections(
            ListBackupSelectionsRequest listBackupSelectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array containing metadata of the resources associated with the target backup plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupSelectionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupSelectionsRequest#builder()}
     * </p>
     *
     * @param listBackupSelectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBackupSelections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListBackupSelectionsResponse> listBackupSelections(
            Consumer<ListBackupSelectionsRequest.Builder> listBackupSelectionsRequest) {
        return listBackupSelections(ListBackupSelectionsRequest.builder().applyMutation(listBackupSelectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupSelections(software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsPublisher publisher = client.listBackupSelectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsPublisher publisher = client.listBackupSelectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupSelections(software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBackupSelectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupSelectionsPublisher listBackupSelectionsPaginator(ListBackupSelectionsRequest listBackupSelectionsRequest) {
        return new ListBackupSelectionsPublisher(this, listBackupSelectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupSelections(software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsPublisher publisher = client.listBackupSelectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsPublisher publisher = client.listBackupSelectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupSelections(software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupSelectionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupSelectionsRequest#builder()}
     * </p>
     *
     * @param listBackupSelectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupSelectionsPublisher listBackupSelectionsPaginator(
            Consumer<ListBackupSelectionsRequest.Builder> listBackupSelectionsRequest) {
        return listBackupSelectionsPaginator(ListBackupSelectionsRequest.builder().applyMutation(listBackupSelectionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     *
     * @param listBackupVaultsRequest
     * @return A Java Future containing the result of the ListBackupVaults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupVaults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBackupVaultsResponse> listBackupVaults(ListBackupVaultsRequest listBackupVaultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupVaultsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackupVaultsRequest#builder()}
     * </p>
     *
     * @param listBackupVaultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBackupVaults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupVaults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBackupVaultsResponse> listBackupVaults(
            Consumer<ListBackupVaultsRequest.Builder> listBackupVaultsRequest) {
        return listBackupVaults(ListBackupVaultsRequest.builder().applyMutation(listBackupVaultsRequest).build());
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     *
     * @return A Java Future containing the result of the ListBackupVaults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupVaults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBackupVaultsResponse> listBackupVaults() {
        return listBackupVaults(ListBackupVaultsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsPublisher publisher = client.listBackupVaultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsPublisher publisher = client.listBackupVaultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupVaults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsPublisher listBackupVaultsPaginator() {
        return listBackupVaultsPaginator(ListBackupVaultsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsPublisher publisher = client.listBackupVaultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsPublisher publisher = client.listBackupVaultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation.</b>
     * </p>
     *
     * @param listBackupVaultsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupVaults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsPublisher listBackupVaultsPaginator(ListBackupVaultsRequest listBackupVaultsRequest) {
        return new ListBackupVaultsPublisher(this, listBackupVaultsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsPublisher publisher = client.listBackupVaultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsPublisher publisher = client.listBackupVaultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupVaultsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackupVaultsRequest#builder()}
     * </p>
     *
     * @param listBackupVaultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListBackupVaults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsPublisher listBackupVaultsPaginator(Consumer<ListBackupVaultsRequest.Builder> listBackupVaultsRequest) {
        return listBackupVaultsPaginator(ListBackupVaultsRequest.builder().applyMutation(listBackupVaultsRequest).build());
    }

    /**
     * <p>
     * This request obtains a list of copy jobs created or running within the the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     *
     * @param listCopyJobSummariesRequest
     * @return A Java Future containing the result of the ListCopyJobSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListCopyJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCopyJobSummariesResponse> listCopyJobSummaries(
            ListCopyJobSummariesRequest listCopyJobSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request obtains a list of copy jobs created or running within the the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCopyJobSummariesRequest.Builder} avoiding the
     * need to create one manually via {@link ListCopyJobSummariesRequest#builder()}
     * </p>
     *
     * @param listCopyJobSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCopyJobSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListCopyJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCopyJobSummariesResponse> listCopyJobSummaries(
            Consumer<ListCopyJobSummariesRequest.Builder> listCopyJobSummariesRequest) {
        return listCopyJobSummaries(ListCopyJobSummariesRequest.builder().applyMutation(listCopyJobSummariesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCopyJobSummaries(software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobSummariesPublisher publisher = client.listCopyJobSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobSummariesPublisher publisher = client.listCopyJobSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListCopyJobSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListCopyJobSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCopyJobSummaries(software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCopyJobSummariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListCopyJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCopyJobSummariesPublisher listCopyJobSummariesPaginator(ListCopyJobSummariesRequest listCopyJobSummariesRequest) {
        return new ListCopyJobSummariesPublisher(this, listCopyJobSummariesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCopyJobSummaries(software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobSummariesPublisher publisher = client.listCopyJobSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobSummariesPublisher publisher = client.listCopyJobSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListCopyJobSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListCopyJobSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCopyJobSummaries(software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCopyJobSummariesRequest.Builder} avoiding the
     * need to create one manually via {@link ListCopyJobSummariesRequest#builder()}
     * </p>
     *
     * @param listCopyJobSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListCopyJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCopyJobSummariesPublisher listCopyJobSummariesPaginator(
            Consumer<ListCopyJobSummariesRequest.Builder> listCopyJobSummariesRequest) {
        return listCopyJobSummariesPaginator(ListCopyJobSummariesRequest.builder().applyMutation(listCopyJobSummariesRequest)
                .build());
    }

    /**
     * <p>
     * Returns metadata about your copy jobs.
     * </p>
     *
     * @param listCopyJobsRequest
     * @return A Java Future containing the result of the ListCopyJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListCopyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCopyJobsResponse> listCopyJobs(ListCopyJobsRequest listCopyJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about your copy jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCopyJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCopyJobsRequest#builder()}
     * </p>
     *
     * @param listCopyJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListCopyJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCopyJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListCopyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCopyJobsResponse> listCopyJobs(Consumer<ListCopyJobsRequest.Builder> listCopyJobsRequest) {
        return listCopyJobs(ListCopyJobsRequest.builder().applyMutation(listCopyJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listCopyJobs(software.amazon.awssdk.services.backup.model.ListCopyJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobsPublisher publisher = client.listCopyJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobsPublisher publisher = client.listCopyJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListCopyJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListCopyJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCopyJobs(software.amazon.awssdk.services.backup.model.ListCopyJobsRequest)} operation.</b>
     * </p>
     *
     * @param listCopyJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListCopyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCopyJobsPublisher listCopyJobsPaginator(ListCopyJobsRequest listCopyJobsRequest) {
        return new ListCopyJobsPublisher(this, listCopyJobsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listCopyJobs(software.amazon.awssdk.services.backup.model.ListCopyJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobsPublisher publisher = client.listCopyJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListCopyJobsPublisher publisher = client.listCopyJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListCopyJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListCopyJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCopyJobs(software.amazon.awssdk.services.backup.model.ListCopyJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCopyJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCopyJobsRequest#builder()}
     * </p>
     *
     * @param listCopyJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListCopyJobsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListCopyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCopyJobsPublisher listCopyJobsPaginator(Consumer<ListCopyJobsRequest.Builder> listCopyJobsRequest) {
        return listCopyJobsPaginator(ListCopyJobsRequest.builder().applyMutation(listCopyJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
     * </p>
     *
     * @param listFrameworksRequest
     * @return A Java Future containing the result of the ListFrameworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListFrameworks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFrameworksResponse> listFrameworks(ListFrameworksRequest listFrameworksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFrameworksRequest.Builder} avoiding the need to
     * create one manually via {@link ListFrameworksRequest#builder()}
     * </p>
     *
     * @param listFrameworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListFrameworksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFrameworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListFrameworks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFrameworksResponse> listFrameworks(Consumer<ListFrameworksRequest.Builder> listFrameworksRequest) {
        return listFrameworks(ListFrameworksRequest.builder().applyMutation(listFrameworksRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFrameworks(software.amazon.awssdk.services.backup.model.ListFrameworksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListFrameworksPublisher publisher = client.listFrameworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListFrameworksPublisher publisher = client.listFrameworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListFrameworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListFrameworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFrameworks(software.amazon.awssdk.services.backup.model.ListFrameworksRequest)} operation.</b>
     * </p>
     *
     * @param listFrameworksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListFrameworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFrameworksPublisher listFrameworksPaginator(ListFrameworksRequest listFrameworksRequest) {
        return new ListFrameworksPublisher(this, listFrameworksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFrameworks(software.amazon.awssdk.services.backup.model.ListFrameworksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListFrameworksPublisher publisher = client.listFrameworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListFrameworksPublisher publisher = client.listFrameworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListFrameworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListFrameworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFrameworks(software.amazon.awssdk.services.backup.model.ListFrameworksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFrameworksRequest.Builder} avoiding the need to
     * create one manually via {@link ListFrameworksRequest#builder()}
     * </p>
     *
     * @param listFrameworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListFrameworksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListFrameworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFrameworksPublisher listFrameworksPaginator(Consumer<ListFrameworksRequest.Builder> listFrameworksRequest) {
        return listFrameworksPaginator(ListFrameworksRequest.builder().applyMutation(listFrameworksRequest).build());
    }

    /**
     * <p>
     * This action returns metadata about active and previous legal holds.
     * </p>
     *
     * @param listLegalHoldsRequest
     * @return A Java Future containing the result of the ListLegalHolds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListLegalHolds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListLegalHolds" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLegalHoldsResponse> listLegalHolds(ListLegalHoldsRequest listLegalHoldsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action returns metadata about active and previous legal holds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLegalHoldsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLegalHoldsRequest#builder()}
     * </p>
     *
     * @param listLegalHoldsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListLegalHolds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListLegalHolds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListLegalHolds" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLegalHoldsResponse> listLegalHolds(Consumer<ListLegalHoldsRequest.Builder> listLegalHoldsRequest) {
        return listLegalHolds(ListLegalHoldsRequest.builder().applyMutation(listLegalHoldsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listLegalHolds(software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListLegalHoldsPublisher publisher = client.listLegalHoldsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListLegalHoldsPublisher publisher = client.listLegalHoldsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLegalHolds(software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest)} operation.</b>
     * </p>
     *
     * @param listLegalHoldsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListLegalHolds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListLegalHolds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLegalHoldsPublisher listLegalHoldsPaginator(ListLegalHoldsRequest listLegalHoldsRequest) {
        return new ListLegalHoldsPublisher(this, listLegalHoldsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listLegalHolds(software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListLegalHoldsPublisher publisher = client.listLegalHoldsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListLegalHoldsPublisher publisher = client.listLegalHoldsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLegalHolds(software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLegalHoldsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLegalHoldsRequest#builder()}
     * </p>
     *
     * @param listLegalHoldsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListLegalHolds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListLegalHolds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLegalHoldsPublisher listLegalHoldsPaginator(Consumer<ListLegalHoldsRequest.Builder> listLegalHoldsRequest) {
        return listLegalHoldsPaginator(ListLegalHoldsRequest.builder().applyMutation(listLegalHoldsRequest).build());
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     *
     * @param listProtectedResourcesRequest
     * @return A Java Future containing the result of the ListProtectedResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListProtectedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListProtectedResourcesResponse> listProtectedResources(
            ListProtectedResourcesRequest listProtectedResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectedResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProtectedResourcesRequest#builder()}
     * </p>
     *
     * @param listProtectedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListProtectedResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListProtectedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListProtectedResourcesResponse> listProtectedResources(
            Consumer<ListProtectedResourcesRequest.Builder> listProtectedResourcesRequest) {
        return listProtectedResources(ListProtectedResourcesRequest.builder().applyMutation(listProtectedResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     *
     * @return A Java Future containing the result of the ListProtectedResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListProtectedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListProtectedResourcesResponse> listProtectedResources() {
        return listProtectedResources(ListProtectedResourcesRequest.builder().build());
    }

    /**
     * <p>
     * This request lists the protected resources corresponding to each backup vault.
     * </p>
     *
     * @param listProtectedResourcesByBackupVaultRequest
     * @return A Java Future containing the result of the ListProtectedResourcesByBackupVault operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListProtectedResourcesByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResourcesByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProtectedResourcesByBackupVaultResponse> listProtectedResourcesByBackupVault(
            ListProtectedResourcesByBackupVaultRequest listProtectedResourcesByBackupVaultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request lists the protected resources corresponding to each backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectedResourcesByBackupVaultRequest.Builder}
     * avoiding the need to create one manually via {@link ListProtectedResourcesByBackupVaultRequest#builder()}
     * </p>
     *
     * @param listProtectedResourcesByBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListProtectedResourcesByBackupVault operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListProtectedResourcesByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResourcesByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProtectedResourcesByBackupVaultResponse> listProtectedResourcesByBackupVault(
            Consumer<ListProtectedResourcesByBackupVaultRequest.Builder> listProtectedResourcesByBackupVaultRequest) {
        return listProtectedResourcesByBackupVault(ListProtectedResourcesByBackupVaultRequest.builder()
                .applyMutation(listProtectedResourcesByBackupVaultRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProtectedResourcesByBackupVault(software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesByBackupVaultPublisher publisher = client.listProtectedResourcesByBackupVaultPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesByBackupVaultPublisher publisher = client.listProtectedResourcesByBackupVaultPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedResourcesByBackupVault(software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProtectedResourcesByBackupVaultRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListProtectedResourcesByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResourcesByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProtectedResourcesByBackupVaultPublisher listProtectedResourcesByBackupVaultPaginator(
            ListProtectedResourcesByBackupVaultRequest listProtectedResourcesByBackupVaultRequest) {
        return new ListProtectedResourcesByBackupVaultPublisher(this, listProtectedResourcesByBackupVaultRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProtectedResourcesByBackupVault(software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesByBackupVaultPublisher publisher = client.listProtectedResourcesByBackupVaultPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesByBackupVaultPublisher publisher = client.listProtectedResourcesByBackupVaultPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedResourcesByBackupVault(software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectedResourcesByBackupVaultRequest.Builder}
     * avoiding the need to create one manually via {@link ListProtectedResourcesByBackupVaultRequest#builder()}
     * </p>
     *
     * @param listProtectedResourcesByBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListProtectedResourcesByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResourcesByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProtectedResourcesByBackupVaultPublisher listProtectedResourcesByBackupVaultPaginator(
            Consumer<ListProtectedResourcesByBackupVaultRequest.Builder> listProtectedResourcesByBackupVaultRequest) {
        return listProtectedResourcesByBackupVaultPaginator(ListProtectedResourcesByBackupVaultRequest.builder()
                .applyMutation(listProtectedResourcesByBackupVaultRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesPublisher publisher = client.listProtectedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesPublisher publisher = client.listProtectedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListProtectedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesPublisher listProtectedResourcesPaginator() {
        return listProtectedResourcesPaginator(ListProtectedResourcesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesPublisher publisher = client.listProtectedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesPublisher publisher = client.listProtectedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProtectedResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListProtectedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesPublisher listProtectedResourcesPaginator(
            ListProtectedResourcesRequest listProtectedResourcesRequest) {
        return new ListProtectedResourcesPublisher(this, listProtectedResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesPublisher publisher = client.listProtectedResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesPublisher publisher = client.listProtectedResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectedResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProtectedResourcesRequest#builder()}
     * </p>
     *
     * @param listProtectedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListProtectedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesPublisher listProtectedResourcesPaginator(
            Consumer<ListProtectedResourcesRequest.Builder> listProtectedResourcesRequest) {
        return listProtectedResourcesPaginator(ListProtectedResourcesRequest.builder()
                .applyMutation(listProtectedResourcesRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about the recovery points stored in a backup vault.
     * </p>
     *
     * @param listRecoveryPointsByBackupVaultRequest
     * @return A Java Future containing the result of the ListRecoveryPointsByBackupVault operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecoveryPointsByBackupVaultResponse> listRecoveryPointsByBackupVault(
            ListRecoveryPointsByBackupVaultRequest listRecoveryPointsByBackupVaultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about the recovery points stored in a backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByBackupVaultRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByBackupVaultRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListRecoveryPointsByBackupVault operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecoveryPointsByBackupVaultResponse> listRecoveryPointsByBackupVault(
            Consumer<ListRecoveryPointsByBackupVaultRequest.Builder> listRecoveryPointsByBackupVaultRequest) {
        return listRecoveryPointsByBackupVault(ListRecoveryPointsByBackupVaultRequest.builder()
                .applyMutation(listRecoveryPointsByBackupVaultRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByBackupVault(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultPublisher publisher = client.listRecoveryPointsByBackupVaultPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultPublisher publisher = client.listRecoveryPointsByBackupVaultPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByBackupVault(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecoveryPointsByBackupVaultRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByBackupVaultPublisher listRecoveryPointsByBackupVaultPaginator(
            ListRecoveryPointsByBackupVaultRequest listRecoveryPointsByBackupVaultRequest) {
        return new ListRecoveryPointsByBackupVaultPublisher(this, listRecoveryPointsByBackupVaultRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByBackupVault(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultPublisher publisher = client.listRecoveryPointsByBackupVaultPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultPublisher publisher = client.listRecoveryPointsByBackupVaultPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByBackupVault(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByBackupVaultRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByBackupVaultRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByBackupVaultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByBackupVaultPublisher listRecoveryPointsByBackupVaultPaginator(
            Consumer<ListRecoveryPointsByBackupVaultRequest.Builder> listRecoveryPointsByBackupVaultRequest) {
        return listRecoveryPointsByBackupVaultPaginator(ListRecoveryPointsByBackupVaultRequest.builder()
                .applyMutation(listRecoveryPointsByBackupVaultRequest).build());
    }

    /**
     * <p>
     * This action returns recovery point ARNs (Amazon Resource Names) of the specified legal hold.
     * </p>
     *
     * @param listRecoveryPointsByLegalHoldRequest
     * @return A Java Future containing the result of the ListRecoveryPointsByLegalHold operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByLegalHold"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecoveryPointsByLegalHoldResponse> listRecoveryPointsByLegalHold(
            ListRecoveryPointsByLegalHoldRequest listRecoveryPointsByLegalHoldRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action returns recovery point ARNs (Amazon Resource Names) of the specified legal hold.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByLegalHoldRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByLegalHoldRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByLegalHoldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListRecoveryPointsByLegalHold operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByLegalHold"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecoveryPointsByLegalHoldResponse> listRecoveryPointsByLegalHold(
            Consumer<ListRecoveryPointsByLegalHoldRequest.Builder> listRecoveryPointsByLegalHoldRequest) {
        return listRecoveryPointsByLegalHold(ListRecoveryPointsByLegalHoldRequest.builder()
                .applyMutation(listRecoveryPointsByLegalHoldRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByLegalHold(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByLegalHoldPublisher publisher = client.listRecoveryPointsByLegalHoldPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByLegalHoldPublisher publisher = client.listRecoveryPointsByLegalHoldPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByLegalHold(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecoveryPointsByLegalHoldRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByLegalHold"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByLegalHoldPublisher listRecoveryPointsByLegalHoldPaginator(
            ListRecoveryPointsByLegalHoldRequest listRecoveryPointsByLegalHoldRequest) {
        return new ListRecoveryPointsByLegalHoldPublisher(this, listRecoveryPointsByLegalHoldRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByLegalHold(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByLegalHoldPublisher publisher = client.listRecoveryPointsByLegalHoldPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByLegalHoldPublisher publisher = client.listRecoveryPointsByLegalHoldPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByLegalHold(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByLegalHoldRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByLegalHoldRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByLegalHoldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByLegalHold"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByLegalHoldPublisher listRecoveryPointsByLegalHoldPaginator(
            Consumer<ListRecoveryPointsByLegalHoldRequest.Builder> listRecoveryPointsByLegalHoldRequest) {
        return listRecoveryPointsByLegalHoldPaginator(ListRecoveryPointsByLegalHoldRequest.builder()
                .applyMutation(listRecoveryPointsByLegalHoldRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource
     * Name (ARN).
     * </p>
     * <note>
     * <p>
     * For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.
     * </p>
     * </note>
     *
     * @param listRecoveryPointsByResourceRequest
     * @return A Java Future containing the result of the ListRecoveryPointsByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecoveryPointsByResourceResponse> listRecoveryPointsByResource(
            ListRecoveryPointsByResourceRequest listRecoveryPointsByResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource
     * Name (ARN).
     * </p>
     * <note>
     * <p>
     * For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByResourceRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListRecoveryPointsByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecoveryPointsByResourceResponse> listRecoveryPointsByResource(
            Consumer<ListRecoveryPointsByResourceRequest.Builder> listRecoveryPointsByResourceRequest) {
        return listRecoveryPointsByResource(ListRecoveryPointsByResourceRequest.builder()
                .applyMutation(listRecoveryPointsByResourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByResource(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourcePublisher publisher = client.listRecoveryPointsByResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourcePublisher publisher = client.listRecoveryPointsByResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByResource(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecoveryPointsByResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByResourcePublisher listRecoveryPointsByResourcePaginator(
            ListRecoveryPointsByResourceRequest listRecoveryPointsByResourceRequest) {
        return new ListRecoveryPointsByResourcePublisher(this, listRecoveryPointsByResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByResource(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourcePublisher publisher = client.listRecoveryPointsByResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourcePublisher publisher = client.listRecoveryPointsByResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByResource(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByResourceRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRecoveryPointsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByResourcePublisher listRecoveryPointsByResourcePaginator(
            Consumer<ListRecoveryPointsByResourceRequest.Builder> listRecoveryPointsByResourceRequest) {
        return listRecoveryPointsByResourcePaginator(ListRecoveryPointsByResourceRequest.builder()
                .applyMutation(listRecoveryPointsByResourceRequest).build());
    }

    /**
     * <p>
     * Returns details about your report jobs.
     * </p>
     *
     * @param listReportJobsRequest
     * @return A Java Future containing the result of the ListReportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListReportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReportJobsResponse> listReportJobs(ListReportJobsRequest listReportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about your report jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListReportJobsRequest#builder()}
     * </p>
     *
     * @param listReportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListReportJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListReportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListReportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReportJobsResponse> listReportJobs(Consumer<ListReportJobsRequest.Builder> listReportJobsRequest) {
        return listReportJobs(ListReportJobsRequest.builder().applyMutation(listReportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listReportJobs(software.amazon.awssdk.services.backup.model.ListReportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportJobsPublisher publisher = client.listReportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportJobsPublisher publisher = client.listReportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListReportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListReportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReportJobs(software.amazon.awssdk.services.backup.model.ListReportJobsRequest)} operation.</b>
     * </p>
     *
     * @param listReportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListReportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportJobsPublisher listReportJobsPaginator(ListReportJobsRequest listReportJobsRequest) {
        return new ListReportJobsPublisher(this, listReportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listReportJobs(software.amazon.awssdk.services.backup.model.ListReportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportJobsPublisher publisher = client.listReportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportJobsPublisher publisher = client.listReportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListReportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListReportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReportJobs(software.amazon.awssdk.services.backup.model.ListReportJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListReportJobsRequest#builder()}
     * </p>
     *
     * @param listReportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListReportJobsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListReportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportJobsPublisher listReportJobsPaginator(Consumer<ListReportJobsRequest.Builder> listReportJobsRequest) {
        return listReportJobsPaginator(ListReportJobsRequest.builder().applyMutation(listReportJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of your report plans. For detailed information about a single report plan, use
     * <code>DescribeReportPlan</code>.
     * </p>
     *
     * @param listReportPlansRequest
     * @return A Java Future containing the result of the ListReportPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListReportPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReportPlansResponse> listReportPlans(ListReportPlansRequest listReportPlansRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of your report plans. For detailed information about a single report plan, use
     * <code>DescribeReportPlan</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportPlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListReportPlansRequest#builder()}
     * </p>
     *
     * @param listReportPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListReportPlansRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListReportPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListReportPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReportPlansResponse> listReportPlans(
            Consumer<ListReportPlansRequest.Builder> listReportPlansRequest) {
        return listReportPlans(ListReportPlansRequest.builder().applyMutation(listReportPlansRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReportPlans(software.amazon.awssdk.services.backup.model.ListReportPlansRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportPlansPublisher publisher = client.listReportPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportPlansPublisher publisher = client.listReportPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListReportPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListReportPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReportPlans(software.amazon.awssdk.services.backup.model.ListReportPlansRequest)} operation.</b>
     * </p>
     *
     * @param listReportPlansRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListReportPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportPlansPublisher listReportPlansPaginator(ListReportPlansRequest listReportPlansRequest) {
        return new ListReportPlansPublisher(this, listReportPlansRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReportPlans(software.amazon.awssdk.services.backup.model.ListReportPlansRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportPlansPublisher publisher = client.listReportPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListReportPlansPublisher publisher = client.listReportPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListReportPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListReportPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReportPlans(software.amazon.awssdk.services.backup.model.ListReportPlansRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportPlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListReportPlansRequest#builder()}
     * </p>
     *
     * @param listReportPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListReportPlansRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListReportPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReportPlansPublisher listReportPlansPaginator(Consumer<ListReportPlansRequest.Builder> listReportPlansRequest) {
        return listReportPlansPaginator(ListReportPlansRequest.builder().applyMutation(listReportPlansRequest).build());
    }

    /**
     * <p>
     * This request obtains a summary of restore jobs created or running within the the most recent 30 days. You can
     * include parameters AccountID, State, ResourceType, AggregationPeriod, MaxResults, or NextToken to filter results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     *
     * @param listRestoreJobSummariesRequest
     * @return A Java Future containing the result of the ListRestoreJobSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRestoreJobSummariesResponse> listRestoreJobSummaries(
            ListRestoreJobSummariesRequest listRestoreJobSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request obtains a summary of restore jobs created or running within the the most recent 30 days. You can
     * include parameters AccountID, State, ResourceType, AggregationPeriod, MaxResults, or NextToken to filter results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreJobSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListRestoreJobSummariesRequest#builder()}
     * </p>
     *
     * @param listRestoreJobSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRestoreJobSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRestoreJobSummariesResponse> listRestoreJobSummaries(
            Consumer<ListRestoreJobSummariesRequest.Builder> listRestoreJobSummariesRequest) {
        return listRestoreJobSummaries(ListRestoreJobSummariesRequest.builder().applyMutation(listRestoreJobSummariesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRestoreJobSummaries(software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobSummariesPublisher publisher = client.listRestoreJobSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobSummariesPublisher publisher = client.listRestoreJobSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobSummaries(software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRestoreJobSummariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRestoreJobSummariesPublisher listRestoreJobSummariesPaginator(
            ListRestoreJobSummariesRequest listRestoreJobSummariesRequest) {
        return new ListRestoreJobSummariesPublisher(this, listRestoreJobSummariesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRestoreJobSummaries(software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobSummariesPublisher publisher = client.listRestoreJobSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobSummariesPublisher publisher = client.listRestoreJobSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobSummaries(software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreJobSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListRestoreJobSummariesRequest#builder()}
     * </p>
     *
     * @param listRestoreJobSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRestoreJobSummariesPublisher listRestoreJobSummariesPaginator(
            Consumer<ListRestoreJobSummariesRequest.Builder> listRestoreJobSummariesRequest) {
        return listRestoreJobSummariesPaginator(ListRestoreJobSummariesRequest.builder()
                .applyMutation(listRestoreJobSummariesRequest).build());
    }

    /**
     * <p>
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery
     * process.
     * </p>
     *
     * @param listRestoreJobsRequest
     * @return A Java Future containing the result of the ListRestoreJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRestoreJobsResponse> listRestoreJobs(ListRestoreJobsRequest listRestoreJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery
     * process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRestoreJobsRequest#builder()}
     * </p>
     *
     * @param listRestoreJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRestoreJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRestoreJobsResponse> listRestoreJobs(
            Consumer<ListRestoreJobsRequest.Builder> listRestoreJobsRequest) {
        return listRestoreJobs(ListRestoreJobsRequest.builder().applyMutation(listRestoreJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery
     * process.
     * </p>
     *
     * @return A Java Future containing the result of the ListRestoreJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRestoreJobsResponse> listRestoreJobs() {
        return listRestoreJobs(ListRestoreJobsRequest.builder().build());
    }

    /**
     * <p>
     * This returns restore jobs that contain the specified protected resource.
     * </p>
     * <p>
     * You must include <code>ResourceArn</code>. You can optionally include <code>NextToken</code>,
     * <code>ByStatus</code>, <code>MaxResults</code>, <code>ByRecoveryPointCreationDateAfter</code> , and
     * <code>ByRecoveryPointCreationDateBefore</code>.
     * </p>
     *
     * @param listRestoreJobsByProtectedResourceRequest
     * @return A Java Future containing the result of the ListRestoreJobsByProtectedResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobsByProtectedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobsByProtectedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRestoreJobsByProtectedResourceResponse> listRestoreJobsByProtectedResource(
            ListRestoreJobsByProtectedResourceRequest listRestoreJobsByProtectedResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This returns restore jobs that contain the specified protected resource.
     * </p>
     * <p>
     * You must include <code>ResourceArn</code>. You can optionally include <code>NextToken</code>,
     * <code>ByStatus</code>, <code>MaxResults</code>, <code>ByRecoveryPointCreationDateAfter</code> , and
     * <code>ByRecoveryPointCreationDateBefore</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreJobsByProtectedResourceRequest.Builder}
     * avoiding the need to create one manually via {@link ListRestoreJobsByProtectedResourceRequest#builder()}
     * </p>
     *
     * @param listRestoreJobsByProtectedResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListRestoreJobsByProtectedResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobsByProtectedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobsByProtectedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRestoreJobsByProtectedResourceResponse> listRestoreJobsByProtectedResource(
            Consumer<ListRestoreJobsByProtectedResourceRequest.Builder> listRestoreJobsByProtectedResourceRequest) {
        return listRestoreJobsByProtectedResource(ListRestoreJobsByProtectedResourceRequest.builder()
                .applyMutation(listRestoreJobsByProtectedResourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRestoreJobsByProtectedResource(software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsByProtectedResourcePublisher publisher = client.listRestoreJobsByProtectedResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsByProtectedResourcePublisher publisher = client.listRestoreJobsByProtectedResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobsByProtectedResource(software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRestoreJobsByProtectedResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobsByProtectedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobsByProtectedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRestoreJobsByProtectedResourcePublisher listRestoreJobsByProtectedResourcePaginator(
            ListRestoreJobsByProtectedResourceRequest listRestoreJobsByProtectedResourceRequest) {
        return new ListRestoreJobsByProtectedResourcePublisher(this, listRestoreJobsByProtectedResourceRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRestoreJobsByProtectedResource(software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsByProtectedResourcePublisher publisher = client.listRestoreJobsByProtectedResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsByProtectedResourcePublisher publisher = client.listRestoreJobsByProtectedResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobsByProtectedResource(software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreJobsByProtectedResourceRequest.Builder}
     * avoiding the need to create one manually via {@link ListRestoreJobsByProtectedResourceRequest#builder()}
     * </p>
     *
     * @param listRestoreJobsByProtectedResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobsByProtectedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobsByProtectedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRestoreJobsByProtectedResourcePublisher listRestoreJobsByProtectedResourcePaginator(
            Consumer<ListRestoreJobsByProtectedResourceRequest.Builder> listRestoreJobsByProtectedResourceRequest) {
        return listRestoreJobsByProtectedResourcePaginator(ListRestoreJobsByProtectedResourceRequest.builder()
                .applyMutation(listRestoreJobsByProtectedResourceRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsPublisher publisher = client.listRestoreJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsPublisher publisher = client.listRestoreJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsPublisher listRestoreJobsPaginator() {
        return listRestoreJobsPaginator(ListRestoreJobsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsPublisher publisher = client.listRestoreJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsPublisher publisher = client.listRestoreJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation.</b>
     * </p>
     *
     * @param listRestoreJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsPublisher listRestoreJobsPaginator(ListRestoreJobsRequest listRestoreJobsRequest) {
        return new ListRestoreJobsPublisher(this, listRestoreJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsPublisher publisher = client.listRestoreJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsPublisher publisher = client.listRestoreJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRestoreJobsRequest#builder()}
     * </p>
     *
     * @param listRestoreJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsPublisher listRestoreJobsPaginator(Consumer<ListRestoreJobsRequest.Builder> listRestoreJobsRequest) {
        return listRestoreJobsPaginator(ListRestoreJobsRequest.builder().applyMutation(listRestoreJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of restore testing plans.
     * </p>
     *
     * @param listRestoreTestingPlansRequest
     * @return A Java Future containing the result of the ListRestoreTestingPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreTestingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRestoreTestingPlansResponse> listRestoreTestingPlans(
            ListRestoreTestingPlansRequest listRestoreTestingPlansRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of restore testing plans.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreTestingPlansRequest.Builder} avoiding
     * the need to create one manually via {@link ListRestoreTestingPlansRequest#builder()}
     * </p>
     *
     * @param listRestoreTestingPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRestoreTestingPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreTestingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRestoreTestingPlansResponse> listRestoreTestingPlans(
            Consumer<ListRestoreTestingPlansRequest.Builder> listRestoreTestingPlansRequest) {
        return listRestoreTestingPlans(ListRestoreTestingPlansRequest.builder().applyMutation(listRestoreTestingPlansRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRestoreTestingPlans(software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreTestingPlansPublisher publisher = client.listRestoreTestingPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreTestingPlansPublisher publisher = client.listRestoreTestingPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreTestingPlans(software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRestoreTestingPlansRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreTestingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRestoreTestingPlansPublisher listRestoreTestingPlansPaginator(
            ListRestoreTestingPlansRequest listRestoreTestingPlansRequest) {
        return new ListRestoreTestingPlansPublisher(this, listRestoreTestingPlansRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRestoreTestingPlans(software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreTestingPlansPublisher publisher = client.listRestoreTestingPlansPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreTestingPlansPublisher publisher = client.listRestoreTestingPlansPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreTestingPlans(software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreTestingPlansRequest.Builder} avoiding
     * the need to create one manually via {@link ListRestoreTestingPlansRequest#builder()}
     * </p>
     *
     * @param listRestoreTestingPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreTestingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRestoreTestingPlansPublisher listRestoreTestingPlansPaginator(
            Consumer<ListRestoreTestingPlansRequest.Builder> listRestoreTestingPlansRequest) {
        return listRestoreTestingPlansPaginator(ListRestoreTestingPlansRequest.builder()
                .applyMutation(listRestoreTestingPlansRequest).build());
    }

    /**
     * <p>
     * Returns a list of restore testing selections. Can be filtered by <code>MaxResults</code> and
     * <code>RestoreTestingPlanName</code>.
     * </p>
     *
     * @param listRestoreTestingSelectionsRequest
     * @return A Java Future containing the result of the ListRestoreTestingSelections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreTestingSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingSelections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRestoreTestingSelectionsResponse> listRestoreTestingSelections(
            ListRestoreTestingSelectionsRequest listRestoreTestingSelectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of restore testing selections. Can be filtered by <code>MaxResults</code> and
     * <code>RestoreTestingPlanName</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreTestingSelectionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListRestoreTestingSelectionsRequest#builder()}
     * </p>
     *
     * @param listRestoreTestingSelectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListRestoreTestingSelections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreTestingSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingSelections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRestoreTestingSelectionsResponse> listRestoreTestingSelections(
            Consumer<ListRestoreTestingSelectionsRequest.Builder> listRestoreTestingSelectionsRequest) {
        return listRestoreTestingSelections(ListRestoreTestingSelectionsRequest.builder()
                .applyMutation(listRestoreTestingSelectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRestoreTestingSelections(software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreTestingSelectionsPublisher publisher = client.listRestoreTestingSelectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreTestingSelectionsPublisher publisher = client.listRestoreTestingSelectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreTestingSelections(software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRestoreTestingSelectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreTestingSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingSelections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRestoreTestingSelectionsPublisher listRestoreTestingSelectionsPaginator(
            ListRestoreTestingSelectionsRequest listRestoreTestingSelectionsRequest) {
        return new ListRestoreTestingSelectionsPublisher(this, listRestoreTestingSelectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRestoreTestingSelections(software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreTestingSelectionsPublisher publisher = client.listRestoreTestingSelectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreTestingSelectionsPublisher publisher = client.listRestoreTestingSelectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreTestingSelections(software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreTestingSelectionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListRestoreTestingSelectionsRequest#builder()}
     * </p>
     *
     * @param listRestoreTestingSelectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListRestoreTestingSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingSelections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRestoreTestingSelectionsPublisher listRestoreTestingSelectionsPaginator(
            Consumer<ListRestoreTestingSelectionsRequest.Builder> listRestoreTestingSelectionsRequest) {
        return listRestoreTestingSelectionsPaginator(ListRestoreTestingSelectionsRequest.builder()
                .applyMutation(listRestoreTestingSelectionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     * </p>
     * <p>
     * <code>ListTags</code> only works for resource types that support full Backup management of their backups. Those
     * resource types are listed in the "Full Backup management" section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table.
     * </p>
     *
     * @param listTagsRequest
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     * </p>
     * <p>
     * <code>ListTags</code> only works for resource types that support full Backup management of their backups. Those
     * resource types are listed in the "Full Backup management" section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.backup.model.ListTagsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.backup.model.ListTagsRequest)} operation.</b>
     * </p>
     *
     * @param listTagsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsPublisher listTagsPaginator(ListTagsRequest listTagsRequest) {
        return new ListTagsPublisher(this, listTagsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.backup.model.ListTagsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backup.model.ListTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backup.model.ListTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.backup.model.ListTagsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.ListTagsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsPublisher listTagsPaginator(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTagsPaginator(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a
     * backup vault name and an access policy document in JSON format.
     * </p>
     *
     * @param putBackupVaultAccessPolicyRequest
     * @return A Java Future containing the result of the PutBackupVaultAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.PutBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutBackupVaultAccessPolicyResponse> putBackupVaultAccessPolicy(
            PutBackupVaultAccessPolicyRequest putBackupVaultAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a
     * backup vault name and an access policy document in JSON format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBackupVaultAccessPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link PutBackupVaultAccessPolicyRequest#builder()}
     * </p>
     *
     * @param putBackupVaultAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutBackupVaultAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.PutBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutBackupVaultAccessPolicyResponse> putBackupVaultAccessPolicy(
            Consumer<PutBackupVaultAccessPolicyRequest.Builder> putBackupVaultAccessPolicyRequest) {
        return putBackupVaultAccessPolicy(PutBackupVaultAccessPolicyRequest.builder()
                .applyMutation(putBackupVaultAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or
     * created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the
     * retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a
     * minimum and maximum retention period for future backup and copy jobs that target a backup vault.
     * </p>
     * <note>
     * <p>
     * Backup Vault Lock has been assessed by Cohasset Associates for use in environments that are subject to SEC 17a-4,
     * CFTC, and FINRA regulations. For more information about how Backup Vault Lock relates to these regulations, see
     * the <a href="samples/cohassetreport.zip">Cohasset Associates Compliance Assessment.</a>
     * </p>
     * </note>
     *
     * @param putBackupVaultLockConfigurationRequest
     * @return A Java Future containing the result of the PutBackupVaultLockConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.PutBackupVaultLockConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultLockConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutBackupVaultLockConfigurationResponse> putBackupVaultLockConfiguration(
            PutBackupVaultLockConfigurationRequest putBackupVaultLockConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or
     * created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the
     * retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a
     * minimum and maximum retention period for future backup and copy jobs that target a backup vault.
     * </p>
     * <note>
     * <p>
     * Backup Vault Lock has been assessed by Cohasset Associates for use in environments that are subject to SEC 17a-4,
     * CFTC, and FINRA regulations. For more information about how Backup Vault Lock relates to these regulations, see
     * the <a href="samples/cohassetreport.zip">Cohasset Associates Compliance Assessment.</a>
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBackupVaultLockConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutBackupVaultLockConfigurationRequest#builder()}
     * </p>
     *
     * @param putBackupVaultLockConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the PutBackupVaultLockConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.PutBackupVaultLockConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultLockConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutBackupVaultLockConfigurationResponse> putBackupVaultLockConfiguration(
            Consumer<PutBackupVaultLockConfigurationRequest.Builder> putBackupVaultLockConfigurationRequest) {
        return putBackupVaultLockConfiguration(PutBackupVaultLockConfigurationRequest.builder()
                .applyMutation(putBackupVaultLockConfigurationRequest).build());
    }

    /**
     * <p>
     * Turns on notifications on a backup vault for the specified topic and events.
     * </p>
     *
     * @param putBackupVaultNotificationsRequest
     * @return A Java Future containing the result of the PutBackupVaultNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.PutBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutBackupVaultNotificationsResponse> putBackupVaultNotifications(
            PutBackupVaultNotificationsRequest putBackupVaultNotificationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Turns on notifications on a backup vault for the specified topic and events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBackupVaultNotificationsRequest.Builder}
     * avoiding the need to create one manually via {@link PutBackupVaultNotificationsRequest#builder()}
     * </p>
     *
     * @param putBackupVaultNotificationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutBackupVaultNotifications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.PutBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutBackupVaultNotificationsResponse> putBackupVaultNotifications(
            Consumer<PutBackupVaultNotificationsRequest.Builder> putBackupVaultNotificationsRequest) {
        return putBackupVaultNotifications(PutBackupVaultNotificationsRequest.builder()
                .applyMutation(putBackupVaultNotificationsRequest).build());
    }

    /**
     * <p>
     * This request allows you to send your independent self-run restore test validation results.
     * <code>RestoreJobId</code> and <code>ValidationStatus</code> are required. Optionally, you can input a
     * <code>ValidationStatusMessage</code>.
     * </p>
     *
     * @param putRestoreValidationResultRequest
     * @return A Java Future containing the result of the PutRestoreValidationResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.PutRestoreValidationResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutRestoreValidationResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRestoreValidationResultResponse> putRestoreValidationResult(
            PutRestoreValidationResultRequest putRestoreValidationResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request allows you to send your independent self-run restore test validation results.
     * <code>RestoreJobId</code> and <code>ValidationStatus</code> are required. Optionally, you can input a
     * <code>ValidationStatusMessage</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRestoreValidationResultRequest.Builder} avoiding
     * the need to create one manually via {@link PutRestoreValidationResultRequest#builder()}
     * </p>
     *
     * @param putRestoreValidationResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.PutRestoreValidationResultRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutRestoreValidationResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.PutRestoreValidationResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutRestoreValidationResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRestoreValidationResultResponse> putRestoreValidationResult(
            Consumer<PutRestoreValidationResultRequest.Builder> putRestoreValidationResultRequest) {
        return putRestoreValidationResult(PutRestoreValidationResultRequest.builder()
                .applyMutation(putRestoreValidationResultRequest).build());
    }

    /**
     * <p>
     * Starts an on-demand backup job for the specified resource.
     * </p>
     *
     * @param startBackupJobRequest
     * @return A Java Future containing the result of the StartBackupJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StartBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartBackupJobResponse> startBackupJob(StartBackupJobRequest startBackupJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an on-demand backup job for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartBackupJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartBackupJobRequest#builder()}
     * </p>
     *
     * @param startBackupJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.StartBackupJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartBackupJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StartBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartBackupJobResponse> startBackupJob(Consumer<StartBackupJobRequest.Builder> startBackupJobRequest) {
        return startBackupJob(StartBackupJobRequest.builder().applyMutation(startBackupJobRequest).build());
    }

    /**
     * <p>
     * Starts a job to create a one-time copy of the specified resource.
     * </p>
     * <p>
     * Does not support continuous backups.
     * </p>
     *
     * @param startCopyJobRequest
     * @return A Java Future containing the result of the StartCopyJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StartCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartCopyJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartCopyJobResponse> startCopyJob(StartCopyJobRequest startCopyJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a job to create a one-time copy of the specified resource.
     * </p>
     * <p>
     * Does not support continuous backups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCopyJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartCopyJobRequest#builder()}
     * </p>
     *
     * @param startCopyJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.StartCopyJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartCopyJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StartCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartCopyJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartCopyJobResponse> startCopyJob(Consumer<StartCopyJobRequest.Builder> startCopyJobRequest) {
        return startCopyJob(StartCopyJobRequest.builder().applyMutation(startCopyJobRequest).build());
    }

    /**
     * <p>
     * Starts an on-demand report job for the specified report plan.
     * </p>
     *
     * @param startReportJobRequest
     * @return A Java Future containing the result of the StartReportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StartReportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartReportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartReportJobResponse> startReportJob(StartReportJobRequest startReportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an on-demand report job for the specified report plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReportJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartReportJobRequest#builder()}
     * </p>
     *
     * @param startReportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.StartReportJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartReportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StartReportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartReportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartReportJobResponse> startReportJob(Consumer<StartReportJobRequest.Builder> startReportJobRequest) {
        return startReportJob(StartReportJobRequest.builder().applyMutation(startReportJobRequest).build());
    }

    /**
     * <p>
     * Recovers the saved resource identified by an Amazon Resource Name (ARN).
     * </p>
     *
     * @param startRestoreJobRequest
     * @return A Java Future containing the result of the StartRestoreJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StartRestoreJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartRestoreJobResponse> startRestoreJob(StartRestoreJobRequest startRestoreJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Recovers the saved resource identified by an Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRestoreJobRequest.Builder} avoiding the need
     * to create one manually via {@link StartRestoreJobRequest#builder()}
     * </p>
     *
     * @param startRestoreJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.StartRestoreJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartRestoreJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StartRestoreJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartRestoreJobResponse> startRestoreJob(
            Consumer<StartRestoreJobRequest.Builder> startRestoreJobRequest) {
        return startRestoreJob(StartRestoreJobRequest.builder().applyMutation(startRestoreJobRequest).build());
    }

    /**
     * <p>
     * Attempts to cancel a job to create a one-time backup of a resource.
     * </p>
     * <p>
     * This action is not supported for the following services: Amazon FSx for Windows File Server, Amazon FSx for
     * Lustre, Amazon FSx for NetApp ONTAP , Amazon FSx for OpenZFS, Amazon DocumentDB (with MongoDB compatibility),
     * Amazon RDS, Amazon Aurora, and Amazon Neptune.
     * </p>
     *
     * @param stopBackupJobRequest
     * @return A Java Future containing the result of the StopBackupJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StopBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StopBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopBackupJobResponse> stopBackupJob(StopBackupJobRequest stopBackupJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to cancel a job to create a one-time backup of a resource.
     * </p>
     * <p>
     * This action is not supported for the following services: Amazon FSx for Windows File Server, Amazon FSx for
     * Lustre, Amazon FSx for NetApp ONTAP , Amazon FSx for OpenZFS, Amazon DocumentDB (with MongoDB compatibility),
     * Amazon RDS, Amazon Aurora, and Amazon Neptune.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopBackupJobRequest.Builder} avoiding the need to
     * create one manually via {@link StopBackupJobRequest#builder()}
     * </p>
     *
     * @param stopBackupJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.StopBackupJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopBackupJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.StopBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StopBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopBackupJobResponse> stopBackupJob(Consumer<StopBackupJobRequest.Builder> stopBackupJobRequest) {
        return stopBackupJob(StopBackupJobRequest.builder().applyMutation(stopBackupJobRequest).build());
    }

    /**
     * <p>
     * Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN).
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN)
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing backup plan identified by its <code>backupPlanId</code> with the input document in JSON
     * format. The new version is uniquely identified by a <code>VersionId</code>.
     * </p>
     *
     * @param updateBackupPlanRequest
     * @return A Java Future containing the result of the UpdateBackupPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBackupPlanResponse> updateBackupPlan(UpdateBackupPlanRequest updateBackupPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing backup plan identified by its <code>backupPlanId</code> with the input document in JSON
     * format. The new version is uniquely identified by a <code>VersionId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBackupPlanRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBackupPlanRequest#builder()}
     * </p>
     *
     * @param updateBackupPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UpdateBackupPlanRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateBackupPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBackupPlanResponse> updateBackupPlan(
            Consumer<UpdateBackupPlanRequest.Builder> updateBackupPlanRequest) {
        return updateBackupPlan(UpdateBackupPlanRequest.builder().applyMutation(updateBackupPlanRequest).build());
    }

    /**
     * <p>
     * Updates an existing framework identified by its <code>FrameworkName</code> with the input document in JSON
     * format.
     * </p>
     *
     * @param updateFrameworkRequest
     * @return A Java Future containing the result of the UpdateFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFrameworkResponse> updateFramework(UpdateFrameworkRequest updateFrameworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing framework identified by its <code>FrameworkName</code> with the input document in JSON
     * format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFrameworkRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateFrameworkRequest#builder()}
     * </p>
     *
     * @param updateFrameworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UpdateFrameworkRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFramework operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The required resource already exists.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>LimitExceededException A limit in the request has been exceeded; for example, a maximum number of
     *         items allowed in a request.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateFramework" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFrameworkResponse> updateFramework(
            Consumer<UpdateFrameworkRequest.Builder> updateFrameworkRequest) {
        return updateFramework(UpdateFrameworkRequest.builder().applyMutation(updateFrameworkRequest).build());
    }

    /**
     * <p>
     * Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the
     * account is not an Organizations management account. Use the <code>DescribeGlobalSettings</code> API to determine
     * the current settings.
     * </p>
     *
     * @param updateGlobalSettingsRequest
     * @return A Java Future containing the result of the UpdateGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateGlobalSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateGlobalSettingsResponse> updateGlobalSettings(
            UpdateGlobalSettingsRequest updateGlobalSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the
     * account is not an Organizations management account. Use the <code>DescribeGlobalSettings</code> API to determine
     * the current settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGlobalSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGlobalSettingsRequest#builder()}
     * </p>
     *
     * @param updateGlobalSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateGlobalSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateGlobalSettingsResponse> updateGlobalSettings(
            Consumer<UpdateGlobalSettingsRequest.Builder> updateGlobalSettingsRequest) {
        return updateGlobalSettings(UpdateGlobalSettingsRequest.builder().applyMutation(updateGlobalSettingsRequest).build());
    }

    /**
     * <p>
     * Sets the transition lifecycle of a recovery point.
     * </p>
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
     * “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to
     * cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * <p>
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage"
     * section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table. Backup ignores this expression for other resource types.
     * </p>
     * <p>
     * This operation does not support continuous backups.
     * </p>
     *
     * @param updateRecoveryPointLifecycleRequest
     * @return A Java Future containing the result of the UpdateRecoveryPointLifecycle operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateRecoveryPointLifecycle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRecoveryPointLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRecoveryPointLifecycleResponse> updateRecoveryPointLifecycle(
            UpdateRecoveryPointLifecycleRequest updateRecoveryPointLifecycleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the transition lifecycle of a recovery point.
     * </p>
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
     * “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to
     * cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * <p>
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage"
     * section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table. Backup ignores this expression for other resource types.
     * </p>
     * <p>
     * This operation does not support continuous backups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRecoveryPointLifecycleRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateRecoveryPointLifecycleRequest#builder()}
     * </p>
     *
     * @param updateRecoveryPointLifecycleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateRecoveryPointLifecycle operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>InvalidRequestException Indicates that something is wrong with the input to the request. For example,
     *         a parameter is of the wrong type.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateRecoveryPointLifecycle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRecoveryPointLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRecoveryPointLifecycleResponse> updateRecoveryPointLifecycle(
            Consumer<UpdateRecoveryPointLifecycleRequest.Builder> updateRecoveryPointLifecycleRequest) {
        return updateRecoveryPointLifecycle(UpdateRecoveryPointLifecycleRequest.builder()
                .applyMutation(updateRecoveryPointLifecycleRequest).build());
    }

    /**
     * <p>
     * Updates the current service opt-in settings for the Region.
     * </p>
     * <p>
     * Use the <code>DescribeRegionSettings</code> API to determine the resource types that are supported.
     * </p>
     *
     * @param updateRegionSettingsRequest
     * @return A Java Future containing the result of the UpdateRegionSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateRegionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRegionSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateRegionSettingsResponse> updateRegionSettings(
            UpdateRegionSettingsRequest updateRegionSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the current service opt-in settings for the Region.
     * </p>
     * <p>
     * Use the <code>DescribeRegionSettings</code> API to determine the resource types that are supported.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRegionSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRegionSettingsRequest#builder()}
     * </p>
     *
     * @param updateRegionSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UpdateRegionSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRegionSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateRegionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRegionSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateRegionSettingsResponse> updateRegionSettings(
            Consumer<UpdateRegionSettingsRequest.Builder> updateRegionSettingsRequest) {
        return updateRegionSettings(UpdateRegionSettingsRequest.builder().applyMutation(updateRegionSettingsRequest).build());
    }

    /**
     * <p>
     * Updates an existing report plan identified by its <code>ReportPlanName</code> with the input document in JSON
     * format.
     * </p>
     *
     * @param updateReportPlanRequest
     * @return A Java Future containing the result of the UpdateReportPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateReportPlanResponse> updateReportPlan(UpdateReportPlanRequest updateReportPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing report plan identified by its <code>ReportPlanName</code> with the input document in JSON
     * format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReportPlanRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateReportPlanRequest#builder()}
     * </p>
     *
     * @param updateReportPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UpdateReportPlanRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateReportPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateReportPlanResponse> updateReportPlan(
            Consumer<UpdateReportPlanRequest.Builder> updateReportPlanRequest) {
        return updateReportPlan(UpdateReportPlanRequest.builder().applyMutation(updateReportPlanRequest).build());
    }

    /**
     * <p>
     * This request will send changes to your specified restore testing plan. <code>RestoreTestingPlanName</code> cannot
     * be updated after it is created.
     * </p>
     * <p>
     * <code>RecoveryPointSelection</code> can contain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Algorithm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExcludeVaults</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IncludeVaults</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RecoveryPointTypes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SelectionWindowDays</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateRestoreTestingPlanRequest
     * @return A Java Future containing the result of the UpdateRestoreTestingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRestoreTestingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRestoreTestingPlanResponse> updateRestoreTestingPlan(
            UpdateRestoreTestingPlanRequest updateRestoreTestingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request will send changes to your specified restore testing plan. <code>RestoreTestingPlanName</code> cannot
     * be updated after it is created.
     * </p>
     * <p>
     * <code>RecoveryPointSelection</code> can contain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Algorithm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExcludeVaults</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IncludeVaults</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RecoveryPointTypes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SelectionWindowDays</code>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRestoreTestingPlanRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateRestoreTestingPlanRequest#builder()}
     * </p>
     *
     * @param updateRestoreTestingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UpdateRestoreTestingPlanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRestoreTestingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRestoreTestingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRestoreTestingPlanResponse> updateRestoreTestingPlan(
            Consumer<UpdateRestoreTestingPlanRequest.Builder> updateRestoreTestingPlanRequest) {
        return updateRestoreTestingPlan(UpdateRestoreTestingPlanRequest.builder().applyMutation(updateRestoreTestingPlanRequest)
                .build());
    }

    /**
     * <p>
     * Most elements except the <code>RestoreTestingSelectionName</code> can be updated with this request.
     * </p>
     * <p>
     * <code>RestoreTestingSelection</code> can use either protected resource ARNs or conditions, but not both. That is,
     * if your selection has <code>ProtectedResourceArns</code>, requesting an update with the parameter
     * <code>ProtectedResourceConditions</code> will be unsuccessful.
     * </p>
     *
     * @param updateRestoreTestingSelectionRequest
     * @return A Java Future containing the result of the UpdateRestoreTestingSelection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRestoreTestingSelectionResponse> updateRestoreTestingSelection(
            UpdateRestoreTestingSelectionRequest updateRestoreTestingSelectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Most elements except the <code>RestoreTestingSelectionName</code> can be updated with this request.
     * </p>
     * <p>
     * <code>RestoreTestingSelection</code> can use either protected resource ARNs or conditions, but not both. That is,
     * if your selection has <code>ProtectedResourceArns</code>, requesting an update with the parameter
     * <code>ProtectedResourceConditions</code> will be unsuccessful.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRestoreTestingSelectionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateRestoreTestingSelectionRequest#builder()}
     * </p>
     *
     * @param updateRestoreTestingSelectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backup.model.UpdateRestoreTestingSelectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateRestoreTestingSelection operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Backup can't perform the action that you requested until it finishes performing a
     *         previous action. Try again later.</li>
     *         <li>InvalidParameterValueException Indicates that something is wrong with a parameter's value. For
     *         example, the value is out of range.</li>
     *         <li>MissingParameterValueException Indicates that a required parameter is missing.</li>
     *         <li>ResourceNotFoundException A resource that is required for the action doesn't exist.</li>
     *         <li>ServiceUnavailableException The request failed due to a temporary failure of the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupAsyncClient.UpdateRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRestoreTestingSelectionResponse> updateRestoreTestingSelection(
            Consumer<UpdateRestoreTestingSelectionRequest.Builder> updateRestoreTestingSelectionRequest) {
        return updateRestoreTestingSelection(UpdateRestoreTestingSelectionRequest.builder()
                .applyMutation(updateRestoreTestingSelectionRequest).build());
    }

    @Override
    default BackupServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BackupAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BackupAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BackupAsyncClient}.
     */
    static BackupAsyncClientBuilder builder() {
        return new DefaultBackupAsyncClientBuilder();
    }
}
