/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBackupSelectionRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, GetBackupSelectionRequest> {
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanId").getter(GetBackupSelectionRequest.getter(GetBackupSelectionRequest::backupPlanId)).setter(GetBackupSelectionRequest.setter(Builder::backupPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupPlanId").build()}).build();
    private static final SdkField<String> SELECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionId").getter(GetBackupSelectionRequest.getter(GetBackupSelectionRequest::selectionId)).setter(GetBackupSelectionRequest.setter(Builder::selectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("selectionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_ID_FIELD, SELECTION_ID_FIELD));
    private final String backupPlanId;
    private final String selectionId;

    private GetBackupSelectionRequest(BuilderImpl builder) {
        super(builder);
        this.backupPlanId = builder.backupPlanId;
        this.selectionId = builder.selectionId;
    }

    public final String backupPlanId() {
        return this.backupPlanId;
    }

    public final String selectionId() {
        return this.selectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackupSelectionRequest)) {
            return false;
        }
        GetBackupSelectionRequest other = (GetBackupSelectionRequest)((Object)obj);
        return Objects.equals(this.backupPlanId(), other.backupPlanId()) && Objects.equals(this.selectionId(), other.selectionId());
    }

    public final String toString() {
        return ToString.builder((String)"GetBackupSelectionRequest").add("BackupPlanId", (Object)this.backupPlanId()).add("SelectionId", (Object)this.selectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupPlanId": {
                return Optional.ofNullable(clazz.cast(this.backupPlanId()));
            }
            case "SelectionId": {
                return Optional.ofNullable(clazz.cast(this.selectionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBackupSelectionRequest, T> g) {
        return obj -> g.apply((GetBackupSelectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String backupPlanId;
        private String selectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackupSelectionRequest model) {
            super(model);
            this.backupPlanId(model.backupPlanId);
            this.selectionId(model.selectionId);
        }

        public final String getBackupPlanId() {
            return this.backupPlanId;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final String getSelectionId() {
            return this.selectionId;
        }

        public final void setSelectionId(String selectionId) {
            this.selectionId = selectionId;
        }

        @Override
        public final Builder selectionId(String selectionId) {
            this.selectionId = selectionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBackupSelectionRequest build() {
            return new GetBackupSelectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBackupSelectionRequest> {
        public Builder backupPlanId(String var1);

        public Builder selectionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

