/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.backup.internal.BackupServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.backup.model.AlreadyExistsException;
import software.amazon.awssdk.services.backup.model.BackupException;
import software.amazon.awssdk.services.backup.model.CancelLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.CancelLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.ConflictException;
import software.amazon.awssdk.services.backup.model.CreateBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.CreateBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.CreateBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.CreateFrameworkRequest;
import software.amazon.awssdk.services.backup.model.CreateFrameworkResponse;
import software.amazon.awssdk.services.backup.model.CreateLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.CreateLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.CreateReportPlanRequest;
import software.amazon.awssdk.services.backup.model.CreateReportPlanResponse;
import software.amazon.awssdk.services.backup.model.CreateRestoreTestingPlanRequest;
import software.amazon.awssdk.services.backup.model.CreateRestoreTestingPlanResponse;
import software.amazon.awssdk.services.backup.model.CreateRestoreTestingSelectionRequest;
import software.amazon.awssdk.services.backup.model.CreateRestoreTestingSelectionResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.DeleteFrameworkRequest;
import software.amazon.awssdk.services.backup.model.DeleteFrameworkResponse;
import software.amazon.awssdk.services.backup.model.DeleteRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DeleteRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.DeleteReportPlanRequest;
import software.amazon.awssdk.services.backup.model.DeleteReportPlanResponse;
import software.amazon.awssdk.services.backup.model.DeleteRestoreTestingPlanRequest;
import software.amazon.awssdk.services.backup.model.DeleteRestoreTestingPlanResponse;
import software.amazon.awssdk.services.backup.model.DeleteRestoreTestingSelectionRequest;
import software.amazon.awssdk.services.backup.model.DeleteRestoreTestingSelectionResponse;
import software.amazon.awssdk.services.backup.model.DependencyFailureException;
import software.amazon.awssdk.services.backup.model.DescribeBackupJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse;
import software.amazon.awssdk.services.backup.model.DescribeBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.DescribeBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.DescribeCopyJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeCopyJobResponse;
import software.amazon.awssdk.services.backup.model.DescribeFrameworkRequest;
import software.amazon.awssdk.services.backup.model.DescribeFrameworkResponse;
import software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsRequest;
import software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsResponse;
import software.amazon.awssdk.services.backup.model.DescribeProtectedResourceRequest;
import software.amazon.awssdk.services.backup.model.DescribeProtectedResourceResponse;
import software.amazon.awssdk.services.backup.model.DescribeRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DescribeRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.DescribeRegionSettingsRequest;
import software.amazon.awssdk.services.backup.model.DescribeRegionSettingsResponse;
import software.amazon.awssdk.services.backup.model.DescribeReportJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeReportJobResponse;
import software.amazon.awssdk.services.backup.model.DescribeReportPlanRequest;
import software.amazon.awssdk.services.backup.model.DescribeReportPlanResponse;
import software.amazon.awssdk.services.backup.model.DescribeRestoreJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeRestoreJobResponse;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentRequest;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentResponse;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateRequest;
import software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.GetLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.GetLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataRequest;
import software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse;
import software.amazon.awssdk.services.backup.model.GetRestoreJobMetadataRequest;
import software.amazon.awssdk.services.backup.model.GetRestoreJobMetadataResponse;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingInferredMetadataRequest;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingInferredMetadataResponse;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingPlanRequest;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingPlanResponse;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingSelectionRequest;
import software.amazon.awssdk.services.backup.model.GetRestoreTestingSelectionResponse;
import software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesRequest;
import software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesResponse;
import software.amazon.awssdk.services.backup.model.InvalidParameterValueException;
import software.amazon.awssdk.services.backup.model.InvalidRequestException;
import software.amazon.awssdk.services.backup.model.InvalidResourceStateException;
import software.amazon.awssdk.services.backup.model.LimitExceededException;
import software.amazon.awssdk.services.backup.model.ListBackupJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobSummariesResponse;
import software.amazon.awssdk.services.backup.model.ListBackupJobsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlansRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlansResponse;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse;
import software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListCopyJobSummariesResponse;
import software.amazon.awssdk.services.backup.model.ListCopyJobsRequest;
import software.amazon.awssdk.services.backup.model.ListCopyJobsResponse;
import software.amazon.awssdk.services.backup.model.ListFrameworksRequest;
import software.amazon.awssdk.services.backup.model.ListFrameworksResponse;
import software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest;
import software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse;
import software.amazon.awssdk.services.backup.model.ListReportJobsRequest;
import software.amazon.awssdk.services.backup.model.ListReportJobsResponse;
import software.amazon.awssdk.services.backup.model.ListReportPlansRequest;
import software.amazon.awssdk.services.backup.model.ListReportPlansResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobSummariesResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsByProtectedResourceResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingPlansResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreTestingSelectionsResponse;
import software.amazon.awssdk.services.backup.model.ListTagsRequest;
import software.amazon.awssdk.services.backup.model.ListTagsResponse;
import software.amazon.awssdk.services.backup.model.MissingParameterValueException;
import software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationResponse;
import software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.PutRestoreValidationResultRequest;
import software.amazon.awssdk.services.backup.model.PutRestoreValidationResultResponse;
import software.amazon.awssdk.services.backup.model.ResourceNotFoundException;
import software.amazon.awssdk.services.backup.model.ServiceUnavailableException;
import software.amazon.awssdk.services.backup.model.StartBackupJobRequest;
import software.amazon.awssdk.services.backup.model.StartBackupJobResponse;
import software.amazon.awssdk.services.backup.model.StartCopyJobRequest;
import software.amazon.awssdk.services.backup.model.StartCopyJobResponse;
import software.amazon.awssdk.services.backup.model.StartReportJobRequest;
import software.amazon.awssdk.services.backup.model.StartReportJobResponse;
import software.amazon.awssdk.services.backup.model.StartRestoreJobRequest;
import software.amazon.awssdk.services.backup.model.StartRestoreJobResponse;
import software.amazon.awssdk.services.backup.model.StopBackupJobRequest;
import software.amazon.awssdk.services.backup.model.StopBackupJobResponse;
import software.amazon.awssdk.services.backup.model.TagResourceRequest;
import software.amazon.awssdk.services.backup.model.TagResourceResponse;
import software.amazon.awssdk.services.backup.model.UntagResourceRequest;
import software.amazon.awssdk.services.backup.model.UntagResourceResponse;
import software.amazon.awssdk.services.backup.model.UpdateBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.UpdateBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.UpdateFrameworkRequest;
import software.amazon.awssdk.services.backup.model.UpdateFrameworkResponse;
import software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsRequest;
import software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsResponse;
import software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleRequest;
import software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleResponse;
import software.amazon.awssdk.services.backup.model.UpdateRegionSettingsRequest;
import software.amazon.awssdk.services.backup.model.UpdateRegionSettingsResponse;
import software.amazon.awssdk.services.backup.model.UpdateReportPlanRequest;
import software.amazon.awssdk.services.backup.model.UpdateReportPlanResponse;
import software.amazon.awssdk.services.backup.model.UpdateRestoreTestingPlanRequest;
import software.amazon.awssdk.services.backup.model.UpdateRestoreTestingPlanResponse;
import software.amazon.awssdk.services.backup.model.UpdateRestoreTestingSelectionRequest;
import software.amazon.awssdk.services.backup.model.UpdateRestoreTestingSelectionResponse;
import software.amazon.awssdk.services.backup.transform.CancelLegalHoldRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateBackupPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateBackupSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateFrameworkRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateLegalHoldRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateLogicallyAirGappedBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateReportPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateRestoreTestingPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.CreateRestoreTestingSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupVaultLockConfigurationRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteFrameworkRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteReportPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteRestoreTestingPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DeleteRestoreTestingSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeBackupJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeCopyJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeFrameworkRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeGlobalSettingsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeProtectedResourceRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeRegionSettingsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeReportJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeReportPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DescribeRestoreJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DisassociateRecoveryPointFromParentRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.DisassociateRecoveryPointRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ExportBackupPlanTemplateRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupPlanFromJsonRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupPlanFromTemplateRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetBackupVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetLegalHoldRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetRecoveryPointRestoreMetadataRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetRestoreJobMetadataRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetRestoreTestingInferredMetadataRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetRestoreTestingPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetRestoreTestingSelectionRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.GetSupportedResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupJobSummariesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupJobsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupPlanTemplatesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupPlanVersionsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupPlansRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupSelectionsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListBackupVaultsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListCopyJobSummariesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListCopyJobsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListFrameworksRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListLegalHoldsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListProtectedResourcesByBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListProtectedResourcesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRecoveryPointsByBackupVaultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRecoveryPointsByLegalHoldRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRecoveryPointsByResourceRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListReportJobsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListReportPlansRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRestoreJobSummariesRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRestoreJobsByProtectedResourceRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRestoreJobsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRestoreTestingPlansRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListRestoreTestingSelectionsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.PutBackupVaultAccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.PutBackupVaultLockConfigurationRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.PutBackupVaultNotificationsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.PutRestoreValidationResultRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.StartBackupJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.StartCopyJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.StartReportJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.StartRestoreJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.StopBackupJobRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateBackupPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateFrameworkRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateGlobalSettingsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateRecoveryPointLifecycleRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateRegionSettingsRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateReportPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateRestoreTestingPlanRequestMarshaller;
import software.amazon.awssdk.services.backup.transform.UpdateRestoreTestingSelectionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link BackupClient}.
 *
 * @see BackupClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultBackupClient implements BackupClient {
    private static final Logger log = Logger.loggerFor(DefaultBackupClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultBackupClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * This action removes the specified legal hold on a recovery point. This action can only be performed by a user
     * with sufficient permissions.
     * </p>
     *
     * @param cancelLegalHoldRequest
     * @return Result of the CancelLegalHold operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidResourceStateException
     *         Backup is already performing an action on this recovery point. It can't perform the action you requested
     *         until the first action finishes. Try again later.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CancelLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CancelLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelLegalHoldResponse cancelLegalHold(CancelLegalHoldRequest cancelLegalHoldRequest)
            throws InvalidParameterValueException, InvalidResourceStateException, MissingParameterValueException,
            ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelLegalHoldResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelLegalHoldResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelLegalHoldRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelLegalHoldRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelLegalHold");

            return clientHandler.execute(new ClientExecutionParams<CancelLegalHoldRequest, CancelLegalHoldResponse>()
                    .withOperationName("CancelLegalHold").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelLegalHoldRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelLegalHoldRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains
     * information that Backup uses to schedule tasks that create recovery points for resources.
     * </p>
     * <p>
     * If you call <code>CreateBackupPlan</code> with a plan that already exists, you receive an
     * <code>AlreadyExistsException</code> exception.
     * </p>
     *
     * @param createBackupPlanRequest
     * @return Result of the CreateBackupPlan operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateBackupPlanResponse createBackupPlan(CreateBackupPlanRequest createBackupPlanRequest)
            throws LimitExceededException, AlreadyExistsException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBackupPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBackupPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBackupPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBackupPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBackupPlan");

            return clientHandler.execute(new ClientExecutionParams<CreateBackupPlanRequest, CreateBackupPlanResponse>()
                    .withOperationName("CreateBackupPlan").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBackupPlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBackupPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json"
     * >Assigning resources programmatically</a>.
     * </p>
     *
     * @param createBackupSelectionRequest
     * @return Result of the CreateBackupSelection operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateBackupSelectionResponse createBackupSelection(CreateBackupSelectionRequest createBackupSelectionRequest)
            throws LimitExceededException, AlreadyExistsException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBackupSelectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBackupSelectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBackupSelectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBackupSelectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBackupSelection");

            return clientHandler.execute(new ClientExecutionParams<CreateBackupSelectionRequest, CreateBackupSelectionResponse>()
                    .withOperationName("CreateBackupSelection").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBackupSelectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBackupSelectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a logical container where backups are stored. A <code>CreateBackupVault</code> request includes a name,
     * optionally one or more resource tags, an encryption key, and a request ID.
     * </p>
     * <note>
     * <p>
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     * </p>
     * </note>
     *
     * @param createBackupVaultRequest
     * @return Result of the CreateBackupVault operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateBackupVaultResponse createBackupVault(CreateBackupVaultRequest createBackupVaultRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            LimitExceededException, AlreadyExistsException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBackupVaultResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBackupVaultResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBackupVaultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBackupVaultRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBackupVault");

            return clientHandler.execute(new ClientExecutionParams<CreateBackupVaultRequest, CreateBackupVaultResponse>()
                    .withOperationName("CreateBackupVault").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBackupVaultRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBackupVaultRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a framework with one or more controls. A framework is a collection of controls that you can use to
     * evaluate your backup practices. By using pre-built customizable controls to define your policies, you can
     * evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.
     * </p>
     *
     * @param createFrameworkRequest
     * @return Result of the CreateFramework operation returned by the service.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateFramework" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFrameworkResponse createFramework(CreateFrameworkRequest createFrameworkRequest) throws AlreadyExistsException,
            LimitExceededException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFrameworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFrameworkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFrameworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFrameworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFramework");

            return clientHandler.execute(new ClientExecutionParams<CreateFrameworkRequest, CreateFrameworkResponse>()
                    .withOperationName("CreateFramework").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createFrameworkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFrameworkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This action creates a legal hold on a recovery point (backup). A legal hold is a restraint on altering or
     * deleting a backup until an authorized user cancels the legal hold. Any actions to delete or disassociate a
     * recovery point will fail with an error if one or more active legal holds are on the recovery point.
     * </p>
     *
     * @param createLegalHoldRequest
     * @return Result of the CreateLegalHold operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateLegalHoldResponse createLegalHold(CreateLegalHoldRequest createLegalHoldRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            LimitExceededException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLegalHoldResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateLegalHoldResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLegalHoldRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLegalHoldRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLegalHold");

            return clientHandler.execute(new ClientExecutionParams<CreateLegalHoldRequest, CreateLegalHoldResponse>()
                    .withOperationName("CreateLegalHold").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createLegalHoldRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateLegalHoldRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This request creates a logical container to where backups may be copied.
     * </p>
     * <p>
     * This request includes a name, the Region, the maximum number of retention days, the minimum number of retention
     * days, and optionally can include tags and a creator request ID.
     * </p>
     * <note>
     * <p>
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     * </p>
     * </note>
     *
     * @param createLogicallyAirGappedBackupVaultRequest
     * @return Result of the CreateLogicallyAirGappedBackupVault operation returned by the service.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateLogicallyAirGappedBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLogicallyAirGappedBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateLogicallyAirGappedBackupVaultResponse createLogicallyAirGappedBackupVault(
            CreateLogicallyAirGappedBackupVaultRequest createLogicallyAirGappedBackupVaultRequest) throws AlreadyExistsException,
            InvalidParameterValueException, LimitExceededException, MissingParameterValueException, ServiceUnavailableException,
            InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLogicallyAirGappedBackupVaultResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateLogicallyAirGappedBackupVaultResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLogicallyAirGappedBackupVaultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createLogicallyAirGappedBackupVaultRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLogicallyAirGappedBackupVault");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateLogicallyAirGappedBackupVaultRequest, CreateLogicallyAirGappedBackupVaultResponse>()
                            .withOperationName("CreateLogicallyAirGappedBackupVault").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createLogicallyAirGappedBackupVaultRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateLogicallyAirGappedBackupVaultRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a report plan. A report plan is a document that contains information about the contents of the report and
     * where Backup will deliver it.
     * </p>
     * <p>
     * If you call <code>CreateReportPlan</code> with a plan that already exists, you receive an
     * <code>AlreadyExistsException</code> exception.
     * </p>
     *
     * @param createReportPlanRequest
     * @return Result of the CreateReportPlan operation returned by the service.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateReportPlanResponse createReportPlan(CreateReportPlanRequest createReportPlanRequest)
            throws AlreadyExistsException, LimitExceededException, InvalidParameterValueException, ServiceUnavailableException,
            MissingParameterValueException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateReportPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateReportPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReportPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReportPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReportPlan");

            return clientHandler.execute(new ClientExecutionParams<CreateReportPlanRequest, CreateReportPlanResponse>()
                    .withOperationName("CreateReportPlan").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createReportPlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateReportPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This is the first of two steps to create a restore testing plan; once this request is successful, finish the
     * procedure with request CreateRestoreTestingSelection.
     * </p>
     * <p>
     * You must include the parameter RestoreTestingPlan. You may optionally include CreatorRequestId and Tags.
     * </p>
     *
     * @param createRestoreTestingPlanRequest
     * @return Result of the CreateRestoreTestingPlan operation returned by the service.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateRestoreTestingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateRestoreTestingPlanResponse createRestoreTestingPlan(
            CreateRestoreTestingPlanRequest createRestoreTestingPlanRequest) throws AlreadyExistsException, ConflictException,
            InvalidParameterValueException, LimitExceededException, MissingParameterValueException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRestoreTestingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateRestoreTestingPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRestoreTestingPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRestoreTestingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRestoreTestingPlan");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateRestoreTestingPlanRequest, CreateRestoreTestingPlanResponse>()
                            .withOperationName("CreateRestoreTestingPlan").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createRestoreTestingPlanRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateRestoreTestingPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This request can be sent after CreateRestoreTestingPlan request returns successfully. This is the second part of
     * creating a resource testing plan, and it must be completed sequentially.
     * </p>
     * <p>
     * This consists of <code>RestoreTestingSelectionName</code>, <code>ProtectedResourceType</code>, and one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ProtectedResourceArns</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ProtectedResourceConditions</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each protected resource type can have one single value.
     * </p>
     * <p>
     * A restore testing selection can include a wildcard value ("*") for <code>ProtectedResourceArns</code> along with
     * <code>ProtectedResourceConditions</code>. Alternatively, you can include up to 30 specific protected resource
     * ARNs in <code>ProtectedResourceArns</code>.
     * </p>
     * <p>
     * Cannot select by both protected resource types AND specific ARNs. Request will fail if both are included.
     * </p>
     *
     * @param createRestoreTestingSelectionRequest
     * @return Result of the CreateRestoreTestingSelection operation returned by the service.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateRestoreTestingSelectionResponse createRestoreTestingSelection(
            CreateRestoreTestingSelectionRequest createRestoreTestingSelectionRequest) throws AlreadyExistsException,
            InvalidParameterValueException, LimitExceededException, MissingParameterValueException, ResourceNotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRestoreTestingSelectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateRestoreTestingSelectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRestoreTestingSelectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createRestoreTestingSelectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRestoreTestingSelection");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateRestoreTestingSelectionRequest, CreateRestoreTestingSelectionResponse>()
                            .withOperationName("CreateRestoreTestingSelection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createRestoreTestingSelectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateRestoreTestingSelectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been
     * deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will
     * still exist.
     * </p>
     *
     * @param deleteBackupPlanRequest
     * @return Result of the DeleteBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteBackupPlanResponse deleteBackupPlan(DeleteBackupPlanRequest deleteBackupPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBackupPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBackupPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackupPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBackupPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackupPlan");

            return clientHandler.execute(new ClientExecutionParams<DeleteBackupPlanRequest, DeleteBackupPlanResponse>()
                    .withOperationName("DeleteBackupPlan").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBackupPlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBackupPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the resource selection associated with a backup plan that is specified by the <code>SelectionId</code>.
     * </p>
     *
     * @param deleteBackupSelectionRequest
     * @return Result of the DeleteBackupSelection operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteBackupSelectionResponse deleteBackupSelection(DeleteBackupSelectionRequest deleteBackupSelectionRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBackupSelectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBackupSelectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackupSelectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBackupSelectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackupSelection");

            return clientHandler.execute(new ClientExecutionParams<DeleteBackupSelectionRequest, DeleteBackupSelectionResponse>()
                    .withOperationName("DeleteBackupSelection").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBackupSelectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBackupSelectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
     * </p>
     *
     * @param deleteBackupVaultRequest
     * @return Result of the DeleteBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteBackupVaultResponse deleteBackupVault(DeleteBackupVaultRequest deleteBackupVaultRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBackupVaultResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBackupVaultResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackupVaultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBackupVaultRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackupVault");

            return clientHandler.execute(new ClientExecutionParams<DeleteBackupVaultRequest, DeleteBackupVaultResponse>()
                    .withOperationName("DeleteBackupVault").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBackupVaultRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBackupVaultRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the policy document that manages permissions on a backup vault.
     * </p>
     *
     * @param deleteBackupVaultAccessPolicyRequest
     * @return Result of the DeleteBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBackupVaultAccessPolicyResponse deleteBackupVaultAccessPolicy(
            DeleteBackupVaultAccessPolicyRequest deleteBackupVaultAccessPolicyRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBackupVaultAccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBackupVaultAccessPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackupVaultAccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteBackupVaultAccessPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackupVaultAccessPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteBackupVaultAccessPolicyRequest, DeleteBackupVaultAccessPolicyResponse>()
                            .withOperationName("DeleteBackupVaultAccessPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteBackupVaultAccessPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteBackupVaultAccessPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes Backup Vault Lock from a backup vault specified by a backup vault name.
     * </p>
     * <p>
     * If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using API operations, and you
     * will receive an <code>InvalidRequestException</code> if you attempt to do so. For more information, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">Vault Lock</a> in the <i>Backup
     * Developer Guide</i>.
     * </p>
     *
     * @param deleteBackupVaultLockConfigurationRequest
     * @return Result of the DeleteBackupVaultLockConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVaultLockConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultLockConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBackupVaultLockConfigurationResponse deleteBackupVaultLockConfiguration(
            DeleteBackupVaultLockConfigurationRequest deleteBackupVaultLockConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            InvalidRequestException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBackupVaultLockConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBackupVaultLockConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackupVaultLockConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteBackupVaultLockConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackupVaultLockConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteBackupVaultLockConfigurationRequest, DeleteBackupVaultLockConfigurationResponse>()
                            .withOperationName("DeleteBackupVaultLockConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteBackupVaultLockConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteBackupVaultLockConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes event notifications for the specified backup vault.
     * </p>
     *
     * @param deleteBackupVaultNotificationsRequest
     * @return Result of the DeleteBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBackupVaultNotificationsResponse deleteBackupVaultNotifications(
            DeleteBackupVaultNotificationsRequest deleteBackupVaultNotificationsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBackupVaultNotificationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBackupVaultNotificationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBackupVaultNotificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteBackupVaultNotificationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBackupVaultNotifications");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteBackupVaultNotificationsRequest, DeleteBackupVaultNotificationsResponse>()
                            .withOperationName("DeleteBackupVaultNotifications").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteBackupVaultNotificationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteBackupVaultNotificationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the framework specified by a framework name.
     * </p>
     *
     * @param deleteFrameworkRequest
     * @return Result of the DeleteFramework operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteFramework" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFrameworkResponse deleteFramework(DeleteFrameworkRequest deleteFrameworkRequest)
            throws MissingParameterValueException, InvalidParameterValueException, ServiceUnavailableException,
            ConflictException, ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFrameworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFrameworkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFrameworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFrameworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFramework");

            return clientHandler.execute(new ClientExecutionParams<DeleteFrameworkRequest, DeleteFrameworkResponse>()
                    .withOperationName("DeleteFramework").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteFrameworkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFrameworkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the recovery point specified by a recovery point ID.
     * </p>
     * <p>
     * If the recovery point ID belongs to a continuous backup, calling this endpoint deletes the existing continuous
     * backup and stops future continuous backup.
     * </p>
     * <p>
     * When an IAM role's permissions are insufficient to call this API, the service sends back an HTTP 200 response
     * with an empty HTTP body, but the recovery point is not deleted. Instead, it enters an <code>EXPIRED</code> state.
     * </p>
     * <p>
     * <code>EXPIRED</code> recovery points can be deleted with this API once the IAM role has the
     * <code>iam:CreateServiceLinkedRole</code> action. To learn more about adding this role, see <a href=
     * "https://docs.aws.amazon.com/aws-backup/latest/devguide/deleting-backups.html#deleting-backups-troubleshooting">
     * Troubleshooting manual deletions</a>.
     * </p>
     * <p>
     * If the user or role is deleted or the permission within the role is removed, the deletion will not be successful
     * and will enter an <code>EXPIRED</code> state.
     * </p>
     *
     * @param deleteRecoveryPointRequest
     * @return Result of the DeleteRecoveryPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidResourceStateException
     *         Backup is already performing an action on this recovery point. It can't perform the action you requested
     *         until the first action finishes. Try again later.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRecoveryPoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteRecoveryPointResponse deleteRecoveryPoint(DeleteRecoveryPointRequest deleteRecoveryPointRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            InvalidResourceStateException, ServiceUnavailableException, InvalidRequestException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRecoveryPointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRecoveryPointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRecoveryPointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRecoveryPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRecoveryPoint");

            return clientHandler.execute(new ClientExecutionParams<DeleteRecoveryPointRequest, DeleteRecoveryPointResponse>()
                    .withOperationName("DeleteRecoveryPoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteRecoveryPointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRecoveryPointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the report plan specified by a report plan name.
     * </p>
     *
     * @param deleteReportPlanRequest
     * @return Result of the DeleteReportPlan operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteReportPlanResponse deleteReportPlan(DeleteReportPlanRequest deleteReportPlanRequest)
            throws MissingParameterValueException, InvalidParameterValueException, ConflictException,
            ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteReportPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteReportPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReportPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReportPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReportPlan");

            return clientHandler.execute(new ClientExecutionParams<DeleteReportPlanRequest, DeleteReportPlanResponse>()
                    .withOperationName("DeleteReportPlan").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteReportPlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteReportPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This request deletes the specified restore testing plan.
     * </p>
     * <p>
     * Deletion can only successfully occur if all associated restore testing selections are deleted first.
     * </p>
     *
     * @param deleteRestoreTestingPlanRequest
     * @return Result of the DeleteRestoreTestingPlan operation returned by the service.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRestoreTestingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRestoreTestingPlanResponse deleteRestoreTestingPlan(
            DeleteRestoreTestingPlanRequest deleteRestoreTestingPlanRequest) throws InvalidRequestException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRestoreTestingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRestoreTestingPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRestoreTestingPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRestoreTestingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRestoreTestingPlan");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRestoreTestingPlanRequest, DeleteRestoreTestingPlanResponse>()
                            .withOperationName("DeleteRestoreTestingPlan").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteRestoreTestingPlanRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRestoreTestingPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Input the Restore Testing Plan name and Restore Testing Selection name.
     * </p>
     * <p>
     * All testing selections associated with a restore testing plan must be deleted before the restore testing plan can
     * be deleted.
     * </p>
     *
     * @param deleteRestoreTestingSelectionRequest
     * @return Result of the DeleteRestoreTestingSelection operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRestoreTestingSelectionResponse deleteRestoreTestingSelection(
            DeleteRestoreTestingSelectionRequest deleteRestoreTestingSelectionRequest) throws ResourceNotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRestoreTestingSelectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRestoreTestingSelectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRestoreTestingSelectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteRestoreTestingSelectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRestoreTestingSelection");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRestoreTestingSelectionRequest, DeleteRestoreTestingSelectionResponse>()
                            .withOperationName("DeleteRestoreTestingSelection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteRestoreTestingSelectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRestoreTestingSelectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns backup job details for the specified <code>BackupJobId</code>.
     * </p>
     *
     * @param describeBackupJobRequest
     * @return Result of the DescribeBackupJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws DependencyFailureException
     *         A dependent Amazon Web Services service or resource returned an error to the Backup service, and the
     *         action cannot be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeBackupJobResponse describeBackupJob(DescribeBackupJobRequest describeBackupJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, DependencyFailureException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBackupJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeBackupJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBackupJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBackupJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBackupJob");

            return clientHandler.execute(new ClientExecutionParams<DescribeBackupJobRequest, DescribeBackupJobResponse>()
                    .withOperationName("DescribeBackupJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeBackupJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeBackupJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns metadata about a backup vault specified by its name.
     * </p>
     *
     * @param describeBackupVaultRequest
     * @return Result of the DescribeBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupVault" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeBackupVaultResponse describeBackupVault(DescribeBackupVaultRequest describeBackupVaultRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBackupVaultResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeBackupVaultResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBackupVaultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBackupVaultRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBackupVault");

            return clientHandler.execute(new ClientExecutionParams<DescribeBackupVaultRequest, DescribeBackupVaultResponse>()
                    .withOperationName("DescribeBackupVault").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeBackupVaultRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeBackupVaultRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns metadata associated with creating a copy of a resource.
     * </p>
     *
     * @param describeCopyJobRequest
     * @return Result of the DescribeCopyJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeCopyJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeCopyJobResponse describeCopyJob(DescribeCopyJobRequest describeCopyJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCopyJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeCopyJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCopyJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCopyJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCopyJob");

            return clientHandler.execute(new ClientExecutionParams<DescribeCopyJobRequest, DescribeCopyJobResponse>()
                    .withOperationName("DescribeCopyJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeCopyJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeCopyJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the framework details for the specified <code>FrameworkName</code>.
     * </p>
     *
     * @param describeFrameworkRequest
     * @return Result of the DescribeFramework operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeFramework" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeFrameworkResponse describeFramework(DescribeFrameworkRequest describeFrameworkRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFrameworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeFrameworkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFrameworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFrameworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFramework");

            return clientHandler.execute(new ClientExecutionParams<DescribeFrameworkRequest, DescribeFrameworkResponse>()
                    .withOperationName("DescribeFramework").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeFrameworkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeFrameworkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the
     * account is not a member of an Organizations organization. Example:
     * <code>describe-global-settings --region us-west-2</code>
     * </p>
     *
     * @param describeGlobalSettingsRequest
     * @return Result of the DescribeGlobalSettings operation returned by the service.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeGlobalSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeGlobalSettingsResponse describeGlobalSettings(DescribeGlobalSettingsRequest describeGlobalSettingsRequest)
            throws InvalidRequestException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeGlobalSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeGlobalSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGlobalSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGlobalSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGlobalSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeGlobalSettingsRequest, DescribeGlobalSettingsResponse>()
                            .withOperationName("DescribeGlobalSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeGlobalSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeGlobalSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name
     * (ARN), and the Amazon Web Services service type of the saved resource.
     * </p>
     *
     * @param describeProtectedResourceRequest
     * @return Result of the DescribeProtectedResource operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeProtectedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeProtectedResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeProtectedResourceResponse describeProtectedResource(
            DescribeProtectedResourceRequest describeProtectedResourceRequest) throws MissingParameterValueException,
            InvalidParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeProtectedResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeProtectedResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeProtectedResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProtectedResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProtectedResource");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeProtectedResourceRequest, DescribeProtectedResourceResponse>()
                            .withOperationName("DescribeProtectedResource").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeProtectedResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeProtectedResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
     * </p>
     *
     * @param describeRecoveryPointRequest
     * @return Result of the DescribeRecoveryPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRecoveryPoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeRecoveryPointResponse describeRecoveryPoint(DescribeRecoveryPointRequest describeRecoveryPointRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRecoveryPointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeRecoveryPointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRecoveryPointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRecoveryPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRecoveryPoint");

            return clientHandler.execute(new ClientExecutionParams<DescribeRecoveryPointRequest, DescribeRecoveryPointResponse>()
                    .withOperationName("DescribeRecoveryPoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeRecoveryPointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeRecoveryPointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup
     * tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or
     * scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region.
     * </p>
     *
     * @param describeRegionSettingsRequest
     * @return Result of the DescribeRegionSettings operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeRegionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRegionSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeRegionSettingsResponse describeRegionSettings(DescribeRegionSettingsRequest describeRegionSettingsRequest)
            throws ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRegionSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeRegionSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRegionSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRegionSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRegionSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeRegionSettingsRequest, DescribeRegionSettingsResponse>()
                            .withOperationName("DescribeRegionSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeRegionSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeRegionSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the details associated with creating a report as specified by its <code>ReportJobId</code>.
     * </p>
     *
     * @param describeReportJobRequest
     * @return Result of the DescribeReportJob operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeReportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeReportJobResponse describeReportJob(DescribeReportJobRequest describeReportJobRequest)
            throws ServiceUnavailableException, MissingParameterValueException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeReportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReportJob");

            return clientHandler.execute(new ClientExecutionParams<DescribeReportJobRequest, DescribeReportJobResponse>()
                    .withOperationName("DescribeReportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeReportJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeReportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.
     * </p>
     *
     * @param describeReportPlanRequest
     * @return Result of the DescribeReportPlan operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeReportPlanResponse describeReportPlan(DescribeReportPlanRequest describeReportPlanRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReportPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeReportPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReportPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReportPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReportPlan");

            return clientHandler.execute(new ClientExecutionParams<DescribeReportPlanRequest, DescribeReportPlanResponse>()
                    .withOperationName("DescribeReportPlan").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeReportPlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeReportPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns metadata associated with a restore job that is specified by a job ID.
     * </p>
     *
     * @param describeRestoreJobRequest
     * @return Result of the DescribeRestoreJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws DependencyFailureException
     *         A dependent Amazon Web Services service or resource returned an error to the Backup service, and the
     *         action cannot be completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeRestoreJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeRestoreJobResponse describeRestoreJob(DescribeRestoreJobRequest describeRestoreJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, DependencyFailureException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRestoreJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeRestoreJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRestoreJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRestoreJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRestoreJob");

            return clientHandler.execute(new ClientExecutionParams<DescribeRestoreJobRequest, DescribeRestoreJobResponse>()
                    .withOperationName("DescribeRestoreJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeRestoreJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeRestoreJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup
     * to the source service, such as Amazon RDS. The source service will continue to create and retain continuous
     * backups using the lifecycle that you specified in your original backup plan.
     * </p>
     * <p>
     * Does not support snapshot backup recovery points.
     * </p>
     *
     * @param disassociateRecoveryPointRequest
     * @return Result of the DisassociateRecoveryPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidResourceStateException
     *         Backup is already performing an action on this recovery point. It can't perform the action you requested
     *         until the first action finishes. Try again later.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DisassociateRecoveryPoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPoint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateRecoveryPointResponse disassociateRecoveryPoint(
            DisassociateRecoveryPointRequest disassociateRecoveryPointRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, InvalidResourceStateException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateRecoveryPointResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateRecoveryPointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateRecoveryPointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateRecoveryPointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateRecoveryPoint");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateRecoveryPointRequest, DisassociateRecoveryPointResponse>()
                            .withOperationName("DisassociateRecoveryPoint").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateRecoveryPointRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateRecoveryPointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This action to a specific child (nested) recovery point removes the relationship between the specified recovery
     * point and its parent (composite) recovery point.
     * </p>
     *
     * @param disassociateRecoveryPointFromParentRequest
     * @return Result of the DisassociateRecoveryPointFromParent operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DisassociateRecoveryPointFromParent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPointFromParent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateRecoveryPointFromParentResponse disassociateRecoveryPointFromParent(
            DisassociateRecoveryPointFromParentRequest disassociateRecoveryPointFromParentRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateRecoveryPointFromParentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateRecoveryPointFromParentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateRecoveryPointFromParentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateRecoveryPointFromParentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateRecoveryPointFromParent");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateRecoveryPointFromParentRequest, DisassociateRecoveryPointFromParentResponse>()
                            .withOperationName("DisassociateRecoveryPointFromParent").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateRecoveryPointFromParentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateRecoveryPointFromParentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the backup plan that is specified by the plan ID as a backup template.
     * </p>
     *
     * @param exportBackupPlanTemplateRequest
     * @return Result of the ExportBackupPlanTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ExportBackupPlanTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ExportBackupPlanTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ExportBackupPlanTemplateResponse exportBackupPlanTemplate(
            ExportBackupPlanTemplateRequest exportBackupPlanTemplateRequest) throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExportBackupPlanTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ExportBackupPlanTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(exportBackupPlanTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, exportBackupPlanTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportBackupPlanTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<ExportBackupPlanTemplateRequest, ExportBackupPlanTemplateResponse>()
                            .withOperationName("ExportBackupPlanTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(exportBackupPlanTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ExportBackupPlanTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns <code>BackupPlan</code> details for the specified <code>BackupPlanId</code>. The details are the body of
     * a backup plan in JSON format, in addition to plan metadata.
     * </p>
     *
     * @param getBackupPlanRequest
     * @return Result of the GetBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBackupPlanResponse getBackupPlan(GetBackupPlanRequest getBackupPlanRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBackupPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetBackupPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackupPlanRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackupPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackupPlan");

            return clientHandler.execute(new ClientExecutionParams<GetBackupPlanRequest, GetBackupPlanResponse>()
                    .withOperationName("GetBackupPlan").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBackupPlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBackupPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a valid JSON document specifying a backup plan or an error.
     * </p>
     *
     * @param getBackupPlanFromJsonRequest
     * @return Result of the GetBackupPlanFromJSON operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlanFromJSON
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromJSON" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetBackupPlanFromJsonResponse getBackupPlanFromJSON(GetBackupPlanFromJsonRequest getBackupPlanFromJsonRequest)
            throws LimitExceededException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBackupPlanFromJsonResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBackupPlanFromJsonResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackupPlanFromJsonRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackupPlanFromJsonRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackupPlanFromJSON");

            return clientHandler.execute(new ClientExecutionParams<GetBackupPlanFromJsonRequest, GetBackupPlanFromJsonResponse>()
                    .withOperationName("GetBackupPlanFromJSON").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBackupPlanFromJsonRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBackupPlanFromJsonRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the template specified by its <code>templateId</code> as a backup plan.
     * </p>
     *
     * @param getBackupPlanFromTemplateRequest
     * @return Result of the GetBackupPlanFromTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlanFromTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBackupPlanFromTemplateResponse getBackupPlanFromTemplate(
            GetBackupPlanFromTemplateRequest getBackupPlanFromTemplateRequest) throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBackupPlanFromTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBackupPlanFromTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackupPlanFromTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackupPlanFromTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackupPlanFromTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<GetBackupPlanFromTemplateRequest, GetBackupPlanFromTemplateResponse>()
                            .withOperationName("GetBackupPlanFromTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getBackupPlanFromTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetBackupPlanFromTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns selection metadata and a document in JSON format that specifies a list of resources that are associated
     * with a backup plan.
     * </p>
     *
     * @param getBackupSelectionRequest
     * @return Result of the GetBackupSelection operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupSelection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetBackupSelectionResponse getBackupSelection(GetBackupSelectionRequest getBackupSelectionRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBackupSelectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBackupSelectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackupSelectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackupSelectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackupSelection");

            return clientHandler.execute(new ClientExecutionParams<GetBackupSelectionRequest, GetBackupSelectionResponse>()
                    .withOperationName("GetBackupSelection").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBackupSelectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBackupSelectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the access policy document that is associated with the named backup vault.
     * </p>
     *
     * @param getBackupVaultAccessPolicyRequest
     * @return Result of the GetBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBackupVaultAccessPolicyResponse getBackupVaultAccessPolicy(
            GetBackupVaultAccessPolicyRequest getBackupVaultAccessPolicyRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBackupVaultAccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBackupVaultAccessPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackupVaultAccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackupVaultAccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackupVaultAccessPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<GetBackupVaultAccessPolicyRequest, GetBackupVaultAccessPolicyResponse>()
                            .withOperationName("GetBackupVaultAccessPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getBackupVaultAccessPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetBackupVaultAccessPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns event notifications for the specified backup vault.
     * </p>
     *
     * @param getBackupVaultNotificationsRequest
     * @return Result of the GetBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBackupVaultNotificationsResponse getBackupVaultNotifications(
            GetBackupVaultNotificationsRequest getBackupVaultNotificationsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBackupVaultNotificationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBackupVaultNotificationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBackupVaultNotificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBackupVaultNotificationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBackupVaultNotifications");

            return clientHandler
                    .execute(new ClientExecutionParams<GetBackupVaultNotificationsRequest, GetBackupVaultNotificationsResponse>()
                            .withOperationName("GetBackupVaultNotifications").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getBackupVaultNotificationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetBackupVaultNotificationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This action returns details for a specified legal hold. The details are the body of a legal hold in JSON format,
     * in addition to metadata.
     * </p>
     *
     * @param getLegalHoldRequest
     * @return Result of the GetLegalHold operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetLegalHold" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetLegalHoldResponse getLegalHold(GetLegalHoldRequest getLegalHoldRequest) throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLegalHoldResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetLegalHoldResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLegalHoldRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLegalHoldRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLegalHold");

            return clientHandler.execute(new ClientExecutionParams<GetLegalHoldRequest, GetLegalHoldResponse>()
                    .withOperationName("GetLegalHold").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getLegalHoldRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLegalHoldRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a set of metadata key-value pairs that were used to create the backup.
     * </p>
     *
     * @param getRecoveryPointRestoreMetadataRequest
     * @return Result of the GetRecoveryPointRestoreMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetRecoveryPointRestoreMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRecoveryPointRestoreMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRecoveryPointRestoreMetadataResponse getRecoveryPointRestoreMetadata(
            GetRecoveryPointRestoreMetadataRequest getRecoveryPointRestoreMetadataRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRecoveryPointRestoreMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRecoveryPointRestoreMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRecoveryPointRestoreMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRecoveryPointRestoreMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRecoveryPointRestoreMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRecoveryPointRestoreMetadataRequest, GetRecoveryPointRestoreMetadataResponse>()
                            .withOperationName("GetRecoveryPointRestoreMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getRecoveryPointRestoreMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRecoveryPointRestoreMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This request returns the metadata for the specified restore job.
     * </p>
     *
     * @param getRestoreJobMetadataRequest
     * @return Result of the GetRestoreJobMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetRestoreJobMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreJobMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetRestoreJobMetadataResponse getRestoreJobMetadata(GetRestoreJobMetadataRequest getRestoreJobMetadataRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRestoreJobMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRestoreJobMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRestoreJobMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRestoreJobMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRestoreJobMetadata");

            return clientHandler.execute(new ClientExecutionParams<GetRestoreJobMetadataRequest, GetRestoreJobMetadataResponse>()
                    .withOperationName("GetRestoreJobMetadata").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getRestoreJobMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRestoreJobMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This request returns the minimal required set of metadata needed to start a restore job with secure default
     * settings. <code>BackupVaultName</code> and <code>RecoveryPointArn</code> are required parameters.
     * <code>BackupVaultAccountId</code> is an optional parameter.
     * </p>
     *
     * @param getRestoreTestingInferredMetadataRequest
     * @return Result of the GetRestoreTestingInferredMetadata operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetRestoreTestingInferredMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingInferredMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRestoreTestingInferredMetadataResponse getRestoreTestingInferredMetadata(
            GetRestoreTestingInferredMetadataRequest getRestoreTestingInferredMetadataRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRestoreTestingInferredMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRestoreTestingInferredMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRestoreTestingInferredMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRestoreTestingInferredMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRestoreTestingInferredMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRestoreTestingInferredMetadataRequest, GetRestoreTestingInferredMetadataResponse>()
                            .withOperationName("GetRestoreTestingInferredMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getRestoreTestingInferredMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRestoreTestingInferredMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns <code>RestoreTestingPlan</code> details for the specified <code>RestoreTestingPlanName</code>. The
     * details are the body of a restore testing plan in JSON format, in addition to plan metadata.
     * </p>
     *
     * @param getRestoreTestingPlanRequest
     * @return Result of the GetRestoreTestingPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetRestoreTestingPlanResponse getRestoreTestingPlan(GetRestoreTestingPlanRequest getRestoreTestingPlanRequest)
            throws ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRestoreTestingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRestoreTestingPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRestoreTestingPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRestoreTestingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRestoreTestingPlan");

            return clientHandler.execute(new ClientExecutionParams<GetRestoreTestingPlanRequest, GetRestoreTestingPlanResponse>()
                    .withOperationName("GetRestoreTestingPlan").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getRestoreTestingPlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRestoreTestingPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns RestoreTestingSelection, which displays resources and elements of the restore testing plan.
     * </p>
     *
     * @param getRestoreTestingSelectionRequest
     * @return Result of the GetRestoreTestingSelection operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRestoreTestingSelectionResponse getRestoreTestingSelection(
            GetRestoreTestingSelectionRequest getRestoreTestingSelectionRequest) throws ResourceNotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRestoreTestingSelectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRestoreTestingSelectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRestoreTestingSelectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRestoreTestingSelectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRestoreTestingSelection");

            return clientHandler
                    .execute(new ClientExecutionParams<GetRestoreTestingSelectionRequest, GetRestoreTestingSelectionResponse>()
                            .withOperationName("GetRestoreTestingSelection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getRestoreTestingSelectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRestoreTestingSelectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the Amazon Web Services resource types supported by Backup.
     * </p>
     *
     * @param getSupportedResourceTypesRequest
     * @return Result of the GetSupportedResourceTypes operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSupportedResourceTypesResponse getSupportedResourceTypes(
            GetSupportedResourceTypesRequest getSupportedResourceTypesRequest) throws ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSupportedResourceTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSupportedResourceTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSupportedResourceTypesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSupportedResourceTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSupportedResourceTypes");

            return clientHandler
                    .execute(new ClientExecutionParams<GetSupportedResourceTypesRequest, GetSupportedResourceTypesResponse>()
                            .withOperationName("GetSupportedResourceTypes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getSupportedResourceTypesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetSupportedResourceTypesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This is a request for a summary of backup jobs created or running within the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     *
     * @param listBackupJobSummariesRequest
     * @return Result of the ListBackupJobSummaries operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListBackupJobSummariesResponse listBackupJobSummaries(ListBackupJobSummariesRequest listBackupJobSummariesRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBackupJobSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBackupJobSummariesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackupJobSummariesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackupJobSummariesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackupJobSummaries");

            return clientHandler
                    .execute(new ClientExecutionParams<ListBackupJobSummariesRequest, ListBackupJobSummariesResponse>()
                            .withOperationName("ListBackupJobSummaries").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listBackupJobSummariesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListBackupJobSummariesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of
     * time, consider using these <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">monitoring tools</a>.
     * </p>
     *
     * @param listBackupJobsRequest
     * @return Result of the ListBackupJobs operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListBackupJobsResponse listBackupJobs(ListBackupJobsRequest listBackupJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBackupJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBackupJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackupJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackupJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackupJobs");

            return clientHandler.execute(new ClientExecutionParams<ListBackupJobsRequest, ListBackupJobsResponse>()
                    .withOperationName("ListBackupJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBackupJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBackupJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     *
     * @param listBackupPlanTemplatesRequest
     * @return Result of the ListBackupPlanTemplates operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBackupPlanTemplatesResponse listBackupPlanTemplates(ListBackupPlanTemplatesRequest listBackupPlanTemplatesRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBackupPlanTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBackupPlanTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackupPlanTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackupPlanTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackupPlanTemplates");

            return clientHandler
                    .execute(new ClientExecutionParams<ListBackupPlanTemplatesRequest, ListBackupPlanTemplatesResponse>()
                            .withOperationName("ListBackupPlanTemplates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listBackupPlanTemplatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListBackupPlanTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation
     * and deletion dates, plan names, and version IDs.
     * </p>
     *
     * @param listBackupPlanVersionsRequest
     * @return Result of the ListBackupPlanVersions operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListBackupPlanVersionsResponse listBackupPlanVersions(ListBackupPlanVersionsRequest listBackupPlanVersionsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBackupPlanVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBackupPlanVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackupPlanVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackupPlanVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackupPlanVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListBackupPlanVersionsRequest, ListBackupPlanVersionsResponse>()
                            .withOperationName("ListBackupPlanVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listBackupPlanVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListBackupPlanVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as
     * Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request
     * IDs.
     * </p>
     *
     * @param listBackupPlansRequest
     * @return Result of the ListBackupPlans operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListBackupPlansResponse listBackupPlans(ListBackupPlansRequest listBackupPlansRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBackupPlansResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBackupPlansResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackupPlansRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackupPlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackupPlans");

            return clientHandler.execute(new ClientExecutionParams<ListBackupPlansRequest, ListBackupPlansResponse>()
                    .withOperationName("ListBackupPlans").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBackupPlansRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBackupPlansRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns an array containing metadata of the resources associated with the target backup plan.
     * </p>
     *
     * @param listBackupSelectionsRequest
     * @return Result of the ListBackupSelections operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListBackupSelectionsResponse listBackupSelections(ListBackupSelectionsRequest listBackupSelectionsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBackupSelectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBackupSelectionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackupSelectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackupSelectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackupSelections");

            return clientHandler.execute(new ClientExecutionParams<ListBackupSelectionsRequest, ListBackupSelectionsResponse>()
                    .withOperationName("ListBackupSelections").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBackupSelectionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBackupSelectionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     *
     * @param listBackupVaultsRequest
     * @return Result of the ListBackupVaults operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupVaults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListBackupVaultsResponse listBackupVaults(ListBackupVaultsRequest listBackupVaultsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBackupVaultsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBackupVaultsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBackupVaultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBackupVaultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBackupVaults");

            return clientHandler.execute(new ClientExecutionParams<ListBackupVaultsRequest, ListBackupVaultsResponse>()
                    .withOperationName("ListBackupVaults").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBackupVaultsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBackupVaultsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This request obtains a list of copy jobs created or running within the the most recent 30 days. You can include
     * parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter
     * results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     *
     * @param listCopyJobSummariesRequest
     * @return Result of the ListCopyJobSummaries operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListCopyJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListCopyJobSummariesResponse listCopyJobSummaries(ListCopyJobSummariesRequest listCopyJobSummariesRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCopyJobSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCopyJobSummariesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCopyJobSummariesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCopyJobSummariesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCopyJobSummaries");

            return clientHandler.execute(new ClientExecutionParams<ListCopyJobSummariesRequest, ListCopyJobSummariesResponse>()
                    .withOperationName("ListCopyJobSummaries").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCopyJobSummariesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCopyJobSummariesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns metadata about your copy jobs.
     * </p>
     *
     * @param listCopyJobsRequest
     * @return Result of the ListCopyJobs operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListCopyJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCopyJobsResponse listCopyJobs(ListCopyJobsRequest listCopyJobsRequest) throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCopyJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListCopyJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCopyJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCopyJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCopyJobs");

            return clientHandler.execute(new ClientExecutionParams<ListCopyJobsRequest, ListCopyJobsResponse>()
                    .withOperationName("ListCopyJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCopyJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCopyJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
     * </p>
     *
     * @param listFrameworksRequest
     * @return Result of the ListFrameworks operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListFrameworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListFrameworks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFrameworksResponse listFrameworks(ListFrameworksRequest listFrameworksRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFrameworksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFrameworksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFrameworksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFrameworksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFrameworks");

            return clientHandler.execute(new ClientExecutionParams<ListFrameworksRequest, ListFrameworksResponse>()
                    .withOperationName("ListFrameworks").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listFrameworksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFrameworksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This action returns metadata about active and previous legal holds.
     * </p>
     *
     * @param listLegalHoldsRequest
     * @return Result of the ListLegalHolds operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListLegalHolds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListLegalHolds" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListLegalHoldsResponse listLegalHolds(ListLegalHoldsRequest listLegalHoldsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLegalHoldsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListLegalHoldsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLegalHoldsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLegalHoldsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLegalHolds");

            return clientHandler.execute(new ClientExecutionParams<ListLegalHoldsRequest, ListLegalHoldsResponse>()
                    .withOperationName("ListLegalHolds").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listLegalHoldsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListLegalHoldsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     *
     * @param listProtectedResourcesRequest
     * @return Result of the ListProtectedResources operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListProtectedResourcesResponse listProtectedResources(ListProtectedResourcesRequest listProtectedResourcesRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProtectedResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListProtectedResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProtectedResourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProtectedResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProtectedResources");

            return clientHandler
                    .execute(new ClientExecutionParams<ListProtectedResourcesRequest, ListProtectedResourcesResponse>()
                            .withOperationName("ListProtectedResources").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listProtectedResourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListProtectedResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This request lists the protected resources corresponding to each backup vault.
     * </p>
     *
     * @param listProtectedResourcesByBackupVaultRequest
     * @return Result of the ListProtectedResourcesByBackupVault operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResourcesByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResourcesByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListProtectedResourcesByBackupVaultResponse listProtectedResourcesByBackupVault(
            ListProtectedResourcesByBackupVaultRequest listProtectedResourcesByBackupVaultRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProtectedResourcesByBackupVaultResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListProtectedResourcesByBackupVaultResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProtectedResourcesByBackupVaultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listProtectedResourcesByBackupVaultRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProtectedResourcesByBackupVault");

            return clientHandler
                    .execute(new ClientExecutionParams<ListProtectedResourcesByBackupVaultRequest, ListProtectedResourcesByBackupVaultResponse>()
                            .withOperationName("ListProtectedResourcesByBackupVault").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listProtectedResourcesByBackupVaultRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListProtectedResourcesByBackupVaultRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns detailed information about the recovery points stored in a backup vault.
     * </p>
     *
     * @param listRecoveryPointsByBackupVaultRequest
     * @return Result of the ListRecoveryPointsByBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByBackupVault
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRecoveryPointsByBackupVaultResponse listRecoveryPointsByBackupVault(
            ListRecoveryPointsByBackupVaultRequest listRecoveryPointsByBackupVaultRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRecoveryPointsByBackupVaultResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRecoveryPointsByBackupVaultResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRecoveryPointsByBackupVaultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listRecoveryPointsByBackupVaultRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecoveryPointsByBackupVault");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRecoveryPointsByBackupVaultRequest, ListRecoveryPointsByBackupVaultResponse>()
                            .withOperationName("ListRecoveryPointsByBackupVault").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listRecoveryPointsByBackupVaultRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListRecoveryPointsByBackupVaultRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This action returns recovery point ARNs (Amazon Resource Names) of the specified legal hold.
     * </p>
     *
     * @param listRecoveryPointsByLegalHoldRequest
     * @return Result of the ListRecoveryPointsByLegalHold operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByLegalHold
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByLegalHold"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRecoveryPointsByLegalHoldResponse listRecoveryPointsByLegalHold(
            ListRecoveryPointsByLegalHoldRequest listRecoveryPointsByLegalHoldRequest) throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRecoveryPointsByLegalHoldResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRecoveryPointsByLegalHoldResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRecoveryPointsByLegalHoldRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listRecoveryPointsByLegalHoldRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecoveryPointsByLegalHold");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRecoveryPointsByLegalHoldRequest, ListRecoveryPointsByLegalHoldResponse>()
                            .withOperationName("ListRecoveryPointsByLegalHold").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listRecoveryPointsByLegalHoldRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListRecoveryPointsByLegalHoldRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource
     * Name (ARN).
     * </p>
     * <note>
     * <p>
     * For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.
     * </p>
     * </note>
     *
     * @param listRecoveryPointsByResourceRequest
     * @return Result of the ListRecoveryPointsByResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRecoveryPointsByResourceResponse listRecoveryPointsByResource(
            ListRecoveryPointsByResourceRequest listRecoveryPointsByResourceRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRecoveryPointsByResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRecoveryPointsByResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRecoveryPointsByResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRecoveryPointsByResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRecoveryPointsByResource");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRecoveryPointsByResourceRequest, ListRecoveryPointsByResourceResponse>()
                            .withOperationName("ListRecoveryPointsByResource").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listRecoveryPointsByResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListRecoveryPointsByResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns details about your report jobs.
     * </p>
     *
     * @param listReportJobsRequest
     * @return Result of the ListReportJobs operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListReportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListReportJobsResponse listReportJobs(ListReportJobsRequest listReportJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReportJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListReportJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReportJobs");

            return clientHandler.execute(new ClientExecutionParams<ListReportJobsRequest, ListReportJobsResponse>()
                    .withOperationName("ListReportJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listReportJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListReportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of your report plans. For detailed information about a single report plan, use
     * <code>DescribeReportPlan</code>.
     * </p>
     *
     * @param listReportPlansRequest
     * @return Result of the ListReportPlans operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListReportPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportPlans" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListReportPlansResponse listReportPlans(ListReportPlansRequest listReportPlansRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReportPlansResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListReportPlansResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReportPlansRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReportPlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReportPlans");

            return clientHandler.execute(new ClientExecutionParams<ListReportPlansRequest, ListReportPlansResponse>()
                    .withOperationName("ListReportPlans").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listReportPlansRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListReportPlansRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This request obtains a summary of restore jobs created or running within the the most recent 30 days. You can
     * include parameters AccountID, State, ResourceType, AggregationPeriod, MaxResults, or NextToken to filter results.
     * </p>
     * <p>
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime,
     * EndTime, and Count of included jobs.
     * </p>
     *
     * @param listRestoreJobSummariesRequest
     * @return Result of the ListRestoreJobSummaries operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRestoreJobSummariesResponse listRestoreJobSummaries(ListRestoreJobSummariesRequest listRestoreJobSummariesRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRestoreJobSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRestoreJobSummariesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRestoreJobSummariesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRestoreJobSummariesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRestoreJobSummaries");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRestoreJobSummariesRequest, ListRestoreJobSummariesResponse>()
                            .withOperationName("ListRestoreJobSummaries").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listRestoreJobSummariesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListRestoreJobSummariesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery
     * process.
     * </p>
     *
     * @param listRestoreJobsRequest
     * @return Result of the ListRestoreJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRestoreJobsResponse listRestoreJobs(ListRestoreJobsRequest listRestoreJobsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRestoreJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRestoreJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRestoreJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRestoreJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRestoreJobs");

            return clientHandler.execute(new ClientExecutionParams<ListRestoreJobsRequest, ListRestoreJobsResponse>()
                    .withOperationName("ListRestoreJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listRestoreJobsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRestoreJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This returns restore jobs that contain the specified protected resource.
     * </p>
     * <p>
     * You must include <code>ResourceArn</code>. You can optionally include <code>NextToken</code>,
     * <code>ByStatus</code>, <code>MaxResults</code>, <code>ByRecoveryPointCreationDateAfter</code> , and
     * <code>ByRecoveryPointCreationDateBefore</code>.
     * </p>
     *
     * @param listRestoreJobsByProtectedResourceRequest
     * @return Result of the ListRestoreJobsByProtectedResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobsByProtectedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobsByProtectedResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRestoreJobsByProtectedResourceResponse listRestoreJobsByProtectedResource(
            ListRestoreJobsByProtectedResourceRequest listRestoreJobsByProtectedResourceRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRestoreJobsByProtectedResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRestoreJobsByProtectedResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRestoreJobsByProtectedResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listRestoreJobsByProtectedResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRestoreJobsByProtectedResource");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRestoreJobsByProtectedResourceRequest, ListRestoreJobsByProtectedResourceResponse>()
                            .withOperationName("ListRestoreJobsByProtectedResource").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listRestoreJobsByProtectedResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListRestoreJobsByProtectedResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of restore testing plans.
     * </p>
     *
     * @param listRestoreTestingPlansRequest
     * @return Result of the ListRestoreTestingPlans operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreTestingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRestoreTestingPlansResponse listRestoreTestingPlans(ListRestoreTestingPlansRequest listRestoreTestingPlansRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRestoreTestingPlansResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRestoreTestingPlansResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRestoreTestingPlansRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRestoreTestingPlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRestoreTestingPlans");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRestoreTestingPlansRequest, ListRestoreTestingPlansResponse>()
                            .withOperationName("ListRestoreTestingPlans").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listRestoreTestingPlansRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListRestoreTestingPlansRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of restore testing selections. Can be filtered by <code>MaxResults</code> and
     * <code>RestoreTestingPlanName</code>.
     * </p>
     *
     * @param listRestoreTestingSelectionsRequest
     * @return Result of the ListRestoreTestingSelections operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreTestingSelections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingSelections"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRestoreTestingSelectionsResponse listRestoreTestingSelections(
            ListRestoreTestingSelectionsRequest listRestoreTestingSelectionsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRestoreTestingSelectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRestoreTestingSelectionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRestoreTestingSelectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRestoreTestingSelectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRestoreTestingSelections");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRestoreTestingSelectionsRequest, ListRestoreTestingSelectionsResponse>()
                            .withOperationName("ListRestoreTestingSelections").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listRestoreTestingSelectionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListRestoreTestingSelectionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     * </p>
     * <p>
     * <code>ListTags</code> only works for resource types that support full Backup management of their backups. Those
     * resource types are listed in the "Full Backup management" section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTags");

            return clientHandler.execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>()
                    .withOperationName("ListTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listTagsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a
     * backup vault name and an access policy document in JSON format.
     * </p>
     *
     * @param putBackupVaultAccessPolicyRequest
     * @return Result of the PutBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.PutBackupVaultAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutBackupVaultAccessPolicyResponse putBackupVaultAccessPolicy(
            PutBackupVaultAccessPolicyRequest putBackupVaultAccessPolicyRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutBackupVaultAccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutBackupVaultAccessPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putBackupVaultAccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putBackupVaultAccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBackupVaultAccessPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<PutBackupVaultAccessPolicyRequest, PutBackupVaultAccessPolicyResponse>()
                            .withOperationName("PutBackupVaultAccessPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putBackupVaultAccessPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutBackupVaultAccessPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or
     * created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the
     * retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a
     * minimum and maximum retention period for future backup and copy jobs that target a backup vault.
     * </p>
     * <note>
     * <p>
     * Backup Vault Lock has been assessed by Cohasset Associates for use in environments that are subject to SEC 17a-4,
     * CFTC, and FINRA regulations. For more information about how Backup Vault Lock relates to these regulations, see
     * the <a href="samples/cohassetreport.zip">Cohasset Associates Compliance Assessment.</a>
     * </p>
     * </note>
     *
     * @param putBackupVaultLockConfigurationRequest
     * @return Result of the PutBackupVaultLockConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.PutBackupVaultLockConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultLockConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutBackupVaultLockConfigurationResponse putBackupVaultLockConfiguration(
            PutBackupVaultLockConfigurationRequest putBackupVaultLockConfigurationRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, InvalidRequestException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutBackupVaultLockConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutBackupVaultLockConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putBackupVaultLockConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putBackupVaultLockConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBackupVaultLockConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<PutBackupVaultLockConfigurationRequest, PutBackupVaultLockConfigurationResponse>()
                            .withOperationName("PutBackupVaultLockConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putBackupVaultLockConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutBackupVaultLockConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Turns on notifications on a backup vault for the specified topic and events.
     * </p>
     *
     * @param putBackupVaultNotificationsRequest
     * @return Result of the PutBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.PutBackupVaultNotifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutBackupVaultNotificationsResponse putBackupVaultNotifications(
            PutBackupVaultNotificationsRequest putBackupVaultNotificationsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutBackupVaultNotificationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutBackupVaultNotificationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putBackupVaultNotificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putBackupVaultNotificationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutBackupVaultNotifications");

            return clientHandler
                    .execute(new ClientExecutionParams<PutBackupVaultNotificationsRequest, PutBackupVaultNotificationsResponse>()
                            .withOperationName("PutBackupVaultNotifications").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putBackupVaultNotificationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutBackupVaultNotificationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This request allows you to send your independent self-run restore test validation results.
     * <code>RestoreJobId</code> and <code>ValidationStatus</code> are required. Optionally, you can input a
     * <code>ValidationStatusMessage</code>.
     * </p>
     *
     * @param putRestoreValidationResultRequest
     * @return Result of the PutRestoreValidationResult operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.PutRestoreValidationResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutRestoreValidationResult"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutRestoreValidationResultResponse putRestoreValidationResult(
            PutRestoreValidationResultRequest putRestoreValidationResultRequest) throws InvalidParameterValueException,
            InvalidRequestException, MissingParameterValueException, ResourceNotFoundException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutRestoreValidationResultResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutRestoreValidationResultResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putRestoreValidationResultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRestoreValidationResultRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRestoreValidationResult");

            return clientHandler
                    .execute(new ClientExecutionParams<PutRestoreValidationResultRequest, PutRestoreValidationResultResponse>()
                            .withOperationName("PutRestoreValidationResult").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putRestoreValidationResultRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutRestoreValidationResultRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an on-demand backup job for the specified resource.
     * </p>
     *
     * @param startBackupJobRequest
     * @return Result of the StartBackupJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartBackupJobResponse startBackupJob(StartBackupJobRequest startBackupJobRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, InvalidRequestException, ServiceUnavailableException,
            LimitExceededException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartBackupJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartBackupJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startBackupJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startBackupJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartBackupJob");

            return clientHandler.execute(new ClientExecutionParams<StartBackupJobRequest, StartBackupJobResponse>()
                    .withOperationName("StartBackupJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startBackupJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartBackupJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a job to create a one-time copy of the specified resource.
     * </p>
     * <p>
     * Does not support continuous backups.
     * </p>
     *
     * @param startCopyJobRequest
     * @return Result of the StartCopyJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartCopyJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartCopyJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartCopyJobResponse startCopyJob(StartCopyJobRequest startCopyJobRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException,
            InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartCopyJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartCopyJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startCopyJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startCopyJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartCopyJob");

            return clientHandler.execute(new ClientExecutionParams<StartCopyJobRequest, StartCopyJobResponse>()
                    .withOperationName("StartCopyJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startCopyJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartCopyJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an on-demand report job for the specified report plan.
     * </p>
     *
     * @param startReportJobRequest
     * @return Result of the StartReportJob operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartReportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartReportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartReportJobResponse startReportJob(StartReportJobRequest startReportJobRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, MissingParameterValueException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartReportJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartReportJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReportJob");

            return clientHandler.execute(new ClientExecutionParams<StartReportJobRequest, StartReportJobResponse>()
                    .withOperationName("StartReportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startReportJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartReportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Recovers the saved resource identified by an Amazon Resource Name (ARN).
     * </p>
     *
     * @param startRestoreJobRequest
     * @return Result of the StartRestoreJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartRestoreJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartRestoreJobResponse startRestoreJob(StartRestoreJobRequest startRestoreJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartRestoreJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartRestoreJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startRestoreJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startRestoreJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartRestoreJob");

            return clientHandler.execute(new ClientExecutionParams<StartRestoreJobRequest, StartRestoreJobResponse>()
                    .withOperationName("StartRestoreJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startRestoreJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartRestoreJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attempts to cancel a job to create a one-time backup of a resource.
     * </p>
     * <p>
     * This action is not supported for the following services: Amazon FSx for Windows File Server, Amazon FSx for
     * Lustre, Amazon FSx for NetApp ONTAP , Amazon FSx for OpenZFS, Amazon DocumentDB (with MongoDB compatibility),
     * Amazon RDS, Amazon Aurora, and Amazon Neptune.
     * </p>
     *
     * @param stopBackupJobRequest
     * @return Result of the StopBackupJob operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StopBackupJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StopBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopBackupJobResponse stopBackupJob(StopBackupJobRequest stopBackupJobRequest) throws MissingParameterValueException,
            ResourceNotFoundException, InvalidParameterValueException, InvalidRequestException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopBackupJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopBackupJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopBackupJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopBackupJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopBackupJob");

            return clientHandler.execute(new ClientExecutionParams<StopBackupJobRequest, StopBackupJobResponse>()
                    .withOperationName("StopBackupJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopBackupJobRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopBackupJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN).
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException,
            AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN)
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing backup plan identified by its <code>backupPlanId</code> with the input document in JSON
     * format. The new version is uniquely identified by a <code>VersionId</code>.
     * </p>
     *
     * @param updateBackupPlanRequest
     * @return Result of the UpdateBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateBackupPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateBackupPlanResponse updateBackupPlan(UpdateBackupPlanRequest updateBackupPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBackupPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateBackupPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBackupPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBackupPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBackupPlan");

            return clientHandler.execute(new ClientExecutionParams<UpdateBackupPlanRequest, UpdateBackupPlanResponse>()
                    .withOperationName("UpdateBackupPlan").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBackupPlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBackupPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing framework identified by its <code>FrameworkName</code> with the input document in JSON
     * format.
     * </p>
     *
     * @param updateFrameworkRequest
     * @return Result of the UpdateFramework operation returned by the service.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateFramework
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateFramework" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateFrameworkResponse updateFramework(UpdateFrameworkRequest updateFrameworkRequest) throws AlreadyExistsException,
            ResourceNotFoundException, LimitExceededException, InvalidParameterValueException, MissingParameterValueException,
            ConflictException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFrameworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateFrameworkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFrameworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFrameworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFramework");

            return clientHandler.execute(new ClientExecutionParams<UpdateFrameworkRequest, UpdateFrameworkResponse>()
                    .withOperationName("UpdateFramework").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateFrameworkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFrameworkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the
     * account is not an Organizations management account. Use the <code>DescribeGlobalSettings</code> API to determine
     * the current settings.
     * </p>
     *
     * @param updateGlobalSettingsRequest
     * @return Result of the UpdateGlobalSettings operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateGlobalSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateGlobalSettingsResponse updateGlobalSettings(UpdateGlobalSettingsRequest updateGlobalSettingsRequest)
            throws ServiceUnavailableException, MissingParameterValueException, InvalidParameterValueException,
            InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGlobalSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateGlobalSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGlobalSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGlobalSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGlobalSettings");

            return clientHandler.execute(new ClientExecutionParams<UpdateGlobalSettingsRequest, UpdateGlobalSettingsResponse>()
                    .withOperationName("UpdateGlobalSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateGlobalSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateGlobalSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the transition lifecycle of a recovery point.
     * </p>
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
     * “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to
     * cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * <p>
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage"
     * section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table. Backup ignores this expression for other resource types.
     * </p>
     * <p>
     * This operation does not support continuous backups.
     * </p>
     *
     * @param updateRecoveryPointLifecycleRequest
     * @return Result of the UpdateRecoveryPointLifecycle operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateRecoveryPointLifecycle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRecoveryPointLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRecoveryPointLifecycleResponse updateRecoveryPointLifecycle(
            UpdateRecoveryPointLifecycleRequest updateRecoveryPointLifecycleRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, InvalidRequestException, MissingParameterValueException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRecoveryPointLifecycleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRecoveryPointLifecycleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRecoveryPointLifecycleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRecoveryPointLifecycleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRecoveryPointLifecycle");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateRecoveryPointLifecycleRequest, UpdateRecoveryPointLifecycleResponse>()
                            .withOperationName("UpdateRecoveryPointLifecycle").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateRecoveryPointLifecycleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateRecoveryPointLifecycleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the current service opt-in settings for the Region.
     * </p>
     * <p>
     * Use the <code>DescribeRegionSettings</code> API to determine the resource types that are supported.
     * </p>
     *
     * @param updateRegionSettingsRequest
     * @return Result of the UpdateRegionSettings operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateRegionSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRegionSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateRegionSettingsResponse updateRegionSettings(UpdateRegionSettingsRequest updateRegionSettingsRequest)
            throws ServiceUnavailableException, MissingParameterValueException, InvalidParameterValueException,
            AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRegionSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRegionSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRegionSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRegionSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRegionSettings");

            return clientHandler.execute(new ClientExecutionParams<UpdateRegionSettingsRequest, UpdateRegionSettingsResponse>()
                    .withOperationName("UpdateRegionSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateRegionSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRegionSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing report plan identified by its <code>ReportPlanName</code> with the input document in JSON
     * format.
     * </p>
     *
     * @param updateReportPlanRequest
     * @return Result of the UpdateReportPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateReportPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateReportPlan" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateReportPlanResponse updateReportPlan(UpdateReportPlanRequest updateReportPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, ServiceUnavailableException,
            MissingParameterValueException, ConflictException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateReportPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateReportPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateReportPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateReportPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateReportPlan");

            return clientHandler.execute(new ClientExecutionParams<UpdateReportPlanRequest, UpdateReportPlanResponse>()
                    .withOperationName("UpdateReportPlan").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateReportPlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateReportPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This request will send changes to your specified restore testing plan. <code>RestoreTestingPlanName</code> cannot
     * be updated after it is created.
     * </p>
     * <p>
     * <code>RecoveryPointSelection</code> can contain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Algorithm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExcludeVaults</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IncludeVaults</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RecoveryPointTypes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SelectionWindowDays</code>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateRestoreTestingPlanRequest
     * @return Result of the UpdateRestoreTestingPlan operation returned by the service.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateRestoreTestingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRestoreTestingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRestoreTestingPlanResponse updateRestoreTestingPlan(
            UpdateRestoreTestingPlanRequest updateRestoreTestingPlanRequest) throws ConflictException,
            InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRestoreTestingPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRestoreTestingPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRestoreTestingPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRestoreTestingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRestoreTestingPlan");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateRestoreTestingPlanRequest, UpdateRestoreTestingPlanResponse>()
                            .withOperationName("UpdateRestoreTestingPlan").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateRestoreTestingPlanRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateRestoreTestingPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Most elements except the <code>RestoreTestingSelectionName</code> can be updated with this request.
     * </p>
     * <p>
     * <code>RestoreTestingSelection</code> can use either protected resource ARNs or conditions, but not both. That is,
     * if your selection has <code>ProtectedResourceArns</code>, requesting an update with the parameter
     * <code>ProtectedResourceConditions</code> will be unsuccessful.
     * </p>
     *
     * @param updateRestoreTestingSelectionRequest
     * @return Result of the UpdateRestoreTestingSelection operation returned by the service.
     * @throws ConflictException
     *         Backup can't perform the action that you requested until it finishes performing a previous action. Try
     *         again later.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateRestoreTestingSelection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRestoreTestingSelection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRestoreTestingSelectionResponse updateRestoreTestingSelection(
            UpdateRestoreTestingSelectionRequest updateRestoreTestingSelectionRequest) throws ConflictException,
            InvalidParameterValueException, MissingParameterValueException, ResourceNotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRestoreTestingSelectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRestoreTestingSelectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRestoreTestingSelectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateRestoreTestingSelectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Backup");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRestoreTestingSelection");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateRestoreTestingSelectionRequest, UpdateRestoreTestingSelectionResponse>()
                            .withOperationName("UpdateRestoreTestingSelection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateRestoreTestingSelectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateRestoreTestingSelectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        BackupServiceClientConfigurationBuilder serviceConfigBuilder = new BackupServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(BackupException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MissingParameterValueException")
                                .exceptionBuilderSupplier(MissingParameterValueException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DependencyFailureException")
                                .exceptionBuilderSupplier(DependencyFailureException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AlreadyExistsException")
                                .exceptionBuilderSupplier(AlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResourceStateException")
                                .exceptionBuilderSupplier(InvalidResourceStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
    }

    @Override
    public final BackupServiceClientConfiguration serviceClientConfiguration() {
        return new BackupServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
