/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReportPlanRequest extends BackupRequest implements
        ToCopyableBuilder<CreateReportPlanRequest.Builder, CreateReportPlanRequest> {
    private static final SdkField<String> REPORT_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportPlanName").getter(getter(CreateReportPlanRequest::reportPlanName))
            .setter(setter(Builder::reportPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanName").build()).build();

    private static final SdkField<String> REPORT_PLAN_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportPlanDescription").getter(getter(CreateReportPlanRequest::reportPlanDescription))
            .setter(setter(Builder::reportPlanDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanDescription").build())
            .build();

    private static final SdkField<ReportDeliveryChannel> REPORT_DELIVERY_CHANNEL_FIELD = SdkField
            .<ReportDeliveryChannel> builder(MarshallingType.SDK_POJO).memberName("ReportDeliveryChannel")
            .getter(getter(CreateReportPlanRequest::reportDeliveryChannel)).setter(setter(Builder::reportDeliveryChannel))
            .constructor(ReportDeliveryChannel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportDeliveryChannel").build())
            .build();

    private static final SdkField<ReportSetting> REPORT_SETTING_FIELD = SdkField
            .<ReportSetting> builder(MarshallingType.SDK_POJO).memberName("ReportSetting")
            .getter(getter(CreateReportPlanRequest::reportSetting)).setter(setter(Builder::reportSetting))
            .constructor(ReportSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportSetting").build()).build();

    private static final SdkField<Map<String, String>> REPORT_PLAN_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ReportPlanTags")
            .getter(getter(CreateReportPlanRequest::reportPlanTags))
            .setter(setter(Builder::reportPlanTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(CreateReportPlanRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_PLAN_NAME_FIELD,
            REPORT_PLAN_DESCRIPTION_FIELD, REPORT_DELIVERY_CHANNEL_FIELD, REPORT_SETTING_FIELD, REPORT_PLAN_TAGS_FIELD,
            IDEMPOTENCY_TOKEN_FIELD));

    private final String reportPlanName;

    private final String reportPlanDescription;

    private final ReportDeliveryChannel reportDeliveryChannel;

    private final ReportSetting reportSetting;

    private final Map<String, String> reportPlanTags;

    private final String idempotencyToken;

    private CreateReportPlanRequest(BuilderImpl builder) {
        super(builder);
        this.reportPlanName = builder.reportPlanName;
        this.reportPlanDescription = builder.reportPlanDescription;
        this.reportDeliveryChannel = builder.reportDeliveryChannel;
        this.reportSetting = builder.reportSetting;
        this.reportPlanTags = builder.reportPlanTags;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The unique name of the report plan. The name must be between 1 and 256 characters, starting with a letter, and
     * consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     * </p>
     * 
     * @return The unique name of the report plan. The name must be between 1 and 256 characters, starting with a
     *         letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     */
    public final String reportPlanName() {
        return reportPlanName;
    }

    /**
     * <p>
     * An optional description of the report plan with a maximum of 1,024 characters.
     * </p>
     * 
     * @return An optional description of the report plan with a maximum of 1,024 characters.
     */
    public final String reportPlanDescription() {
        return reportPlanDescription;
    }

    /**
     * <p>
     * A structure that contains information about where and how to deliver your reports, specifically your Amazon S3
     * bucket name, S3 key prefix, and the formats of your reports.
     * </p>
     * 
     * @return A structure that contains information about where and how to deliver your reports, specifically your
     *         Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
     */
    public final ReportDeliveryChannel reportDeliveryChannel() {
        return reportDeliveryChannel;
    }

    /**
     * <p>
     * Identifies the report template for the report. Reports are built using a report template. The report templates
     * are:
     * </p>
     * <p>
     * <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
     * </p>
     * <p>
     * If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code>, this
     * API resource also describes the report coverage by Amazon Web Services Regions and frameworks.
     * </p>
     * 
     * @return Identifies the report template for the report. Reports are built using a report template. The report
     *         templates are:</p>
     *         <p>
     *         <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
     *         </p>
     *         <p>
     *         If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
     *         <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report coverage by Amazon
     *         Web Services Regions and frameworks.
     */
    public final ReportSetting reportSetting() {
        return reportSetting;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReportPlanTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReportPlanTags() {
        return reportPlanTags != null && !(reportPlanTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the report plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReportPlanTags} method.
     * </p>
     * 
     * @return The tags to assign to the report plan.
     */
    public final Map<String, String> reportPlanTags() {
        return reportPlanTags;
    }

    /**
     * <p>
     * A customer-chosen string that you can use to distinguish between otherwise identical calls to
     * <code>CreateReportPlanInput</code>. Retrying a successful request with the same idempotency token results in a
     * success message with no action taken.
     * </p>
     * 
     * @return A customer-chosen string that you can use to distinguish between otherwise identical calls to
     *         <code>CreateReportPlanInput</code>. Retrying a successful request with the same idempotency token results
     *         in a success message with no action taken.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(reportPlanDescription());
        hashCode = 31 * hashCode + Objects.hashCode(reportDeliveryChannel());
        hashCode = 31 * hashCode + Objects.hashCode(reportSetting());
        hashCode = 31 * hashCode + Objects.hashCode(hasReportPlanTags() ? reportPlanTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReportPlanRequest)) {
            return false;
        }
        CreateReportPlanRequest other = (CreateReportPlanRequest) obj;
        return Objects.equals(reportPlanName(), other.reportPlanName())
                && Objects.equals(reportPlanDescription(), other.reportPlanDescription())
                && Objects.equals(reportDeliveryChannel(), other.reportDeliveryChannel())
                && Objects.equals(reportSetting(), other.reportSetting()) && hasReportPlanTags() == other.hasReportPlanTags()
                && Objects.equals(reportPlanTags(), other.reportPlanTags())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReportPlanRequest").add("ReportPlanName", reportPlanName())
                .add("ReportPlanDescription", reportPlanDescription()).add("ReportDeliveryChannel", reportDeliveryChannel())
                .add("ReportSetting", reportSetting()).add("ReportPlanTags", hasReportPlanTags() ? reportPlanTags() : null)
                .add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportPlanName":
            return Optional.ofNullable(clazz.cast(reportPlanName()));
        case "ReportPlanDescription":
            return Optional.ofNullable(clazz.cast(reportPlanDescription()));
        case "ReportDeliveryChannel":
            return Optional.ofNullable(clazz.cast(reportDeliveryChannel()));
        case "ReportSetting":
            return Optional.ofNullable(clazz.cast(reportSetting()));
        case "ReportPlanTags":
            return Optional.ofNullable(clazz.cast(reportPlanTags()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReportPlanRequest, T> g) {
        return obj -> g.apply((CreateReportPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateReportPlanRequest> {
        /**
         * <p>
         * The unique name of the report plan. The name must be between 1 and 256 characters, starting with a letter,
         * and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * </p>
         * 
         * @param reportPlanName
         *        The unique name of the report plan. The name must be between 1 and 256 characters, starting with a
         *        letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportPlanName(String reportPlanName);

        /**
         * <p>
         * An optional description of the report plan with a maximum of 1,024 characters.
         * </p>
         * 
         * @param reportPlanDescription
         *        An optional description of the report plan with a maximum of 1,024 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportPlanDescription(String reportPlanDescription);

        /**
         * <p>
         * A structure that contains information about where and how to deliver your reports, specifically your Amazon
         * S3 bucket name, S3 key prefix, and the formats of your reports.
         * </p>
         * 
         * @param reportDeliveryChannel
         *        A structure that contains information about where and how to deliver your reports, specifically your
         *        Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportDeliveryChannel(ReportDeliveryChannel reportDeliveryChannel);

        /**
         * <p>
         * A structure that contains information about where and how to deliver your reports, specifically your Amazon
         * S3 bucket name, S3 key prefix, and the formats of your reports.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportDeliveryChannel.Builder} avoiding
         * the need to create one manually via {@link ReportDeliveryChannel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportDeliveryChannel.Builder#build()} is called immediately and
         * its result is passed to {@link #reportDeliveryChannel(ReportDeliveryChannel)}.
         * 
         * @param reportDeliveryChannel
         *        a consumer that will call methods on {@link ReportDeliveryChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportDeliveryChannel(ReportDeliveryChannel)
         */
        default Builder reportDeliveryChannel(Consumer<ReportDeliveryChannel.Builder> reportDeliveryChannel) {
            return reportDeliveryChannel(ReportDeliveryChannel.builder().applyMutation(reportDeliveryChannel).build());
        }

        /**
         * <p>
         * Identifies the report template for the report. Reports are built using a report template. The report
         * templates are:
         * </p>
         * <p>
         * <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         * </p>
         * <p>
         * If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code>,
         * this API resource also describes the report coverage by Amazon Web Services Regions and frameworks.
         * </p>
         * 
         * @param reportSetting
         *        Identifies the report template for the report. Reports are built using a report template. The report
         *        templates are:</p>
         *        <p>
         *        <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         *        </p>
         *        <p>
         *        If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
         *        <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report coverage by Amazon
         *        Web Services Regions and frameworks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportSetting(ReportSetting reportSetting);

        /**
         * <p>
         * Identifies the report template for the report. Reports are built using a report template. The report
         * templates are:
         * </p>
         * <p>
         * <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         * </p>
         * <p>
         * If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code>,
         * this API resource also describes the report coverage by Amazon Web Services Regions and frameworks.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportSetting.Builder} avoiding the need
         * to create one manually via {@link ReportSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #reportSetting(ReportSetting)}.
         * 
         * @param reportSetting
         *        a consumer that will call methods on {@link ReportSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportSetting(ReportSetting)
         */
        default Builder reportSetting(Consumer<ReportSetting.Builder> reportSetting) {
            return reportSetting(ReportSetting.builder().applyMutation(reportSetting).build());
        }

        /**
         * <p>
         * The tags to assign to the report plan.
         * </p>
         * 
         * @param reportPlanTags
         *        The tags to assign to the report plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportPlanTags(Map<String, String> reportPlanTags);

        /**
         * <p>
         * A customer-chosen string that you can use to distinguish between otherwise identical calls to
         * <code>CreateReportPlanInput</code>. Retrying a successful request with the same idempotency token results in
         * a success message with no action taken.
         * </p>
         * 
         * @param idempotencyToken
         *        A customer-chosen string that you can use to distinguish between otherwise identical calls to
         *        <code>CreateReportPlanInput</code>. Retrying a successful request with the same idempotency token
         *        results in a success message with no action taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String reportPlanName;

        private String reportPlanDescription;

        private ReportDeliveryChannel reportDeliveryChannel;

        private ReportSetting reportSetting;

        private Map<String, String> reportPlanTags = DefaultSdkAutoConstructMap.getInstance();

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReportPlanRequest model) {
            super(model);
            reportPlanName(model.reportPlanName);
            reportPlanDescription(model.reportPlanDescription);
            reportDeliveryChannel(model.reportDeliveryChannel);
            reportSetting(model.reportSetting);
            reportPlanTags(model.reportPlanTags);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getReportPlanName() {
            return reportPlanName;
        }

        public final void setReportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
        }

        @Override
        public final Builder reportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
            return this;
        }

        public final String getReportPlanDescription() {
            return reportPlanDescription;
        }

        public final void setReportPlanDescription(String reportPlanDescription) {
            this.reportPlanDescription = reportPlanDescription;
        }

        @Override
        public final Builder reportPlanDescription(String reportPlanDescription) {
            this.reportPlanDescription = reportPlanDescription;
            return this;
        }

        public final ReportDeliveryChannel.Builder getReportDeliveryChannel() {
            return reportDeliveryChannel != null ? reportDeliveryChannel.toBuilder() : null;
        }

        public final void setReportDeliveryChannel(ReportDeliveryChannel.BuilderImpl reportDeliveryChannel) {
            this.reportDeliveryChannel = reportDeliveryChannel != null ? reportDeliveryChannel.build() : null;
        }

        @Override
        public final Builder reportDeliveryChannel(ReportDeliveryChannel reportDeliveryChannel) {
            this.reportDeliveryChannel = reportDeliveryChannel;
            return this;
        }

        public final ReportSetting.Builder getReportSetting() {
            return reportSetting != null ? reportSetting.toBuilder() : null;
        }

        public final void setReportSetting(ReportSetting.BuilderImpl reportSetting) {
            this.reportSetting = reportSetting != null ? reportSetting.build() : null;
        }

        @Override
        public final Builder reportSetting(ReportSetting reportSetting) {
            this.reportSetting = reportSetting;
            return this;
        }

        public final Map<String, String> getReportPlanTags() {
            if (reportPlanTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return reportPlanTags;
        }

        public final void setReportPlanTags(Map<String, String> reportPlanTags) {
            this.reportPlanTags = _stringMapCopier.copy(reportPlanTags);
        }

        @Override
        public final Builder reportPlanTags(Map<String, String> reportPlanTags) {
            this.reportPlanTags = _stringMapCopier.copy(reportPlanTags);
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReportPlanRequest build() {
            return new CreateReportPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
