/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRestoreTestingPlanRequest extends BackupRequest implements
        ToCopyableBuilder<CreateRestoreTestingPlanRequest.Builder, CreateRestoreTestingPlanRequest> {
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(CreateRestoreTestingPlanRequest::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<RestoreTestingPlanForCreate> RESTORE_TESTING_PLAN_FIELD = SdkField
            .<RestoreTestingPlanForCreate> builder(MarshallingType.SDK_POJO).memberName("RestoreTestingPlan")
            .getter(getter(CreateRestoreTestingPlanRequest::restoreTestingPlan)).setter(setter(Builder::restoreTestingPlan))
            .constructor(RestoreTestingPlanForCreate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlan").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateRestoreTestingPlanRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATOR_REQUEST_ID_FIELD,
            RESTORE_TESTING_PLAN_FIELD, TAGS_FIELD));

    private final String creatorRequestId;

    private final RestoreTestingPlanForCreate restoreTestingPlan;

    private final Map<String, String> tags;

    private CreateRestoreTestingPlanRequest(BuilderImpl builder) {
        super(builder);
        this.creatorRequestId = builder.creatorRequestId;
        this.restoreTestingPlan = builder.restoreTestingPlan;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * This is a unique string that identifies the request and allows failed requests to be retriedwithout the risk of
     * running the operation twice. This parameter is optional. If used, this parameter must contain 1 to 50
     * alphanumeric or '-_.' characters.
     * </p>
     * 
     * @return This is a unique string that identifies the request and allows failed requests to be retriedwithout the
     *         risk of running the operation twice. This parameter is optional. If used, this parameter must contain 1
     *         to 50 alphanumeric or '-_.' characters.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * A restore testing plan must contain a unique <code>RestoreTestingPlanName</code> string you create and must
     * contain a <code>ScheduleExpression</code> cron. You may optionally include a <code>StartWindowHours</code>
     * integer and a <code>CreatorRequestId</code> string.
     * </p>
     * <p>
     * The <code>RestoreTestingPlanName</code> is a unique string that is the name of the restore testing plan. This
     * cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
     * </p>
     * 
     * @return A restore testing plan must contain a unique <code>RestoreTestingPlanName</code> string you create and
     *         must contain a <code>ScheduleExpression</code> cron. You may optionally include a
     *         <code>StartWindowHours</code> integer and a <code>CreatorRequestId</code> string.</p>
     *         <p>
     *         The <code>RestoreTestingPlanName</code> is a unique string that is the name of the restore testing plan.
     *         This cannot be changed after creation, and it must consist of only alphanumeric characters and
     *         underscores.
     */
    public final RestoreTestingPlanForCreate restoreTestingPlan() {
        return restoreTestingPlan;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the restore testing plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to assign to the restore testing plan.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlan());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestoreTestingPlanRequest)) {
            return false;
        }
        CreateRestoreTestingPlanRequest other = (CreateRestoreTestingPlanRequest) obj;
        return Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(restoreTestingPlan(), other.restoreTestingPlan()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRestoreTestingPlanRequest").add("CreatorRequestId", creatorRequestId())
                .add("RestoreTestingPlan", restoreTestingPlan())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "RestoreTestingPlan":
            return Optional.ofNullable(clazz.cast(restoreTestingPlan()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRestoreTestingPlanRequest, T> g) {
        return obj -> g.apply((CreateRestoreTestingPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRestoreTestingPlanRequest> {
        /**
         * <p>
         * This is a unique string that identifies the request and allows failed requests to be retriedwithout the risk
         * of running the operation twice. This parameter is optional. If used, this parameter must contain 1 to 50
         * alphanumeric or '-_.' characters.
         * </p>
         * 
         * @param creatorRequestId
         *        This is a unique string that identifies the request and allows failed requests to be retriedwithout
         *        the risk of running the operation twice. This parameter is optional. If used, this parameter must
         *        contain 1 to 50 alphanumeric or '-_.' characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * A restore testing plan must contain a unique <code>RestoreTestingPlanName</code> string you create and must
         * contain a <code>ScheduleExpression</code> cron. You may optionally include a <code>StartWindowHours</code>
         * integer and a <code>CreatorRequestId</code> string.
         * </p>
         * <p>
         * The <code>RestoreTestingPlanName</code> is a unique string that is the name of the restore testing plan. This
         * cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
         * </p>
         * 
         * @param restoreTestingPlan
         *        A restore testing plan must contain a unique <code>RestoreTestingPlanName</code> string you create and
         *        must contain a <code>ScheduleExpression</code> cron. You may optionally include a
         *        <code>StartWindowHours</code> integer and a <code>CreatorRequestId</code> string.</p>
         *        <p>
         *        The <code>RestoreTestingPlanName</code> is a unique string that is the name of the restore testing
         *        plan. This cannot be changed after creation, and it must consist of only alphanumeric characters and
         *        underscores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlan(RestoreTestingPlanForCreate restoreTestingPlan);

        /**
         * <p>
         * A restore testing plan must contain a unique <code>RestoreTestingPlanName</code> string you create and must
         * contain a <code>ScheduleExpression</code> cron. You may optionally include a <code>StartWindowHours</code>
         * integer and a <code>CreatorRequestId</code> string.
         * </p>
         * <p>
         * The <code>RestoreTestingPlanName</code> is a unique string that is the name of the restore testing plan. This
         * cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
         * </p>
         * This is a convenience method that creates an instance of the {@link RestoreTestingPlanForCreate.Builder}
         * avoiding the need to create one manually via {@link RestoreTestingPlanForCreate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RestoreTestingPlanForCreate.Builder#build()} is called
         * immediately and its result is passed to {@link #restoreTestingPlan(RestoreTestingPlanForCreate)}.
         * 
         * @param restoreTestingPlan
         *        a consumer that will call methods on {@link RestoreTestingPlanForCreate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreTestingPlan(RestoreTestingPlanForCreate)
         */
        default Builder restoreTestingPlan(Consumer<RestoreTestingPlanForCreate.Builder> restoreTestingPlan) {
            return restoreTestingPlan(RestoreTestingPlanForCreate.builder().applyMutation(restoreTestingPlan).build());
        }

        /**
         * <p>
         * The tags to assign to the restore testing plan.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the restore testing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String creatorRequestId;

        private RestoreTestingPlanForCreate restoreTestingPlan;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestoreTestingPlanRequest model) {
            super(model);
            creatorRequestId(model.creatorRequestId);
            restoreTestingPlan(model.restoreTestingPlan);
            tags(model.tags);
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final RestoreTestingPlanForCreate.Builder getRestoreTestingPlan() {
            return restoreTestingPlan != null ? restoreTestingPlan.toBuilder() : null;
        }

        public final void setRestoreTestingPlan(RestoreTestingPlanForCreate.BuilderImpl restoreTestingPlan) {
            this.restoreTestingPlan = restoreTestingPlan != null ? restoreTestingPlan.build() : null;
        }

        @Override
        public final Builder restoreTestingPlan(RestoreTestingPlanForCreate restoreTestingPlan) {
            this.restoreTestingPlan = restoreTestingPlan;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = SensitiveStringMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = SensitiveStringMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRestoreTestingPlanRequest build() {
            return new CreateRestoreTestingPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
