/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about a saved recovery point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryPointByResource implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryPointByResource.Builder, RecoveryPointByResource> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(RecoveryPointByResource::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(RecoveryPointByResource::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RecoveryPointByResource::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(RecoveryPointByResource::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(RecoveryPointByResource::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<Long> BACKUP_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BackupSizeBytes").getter(getter(RecoveryPointByResource::backupSizeBytes))
            .setter(setter(Builder::backupSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeBytes").build()).build();

    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(RecoveryPointByResource::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<Boolean> IS_PARENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsParent").getter(getter(RecoveryPointByResource::isParent)).setter(setter(Builder::isParent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsParent").build()).build();

    private static final SdkField<String> PARENT_RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentRecoveryPointArn").getter(getter(RecoveryPointByResource::parentRecoveryPointArn))
            .setter(setter(Builder::parentRecoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentRecoveryPointArn").build())
            .build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(RecoveryPointByResource::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> VAULT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VaultType").getter(getter(RecoveryPointByResource::vaultTypeAsString))
            .setter(setter(Builder::vaultType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD,
            CREATION_DATE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, ENCRYPTION_KEY_ARN_FIELD, BACKUP_SIZE_BYTES_FIELD,
            BACKUP_VAULT_NAME_FIELD, IS_PARENT_FIELD, PARENT_RECOVERY_POINT_ARN_FIELD, RESOURCE_NAME_FIELD, VAULT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recoveryPointArn;

    private final Instant creationDate;

    private final String status;

    private final String statusMessage;

    private final String encryptionKeyArn;

    private final Long backupSizeBytes;

    private final String backupVaultName;

    private final Boolean isParent;

    private final String parentRecoveryPointArn;

    private final String resourceName;

    private final String vaultType;

    private RecoveryPointByResource(BuilderImpl builder) {
        this.recoveryPointArn = builder.recoveryPointArn;
        this.creationDate = builder.creationDate;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.backupSizeBytes = builder.backupSizeBytes;
        this.backupVaultName = builder.backupVaultName;
        this.isParent = builder.isParent;
        this.parentRecoveryPointArn = builder.parentRecoveryPointArn;
        this.resourceName = builder.resourceName;
        this.vaultType = builder.vaultType;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * A status code specifying the state of the recovery point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecoveryPointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A status code specifying the state of the recovery point.
     * @see RecoveryPointStatus
     */
    public final RecoveryPointStatus status() {
        return RecoveryPointStatus.fromValue(status);
    }

    /**
     * <p>
     * A status code specifying the state of the recovery point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecoveryPointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A status code specifying the state of the recovery point.
     * @see RecoveryPointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message explaining the current status of the recovery point.
     * </p>
     * 
     * @return A message explaining the current status of the recovery point.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The server-side encryption key that is used to protect your backups; for example,
     * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * 
     * @return The server-side encryption key that is used to protect your backups; for example,
     *         <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * The size, in bytes, of a backup.
     * </p>
     * 
     * @return The size, in bytes, of a backup.
     */
    public final Long backupSizeBytes() {
        return backupSizeBytes;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the Amazon Web Services Region where they are created.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the Amazon Web Services Region where they are created.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * This is a boolean value indicating this is a parent (composite) recovery point.
     * </p>
     * 
     * @return This is a boolean value indicating this is a parent (composite) recovery point.
     */
    public final Boolean isParent() {
        return isParent;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the parent (composite) recovery point.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the parent (composite) recovery point.
     */
    public final String parentRecoveryPointArn() {
        return parentRecoveryPointArn;
    }

    /**
     * <p>
     * The non-unique name of the resource that belongs to the specified backup.
     * </p>
     * 
     * @return The non-unique name of the resource that belongs to the specified backup.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The type of vault in which the described recovery point is stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vaultType} will
     * return {@link VaultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vaultTypeAsString}.
     * </p>
     * 
     * @return The type of vault in which the described recovery point is stored.
     * @see VaultType
     */
    public final VaultType vaultType() {
        return VaultType.fromValue(vaultType);
    }

    /**
     * <p>
     * The type of vault in which the described recovery point is stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vaultType} will
     * return {@link VaultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vaultTypeAsString}.
     * </p>
     * 
     * @return The type of vault in which the described recovery point is stored.
     * @see VaultType
     */
    public final String vaultTypeAsString() {
        return vaultType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(isParent());
        hashCode = 31 * hashCode + Objects.hashCode(parentRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(vaultTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryPointByResource)) {
            return false;
        }
        RecoveryPointByResource other = (RecoveryPointByResource) obj;
        return Objects.equals(recoveryPointArn(), other.recoveryPointArn())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(backupSizeBytes(), other.backupSizeBytes())
                && Objects.equals(backupVaultName(), other.backupVaultName()) && Objects.equals(isParent(), other.isParent())
                && Objects.equals(parentRecoveryPointArn(), other.parentRecoveryPointArn())
                && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(vaultTypeAsString(), other.vaultTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryPointByResource").add("RecoveryPointArn", recoveryPointArn())
                .add("CreationDate", creationDate()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("EncryptionKeyArn", encryptionKeyArn()).add("BackupSizeBytes", backupSizeBytes())
                .add("BackupVaultName", backupVaultName()).add("IsParent", isParent())
                .add("ParentRecoveryPointArn", parentRecoveryPointArn()).add("ResourceName", resourceName())
                .add("VaultType", vaultTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "BackupSizeBytes":
            return Optional.ofNullable(clazz.cast(backupSizeBytes()));
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "IsParent":
            return Optional.ofNullable(clazz.cast(isParent()));
        case "ParentRecoveryPointArn":
            return Optional.ofNullable(clazz.cast(parentRecoveryPointArn()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "VaultType":
            return Optional.ofNullable(clazz.cast(vaultTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryPointByResource, T> g) {
        return obj -> g.apply((RecoveryPointByResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryPointByResource> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param recoveryPointArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value
         * of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationDate
         *        The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * A status code specifying the state of the recovery point.
         * </p>
         * 
         * @param status
         *        A status code specifying the state of the recovery point.
         * @see RecoveryPointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryPointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A status code specifying the state of the recovery point.
         * </p>
         * 
         * @param status
         *        A status code specifying the state of the recovery point.
         * @see RecoveryPointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryPointStatus
         */
        Builder status(RecoveryPointStatus status);

        /**
         * <p>
         * A message explaining the current status of the recovery point.
         * </p>
         * 
         * @param statusMessage
         *        A message explaining the current status of the recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The server-side encryption key that is used to protect your backups; for example,
         * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The server-side encryption key that is used to protect your backups; for example,
         *        <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * The size, in bytes, of a backup.
         * </p>
         * 
         * @param backupSizeBytes
         *        The size, in bytes, of a backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSizeBytes(Long backupSizeBytes);

        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the account used to create them and the Amazon Web Services Region where they are created.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the account used to create them and the Amazon Web Services Region where they are
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * This is a boolean value indicating this is a parent (composite) recovery point.
         * </p>
         * 
         * @param isParent
         *        This is a boolean value indicating this is a parent (composite) recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isParent(Boolean isParent);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the parent (composite) recovery point.
         * </p>
         * 
         * @param parentRecoveryPointArn
         *        The Amazon Resource Name (ARN) of the parent (composite) recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentRecoveryPointArn(String parentRecoveryPointArn);

        /**
         * <p>
         * The non-unique name of the resource that belongs to the specified backup.
         * </p>
         * 
         * @param resourceName
         *        The non-unique name of the resource that belongs to the specified backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The type of vault in which the described recovery point is stored.
         * </p>
         * 
         * @param vaultType
         *        The type of vault in which the described recovery point is stored.
         * @see VaultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VaultType
         */
        Builder vaultType(String vaultType);

        /**
         * <p>
         * The type of vault in which the described recovery point is stored.
         * </p>
         * 
         * @param vaultType
         *        The type of vault in which the described recovery point is stored.
         * @see VaultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VaultType
         */
        Builder vaultType(VaultType vaultType);
    }

    static final class BuilderImpl implements Builder {
        private String recoveryPointArn;

        private Instant creationDate;

        private String status;

        private String statusMessage;

        private String encryptionKeyArn;

        private Long backupSizeBytes;

        private String backupVaultName;

        private Boolean isParent;

        private String parentRecoveryPointArn;

        private String resourceName;

        private String vaultType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryPointByResource model) {
            recoveryPointArn(model.recoveryPointArn);
            creationDate(model.creationDate);
            status(model.status);
            statusMessage(model.statusMessage);
            encryptionKeyArn(model.encryptionKeyArn);
            backupSizeBytes(model.backupSizeBytes);
            backupVaultName(model.backupVaultName);
            isParent(model.isParent);
            parentRecoveryPointArn(model.parentRecoveryPointArn);
            resourceName(model.resourceName);
            vaultType(model.vaultType);
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecoveryPointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final Long getBackupSizeBytes() {
            return backupSizeBytes;
        }

        public final void setBackupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
        }

        @Override
        public final Builder backupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
            return this;
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final Boolean getIsParent() {
            return isParent;
        }

        public final void setIsParent(Boolean isParent) {
            this.isParent = isParent;
        }

        @Override
        public final Builder isParent(Boolean isParent) {
            this.isParent = isParent;
            return this;
        }

        public final String getParentRecoveryPointArn() {
            return parentRecoveryPointArn;
        }

        public final void setParentRecoveryPointArn(String parentRecoveryPointArn) {
            this.parentRecoveryPointArn = parentRecoveryPointArn;
        }

        @Override
        public final Builder parentRecoveryPointArn(String parentRecoveryPointArn) {
            this.parentRecoveryPointArn = parentRecoveryPointArn;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getVaultType() {
            return vaultType;
        }

        public final void setVaultType(String vaultType) {
            this.vaultType = vaultType;
        }

        @Override
        public final Builder vaultType(String vaultType) {
            this.vaultType = vaultType;
            return this;
        }

        @Override
        public final Builder vaultType(VaultType vaultType) {
            this.vaultType(vaultType == null ? null : vaultType.toString());
            return this;
        }

        @Override
        public RecoveryPointByResource build() {
            return new RecoveryPointByResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
