/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains metadata about a restore testing selection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTestingSelectionForUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<RestoreTestingSelectionForUpdate.Builder, RestoreTestingSelectionForUpdate> {
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(RestoreTestingSelectionForUpdate::iamRoleArn))
            .setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<List<String>> PROTECTED_RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProtectedResourceArns")
            .getter(getter(RestoreTestingSelectionForUpdate::protectedResourceArns))
            .setter(setter(Builder::protectedResourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProtectedResourceConditions> PROTECTED_RESOURCE_CONDITIONS_FIELD = SdkField
            .<ProtectedResourceConditions> builder(MarshallingType.SDK_POJO)
            .memberName("ProtectedResourceConditions")
            .getter(getter(RestoreTestingSelectionForUpdate::protectedResourceConditions))
            .setter(setter(Builder::protectedResourceConditions))
            .constructor(ProtectedResourceConditions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceConditions")
                    .build()).build();

    private static final SdkField<Map<String, String>> RESTORE_METADATA_OVERRIDES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("RestoreMetadataOverrides")
            .getter(getter(RestoreTestingSelectionForUpdate::restoreMetadataOverrides))
            .setter(setter(Builder::restoreMetadataOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreMetadataOverrides").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> VALIDATION_WINDOW_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ValidationWindowHours").getter(getter(RestoreTestingSelectionForUpdate::validationWindowHours))
            .setter(setter(Builder::validationWindowHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationWindowHours").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_ARN_FIELD,
            PROTECTED_RESOURCE_ARNS_FIELD, PROTECTED_RESOURCE_CONDITIONS_FIELD, RESTORE_METADATA_OVERRIDES_FIELD,
            VALIDATION_WINDOW_HOURS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String iamRoleArn;

    private final List<String> protectedResourceArns;

    private final ProtectedResourceConditions protectedResourceConditions;

    private final Map<String, String> restoreMetadataOverrides;

    private final Integer validationWindowHours;

    private RestoreTestingSelectionForUpdate(BuilderImpl builder) {
        this.iamRoleArn = builder.iamRoleArn;
        this.protectedResourceArns = builder.protectedResourceArns;
        this.protectedResourceConditions = builder.protectedResourceConditions;
        this.restoreMetadataOverrides = builder.restoreMetadataOverrides;
        this.validationWindowHours = builder.validationWindowHours;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example:
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for
     *         example: <code>arn:aws:iam::123456789012:role/S3Access</code>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProtectedResourceArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProtectedResourceArns() {
        return protectedResourceArns != null && !(protectedResourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can include a list of specific ARNs, such as
     * <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard:
     * <code>ProtectedResourceArns: ["*"]</code>, but not both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtectedResourceArns} method.
     * </p>
     * 
     * @return You can include a list of specific ARNs, such as
     *         <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard:
     *         <code>ProtectedResourceArns: ["*"]</code>, but not both.
     */
    public final List<String> protectedResourceArns() {
        return protectedResourceArns;
    }

    /**
     * <p>
     * The conditions that you define for resources in your restore testing plan using tags.
     * </p>
     * 
     * @return The conditions that you define for resources in your restore testing plan using tags.
     */
    public final ProtectedResourceConditions protectedResourceConditions() {
        return protectedResourceConditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the RestoreMetadataOverrides property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRestoreMetadataOverrides() {
        return restoreMetadataOverrides != null && !(restoreMetadataOverrides instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code>
     * in the body of <code>RestoreTestingSelection</code>. Key values are not case sensitive.
     * </p>
     * <p>
     * See the complete list of <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html">restore
     * testing inferred metadata</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestoreMetadataOverrides} method.
     * </p>
     * 
     * @return You can override certain restore metadata keys by including the parameter
     *         <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code>. Key values are
     *         not case sensitive.</p>
     *         <p>
     *         See the complete list of <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html"
     *         >restore testing inferred metadata</a>.
     */
    public final Map<String, String> restoreMetadataOverrides() {
        return restoreMetadataOverrides;
    }

    /**
     * <p>
     * This value represents the time, in hours, data is retained after a restore test so that optional validation can
     * be completed.
     * </p>
     * <p>
     * Accepted value is an integer between 0 and 168 (the hourly equivalent of seven days).
     * </p>
     * 
     * @return This value represents the time, in hours, data is retained after a restore test so that optional
     *         validation can be completed.</p>
     *         <p>
     *         Accepted value is an integer between 0 and 168 (the hourly equivalent of seven days).
     */
    public final Integer validationWindowHours() {
        return validationWindowHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasProtectedResourceArns() ? protectedResourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(protectedResourceConditions());
        hashCode = 31 * hashCode + Objects.hashCode(hasRestoreMetadataOverrides() ? restoreMetadataOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(validationWindowHours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTestingSelectionForUpdate)) {
            return false;
        }
        RestoreTestingSelectionForUpdate other = (RestoreTestingSelectionForUpdate) obj;
        return Objects.equals(iamRoleArn(), other.iamRoleArn()) && hasProtectedResourceArns() == other.hasProtectedResourceArns()
                && Objects.equals(protectedResourceArns(), other.protectedResourceArns())
                && Objects.equals(protectedResourceConditions(), other.protectedResourceConditions())
                && hasRestoreMetadataOverrides() == other.hasRestoreMetadataOverrides()
                && Objects.equals(restoreMetadataOverrides(), other.restoreMetadataOverrides())
                && Objects.equals(validationWindowHours(), other.validationWindowHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreTestingSelectionForUpdate").add("IamRoleArn", iamRoleArn())
                .add("ProtectedResourceArns", hasProtectedResourceArns() ? protectedResourceArns() : null)
                .add("ProtectedResourceConditions", protectedResourceConditions())
                .add("RestoreMetadataOverrides", restoreMetadataOverrides() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ValidationWindowHours", validationWindowHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "ProtectedResourceArns":
            return Optional.ofNullable(clazz.cast(protectedResourceArns()));
        case "ProtectedResourceConditions":
            return Optional.ofNullable(clazz.cast(protectedResourceConditions()));
        case "RestoreMetadataOverrides":
            return Optional.ofNullable(clazz.cast(restoreMetadataOverrides()));
        case "ValidationWindowHours":
            return Optional.ofNullable(clazz.cast(validationWindowHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTestingSelectionForUpdate, T> g) {
        return obj -> g.apply((RestoreTestingSelectionForUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestoreTestingSelectionForUpdate> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example:
         * <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for
         *        example: <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * You can include a list of specific ARNs, such as
         * <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard:
         * <code>ProtectedResourceArns: ["*"]</code>, but not both.
         * </p>
         * 
         * @param protectedResourceArns
         *        You can include a list of specific ARNs, such as
         *        <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard:
         *        <code>ProtectedResourceArns: ["*"]</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResourceArns(Collection<String> protectedResourceArns);

        /**
         * <p>
         * You can include a list of specific ARNs, such as
         * <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard:
         * <code>ProtectedResourceArns: ["*"]</code>, but not both.
         * </p>
         * 
         * @param protectedResourceArns
         *        You can include a list of specific ARNs, such as
         *        <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard:
         *        <code>ProtectedResourceArns: ["*"]</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResourceArns(String... protectedResourceArns);

        /**
         * <p>
         * The conditions that you define for resources in your restore testing plan using tags.
         * </p>
         * 
         * @param protectedResourceConditions
         *        The conditions that you define for resources in your restore testing plan using tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResourceConditions(ProtectedResourceConditions protectedResourceConditions);

        /**
         * <p>
         * The conditions that you define for resources in your restore testing plan using tags.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedResourceConditions.Builder}
         * avoiding the need to create one manually via {@link ProtectedResourceConditions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedResourceConditions.Builder#build()} is called
         * immediately and its result is passed to {@link #protectedResourceConditions(ProtectedResourceConditions)}.
         * 
         * @param protectedResourceConditions
         *        a consumer that will call methods on {@link ProtectedResourceConditions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectedResourceConditions(ProtectedResourceConditions)
         */
        default Builder protectedResourceConditions(Consumer<ProtectedResourceConditions.Builder> protectedResourceConditions) {
            return protectedResourceConditions(ProtectedResourceConditions.builder().applyMutation(protectedResourceConditions)
                    .build());
        }

        /**
         * <p>
         * You can override certain restore metadata keys by including the parameter
         * <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code>. Key values are not
         * case sensitive.
         * </p>
         * <p>
         * See the complete list of <a
         * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html">restore
         * testing inferred metadata</a>.
         * </p>
         * 
         * @param restoreMetadataOverrides
         *        You can override certain restore metadata keys by including the parameter
         *        <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code>. Key values
         *        are not case sensitive.</p>
         *        <p>
         *        See the complete list of <a
         *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html"
         *        >restore testing inferred metadata</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreMetadataOverrides(Map<String, String> restoreMetadataOverrides);

        /**
         * <p>
         * This value represents the time, in hours, data is retained after a restore test so that optional validation
         * can be completed.
         * </p>
         * <p>
         * Accepted value is an integer between 0 and 168 (the hourly equivalent of seven days).
         * </p>
         * 
         * @param validationWindowHours
         *        This value represents the time, in hours, data is retained after a restore test so that optional
         *        validation can be completed.</p>
         *        <p>
         *        Accepted value is an integer between 0 and 168 (the hourly equivalent of seven days).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationWindowHours(Integer validationWindowHours);
    }

    static final class BuilderImpl implements Builder {
        private String iamRoleArn;

        private List<String> protectedResourceArns = DefaultSdkAutoConstructList.getInstance();

        private ProtectedResourceConditions protectedResourceConditions;

        private Map<String, String> restoreMetadataOverrides = DefaultSdkAutoConstructMap.getInstance();

        private Integer validationWindowHours;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTestingSelectionForUpdate model) {
            iamRoleArn(model.iamRoleArn);
            protectedResourceArns(model.protectedResourceArns);
            protectedResourceConditions(model.protectedResourceConditions);
            restoreMetadataOverrides(model.restoreMetadataOverrides);
            validationWindowHours(model.validationWindowHours);
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Collection<String> getProtectedResourceArns() {
            if (protectedResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return protectedResourceArns;
        }

        public final void setProtectedResourceArns(Collection<String> protectedResourceArns) {
            this.protectedResourceArns = _stringListCopier.copy(protectedResourceArns);
        }

        @Override
        public final Builder protectedResourceArns(Collection<String> protectedResourceArns) {
            this.protectedResourceArns = _stringListCopier.copy(protectedResourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedResourceArns(String... protectedResourceArns) {
            protectedResourceArns(Arrays.asList(protectedResourceArns));
            return this;
        }

        public final ProtectedResourceConditions.Builder getProtectedResourceConditions() {
            return protectedResourceConditions != null ? protectedResourceConditions.toBuilder() : null;
        }

        public final void setProtectedResourceConditions(ProtectedResourceConditions.BuilderImpl protectedResourceConditions) {
            this.protectedResourceConditions = protectedResourceConditions != null ? protectedResourceConditions.build() : null;
        }

        @Override
        public final Builder protectedResourceConditions(ProtectedResourceConditions protectedResourceConditions) {
            this.protectedResourceConditions = protectedResourceConditions;
            return this;
        }

        public final Map<String, String> getRestoreMetadataOverrides() {
            if (restoreMetadataOverrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return restoreMetadataOverrides;
        }

        public final void setRestoreMetadataOverrides(Map<String, String> restoreMetadataOverrides) {
            this.restoreMetadataOverrides = SensitiveStringMapCopier.copy(restoreMetadataOverrides);
        }

        @Override
        public final Builder restoreMetadataOverrides(Map<String, String> restoreMetadataOverrides) {
            this.restoreMetadataOverrides = SensitiveStringMapCopier.copy(restoreMetadataOverrides);
            return this;
        }

        public final Integer getValidationWindowHours() {
            return validationWindowHours;
        }

        public final void setValidationWindowHours(Integer validationWindowHours) {
            this.validationWindowHours = validationWindowHours;
        }

        @Override
        public final Builder validationWindowHours(Integer validationWindowHours) {
            this.validationWindowHours = validationWindowHours;
            return this;
        }

        @Override
        public RestoreTestingSelectionForUpdate build() {
            return new RestoreTestingSelectionForUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
