/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRestoreJobsRequest extends BackupRequest implements
        ToCopyableBuilder<ListRestoreJobsRequest.Builder, ListRestoreJobsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRestoreJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListRestoreJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> BY_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByAccountId").getter(getter(ListRestoreJobsRequest::byAccountId)).setter(setter(Builder::byAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("accountId").build()).build();

    private static final SdkField<String> BY_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByResourceType").getter(getter(ListRestoreJobsRequest::byResourceType))
            .setter(setter(Builder::byResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()).build();

    private static final SdkField<Instant> BY_CREATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ByCreatedBefore").getter(getter(ListRestoreJobsRequest::byCreatedBefore))
            .setter(setter(Builder::byCreatedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build()).build();

    private static final SdkField<Instant> BY_CREATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ByCreatedAfter").getter(getter(ListRestoreJobsRequest::byCreatedAfter))
            .setter(setter(Builder::byCreatedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build()).build();

    private static final SdkField<String> BY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByStatus").getter(getter(ListRestoreJobsRequest::byStatusAsString)).setter(setter(Builder::byStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<Instant> BY_COMPLETE_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ByCompleteBefore").getter(getter(ListRestoreJobsRequest::byCompleteBefore))
            .setter(setter(Builder::byCompleteBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("completeBefore").build())
            .build();

    private static final SdkField<Instant> BY_COMPLETE_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ByCompleteAfter").getter(getter(ListRestoreJobsRequest::byCompleteAfter))
            .setter(setter(Builder::byCompleteAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("completeAfter").build()).build();

    private static final SdkField<String> BY_RESTORE_TESTING_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByRestoreTestingPlanArn").getter(getter(ListRestoreJobsRequest::byRestoreTestingPlanArn))
            .setter(setter(Builder::byRestoreTestingPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("restoreTestingPlanArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, BY_ACCOUNT_ID_FIELD, BY_RESOURCE_TYPE_FIELD, BY_CREATED_BEFORE_FIELD, BY_CREATED_AFTER_FIELD,
            BY_STATUS_FIELD, BY_COMPLETE_BEFORE_FIELD, BY_COMPLETE_AFTER_FIELD, BY_RESTORE_TESTING_PLAN_ARN_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String byAccountId;

    private final String byResourceType;

    private final Instant byCreatedBefore;

    private final Instant byCreatedAfter;

    private final String byStatus;

    private final Instant byCompleteBefore;

    private final Instant byCompleteAfter;

    private final String byRestoreTestingPlanArn;

    private ListRestoreJobsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.byAccountId = builder.byAccountId;
        this.byResourceType = builder.byResourceType;
        this.byCreatedBefore = builder.byCreatedBefore;
        this.byCreatedAfter = builder.byCreatedAfter;
        this.byStatus = builder.byStatus;
        this.byCompleteBefore = builder.byCompleteBefore;
        this.byCompleteAfter = builder.byCompleteAfter;
        this.byRestoreTestingPlanArn = builder.byRestoreTestingPlanArn;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to be returned.
     * </p>
     * 
     * @return The maximum number of items to be returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The account ID to list the jobs from. Returns only restore jobs associated with the specified account ID.
     * </p>
     * 
     * @return The account ID to list the jobs from. Returns only restore jobs associated with the specified account ID.
     */
    public final String byAccountId() {
        return byAccountId;
    }

    /**
     * <p>
     * Include this parameter to return only restore jobs for the specified resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Aurora</code> for Amazon Aurora
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CloudFormation</code> for CloudFormation
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DynamoDB</code> for Amazon DynamoDB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EBS</code> for Amazon Elastic Block Store
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2</code> for Amazon Elastic Compute Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EFS</code> for Amazon Elastic File System
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FSx</code> for Amazon FSx
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Neptune</code> for Amazon Neptune
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RDS</code> for Amazon Relational Database Service
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Redshift</code> for Amazon Redshift
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAP HANA on Amazon EC2</code> for SAP HANA databases on Amazon Elastic Compute Cloud instances
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Storage Gateway</code> for Storage Gateway
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Timestream</code> for Amazon Timestream
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VirtualMachine</code> for VMware virtual machines
     * </p>
     * </li>
     * </ul>
     * 
     * @return Include this parameter to return only restore jobs for the specified resources:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Aurora</code> for Amazon Aurora
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CloudFormation</code> for CloudFormation
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DynamoDB</code> for Amazon DynamoDB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EBS</code> for Amazon Elastic Block Store
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EC2</code> for Amazon Elastic Compute Cloud
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EFS</code> for Amazon Elastic File System
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FSx</code> for Amazon FSx
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Neptune</code> for Amazon Neptune
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RDS</code> for Amazon Relational Database Service
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Redshift</code> for Amazon Redshift
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAP HANA on Amazon EC2</code> for SAP HANA databases on Amazon Elastic Compute Cloud instances
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Storage Gateway</code> for Storage Gateway
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Timestream</code> for Amazon Timestream
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VirtualMachine</code> for VMware virtual machines
     *         </p>
     *         </li>
     */
    public final String byResourceType() {
        return byResourceType;
    }

    /**
     * <p>
     * Returns only restore jobs that were created before the specified date.
     * </p>
     * 
     * @return Returns only restore jobs that were created before the specified date.
     */
    public final Instant byCreatedBefore() {
        return byCreatedBefore;
    }

    /**
     * <p>
     * Returns only restore jobs that were created after the specified date.
     * </p>
     * 
     * @return Returns only restore jobs that were created after the specified date.
     */
    public final Instant byCreatedAfter() {
        return byCreatedAfter;
    }

    /**
     * <p>
     * Returns only restore jobs associated with the specified job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byStatus} will
     * return {@link RestoreJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byStatusAsString}.
     * </p>
     * 
     * @return Returns only restore jobs associated with the specified job status.
     * @see RestoreJobStatus
     */
    public final RestoreJobStatus byStatus() {
        return RestoreJobStatus.fromValue(byStatus);
    }

    /**
     * <p>
     * Returns only restore jobs associated with the specified job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byStatus} will
     * return {@link RestoreJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byStatusAsString}.
     * </p>
     * 
     * @return Returns only restore jobs associated with the specified job status.
     * @see RestoreJobStatus
     */
    public final String byStatusAsString() {
        return byStatus;
    }

    /**
     * <p>
     * Returns only copy jobs completed before a date expressed in Unix format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return Returns only copy jobs completed before a date expressed in Unix format and Coordinated Universal Time
     *         (UTC).
     */
    public final Instant byCompleteBefore() {
        return byCompleteBefore;
    }

    /**
     * <p>
     * Returns only copy jobs completed after a date expressed in Unix format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return Returns only copy jobs completed after a date expressed in Unix format and Coordinated Universal Time
     *         (UTC).
     */
    public final Instant byCompleteAfter() {
        return byCompleteAfter;
    }

    /**
     * <p>
     * This returns only restore testing jobs that match the specified resource Amazon Resource Name (ARN).
     * </p>
     * 
     * @return This returns only restore testing jobs that match the specified resource Amazon Resource Name (ARN).
     */
    public final String byRestoreTestingPlanArn() {
        return byRestoreTestingPlanArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(byAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(byResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(byCreatedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(byCreatedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(byStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(byCompleteBefore());
        hashCode = 31 * hashCode + Objects.hashCode(byCompleteAfter());
        hashCode = 31 * hashCode + Objects.hashCode(byRestoreTestingPlanArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRestoreJobsRequest)) {
            return false;
        }
        ListRestoreJobsRequest other = (ListRestoreJobsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(byAccountId(), other.byAccountId()) && Objects.equals(byResourceType(), other.byResourceType())
                && Objects.equals(byCreatedBefore(), other.byCreatedBefore())
                && Objects.equals(byCreatedAfter(), other.byCreatedAfter())
                && Objects.equals(byStatusAsString(), other.byStatusAsString())
                && Objects.equals(byCompleteBefore(), other.byCompleteBefore())
                && Objects.equals(byCompleteAfter(), other.byCompleteAfter())
                && Objects.equals(byRestoreTestingPlanArn(), other.byRestoreTestingPlanArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRestoreJobsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ByAccountId", byAccountId()).add("ByResourceType", byResourceType())
                .add("ByCreatedBefore", byCreatedBefore()).add("ByCreatedAfter", byCreatedAfter())
                .add("ByStatus", byStatusAsString()).add("ByCompleteBefore", byCompleteBefore())
                .add("ByCompleteAfter", byCompleteAfter()).add("ByRestoreTestingPlanArn", byRestoreTestingPlanArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ByAccountId":
            return Optional.ofNullable(clazz.cast(byAccountId()));
        case "ByResourceType":
            return Optional.ofNullable(clazz.cast(byResourceType()));
        case "ByCreatedBefore":
            return Optional.ofNullable(clazz.cast(byCreatedBefore()));
        case "ByCreatedAfter":
            return Optional.ofNullable(clazz.cast(byCreatedAfter()));
        case "ByStatus":
            return Optional.ofNullable(clazz.cast(byStatusAsString()));
        case "ByCompleteBefore":
            return Optional.ofNullable(clazz.cast(byCompleteBefore()));
        case "ByCompleteAfter":
            return Optional.ofNullable(clazz.cast(byCompleteAfter()));
        case "ByRestoreTestingPlanArn":
            return Optional.ofNullable(clazz.cast(byRestoreTestingPlanArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRestoreJobsRequest, T> g) {
        return obj -> g.apply((ListRestoreJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRestoreJobsRequest> {
        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to be returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The account ID to list the jobs from. Returns only restore jobs associated with the specified account ID.
         * </p>
         * 
         * @param byAccountId
         *        The account ID to list the jobs from. Returns only restore jobs associated with the specified account
         *        ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byAccountId(String byAccountId);

        /**
         * <p>
         * Include this parameter to return only restore jobs for the specified resources:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Aurora</code> for Amazon Aurora
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CloudFormation</code> for CloudFormation
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DynamoDB</code> for Amazon DynamoDB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EBS</code> for Amazon Elastic Block Store
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EC2</code> for Amazon Elastic Compute Cloud
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EFS</code> for Amazon Elastic File System
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FSx</code> for Amazon FSx
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Neptune</code> for Amazon Neptune
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RDS</code> for Amazon Relational Database Service
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Redshift</code> for Amazon Redshift
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAP HANA on Amazon EC2</code> for SAP HANA databases on Amazon Elastic Compute Cloud instances
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Storage Gateway</code> for Storage Gateway
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Timestream</code> for Amazon Timestream
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VirtualMachine</code> for VMware virtual machines
         * </p>
         * </li>
         * </ul>
         * 
         * @param byResourceType
         *        Include this parameter to return only restore jobs for the specified resources:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Aurora</code> for Amazon Aurora
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CloudFormation</code> for CloudFormation
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DynamoDB</code> for Amazon DynamoDB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EBS</code> for Amazon Elastic Block Store
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EC2</code> for Amazon Elastic Compute Cloud
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EFS</code> for Amazon Elastic File System
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FSx</code> for Amazon FSx
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Neptune</code> for Amazon Neptune
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RDS</code> for Amazon Relational Database Service
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Redshift</code> for Amazon Redshift
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAP HANA on Amazon EC2</code> for SAP HANA databases on Amazon Elastic Compute Cloud instances
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Storage Gateway</code> for Storage Gateway
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Timestream</code> for Amazon Timestream
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VirtualMachine</code> for VMware virtual machines
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byResourceType(String byResourceType);

        /**
         * <p>
         * Returns only restore jobs that were created before the specified date.
         * </p>
         * 
         * @param byCreatedBefore
         *        Returns only restore jobs that were created before the specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byCreatedBefore(Instant byCreatedBefore);

        /**
         * <p>
         * Returns only restore jobs that were created after the specified date.
         * </p>
         * 
         * @param byCreatedAfter
         *        Returns only restore jobs that were created after the specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byCreatedAfter(Instant byCreatedAfter);

        /**
         * <p>
         * Returns only restore jobs associated with the specified job status.
         * </p>
         * 
         * @param byStatus
         *        Returns only restore jobs associated with the specified job status.
         * @see RestoreJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestoreJobStatus
         */
        Builder byStatus(String byStatus);

        /**
         * <p>
         * Returns only restore jobs associated with the specified job status.
         * </p>
         * 
         * @param byStatus
         *        Returns only restore jobs associated with the specified job status.
         * @see RestoreJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestoreJobStatus
         */
        Builder byStatus(RestoreJobStatus byStatus);

        /**
         * <p>
         * Returns only copy jobs completed before a date expressed in Unix format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param byCompleteBefore
         *        Returns only copy jobs completed before a date expressed in Unix format and Coordinated Universal Time
         *        (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byCompleteBefore(Instant byCompleteBefore);

        /**
         * <p>
         * Returns only copy jobs completed after a date expressed in Unix format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param byCompleteAfter
         *        Returns only copy jobs completed after a date expressed in Unix format and Coordinated Universal Time
         *        (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byCompleteAfter(Instant byCompleteAfter);

        /**
         * <p>
         * This returns only restore testing jobs that match the specified resource Amazon Resource Name (ARN).
         * </p>
         * 
         * @param byRestoreTestingPlanArn
         *        This returns only restore testing jobs that match the specified resource Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byRestoreTestingPlanArn(String byRestoreTestingPlanArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String byAccountId;

        private String byResourceType;

        private Instant byCreatedBefore;

        private Instant byCreatedAfter;

        private String byStatus;

        private Instant byCompleteBefore;

        private Instant byCompleteAfter;

        private String byRestoreTestingPlanArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRestoreJobsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            byAccountId(model.byAccountId);
            byResourceType(model.byResourceType);
            byCreatedBefore(model.byCreatedBefore);
            byCreatedAfter(model.byCreatedAfter);
            byStatus(model.byStatus);
            byCompleteBefore(model.byCompleteBefore);
            byCompleteAfter(model.byCompleteAfter);
            byRestoreTestingPlanArn(model.byRestoreTestingPlanArn);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getByAccountId() {
            return byAccountId;
        }

        public final void setByAccountId(String byAccountId) {
            this.byAccountId = byAccountId;
        }

        @Override
        public final Builder byAccountId(String byAccountId) {
            this.byAccountId = byAccountId;
            return this;
        }

        public final String getByResourceType() {
            return byResourceType;
        }

        public final void setByResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
        }

        @Override
        public final Builder byResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
            return this;
        }

        public final Instant getByCreatedBefore() {
            return byCreatedBefore;
        }

        public final void setByCreatedBefore(Instant byCreatedBefore) {
            this.byCreatedBefore = byCreatedBefore;
        }

        @Override
        public final Builder byCreatedBefore(Instant byCreatedBefore) {
            this.byCreatedBefore = byCreatedBefore;
            return this;
        }

        public final Instant getByCreatedAfter() {
            return byCreatedAfter;
        }

        public final void setByCreatedAfter(Instant byCreatedAfter) {
            this.byCreatedAfter = byCreatedAfter;
        }

        @Override
        public final Builder byCreatedAfter(Instant byCreatedAfter) {
            this.byCreatedAfter = byCreatedAfter;
            return this;
        }

        public final String getByStatus() {
            return byStatus;
        }

        public final void setByStatus(String byStatus) {
            this.byStatus = byStatus;
        }

        @Override
        public final Builder byStatus(String byStatus) {
            this.byStatus = byStatus;
            return this;
        }

        @Override
        public final Builder byStatus(RestoreJobStatus byStatus) {
            this.byStatus(byStatus == null ? null : byStatus.toString());
            return this;
        }

        public final Instant getByCompleteBefore() {
            return byCompleteBefore;
        }

        public final void setByCompleteBefore(Instant byCompleteBefore) {
            this.byCompleteBefore = byCompleteBefore;
        }

        @Override
        public final Builder byCompleteBefore(Instant byCompleteBefore) {
            this.byCompleteBefore = byCompleteBefore;
            return this;
        }

        public final Instant getByCompleteAfter() {
            return byCompleteAfter;
        }

        public final void setByCompleteAfter(Instant byCompleteAfter) {
            this.byCompleteAfter = byCompleteAfter;
        }

        @Override
        public final Builder byCompleteAfter(Instant byCompleteAfter) {
            this.byCompleteAfter = byCompleteAfter;
            return this;
        }

        public final String getByRestoreTestingPlanArn() {
            return byRestoreTestingPlanArn;
        }

        public final void setByRestoreTestingPlanArn(String byRestoreTestingPlanArn) {
            this.byRestoreTestingPlanArn = byRestoreTestingPlanArn;
        }

        @Override
        public final Builder byRestoreTestingPlanArn(String byRestoreTestingPlanArn) {
            this.byRestoreTestingPlanArn = byRestoreTestingPlanArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRestoreJobsRequest build() {
            return new ListRestoreJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
