/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRestoreJobsResponse extends BackupResponse implements
        ToCopyableBuilder<ListRestoreJobsResponse.Builder, ListRestoreJobsResponse> {
    private static final SdkField<List<RestoreJobsListMember>> RESTORE_JOBS_FIELD = SdkField
            .<List<RestoreJobsListMember>> builder(MarshallingType.LIST)
            .getter(getter(ListRestoreJobsResponse::restoreJobs))
            .setter(setter(Builder::restoreJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RestoreJobsListMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(RestoreJobsListMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRestoreJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTORE_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<RestoreJobsListMember> restoreJobs;

    private final String nextToken;

    private ListRestoreJobsResponse(BuilderImpl builder) {
        super(builder);
        this.restoreJobs = builder.restoreJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of objects that contain detailed information about jobs to restore saved resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of objects that contain detailed information about jobs to restore saved resources.
     */
    public List<RestoreJobsListMember> restoreJobs() {
        return restoreJobs;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restoreJobs());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRestoreJobsResponse)) {
            return false;
        }
        ListRestoreJobsResponse other = (ListRestoreJobsResponse) obj;
        return Objects.equals(restoreJobs(), other.restoreJobs()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListRestoreJobsResponse").add("RestoreJobs", restoreJobs()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestoreJobs":
            return Optional.ofNullable(clazz.cast(restoreJobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRestoreJobsResponse, T> g) {
        return obj -> g.apply((ListRestoreJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRestoreJobsResponse> {
        /**
         * <p>
         * An array of objects that contain detailed information about jobs to restore saved resources.
         * </p>
         * 
         * @param restoreJobs
         *        An array of objects that contain detailed information about jobs to restore saved resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreJobs(Collection<RestoreJobsListMember> restoreJobs);

        /**
         * <p>
         * An array of objects that contain detailed information about jobs to restore saved resources.
         * </p>
         * 
         * @param restoreJobs
         *        An array of objects that contain detailed information about jobs to restore saved resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreJobs(RestoreJobsListMember... restoreJobs);

        /**
         * <p>
         * An array of objects that contain detailed information about jobs to restore saved resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RestoreJobsListMember>.Builder} avoiding
         * the need to create one manually via {@link List<RestoreJobsListMember>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RestoreJobsListMember>.Builder#build()} is called
         * immediately and its result is passed to {@link #restoreJobs(List<RestoreJobsListMember>)}.
         * 
         * @param restoreJobs
         *        a consumer that will call methods on {@link List<RestoreJobsListMember>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreJobs(List<RestoreJobsListMember>)
         */
        Builder restoreJobs(Consumer<RestoreJobsListMember.Builder>... restoreJobs);

        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private List<RestoreJobsListMember> restoreJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRestoreJobsResponse model) {
            super(model);
            restoreJobs(model.restoreJobs);
            nextToken(model.nextToken);
        }

        public final Collection<RestoreJobsListMember.Builder> getRestoreJobs() {
            return restoreJobs != null ? restoreJobs.stream().map(RestoreJobsListMember::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder restoreJobs(Collection<RestoreJobsListMember> restoreJobs) {
            this.restoreJobs = RestoreJobsListCopier.copy(restoreJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreJobs(RestoreJobsListMember... restoreJobs) {
            restoreJobs(Arrays.asList(restoreJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreJobs(Consumer<RestoreJobsListMember.Builder>... restoreJobs) {
            restoreJobs(Stream.of(restoreJobs).map(c -> RestoreJobsListMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRestoreJobs(Collection<RestoreJobsListMember.BuilderImpl> restoreJobs) {
            this.restoreJobs = RestoreJobsListCopier.copyFromBuilder(restoreJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRestoreJobsResponse build() {
            return new ListRestoreJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
