/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBackupVaultNotificationsRequest extends BackupRequest implements
        ToCopyableBuilder<PutBackupVaultNotificationsRequest.Builder, PutBackupVaultNotificationsRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutBackupVaultNotificationsRequest::backupVaultName)).setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutBackupVaultNotificationsRequest::snsTopicArn)).setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSTopicArn").build()).build();

    private static final SdkField<List<String>> BACKUP_VAULT_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PutBackupVaultNotificationsRequest::backupVaultEventsAsStrings))
            .setter(setter(Builder::backupVaultEventsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD,
            SNS_TOPIC_ARN_FIELD, BACKUP_VAULT_EVENTS_FIELD));

    private final String backupVaultName;

    private final String snsTopicArn;

    private final List<String> backupVaultEvents;

    private PutBackupVaultNotificationsRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.snsTopicArn = builder.snsTopicArn;
        this.backupVaultEvents = builder.backupVaultEvents;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the AWS Region where they are created. They consist of lowercase letters,
     * numbers, and hyphens.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the AWS Region where they are created. They consist of
     *         lowercase letters, numbers, and hyphens.
     */
    public String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for example,
     * <code>arn:aws:sns:us-west-2:111122223333:MyVaultTopic</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for example,
     *         <code>arn:aws:sns:us-west-2:111122223333:MyVaultTopic</code>.
     */
    public String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * An array of events that indicate the status of jobs to back up resources to the backup vault.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of events that indicate the status of jobs to back up resources to the backup vault.
     */
    public List<BackupVaultEvent> backupVaultEvents() {
        return TypeConverter.convert(backupVaultEvents, BackupVaultEvent::fromValue);
    }

    /**
     * <p>
     * An array of events that indicate the status of jobs to back up resources to the backup vault.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of events that indicate the status of jobs to back up resources to the backup vault.
     */
    public List<String> backupVaultEventsAsStrings() {
        return backupVaultEvents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultEventsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBackupVaultNotificationsRequest)) {
            return false;
        }
        PutBackupVaultNotificationsRequest other = (PutBackupVaultNotificationsRequest) obj;
        return Objects.equals(backupVaultName(), other.backupVaultName()) && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && Objects.equals(backupVaultEventsAsStrings(), other.backupVaultEventsAsStrings());
    }

    @Override
    public String toString() {
        return ToString.builder("PutBackupVaultNotificationsRequest").add("BackupVaultName", backupVaultName())
                .add("SNSTopicArn", snsTopicArn()).add("BackupVaultEvents", backupVaultEventsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "SNSTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "BackupVaultEvents":
            return Optional.ofNullable(clazz.cast(backupVaultEventsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBackupVaultNotificationsRequest, T> g) {
        return obj -> g.apply((PutBackupVaultNotificationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutBackupVaultNotificationsRequest> {
        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the account used to create them and the AWS Region where they are created. They consist of
         * lowercase letters, numbers, and hyphens.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the account used to create them and the AWS Region where they are created. They consist
         *        of lowercase letters, numbers, and hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for example,
         * <code>arn:aws:sns:us-west-2:111122223333:MyVaultTopic</code>.
         * </p>
         * 
         * @param snsTopicArn
         *        The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for example,
         *        <code>arn:aws:sns:us-west-2:111122223333:MyVaultTopic</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * An array of events that indicate the status of jobs to back up resources to the backup vault.
         * </p>
         * 
         * @param backupVaultEvents
         *        An array of events that indicate the status of jobs to back up resources to the backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultEventsWithStrings(Collection<String> backupVaultEvents);

        /**
         * <p>
         * An array of events that indicate the status of jobs to back up resources to the backup vault.
         * </p>
         * 
         * @param backupVaultEvents
         *        An array of events that indicate the status of jobs to back up resources to the backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultEventsWithStrings(String... backupVaultEvents);

        /**
         * <p>
         * An array of events that indicate the status of jobs to back up resources to the backup vault.
         * </p>
         * 
         * @param backupVaultEvents
         *        An array of events that indicate the status of jobs to back up resources to the backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultEvents(Collection<BackupVaultEvent> backupVaultEvents);

        /**
         * <p>
         * An array of events that indicate the status of jobs to back up resources to the backup vault.
         * </p>
         * 
         * @param backupVaultEvents
         *        An array of events that indicate the status of jobs to back up resources to the backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultEvents(BackupVaultEvent... backupVaultEvents);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupVaultName;

        private String snsTopicArn;

        private List<String> backupVaultEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutBackupVaultNotificationsRequest model) {
            super(model);
            backupVaultName(model.backupVaultName);
            snsTopicArn(model.snsTopicArn);
            backupVaultEventsWithStrings(model.backupVaultEvents);
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final Collection<String> getBackupVaultEventsAsStrings() {
            return backupVaultEvents;
        }

        @Override
        public final Builder backupVaultEventsWithStrings(Collection<String> backupVaultEvents) {
            this.backupVaultEvents = BackupVaultEventsCopier.copy(backupVaultEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupVaultEventsWithStrings(String... backupVaultEvents) {
            backupVaultEventsWithStrings(Arrays.asList(backupVaultEvents));
            return this;
        }

        @Override
        public final Builder backupVaultEvents(Collection<BackupVaultEvent> backupVaultEvents) {
            this.backupVaultEvents = BackupVaultEventsCopier.copyEnumToString(backupVaultEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupVaultEvents(BackupVaultEvent... backupVaultEvents) {
            backupVaultEvents(Arrays.asList(backupVaultEvents));
            return this;
        }

        public final void setBackupVaultEventsWithStrings(Collection<String> backupVaultEvents) {
            this.backupVaultEvents = BackupVaultEventsCopier.copy(backupVaultEvents);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBackupVaultNotificationsRequest build() {
            return new PutBackupVaultNotificationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
