/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupPlanInput;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBackupPlanRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, CreateBackupPlanRequest> {
    private static final SdkField<BackupPlanInput> BACKUP_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateBackupPlanRequest.getter(CreateBackupPlanRequest::backupPlan)).setter(CreateBackupPlanRequest.setter(Builder::backupPlan)).constructor(BackupPlanInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlan").build()}).build();
    private static final SdkField<Map<String, String>> BACKUP_PLAN_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateBackupPlanRequest.getter(CreateBackupPlanRequest::backupPlanTags)).setter(CreateBackupPlanRequest.setter(Builder::backupPlanTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateBackupPlanRequest.getter(CreateBackupPlanRequest::creatorRequestId)).setter(CreateBackupPlanRequest.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_FIELD, BACKUP_PLAN_TAGS_FIELD, CREATOR_REQUEST_ID_FIELD));
    private final BackupPlanInput backupPlan;
    private final Map<String, String> backupPlanTags;
    private final String creatorRequestId;

    private CreateBackupPlanRequest(BuilderImpl builder) {
        super(builder);
        this.backupPlan = builder.backupPlan;
        this.backupPlanTags = builder.backupPlanTags;
        this.creatorRequestId = builder.creatorRequestId;
    }

    public BackupPlanInput backupPlan() {
        return this.backupPlan;
    }

    public Map<String, String> backupPlanTags() {
        return this.backupPlanTags;
    }

    public String creatorRequestId() {
        return this.creatorRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackupPlanRequest)) {
            return false;
        }
        CreateBackupPlanRequest other = (CreateBackupPlanRequest)((Object)obj);
        return Objects.equals(this.backupPlan(), other.backupPlan()) && Objects.equals(this.backupPlanTags(), other.backupPlanTags()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId());
    }

    public String toString() {
        return ToString.builder((String)"CreateBackupPlanRequest").add("BackupPlan", (Object)this.backupPlan()).add("BackupPlanTags", this.backupPlanTags()).add("CreatorRequestId", (Object)this.creatorRequestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupPlan": {
                return Optional.ofNullable(clazz.cast(this.backupPlan()));
            }
            case "BackupPlanTags": {
                return Optional.ofNullable(clazz.cast(this.backupPlanTags()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackupPlanRequest, T> g) {
        return obj -> g.apply((CreateBackupPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private BackupPlanInput backupPlan;
        private Map<String, String> backupPlanTags = DefaultSdkAutoConstructMap.getInstance();
        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackupPlanRequest model) {
            super(model);
            this.backupPlan(model.backupPlan);
            this.backupPlanTags(model.backupPlanTags);
            this.creatorRequestId(model.creatorRequestId);
        }

        public final BackupPlanInput.Builder getBackupPlan() {
            return this.backupPlan != null ? this.backupPlan.toBuilder() : null;
        }

        @Override
        public final Builder backupPlan(BackupPlanInput backupPlan) {
            this.backupPlan = backupPlan;
            return this;
        }

        public final void setBackupPlan(BackupPlanInput.BuilderImpl backupPlan) {
            this.backupPlan = backupPlan != null ? backupPlan.build() : null;
        }

        public final Map<String, String> getBackupPlanTags() {
            return this.backupPlanTags;
        }

        @Override
        public final Builder backupPlanTags(Map<String, String> backupPlanTags) {
            this.backupPlanTags = TagsCopier.copy(backupPlanTags);
            return this;
        }

        public final void setBackupPlanTags(Map<String, String> backupPlanTags) {
            this.backupPlanTags = TagsCopier.copy(backupPlanTags);
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBackupPlanRequest build() {
            return new CreateBackupPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBackupPlanRequest> {
        public Builder backupPlan(BackupPlanInput var1);

        default public Builder backupPlan(Consumer<BackupPlanInput.Builder> backupPlan) {
            return this.backupPlan((BackupPlanInput)((BackupPlanInput.Builder)BackupPlanInput.builder().applyMutation(backupPlan)).build());
        }

        public Builder backupPlanTags(Map<String, String> var1);

        public Builder creatorRequestId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

