/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object specifying metadata associated with a backup plan template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackupPlanTemplatesListMember implements SdkPojo, Serializable,
        ToCopyableBuilder<BackupPlanTemplatesListMember.Builder, BackupPlanTemplatesListMember> {
    private static final SdkField<String> BACKUP_PLAN_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BackupPlanTemplatesListMember::backupPlanTemplateId)).setter(setter(Builder::backupPlanTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanTemplateId").build())
            .build();

    private static final SdkField<String> BACKUP_PLAN_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BackupPlanTemplatesListMember::backupPlanTemplateName))
            .setter(setter(Builder::backupPlanTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanTemplateName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_TEMPLATE_ID_FIELD,
            BACKUP_PLAN_TEMPLATE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String backupPlanTemplateId;

    private final String backupPlanTemplateName;

    private BackupPlanTemplatesListMember(BuilderImpl builder) {
        this.backupPlanTemplateId = builder.backupPlanTemplateId;
        this.backupPlanTemplateName = builder.backupPlanTemplateName;
    }

    /**
     * <p>
     * Uniquely identifies a stored backup plan template.
     * </p>
     * 
     * @return Uniquely identifies a stored backup plan template.
     */
    public String backupPlanTemplateId() {
        return backupPlanTemplateId;
    }

    /**
     * <p>
     * The optional display name of a backup plan template.
     * </p>
     * 
     * @return The optional display name of a backup plan template.
     */
    public String backupPlanTemplateName() {
        return backupPlanTemplateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanTemplateName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupPlanTemplatesListMember)) {
            return false;
        }
        BackupPlanTemplatesListMember other = (BackupPlanTemplatesListMember) obj;
        return Objects.equals(backupPlanTemplateId(), other.backupPlanTemplateId())
                && Objects.equals(backupPlanTemplateName(), other.backupPlanTemplateName());
    }

    @Override
    public String toString() {
        return ToString.builder("BackupPlanTemplatesListMember").add("BackupPlanTemplateId", backupPlanTemplateId())
                .add("BackupPlanTemplateName", backupPlanTemplateName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanTemplateId":
            return Optional.ofNullable(clazz.cast(backupPlanTemplateId()));
        case "BackupPlanTemplateName":
            return Optional.ofNullable(clazz.cast(backupPlanTemplateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupPlanTemplatesListMember, T> g) {
        return obj -> g.apply((BackupPlanTemplatesListMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackupPlanTemplatesListMember> {
        /**
         * <p>
         * Uniquely identifies a stored backup plan template.
         * </p>
         * 
         * @param backupPlanTemplateId
         *        Uniquely identifies a stored backup plan template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanTemplateId(String backupPlanTemplateId);

        /**
         * <p>
         * The optional display name of a backup plan template.
         * </p>
         * 
         * @param backupPlanTemplateName
         *        The optional display name of a backup plan template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanTemplateName(String backupPlanTemplateName);
    }

    static final class BuilderImpl implements Builder {
        private String backupPlanTemplateId;

        private String backupPlanTemplateName;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupPlanTemplatesListMember model) {
            backupPlanTemplateId(model.backupPlanTemplateId);
            backupPlanTemplateName(model.backupPlanTemplateName);
        }

        public final String getBackupPlanTemplateId() {
            return backupPlanTemplateId;
        }

        @Override
        public final Builder backupPlanTemplateId(String backupPlanTemplateId) {
            this.backupPlanTemplateId = backupPlanTemplateId;
            return this;
        }

        public final void setBackupPlanTemplateId(String backupPlanTemplateId) {
            this.backupPlanTemplateId = backupPlanTemplateId;
        }

        public final String getBackupPlanTemplateName() {
            return backupPlanTemplateName;
        }

        @Override
        public final Builder backupPlanTemplateName(String backupPlanTemplateName) {
            this.backupPlanTemplateName = backupPlanTemplateName;
            return this;
        }

        public final void setBackupPlanTemplateName(String backupPlanTemplateName) {
            this.backupPlanTemplateName = backupPlanTemplateName;
        }

        @Override
        public BackupPlanTemplatesListMember build() {
            return new BackupPlanTemplatesListMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
