/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLogicallyAirGappedBackupVaultRequest extends BackupRequest implements
        ToCopyableBuilder<CreateLogicallyAirGappedBackupVaultRequest.Builder, CreateLogicallyAirGappedBackupVaultRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(CreateLogicallyAirGappedBackupVaultRequest::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()).build();

    private static final SdkField<Map<String, String>> BACKUP_VAULT_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("BackupVaultTags")
            .getter(getter(CreateLogicallyAirGappedBackupVaultRequest::backupVaultTags))
            .setter(setter(Builder::backupVaultTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(CreateLogicallyAirGappedBackupVaultRequest::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<Long> MIN_RETENTION_DAYS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MinRetentionDays").getter(getter(CreateLogicallyAirGappedBackupVaultRequest::minRetentionDays))
            .setter(setter(Builder::minRetentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinRetentionDays").build()).build();

    private static final SdkField<Long> MAX_RETENTION_DAYS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxRetentionDays").getter(getter(CreateLogicallyAirGappedBackupVaultRequest::maxRetentionDays))
            .setter(setter(Builder::maxRetentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetentionDays").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD,
            BACKUP_VAULT_TAGS_FIELD, CREATOR_REQUEST_ID_FIELD, MIN_RETENTION_DAYS_FIELD, MAX_RETENTION_DAYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String backupVaultName;

    private final Map<String, String> backupVaultTags;

    private final String creatorRequestId;

    private final Long minRetentionDays;

    private final Long maxRetentionDays;

    private CreateLogicallyAirGappedBackupVaultRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultTags = builder.backupVaultTags;
        this.creatorRequestId = builder.creatorRequestId;
        this.minRetentionDays = builder.minRetentionDays;
        this.maxRetentionDays = builder.maxRetentionDays;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Logically air-gapped backup vaults are identified by
     * names that are unique to the account used to create them and the Region where they are created.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Logically air-gapped backup vaults are
     *         identified by names that are unique to the account used to create them and the Region where they are
     *         created.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * For responses, this returns true if the service returned a value for the BackupVaultTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBackupVaultTags() {
        return backupVaultTags != null && !(backupVaultTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the vault.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupVaultTags} method.
     * </p>
     * 
     * @return The tags to assign to the vault.
     */
    public final Map<String, String> backupVaultTags() {
        return backupVaultTags;
    }

    /**
     * <p>
     * The ID of the creation request.
     * </p>
     * <p>
     * This parameter is optional. If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     * </p>
     * 
     * @return The ID of the creation request.</p>
     *         <p>
     *         This parameter is optional. If used, this parameter must contain 1 to 50 alphanumeric or '-_.'
     *         characters.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * This setting specifies the minimum retention period that the vault retains its recovery points.
     * </p>
     * <p>
     * The minimum value accepted is 7 days.
     * </p>
     * 
     * @return This setting specifies the minimum retention period that the vault retains its recovery points.</p>
     *         <p>
     *         The minimum value accepted is 7 days.
     */
    public final Long minRetentionDays() {
        return minRetentionDays;
    }

    /**
     * <p>
     * The maximum retention period that the vault retains its recovery points.
     * </p>
     * 
     * @return The maximum retention period that the vault retains its recovery points.
     */
    public final Long maxRetentionDays() {
        return maxRetentionDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupVaultTags() ? backupVaultTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(minRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetentionDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLogicallyAirGappedBackupVaultRequest)) {
            return false;
        }
        CreateLogicallyAirGappedBackupVaultRequest other = (CreateLogicallyAirGappedBackupVaultRequest) obj;
        return Objects.equals(backupVaultName(), other.backupVaultName()) && hasBackupVaultTags() == other.hasBackupVaultTags()
                && Objects.equals(backupVaultTags(), other.backupVaultTags())
                && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(minRetentionDays(), other.minRetentionDays())
                && Objects.equals(maxRetentionDays(), other.maxRetentionDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLogicallyAirGappedBackupVaultRequest").add("BackupVaultName", backupVaultName())
                .add("BackupVaultTags", backupVaultTags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatorRequestId", creatorRequestId()).add("MinRetentionDays", minRetentionDays())
                .add("MaxRetentionDays", maxRetentionDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "BackupVaultTags":
            return Optional.ofNullable(clazz.cast(backupVaultTags()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "MinRetentionDays":
            return Optional.ofNullable(clazz.cast(minRetentionDays()));
        case "MaxRetentionDays":
            return Optional.ofNullable(clazz.cast(maxRetentionDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("backupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("BackupVaultTags", BACKUP_VAULT_TAGS_FIELD);
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("MinRetentionDays", MIN_RETENTION_DAYS_FIELD);
        map.put("MaxRetentionDays", MAX_RETENTION_DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLogicallyAirGappedBackupVaultRequest, T> g) {
        return obj -> g.apply((CreateLogicallyAirGappedBackupVaultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLogicallyAirGappedBackupVaultRequest> {
        /**
         * <p>
         * The name of a logical container where backups are stored. Logically air-gapped backup vaults are identified
         * by names that are unique to the account used to create them and the Region where they are created.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Logically air-gapped backup vaults are
         *        identified by names that are unique to the account used to create them and the Region where they are
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * The tags to assign to the vault.
         * </p>
         * 
         * @param backupVaultTags
         *        The tags to assign to the vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultTags(Map<String, String> backupVaultTags);

        /**
         * <p>
         * The ID of the creation request.
         * </p>
         * <p>
         * This parameter is optional. If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         * </p>
         * 
         * @param creatorRequestId
         *        The ID of the creation request.</p>
         *        <p>
         *        This parameter is optional. If used, this parameter must contain 1 to 50 alphanumeric or '-_.'
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * This setting specifies the minimum retention period that the vault retains its recovery points.
         * </p>
         * <p>
         * The minimum value accepted is 7 days.
         * </p>
         * 
         * @param minRetentionDays
         *        This setting specifies the minimum retention period that the vault retains its recovery points.</p>
         *        <p>
         *        The minimum value accepted is 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minRetentionDays(Long minRetentionDays);

        /**
         * <p>
         * The maximum retention period that the vault retains its recovery points.
         * </p>
         * 
         * @param maxRetentionDays
         *        The maximum retention period that the vault retains its recovery points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetentionDays(Long maxRetentionDays);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupVaultName;

        private Map<String, String> backupVaultTags = DefaultSdkAutoConstructMap.getInstance();

        private String creatorRequestId;

        private Long minRetentionDays;

        private Long maxRetentionDays;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLogicallyAirGappedBackupVaultRequest model) {
            super(model);
            backupVaultName(model.backupVaultName);
            backupVaultTags(model.backupVaultTags);
            creatorRequestId(model.creatorRequestId);
            minRetentionDays(model.minRetentionDays);
            maxRetentionDays(model.maxRetentionDays);
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final Map<String, String> getBackupVaultTags() {
            if (backupVaultTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return backupVaultTags;
        }

        public final void setBackupVaultTags(Map<String, String> backupVaultTags) {
            this.backupVaultTags = TagsCopier.copy(backupVaultTags);
        }

        @Override
        public final Builder backupVaultTags(Map<String, String> backupVaultTags) {
            this.backupVaultTags = TagsCopier.copy(backupVaultTags);
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final Long getMinRetentionDays() {
            return minRetentionDays;
        }

        public final void setMinRetentionDays(Long minRetentionDays) {
            this.minRetentionDays = minRetentionDays;
        }

        @Override
        public final Builder minRetentionDays(Long minRetentionDays) {
            this.minRetentionDays = minRetentionDays;
            return this;
        }

        public final Long getMaxRetentionDays() {
            return maxRetentionDays;
        }

        public final void setMaxRetentionDays(Long maxRetentionDays) {
            this.maxRetentionDays = maxRetentionDays;
        }

        @Override
        public final Builder maxRetentionDays(Long maxRetentionDays) {
            this.maxRetentionDays = maxRetentionDays;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLogicallyAirGappedBackupVaultRequest build() {
            return new CreateLogicallyAirGappedBackupVaultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
