/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReportPlanResponse extends BackupResponse implements
        ToCopyableBuilder<CreateReportPlanResponse.Builder, CreateReportPlanResponse> {
    private static final SdkField<String> REPORT_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportPlanName").getter(getter(CreateReportPlanResponse::reportPlanName))
            .setter(setter(Builder::reportPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanName").build()).build();

    private static final SdkField<String> REPORT_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportPlanArn").getter(getter(CreateReportPlanResponse::reportPlanArn))
            .setter(setter(Builder::reportPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(CreateReportPlanResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_PLAN_NAME_FIELD,
            REPORT_PLAN_ARN_FIELD, CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String reportPlanName;

    private final String reportPlanArn;

    private final Instant creationTime;

    private CreateReportPlanResponse(BuilderImpl builder) {
        super(builder);
        this.reportPlanName = builder.reportPlanName;
        this.reportPlanArn = builder.reportPlanArn;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The unique name of the report plan.
     * </p>
     * 
     * @return The unique name of the report plan.
     */
    public final String reportPlanName() {
        return reportPlanName;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource
     * type.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
     *         resource type.
     */
    public final String reportPlanArn() {
        return reportPlanArn;
    }

    /**
     * <p>
     * The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(reportPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReportPlanResponse)) {
            return false;
        }
        CreateReportPlanResponse other = (CreateReportPlanResponse) obj;
        return Objects.equals(reportPlanName(), other.reportPlanName()) && Objects.equals(reportPlanArn(), other.reportPlanArn())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateReportPlanResponse").add("ReportPlanName", reportPlanName())
                .add("ReportPlanArn", reportPlanArn()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportPlanName":
            return Optional.ofNullable(clazz.cast(reportPlanName()));
        case "ReportPlanArn":
            return Optional.ofNullable(clazz.cast(reportPlanArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReportPlanName", REPORT_PLAN_NAME_FIELD);
        map.put("ReportPlanArn", REPORT_PLAN_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReportPlanResponse, T> g) {
        return obj -> g.apply((CreateReportPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateReportPlanResponse> {
        /**
         * <p>
         * The unique name of the report plan.
         * </p>
         * 
         * @param reportPlanName
         *        The unique name of the report plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportPlanName(String reportPlanName);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
         * resource type.
         * </p>
         * 
         * @param reportPlanArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on
         *        the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportPlanArn(String reportPlanArn);

        /**
         * <p>
         * The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The value
         * of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationTime
         *        The date and time a backup vault is created, in Unix format and Coordinated Universal Time (UTC). The
         *        value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         *        represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String reportPlanName;

        private String reportPlanArn;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReportPlanResponse model) {
            super(model);
            reportPlanName(model.reportPlanName);
            reportPlanArn(model.reportPlanArn);
            creationTime(model.creationTime);
        }

        public final String getReportPlanName() {
            return reportPlanName;
        }

        public final void setReportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
        }

        @Override
        public final Builder reportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
            return this;
        }

        public final String getReportPlanArn() {
            return reportPlanArn;
        }

        public final void setReportPlanArn(String reportPlanArn) {
            this.reportPlanArn = reportPlanArn;
        }

        @Override
        public final Builder reportPlanArn(String reportPlanArn) {
            this.reportPlanArn = reportPlanArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public CreateReportPlanResponse build() {
            return new CreateReportPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
