/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRestoreTestingPlanResponse extends BackupResponse implements
        ToCopyableBuilder<CreateRestoreTestingPlanResponse.Builder, CreateRestoreTestingPlanResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(CreateRestoreTestingPlanResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanArn").getter(getter(CreateRestoreTestingPlanResponse::restoreTestingPlanArn))
            .setter(setter(Builder::restoreTestingPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanArn").build())
            .build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanName").getter(getter(CreateRestoreTestingPlanResponse::restoreTestingPlanName))
            .setter(setter(Builder::restoreTestingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            RESTORE_TESTING_PLAN_ARN_FIELD, RESTORE_TESTING_PLAN_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant creationTime;

    private final String restoreTestingPlanArn;

    private final String restoreTestingPlanName;

    private CreateRestoreTestingPlanResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.restoreTestingPlanArn = builder.restoreTestingPlanArn;
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
    }

    /**
     * <p>
     * The date and time a restore testing plan was created, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087AM.
     * </p>
     * 
     * @return The date and time a restore testing plan was created, in Unix format and Coordinated Universal Time
     *         (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087AM.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies the created restore testing plan.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies the created restore testing plan.
     */
    public final String restoreTestingPlanArn() {
        return restoreTestingPlanArn;
    }

    /**
     * <p>
     * This unique string is the name of the restore testing plan.
     * </p>
     * <p>
     * The name cannot be changed after creation. The name consists of only alphanumeric characters and underscores.
     * Maximum length is 50.
     * </p>
     * 
     * @return This unique string is the name of the restore testing plan.</p>
     *         <p>
     *         The name cannot be changed after creation. The name consists of only alphanumeric characters and
     *         underscores. Maximum length is 50.
     */
    public final String restoreTestingPlanName() {
        return restoreTestingPlanName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestoreTestingPlanResponse)) {
            return false;
        }
        CreateRestoreTestingPlanResponse other = (CreateRestoreTestingPlanResponse) obj;
        return Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(restoreTestingPlanArn(), other.restoreTestingPlanArn())
                && Objects.equals(restoreTestingPlanName(), other.restoreTestingPlanName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRestoreTestingPlanResponse").add("CreationTime", creationTime())
                .add("RestoreTestingPlanArn", restoreTestingPlanArn()).add("RestoreTestingPlanName", restoreTestingPlanName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "RestoreTestingPlanArn":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanArn()));
        case "RestoreTestingPlanName":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("RestoreTestingPlanArn", RESTORE_TESTING_PLAN_ARN_FIELD);
        map.put("RestoreTestingPlanName", RESTORE_TESTING_PLAN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRestoreTestingPlanResponse, T> g) {
        return obj -> g.apply((CreateRestoreTestingPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRestoreTestingPlanResponse> {
        /**
         * <p>
         * The date and time a restore testing plan was created, in Unix format and Coordinated Universal Time (UTC).
         * The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087AM.
         * </p>
         * 
         * @param creationTime
         *        The date and time a restore testing plan was created, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies the created restore testing plan.
         * </p>
         * 
         * @param restoreTestingPlanArn
         *        An Amazon Resource Name (ARN) that uniquely identifies the created restore testing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanArn(String restoreTestingPlanArn);

        /**
         * <p>
         * This unique string is the name of the restore testing plan.
         * </p>
         * <p>
         * The name cannot be changed after creation. The name consists of only alphanumeric characters and underscores.
         * Maximum length is 50.
         * </p>
         * 
         * @param restoreTestingPlanName
         *        This unique string is the name of the restore testing plan.</p>
         *        <p>
         *        The name cannot be changed after creation. The name consists of only alphanumeric characters and
         *        underscores. Maximum length is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanName(String restoreTestingPlanName);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private Instant creationTime;

        private String restoreTestingPlanArn;

        private String restoreTestingPlanName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestoreTestingPlanResponse model) {
            super(model);
            creationTime(model.creationTime);
            restoreTestingPlanArn(model.restoreTestingPlanArn);
            restoreTestingPlanName(model.restoreTestingPlanName);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getRestoreTestingPlanArn() {
            return restoreTestingPlanArn;
        }

        public final void setRestoreTestingPlanArn(String restoreTestingPlanArn) {
            this.restoreTestingPlanArn = restoreTestingPlanArn;
        }

        @Override
        public final Builder restoreTestingPlanArn(String restoreTestingPlanArn) {
            this.restoreTestingPlanArn = restoreTestingPlanArn;
            return this;
        }

        public final String getRestoreTestingPlanName() {
            return restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        @Override
        public CreateRestoreTestingPlanResponse build() {
            return new CreateRestoreTestingPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
