/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRestoreTestingSelectionRequest extends BackupRequest implements
        ToCopyableBuilder<CreateRestoreTestingSelectionRequest.Builder, CreateRestoreTestingSelectionRequest> {
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(CreateRestoreTestingSelectionRequest::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanName").getter(getter(CreateRestoreTestingSelectionRequest::restoreTestingPlanName))
            .setter(setter(Builder::restoreTestingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("RestoreTestingPlanName").build())
            .build();

    private static final SdkField<RestoreTestingSelectionForCreate> RESTORE_TESTING_SELECTION_FIELD = SdkField
            .<RestoreTestingSelectionForCreate> builder(MarshallingType.SDK_POJO).memberName("RestoreTestingSelection")
            .getter(getter(CreateRestoreTestingSelectionRequest::restoreTestingSelection))
            .setter(setter(Builder::restoreTestingSelection)).constructor(RestoreTestingSelectionForCreate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingSelection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATOR_REQUEST_ID_FIELD,
            RESTORE_TESTING_PLAN_NAME_FIELD, RESTORE_TESTING_SELECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String creatorRequestId;

    private final String restoreTestingPlanName;

    private final RestoreTestingSelectionForCreate restoreTestingSelection;

    private CreateRestoreTestingSelectionRequest(BuilderImpl builder) {
        super(builder);
        this.creatorRequestId = builder.creatorRequestId;
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
        this.restoreTestingSelection = builder.restoreTestingSelection;
    }

    /**
     * <p>
     * This is an optional unique string that identifies the request and allows failed requests to be retried without
     * the risk of running the operation twice. If used, this parameter must contain 1 to 50 alphanumeric or '-_.'
     * characters.
     * </p>
     * 
     * @return This is an optional unique string that identifies the request and allows failed requests to be retried
     *         without the risk of running the operation twice. If used, this parameter must contain 1 to 50
     *         alphanumeric or '-_.' characters.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * Input the restore testing plan name that was returned from the related CreateRestoreTestingPlan request.
     * </p>
     * 
     * @return Input the restore testing plan name that was returned from the related CreateRestoreTestingPlan request.
     */
    public final String restoreTestingPlanName() {
        return restoreTestingPlanName;
    }

    /**
     * <p>
     * This consists of <code>RestoreTestingSelectionName</code>, <code>ProtectedResourceType</code>, and one of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ProtectedResourceArns</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ProtectedResourceConditions</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each protected resource type can have one single value.
     * </p>
     * <p>
     * A restore testing selection can include a wildcard value ("*") for <code>ProtectedResourceArns</code> along with
     * <code>ProtectedResourceConditions</code>. Alternatively, you can include up to 30 specific protected resource
     * ARNs in <code>ProtectedResourceArns</code>.
     * </p>
     * 
     * @return This consists of <code>RestoreTestingSelectionName</code>, <code>ProtectedResourceType</code>, and one of
     *         the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ProtectedResourceArns</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ProtectedResourceConditions</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Each protected resource type can have one single value.
     *         </p>
     *         <p>
     *         A restore testing selection can include a wildcard value ("*") for <code>ProtectedResourceArns</code>
     *         along with <code>ProtectedResourceConditions</code>. Alternatively, you can include up to 30 specific
     *         protected resource ARNs in <code>ProtectedResourceArns</code>.
     */
    public final RestoreTestingSelectionForCreate restoreTestingSelection() {
        return restoreTestingSelection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingSelection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestoreTestingSelectionRequest)) {
            return false;
        }
        CreateRestoreTestingSelectionRequest other = (CreateRestoreTestingSelectionRequest) obj;
        return Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(restoreTestingPlanName(), other.restoreTestingPlanName())
                && Objects.equals(restoreTestingSelection(), other.restoreTestingSelection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRestoreTestingSelectionRequest").add("CreatorRequestId", creatorRequestId())
                .add("RestoreTestingPlanName", restoreTestingPlanName())
                .add("RestoreTestingSelection", restoreTestingSelection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "RestoreTestingPlanName":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanName()));
        case "RestoreTestingSelection":
            return Optional.ofNullable(clazz.cast(restoreTestingSelection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("RestoreTestingPlanName", RESTORE_TESTING_PLAN_NAME_FIELD);
        map.put("RestoreTestingSelection", RESTORE_TESTING_SELECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRestoreTestingSelectionRequest, T> g) {
        return obj -> g.apply((CreateRestoreTestingSelectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRestoreTestingSelectionRequest> {
        /**
         * <p>
         * This is an optional unique string that identifies the request and allows failed requests to be retried
         * without the risk of running the operation twice. If used, this parameter must contain 1 to 50 alphanumeric or
         * '-_.' characters.
         * </p>
         * 
         * @param creatorRequestId
         *        This is an optional unique string that identifies the request and allows failed requests to be retried
         *        without the risk of running the operation twice. If used, this parameter must contain 1 to 50
         *        alphanumeric or '-_.' characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * Input the restore testing plan name that was returned from the related CreateRestoreTestingPlan request.
         * </p>
         * 
         * @param restoreTestingPlanName
         *        Input the restore testing plan name that was returned from the related CreateRestoreTestingPlan
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanName(String restoreTestingPlanName);

        /**
         * <p>
         * This consists of <code>RestoreTestingSelectionName</code>, <code>ProtectedResourceType</code>, and one of the
         * following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProtectedResourceArns</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ProtectedResourceConditions</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Each protected resource type can have one single value.
         * </p>
         * <p>
         * A restore testing selection can include a wildcard value ("*") for <code>ProtectedResourceArns</code> along
         * with <code>ProtectedResourceConditions</code>. Alternatively, you can include up to 30 specific protected
         * resource ARNs in <code>ProtectedResourceArns</code>.
         * </p>
         * 
         * @param restoreTestingSelection
         *        This consists of <code>RestoreTestingSelectionName</code>, <code>ProtectedResourceType</code>, and one
         *        of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ProtectedResourceArns</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ProtectedResourceConditions</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Each protected resource type can have one single value.
         *        </p>
         *        <p>
         *        A restore testing selection can include a wildcard value ("*") for <code>ProtectedResourceArns</code>
         *        along with <code>ProtectedResourceConditions</code>. Alternatively, you can include up to 30 specific
         *        protected resource ARNs in <code>ProtectedResourceArns</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingSelection(RestoreTestingSelectionForCreate restoreTestingSelection);

        /**
         * <p>
         * This consists of <code>RestoreTestingSelectionName</code>, <code>ProtectedResourceType</code>, and one of the
         * following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ProtectedResourceArns</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ProtectedResourceConditions</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Each protected resource type can have one single value.
         * </p>
         * <p>
         * A restore testing selection can include a wildcard value ("*") for <code>ProtectedResourceArns</code> along
         * with <code>ProtectedResourceConditions</code>. Alternatively, you can include up to 30 specific protected
         * resource ARNs in <code>ProtectedResourceArns</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RestoreTestingSelectionForCreate.Builder}
         * avoiding the need to create one manually via {@link RestoreTestingSelectionForCreate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RestoreTestingSelectionForCreate.Builder#build()} is called
         * immediately and its result is passed to {@link #restoreTestingSelection(RestoreTestingSelectionForCreate)}.
         * 
         * @param restoreTestingSelection
         *        a consumer that will call methods on {@link RestoreTestingSelectionForCreate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreTestingSelection(RestoreTestingSelectionForCreate)
         */
        default Builder restoreTestingSelection(Consumer<RestoreTestingSelectionForCreate.Builder> restoreTestingSelection) {
            return restoreTestingSelection(RestoreTestingSelectionForCreate.builder().applyMutation(restoreTestingSelection)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String creatorRequestId;

        private String restoreTestingPlanName;

        private RestoreTestingSelectionForCreate restoreTestingSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestoreTestingSelectionRequest model) {
            super(model);
            creatorRequestId(model.creatorRequestId);
            restoreTestingPlanName(model.restoreTestingPlanName);
            restoreTestingSelection(model.restoreTestingSelection);
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getRestoreTestingPlanName() {
            return restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        public final RestoreTestingSelectionForCreate.Builder getRestoreTestingSelection() {
            return restoreTestingSelection != null ? restoreTestingSelection.toBuilder() : null;
        }

        public final void setRestoreTestingSelection(RestoreTestingSelectionForCreate.BuilderImpl restoreTestingSelection) {
            this.restoreTestingSelection = restoreTestingSelection != null ? restoreTestingSelection.build() : null;
        }

        @Override
        public final Builder restoreTestingSelection(RestoreTestingSelectionForCreate restoreTestingSelection) {
            this.restoreTestingSelection = restoreTestingSelection;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRestoreTestingSelectionRequest build() {
            return new CreateRestoreTestingSelectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
