/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRestoreTestingSelectionResponse extends BackupResponse implements
        ToCopyableBuilder<CreateRestoreTestingSelectionResponse.Builder, CreateRestoreTestingSelectionResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(CreateRestoreTestingSelectionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanArn").getter(getter(CreateRestoreTestingSelectionResponse::restoreTestingPlanArn))
            .setter(setter(Builder::restoreTestingPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanArn").build())
            .build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanName").getter(getter(CreateRestoreTestingSelectionResponse::restoreTestingPlanName))
            .setter(setter(Builder::restoreTestingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanName").build())
            .build();

    private static final SdkField<String> RESTORE_TESTING_SELECTION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingSelectionName")
            .getter(getter(CreateRestoreTestingSelectionResponse::restoreTestingSelectionName))
            .setter(setter(Builder::restoreTestingSelectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingSelectionName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            RESTORE_TESTING_PLAN_ARN_FIELD, RESTORE_TESTING_PLAN_NAME_FIELD, RESTORE_TESTING_SELECTION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant creationTime;

    private final String restoreTestingPlanArn;

    private final String restoreTestingPlanName;

    private final String restoreTestingSelectionName;

    private CreateRestoreTestingSelectionResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.restoreTestingPlanArn = builder.restoreTestingPlanArn;
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
        this.restoreTestingSelectionName = builder.restoreTestingSelectionName;
    }

    /**
     * <p>
     * The time that the resource testing selection was created.
     * </p>
     * 
     * @return The time that the resource testing selection was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The ARN of the restore testing plan with which the restore testing selection is associated.
     * </p>
     * 
     * @return The ARN of the restore testing plan with which the restore testing selection is associated.
     */
    public final String restoreTestingPlanArn() {
        return restoreTestingPlanArn;
    }

    /**
     * <p>
     * The name of the restore testing plan.
     * </p>
     * <p>
     * The name cannot be changed after creation. The name consists of only alphanumeric characters and underscores.
     * Maximum length is 50.
     * </p>
     * 
     * @return The name of the restore testing plan.</p>
     *         <p>
     *         The name cannot be changed after creation. The name consists of only alphanumeric characters and
     *         underscores. Maximum length is 50.
     */
    public final String restoreTestingPlanName() {
        return restoreTestingPlanName;
    }

    /**
     * <p>
     * The name of the restore testing selection for the related restore testing plan.
     * </p>
     * 
     * @return The name of the restore testing selection for the related restore testing plan.
     */
    public final String restoreTestingSelectionName() {
        return restoreTestingSelectionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingSelectionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestoreTestingSelectionResponse)) {
            return false;
        }
        CreateRestoreTestingSelectionResponse other = (CreateRestoreTestingSelectionResponse) obj;
        return Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(restoreTestingPlanArn(), other.restoreTestingPlanArn())
                && Objects.equals(restoreTestingPlanName(), other.restoreTestingPlanName())
                && Objects.equals(restoreTestingSelectionName(), other.restoreTestingSelectionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRestoreTestingSelectionResponse").add("CreationTime", creationTime())
                .add("RestoreTestingPlanArn", restoreTestingPlanArn()).add("RestoreTestingPlanName", restoreTestingPlanName())
                .add("RestoreTestingSelectionName", restoreTestingSelectionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "RestoreTestingPlanArn":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanArn()));
        case "RestoreTestingPlanName":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanName()));
        case "RestoreTestingSelectionName":
            return Optional.ofNullable(clazz.cast(restoreTestingSelectionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("RestoreTestingPlanArn", RESTORE_TESTING_PLAN_ARN_FIELD);
        map.put("RestoreTestingPlanName", RESTORE_TESTING_PLAN_NAME_FIELD);
        map.put("RestoreTestingSelectionName", RESTORE_TESTING_SELECTION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRestoreTestingSelectionResponse, T> g) {
        return obj -> g.apply((CreateRestoreTestingSelectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRestoreTestingSelectionResponse> {
        /**
         * <p>
         * The time that the resource testing selection was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the resource testing selection was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The ARN of the restore testing plan with which the restore testing selection is associated.
         * </p>
         * 
         * @param restoreTestingPlanArn
         *        The ARN of the restore testing plan with which the restore testing selection is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanArn(String restoreTestingPlanArn);

        /**
         * <p>
         * The name of the restore testing plan.
         * </p>
         * <p>
         * The name cannot be changed after creation. The name consists of only alphanumeric characters and underscores.
         * Maximum length is 50.
         * </p>
         * 
         * @param restoreTestingPlanName
         *        The name of the restore testing plan.</p>
         *        <p>
         *        The name cannot be changed after creation. The name consists of only alphanumeric characters and
         *        underscores. Maximum length is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanName(String restoreTestingPlanName);

        /**
         * <p>
         * The name of the restore testing selection for the related restore testing plan.
         * </p>
         * 
         * @param restoreTestingSelectionName
         *        The name of the restore testing selection for the related restore testing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingSelectionName(String restoreTestingSelectionName);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private Instant creationTime;

        private String restoreTestingPlanArn;

        private String restoreTestingPlanName;

        private String restoreTestingSelectionName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestoreTestingSelectionResponse model) {
            super(model);
            creationTime(model.creationTime);
            restoreTestingPlanArn(model.restoreTestingPlanArn);
            restoreTestingPlanName(model.restoreTestingPlanName);
            restoreTestingSelectionName(model.restoreTestingSelectionName);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getRestoreTestingPlanArn() {
            return restoreTestingPlanArn;
        }

        public final void setRestoreTestingPlanArn(String restoreTestingPlanArn) {
            this.restoreTestingPlanArn = restoreTestingPlanArn;
        }

        @Override
        public final Builder restoreTestingPlanArn(String restoreTestingPlanArn) {
            this.restoreTestingPlanArn = restoreTestingPlanArn;
            return this;
        }

        public final String getRestoreTestingPlanName() {
            return restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        public final String getRestoreTestingSelectionName() {
            return restoreTestingSelectionName;
        }

        public final void setRestoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
        }

        @Override
        public final Builder restoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
            return this;
        }

        @Override
        public CreateRestoreTestingSelectionResponse build() {
            return new CreateRestoreTestingSelectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
