/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBackupVaultRequest extends BackupRequest implements
        ToCopyableBuilder<DescribeBackupVaultRequest.Builder, DescribeBackupVaultRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(DescribeBackupVaultRequest::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()).build();

    private static final SdkField<String> BACKUP_VAULT_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultAccountId").getter(getter(DescribeBackupVaultRequest::backupVaultAccountId))
            .setter(setter(Builder::backupVaultAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("backupVaultAccountId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD,
            BACKUP_VAULT_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String backupVaultName;

    private final String backupVaultAccountId;

    private DescribeBackupVaultRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultAccountId = builder.backupVaultAccountId;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the Amazon Web Services Region where they are created.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the Amazon Web Services Region where they are created.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * The account ID of the specified backup vault.
     * </p>
     * 
     * @return The account ID of the specified backup vault.
     */
    public final String backupVaultAccountId() {
        return backupVaultAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBackupVaultRequest)) {
            return false;
        }
        DescribeBackupVaultRequest other = (DescribeBackupVaultRequest) obj;
        return Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(backupVaultAccountId(), other.backupVaultAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBackupVaultRequest").add("BackupVaultName", backupVaultName())
                .add("BackupVaultAccountId", backupVaultAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "BackupVaultAccountId":
            return Optional.ofNullable(clazz.cast(backupVaultAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("backupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("backupVaultAccountId", BACKUP_VAULT_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeBackupVaultRequest, T> g) {
        return obj -> g.apply((DescribeBackupVaultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBackupVaultRequest> {
        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the account used to create them and the Amazon Web Services Region where they are created.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the account used to create them and the Amazon Web Services Region where they are
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * The account ID of the specified backup vault.
         * </p>
         * 
         * @param backupVaultAccountId
         *        The account ID of the specified backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultAccountId(String backupVaultAccountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupVaultName;

        private String backupVaultAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBackupVaultRequest model) {
            super(model);
            backupVaultName(model.backupVaultName);
            backupVaultAccountId(model.backupVaultAccountId);
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getBackupVaultAccountId() {
            return backupVaultAccountId;
        }

        public final void setBackupVaultAccountId(String backupVaultAccountId) {
            this.backupVaultAccountId = backupVaultAccountId;
        }

        @Override
        public final Builder backupVaultAccountId(String backupVaultAccountId) {
            this.backupVaultAccountId = backupVaultAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeBackupVaultRequest build() {
            return new DescribeBackupVaultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
