/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProtectedResourceResponse extends BackupResponse implements
        ToCopyableBuilder<DescribeProtectedResourceResponse.Builder, DescribeProtectedResourceResponse> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(DescribeProtectedResourceResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(DescribeProtectedResourceResponse::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Instant> LAST_BACKUP_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastBackupTime").getter(getter(DescribeProtectedResourceResponse::lastBackupTime))
            .setter(setter(Builder::lastBackupTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastBackupTime").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(DescribeProtectedResourceResponse::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> LAST_BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastBackupVaultArn").getter(getter(DescribeProtectedResourceResponse::lastBackupVaultArn))
            .setter(setter(Builder::lastBackupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastBackupVaultArn").build())
            .build();

    private static final SdkField<String> LAST_RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastRecoveryPointArn").getter(getter(DescribeProtectedResourceResponse::lastRecoveryPointArn))
            .setter(setter(Builder::lastRecoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRecoveryPointArn").build())
            .build();

    private static final SdkField<Long> LATEST_RESTORE_EXECUTION_TIME_MINUTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("LatestRestoreExecutionTimeMinutes")
            .getter(getter(DescribeProtectedResourceResponse::latestRestoreExecutionTimeMinutes))
            .setter(setter(Builder::latestRestoreExecutionTimeMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestoreExecutionTimeMinutes")
                    .build()).build();

    private static final SdkField<Instant> LATEST_RESTORE_JOB_CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestRestoreJobCreationDate")
            .getter(getter(DescribeProtectedResourceResponse::latestRestoreJobCreationDate))
            .setter(setter(Builder::latestRestoreJobCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestoreJobCreationDate")
                    .build()).build();

    private static final SdkField<Instant> LATEST_RESTORE_RECOVERY_POINT_CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestRestoreRecoveryPointCreationDate")
            .getter(getter(DescribeProtectedResourceResponse::latestRestoreRecoveryPointCreationDate))
            .setter(setter(Builder::latestRestoreRecoveryPointCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LatestRestoreRecoveryPointCreationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            RESOURCE_TYPE_FIELD, LAST_BACKUP_TIME_FIELD, RESOURCE_NAME_FIELD, LAST_BACKUP_VAULT_ARN_FIELD,
            LAST_RECOVERY_POINT_ARN_FIELD, LATEST_RESTORE_EXECUTION_TIME_MINUTES_FIELD, LATEST_RESTORE_JOB_CREATION_DATE_FIELD,
            LATEST_RESTORE_RECOVERY_POINT_CREATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceArn;

    private final String resourceType;

    private final Instant lastBackupTime;

    private final String resourceName;

    private final String lastBackupVaultArn;

    private final String lastRecoveryPointArn;

    private final Long latestRestoreExecutionTimeMinutes;

    private final Instant latestRestoreJobCreationDate;

    private final Instant latestRestoreRecoveryPointCreationDate;

    private DescribeProtectedResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.lastBackupTime = builder.lastBackupTime;
        this.resourceName = builder.resourceName;
        this.lastBackupVaultArn = builder.lastBackupVaultArn;
        this.lastRecoveryPointArn = builder.lastRecoveryPointArn;
        this.latestRestoreExecutionTimeMinutes = builder.latestRestoreExecutionTimeMinutes;
        this.latestRestoreJobCreationDate = builder.latestRestoreJobCreationDate;
        this.latestRestoreRecoveryPointCreationDate = builder.latestRestoreRecoveryPointCreationDate;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
     * </p>
     * 
     * @return An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The type of Amazon Web Services resource saved as a recovery point; for example, an Amazon EBS volume or an
     * Amazon RDS database.
     * </p>
     * 
     * @return The type of Amazon Web Services resource saved as a recovery point; for example, an Amazon EBS volume or
     *         an Amazon RDS database.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The date and time that a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     * represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a resource was last backed up, in Unix format and Coordinated Universal Time
     *         (UTC). The value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant lastBackupTime() {
        return lastBackupTime;
    }

    /**
     * <p>
     * The name of the resource that belongs to the specified backup.
     * </p>
     * 
     * @return The name of the resource that belongs to the specified backup.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the backup vault that contains the most recent backup recovery point.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the backup vault that contains the most recent backup recovery point.
     */
    public final String lastBackupVaultArn() {
        return lastBackupVaultArn;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the most recent recovery point.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the most recent recovery point.
     */
    public final String lastRecoveryPointArn() {
        return lastRecoveryPointArn;
    }

    /**
     * <p>
     * The time, in minutes, that the most recent restore job took to complete.
     * </p>
     * 
     * @return The time, in minutes, that the most recent restore job took to complete.
     */
    public final Long latestRestoreExecutionTimeMinutes() {
        return latestRestoreExecutionTimeMinutes;
    }

    /**
     * <p>
     * The creation date of the most recent restore job.
     * </p>
     * 
     * @return The creation date of the most recent restore job.
     */
    public final Instant latestRestoreJobCreationDate() {
        return latestRestoreJobCreationDate;
    }

    /**
     * <p>
     * The date the most recent recovery point was created.
     * </p>
     * 
     * @return The date the most recent recovery point was created.
     */
    public final Instant latestRestoreRecoveryPointCreationDate() {
        return latestRestoreRecoveryPointCreationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(lastBackupTime());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(lastBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(latestRestoreExecutionTimeMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(latestRestoreJobCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(latestRestoreRecoveryPointCreationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProtectedResourceResponse)) {
            return false;
        }
        DescribeProtectedResourceResponse other = (DescribeProtectedResourceResponse) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(lastBackupTime(), other.lastBackupTime())
                && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(lastBackupVaultArn(), other.lastBackupVaultArn())
                && Objects.equals(lastRecoveryPointArn(), other.lastRecoveryPointArn())
                && Objects.equals(latestRestoreExecutionTimeMinutes(), other.latestRestoreExecutionTimeMinutes())
                && Objects.equals(latestRestoreJobCreationDate(), other.latestRestoreJobCreationDate())
                && Objects.equals(latestRestoreRecoveryPointCreationDate(), other.latestRestoreRecoveryPointCreationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProtectedResourceResponse").add("ResourceArn", resourceArn())
                .add("ResourceType", resourceType()).add("LastBackupTime", lastBackupTime()).add("ResourceName", resourceName())
                .add("LastBackupVaultArn", lastBackupVaultArn()).add("LastRecoveryPointArn", lastRecoveryPointArn())
                .add("LatestRestoreExecutionTimeMinutes", latestRestoreExecutionTimeMinutes())
                .add("LatestRestoreJobCreationDate", latestRestoreJobCreationDate())
                .add("LatestRestoreRecoveryPointCreationDate", latestRestoreRecoveryPointCreationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "LastBackupTime":
            return Optional.ofNullable(clazz.cast(lastBackupTime()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "LastBackupVaultArn":
            return Optional.ofNullable(clazz.cast(lastBackupVaultArn()));
        case "LastRecoveryPointArn":
            return Optional.ofNullable(clazz.cast(lastRecoveryPointArn()));
        case "LatestRestoreExecutionTimeMinutes":
            return Optional.ofNullable(clazz.cast(latestRestoreExecutionTimeMinutes()));
        case "LatestRestoreJobCreationDate":
            return Optional.ofNullable(clazz.cast(latestRestoreJobCreationDate()));
        case "LatestRestoreRecoveryPointCreationDate":
            return Optional.ofNullable(clazz.cast(latestRestoreRecoveryPointCreationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("LastBackupTime", LAST_BACKUP_TIME_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("LastBackupVaultArn", LAST_BACKUP_VAULT_ARN_FIELD);
        map.put("LastRecoveryPointArn", LAST_RECOVERY_POINT_ARN_FIELD);
        map.put("LatestRestoreExecutionTimeMinutes", LATEST_RESTORE_EXECUTION_TIME_MINUTES_FIELD);
        map.put("LatestRestoreJobCreationDate", LATEST_RESTORE_JOB_CREATION_DATE_FIELD);
        map.put("LatestRestoreRecoveryPointCreationDate", LATEST_RESTORE_RECOVERY_POINT_CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeProtectedResourceResponse, T> g) {
        return obj -> g.apply((DescribeProtectedResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProtectedResourceResponse> {
        /**
         * <p>
         * An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
         * </p>
         * 
         * @param resourceArn
         *        An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The type of Amazon Web Services resource saved as a recovery point; for example, an Amazon EBS volume or an
         * Amazon RDS database.
         * </p>
         * 
         * @param resourceType
         *        The type of Amazon Web Services resource saved as a recovery point; for example, an Amazon EBS volume
         *        or an Amazon RDS database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The date and time that a resource was last backed up, in Unix format and Coordinated Universal Time (UTC).
         * The value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param lastBackupTime
         *        The date and time that a resource was last backed up, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastBackupTime(Instant lastBackupTime);

        /**
         * <p>
         * The name of the resource that belongs to the specified backup.
         * </p>
         * 
         * @param resourceName
         *        The name of the resource that belongs to the specified backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the backup vault that contains the most recent backup recovery point.
         * </p>
         * 
         * @param lastBackupVaultArn
         *        The ARN (Amazon Resource Name) of the backup vault that contains the most recent backup recovery
         *        point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastBackupVaultArn(String lastBackupVaultArn);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the most recent recovery point.
         * </p>
         * 
         * @param lastRecoveryPointArn
         *        The ARN (Amazon Resource Name) of the most recent recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRecoveryPointArn(String lastRecoveryPointArn);

        /**
         * <p>
         * The time, in minutes, that the most recent restore job took to complete.
         * </p>
         * 
         * @param latestRestoreExecutionTimeMinutes
         *        The time, in minutes, that the most recent restore job took to complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRestoreExecutionTimeMinutes(Long latestRestoreExecutionTimeMinutes);

        /**
         * <p>
         * The creation date of the most recent restore job.
         * </p>
         * 
         * @param latestRestoreJobCreationDate
         *        The creation date of the most recent restore job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRestoreJobCreationDate(Instant latestRestoreJobCreationDate);

        /**
         * <p>
         * The date the most recent recovery point was created.
         * </p>
         * 
         * @param latestRestoreRecoveryPointCreationDate
         *        The date the most recent recovery point was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRestoreRecoveryPointCreationDate(Instant latestRestoreRecoveryPointCreationDate);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String resourceArn;

        private String resourceType;

        private Instant lastBackupTime;

        private String resourceName;

        private String lastBackupVaultArn;

        private String lastRecoveryPointArn;

        private Long latestRestoreExecutionTimeMinutes;

        private Instant latestRestoreJobCreationDate;

        private Instant latestRestoreRecoveryPointCreationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProtectedResourceResponse model) {
            super(model);
            resourceArn(model.resourceArn);
            resourceType(model.resourceType);
            lastBackupTime(model.lastBackupTime);
            resourceName(model.resourceName);
            lastBackupVaultArn(model.lastBackupVaultArn);
            lastRecoveryPointArn(model.lastRecoveryPointArn);
            latestRestoreExecutionTimeMinutes(model.latestRestoreExecutionTimeMinutes);
            latestRestoreJobCreationDate(model.latestRestoreJobCreationDate);
            latestRestoreRecoveryPointCreationDate(model.latestRestoreRecoveryPointCreationDate);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Instant getLastBackupTime() {
            return lastBackupTime;
        }

        public final void setLastBackupTime(Instant lastBackupTime) {
            this.lastBackupTime = lastBackupTime;
        }

        @Override
        public final Builder lastBackupTime(Instant lastBackupTime) {
            this.lastBackupTime = lastBackupTime;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getLastBackupVaultArn() {
            return lastBackupVaultArn;
        }

        public final void setLastBackupVaultArn(String lastBackupVaultArn) {
            this.lastBackupVaultArn = lastBackupVaultArn;
        }

        @Override
        public final Builder lastBackupVaultArn(String lastBackupVaultArn) {
            this.lastBackupVaultArn = lastBackupVaultArn;
            return this;
        }

        public final String getLastRecoveryPointArn() {
            return lastRecoveryPointArn;
        }

        public final void setLastRecoveryPointArn(String lastRecoveryPointArn) {
            this.lastRecoveryPointArn = lastRecoveryPointArn;
        }

        @Override
        public final Builder lastRecoveryPointArn(String lastRecoveryPointArn) {
            this.lastRecoveryPointArn = lastRecoveryPointArn;
            return this;
        }

        public final Long getLatestRestoreExecutionTimeMinutes() {
            return latestRestoreExecutionTimeMinutes;
        }

        public final void setLatestRestoreExecutionTimeMinutes(Long latestRestoreExecutionTimeMinutes) {
            this.latestRestoreExecutionTimeMinutes = latestRestoreExecutionTimeMinutes;
        }

        @Override
        public final Builder latestRestoreExecutionTimeMinutes(Long latestRestoreExecutionTimeMinutes) {
            this.latestRestoreExecutionTimeMinutes = latestRestoreExecutionTimeMinutes;
            return this;
        }

        public final Instant getLatestRestoreJobCreationDate() {
            return latestRestoreJobCreationDate;
        }

        public final void setLatestRestoreJobCreationDate(Instant latestRestoreJobCreationDate) {
            this.latestRestoreJobCreationDate = latestRestoreJobCreationDate;
        }

        @Override
        public final Builder latestRestoreJobCreationDate(Instant latestRestoreJobCreationDate) {
            this.latestRestoreJobCreationDate = latestRestoreJobCreationDate;
            return this;
        }

        public final Instant getLatestRestoreRecoveryPointCreationDate() {
            return latestRestoreRecoveryPointCreationDate;
        }

        public final void setLatestRestoreRecoveryPointCreationDate(Instant latestRestoreRecoveryPointCreationDate) {
            this.latestRestoreRecoveryPointCreationDate = latestRestoreRecoveryPointCreationDate;
        }

        @Override
        public final Builder latestRestoreRecoveryPointCreationDate(Instant latestRestoreRecoveryPointCreationDate) {
            this.latestRestoreRecoveryPointCreationDate = latestRestoreRecoveryPointCreationDate;
            return this;
        }

        @Override
        public DescribeProtectedResourceResponse build() {
            return new DescribeProtectedResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
