/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRecoveryPointResponse extends BackupResponse implements
        ToCopyableBuilder<DescribeRecoveryPointResponse.Builder, DescribeRecoveryPointResponse> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(DescribeRecoveryPointResponse::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(DescribeRecoveryPointResponse::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultArn").getter(getter(DescribeRecoveryPointResponse::backupVaultArn))
            .setter(setter(Builder::backupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()).build();

    private static final SdkField<String> SOURCE_BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceBackupVaultArn").getter(getter(DescribeRecoveryPointResponse::sourceBackupVaultArn))
            .setter(setter(Builder::sourceBackupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupVaultArn").build())
            .build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(DescribeRecoveryPointResponse::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(DescribeRecoveryPointResponse::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<RecoveryPointCreator> CREATED_BY_FIELD = SdkField
            .<RecoveryPointCreator> builder(MarshallingType.SDK_POJO).memberName("CreatedBy")
            .getter(getter(DescribeRecoveryPointResponse::createdBy)).setter(setter(Builder::createdBy))
            .constructor(RecoveryPointCreator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(DescribeRecoveryPointResponse::iamRoleArn))
            .setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeRecoveryPointResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(DescribeRecoveryPointResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(DescribeRecoveryPointResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionDate").getter(getter(DescribeRecoveryPointResponse::completionDate))
            .setter(setter(Builder::completionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()).build();

    private static final SdkField<Long> BACKUP_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BackupSizeInBytes").getter(getter(DescribeRecoveryPointResponse::backupSizeInBytes))
            .setter(setter(Builder::backupSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeInBytes").build()).build();

    private static final SdkField<CalculatedLifecycle> CALCULATED_LIFECYCLE_FIELD = SdkField
            .<CalculatedLifecycle> builder(MarshallingType.SDK_POJO).memberName("CalculatedLifecycle")
            .getter(getter(DescribeRecoveryPointResponse::calculatedLifecycle)).setter(setter(Builder::calculatedLifecycle))
            .constructor(CalculatedLifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedLifecycle").build())
            .build();

    private static final SdkField<Lifecycle> LIFECYCLE_FIELD = SdkField.<Lifecycle> builder(MarshallingType.SDK_POJO)
            .memberName("Lifecycle").getter(getter(DescribeRecoveryPointResponse::lifecycle)).setter(setter(Builder::lifecycle))
            .constructor(Lifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(DescribeRecoveryPointResponse::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<Boolean> IS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsEncrypted").getter(getter(DescribeRecoveryPointResponse::isEncrypted))
            .setter(setter(Builder::isEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEncrypted").build()).build();

    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageClass").getter(getter(DescribeRecoveryPointResponse::storageClassAsString))
            .setter(setter(Builder::storageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").build()).build();

    private static final SdkField<Instant> LAST_RESTORE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastRestoreTime").getter(getter(DescribeRecoveryPointResponse::lastRestoreTime))
            .setter(setter(Builder::lastRestoreTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRestoreTime").build()).build();

    private static final SdkField<String> PARENT_RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentRecoveryPointArn").getter(getter(DescribeRecoveryPointResponse::parentRecoveryPointArn))
            .setter(setter(Builder::parentRecoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentRecoveryPointArn").build())
            .build();

    private static final SdkField<String> COMPOSITE_MEMBER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompositeMemberIdentifier").getter(getter(DescribeRecoveryPointResponse::compositeMemberIdentifier))
            .setter(setter(Builder::compositeMemberIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeMemberIdentifier").build())
            .build();

    private static final SdkField<Boolean> IS_PARENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsParent").getter(getter(DescribeRecoveryPointResponse::isParent)).setter(setter(Builder::isParent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsParent").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(DescribeRecoveryPointResponse::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> VAULT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VaultType").getter(getter(DescribeRecoveryPointResponse::vaultTypeAsString))
            .setter(setter(Builder::vaultType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultType").build()).build();

    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexStatus").getter(getter(DescribeRecoveryPointResponse::indexStatusAsString))
            .setter(setter(Builder::indexStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()).build();

    private static final SdkField<String> INDEX_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexStatusMessage").getter(getter(DescribeRecoveryPointResponse::indexStatusMessage))
            .setter(setter(Builder::indexStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatusMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD,
            BACKUP_VAULT_NAME_FIELD, BACKUP_VAULT_ARN_FIELD, SOURCE_BACKUP_VAULT_ARN_FIELD, RESOURCE_ARN_FIELD,
            RESOURCE_TYPE_FIELD, CREATED_BY_FIELD, IAM_ROLE_ARN_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_DATE_FIELD,
            COMPLETION_DATE_FIELD, BACKUP_SIZE_IN_BYTES_FIELD, CALCULATED_LIFECYCLE_FIELD, LIFECYCLE_FIELD,
            ENCRYPTION_KEY_ARN_FIELD, IS_ENCRYPTED_FIELD, STORAGE_CLASS_FIELD, LAST_RESTORE_TIME_FIELD,
            PARENT_RECOVERY_POINT_ARN_FIELD, COMPOSITE_MEMBER_IDENTIFIER_FIELD, IS_PARENT_FIELD, RESOURCE_NAME_FIELD,
            VAULT_TYPE_FIELD, INDEX_STATUS_FIELD, INDEX_STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String recoveryPointArn;

    private final String backupVaultName;

    private final String backupVaultArn;

    private final String sourceBackupVaultArn;

    private final String resourceArn;

    private final String resourceType;

    private final RecoveryPointCreator createdBy;

    private final String iamRoleArn;

    private final String status;

    private final String statusMessage;

    private final Instant creationDate;

    private final Instant completionDate;

    private final Long backupSizeInBytes;

    private final CalculatedLifecycle calculatedLifecycle;

    private final Lifecycle lifecycle;

    private final String encryptionKeyArn;

    private final Boolean isEncrypted;

    private final String storageClass;

    private final Instant lastRestoreTime;

    private final String parentRecoveryPointArn;

    private final String compositeMemberIdentifier;

    private final Boolean isParent;

    private final String resourceName;

    private final String vaultType;

    private final String indexStatus;

    private final String indexStatusMessage;

    private DescribeRecoveryPointResponse(BuilderImpl builder) {
        super(builder);
        this.recoveryPointArn = builder.recoveryPointArn;
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultArn = builder.backupVaultArn;
        this.sourceBackupVaultArn = builder.sourceBackupVaultArn;
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.createdBy = builder.createdBy;
        this.iamRoleArn = builder.iamRoleArn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.backupSizeInBytes = builder.backupSizeInBytes;
        this.calculatedLifecycle = builder.calculatedLifecycle;
        this.lifecycle = builder.lifecycle;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.isEncrypted = builder.isEncrypted;
        this.storageClass = builder.storageClass;
        this.lastRestoreTime = builder.lastRestoreTime;
        this.parentRecoveryPointArn = builder.parentRecoveryPointArn;
        this.compositeMemberIdentifier = builder.compositeMemberIdentifier;
        this.isParent = builder.isParent;
        this.resourceName = builder.resourceName;
        this.vaultType = builder.vaultType;
        this.indexStatus = builder.indexStatus;
        this.indexStatusMessage = builder.indexStatusMessage;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies a recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the Region where they are created.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the Region where they are created.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a backup vault; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies a backup vault; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>.
     */
    public final String backupVaultArn() {
        return backupVaultArn;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally backed
     * up in; for example, <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>. If the recovery
     * is restored to the same Amazon Web Services account or Region, this value will be <code>null</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally
     *         backed up in; for example, <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>.
     *         If the recovery is restored to the same Amazon Web Services account or Region, this value will be
     *         <code>null</code>.
     */
    public final String sourceBackupVaultArn() {
        return sourceBackupVaultArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
     * </p>
     * 
     * @return An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block Store
     * (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     * </p>
     * 
     * @return The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic
     *         Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan
     * used to create it.
     * </p>
     * 
     * @return Contains identifying information about the creation of a recovery point, including the
     *         <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
     *         <code>BackupRuleId</code> of the backup plan used to create it.
     */
    public final RecoveryPointCreator createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Specifies the IAM role ARN used to create the target recovery point; for example,
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @return Specifies the IAM role ARN used to create the target recovery point; for example,
     *         <code>arn:aws:iam::123456789012:role/S3Access</code>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * A status code specifying the state of the recovery point.
     * </p>
     * <p>
     * <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window closed.
     * To increase your backup plan window using the API, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>. You
     * can also increase your backup plan window using the Console by choosing and editing your backup plan.
     * </p>
     * <p>
     * <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup lacks
     * permission or is otherwise unable to delete it. To manually delete these recovery points, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step 3:
     * Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.
     * </p>
     * <p>
     * <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes the
     * continuous backup to be disabled. This can be caused by the removal of permissions, turning off versioning,
     * turning off events being sent to EventBridge, or disabling the EventBridge rules that are put in place by Backup.
     * For recovery points of Amazon S3, Amazon RDS, and Amazon Aurora resources, this status occurs when the retention
     * period of a continuous backup rule is changed.
     * </p>
     * <p>
     * To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that versioning is
     * enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule running will result
     * in a new continuous recovery point being created. The recovery points with STOPPED status do not need to be
     * deleted.
     * </p>
     * <p>
     * For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application misconfiguration,
     * or backup failure. To ensure that future continuous backups succeed, refer to the recovery point status and check
     * SAP HANA for details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecoveryPointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A status code specifying the state of the recovery point.</p>
     *         <p>
     *         <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window
     *         closed. To increase your backup plan window using the API, see <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html"
     *         >UpdateBackupPlan</a>. You can also increase your backup plan window using the Console by choosing and
     *         editing your backup plan.
     *         </p>
     *         <p>
     *         <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but
     *         Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points,
     *         see <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups">
     *         Step 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting
     *         started</i>.
     *         </p>
     *         <p>
     *         <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes
     *         the continuous backup to be disabled. This can be caused by the removal of permissions, turning off
     *         versioning, turning off events being sent to EventBridge, or disabling the EventBridge rules that are put
     *         in place by Backup. For recovery points of Amazon S3, Amazon RDS, and Amazon Aurora resources, this
     *         status occurs when the retention period of a continuous backup rule is changed.
     *         </p>
     *         <p>
     *         To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that
     *         versioning is enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule
     *         running will result in a new continuous recovery point being created. The recovery points with STOPPED
     *         status do not need to be deleted.
     *         </p>
     *         <p>
     *         For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application
     *         misconfiguration, or backup failure. To ensure that future continuous backups succeed, refer to the
     *         recovery point status and check SAP HANA for details.
     * @see RecoveryPointStatus
     */
    public final RecoveryPointStatus status() {
        return RecoveryPointStatus.fromValue(status);
    }

    /**
     * <p>
     * A status code specifying the state of the recovery point.
     * </p>
     * <p>
     * <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window closed.
     * To increase your backup plan window using the API, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>. You
     * can also increase your backup plan window using the Console by choosing and editing your backup plan.
     * </p>
     * <p>
     * <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup lacks
     * permission or is otherwise unable to delete it. To manually delete these recovery points, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step 3:
     * Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.
     * </p>
     * <p>
     * <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes the
     * continuous backup to be disabled. This can be caused by the removal of permissions, turning off versioning,
     * turning off events being sent to EventBridge, or disabling the EventBridge rules that are put in place by Backup.
     * For recovery points of Amazon S3, Amazon RDS, and Amazon Aurora resources, this status occurs when the retention
     * period of a continuous backup rule is changed.
     * </p>
     * <p>
     * To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that versioning is
     * enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule running will result
     * in a new continuous recovery point being created. The recovery points with STOPPED status do not need to be
     * deleted.
     * </p>
     * <p>
     * For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application misconfiguration,
     * or backup failure. To ensure that future continuous backups succeed, refer to the recovery point status and check
     * SAP HANA for details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecoveryPointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A status code specifying the state of the recovery point.</p>
     *         <p>
     *         <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window
     *         closed. To increase your backup plan window using the API, see <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html"
     *         >UpdateBackupPlan</a>. You can also increase your backup plan window using the Console by choosing and
     *         editing your backup plan.
     *         </p>
     *         <p>
     *         <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but
     *         Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points,
     *         see <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups">
     *         Step 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting
     *         started</i>.
     *         </p>
     *         <p>
     *         <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes
     *         the continuous backup to be disabled. This can be caused by the removal of permissions, turning off
     *         versioning, turning off events being sent to EventBridge, or disabling the EventBridge rules that are put
     *         in place by Backup. For recovery points of Amazon S3, Amazon RDS, and Amazon Aurora resources, this
     *         status occurs when the retention period of a continuous backup rule is changed.
     *         </p>
     *         <p>
     *         To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that
     *         versioning is enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule
     *         running will result in a new continuous recovery point being created. The recovery points with STOPPED
     *         status do not need to be deleted.
     *         </p>
     *         <p>
     *         For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application
     *         misconfiguration, or backup failure. To ensure that future continuous backups succeed, refer to the
     *         recovery point status and check SAP HANA for details.
     * @see RecoveryPointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A status message explaining the status of the recovery point.
     * </p>
     * 
     * @return A status message explaining the status of the recovery point.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC).
     *         The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time that a job to create a recovery point is completed, in Unix format and Coordinated Universal
     * Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value
     * 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a job to create a recovery point is completed, in Unix format and Coordinated
     *         Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example,
     *         the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant completionDate() {
        return completionDate;
    }

    /**
     * <p>
     * The size, in bytes, of a backup.
     * </p>
     * 
     * @return The size, in bytes, of a backup.
     */
    public final Long backupSizeInBytes() {
        return backupSizeInBytes;
    }

    /**
     * <p>
     * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code>
     * timestamps.
     * </p>
     * 
     * @return A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
     *         <code>MoveToColdStorageAt</code> timestamps.
     */
    public final CalculatedLifecycle calculatedLifecycle() {
        return calculatedLifecycle;
    }

    /**
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore,
     * the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition
     * to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * <p>
     * Resource types that can transition to cold storage are listed in the <a href=
     * "https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource"
     * >Feature availability by resource</a> table. Backup ignores this expression for other resource types.
     * </p>
     * 
     * @return The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.
     *         Backup transitions and expires backups automatically according to the lifecycle that you define.</p>
     *         <p>
     *         Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
     *         Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days”
     *         setting. The “transition to cold after days” setting cannot be changed after a backup has been
     *         transitioned to cold.
     *         </p>
     *         <p>
     *         Resource types that can transition to cold storage are listed in the <a href=
     *         "https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource"
     *         >Feature availability by resource</a> table. Backup ignores this expression for other resource types.
     */
    public final Lifecycle lifecycle() {
        return lifecycle;
    }

    /**
     * <p>
     * The server-side encryption key used to protect your backups; for example,
     * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * 
     * @return The server-side encryption key used to protect your backups; for example,
     *         <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     * <code>FALSE</code> if the recovery point is not encrypted.
     * </p>
     * 
     * @return A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     *         <code>FALSE</code> if the recovery point is not encrypted.
     */
    public final Boolean isEncrypted() {
        return isEncrypted;
    }

    /**
     * <p>
     * Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassAsString}.
     * </p>
     * 
     * @return Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or
     *         <code>COLD</code>.
     * @see StorageClass
     */
    public final StorageClass storageClass() {
        return StorageClass.fromValue(storageClass);
    }

    /**
     * <p>
     * Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassAsString}.
     * </p>
     * 
     * @return Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or
     *         <code>COLD</code>.
     * @see StorageClass
     */
    public final String storageClassAsString() {
        return storageClass;
    }

    /**
     * <p>
     * The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC).
     * The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     * represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time
     *         (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant lastRestoreTime() {
        return lastRestoreTime;
    }

    /**
     * <p>
     * This is an ARN that uniquely identifies a parent (composite) recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return This is an ARN that uniquely identifies a parent (composite) recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public final String parentRecoveryPointArn() {
        return parentRecoveryPointArn;
    }

    /**
     * <p>
     * The identifier of a resource within a composite group, such as nested (child) recovery point belonging to a
     * composite (parent) stack. The ID is transferred from the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax"
     * > logical ID</a> within a stack.
     * </p>
     * 
     * @return The identifier of a resource within a composite group, such as nested (child) recovery point belonging to
     *         a composite (parent) stack. The ID is transferred from the <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax"
     *         > logical ID</a> within a stack.
     */
    public final String compositeMemberIdentifier() {
        return compositeMemberIdentifier;
    }

    /**
     * <p>
     * This returns the boolean value that a recovery point is a parent (composite) job.
     * </p>
     * 
     * @return This returns the boolean value that a recovery point is a parent (composite) job.
     */
    public final Boolean isParent() {
        return isParent;
    }

    /**
     * <p>
     * The name of the resource that belongs to the specified backup.
     * </p>
     * 
     * @return The name of the resource that belongs to the specified backup.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The type of vault in which the described recovery point is stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vaultType} will
     * return {@link VaultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vaultTypeAsString}.
     * </p>
     * 
     * @return The type of vault in which the described recovery point is stored.
     * @see VaultType
     */
    public final VaultType vaultType() {
        return VaultType.fromValue(vaultType);
    }

    /**
     * <p>
     * The type of vault in which the described recovery point is stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vaultType} will
     * return {@link VaultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vaultTypeAsString}.
     * </p>
     * 
     * @return The type of vault in which the described recovery point is stored.
     * @see VaultType
     */
    public final String vaultTypeAsString() {
        return vaultType;
    }

    /**
     * <p>
     * This is the current status for the backup index associated with the specified recovery point.
     * </p>
     * <p>
     * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     * </p>
     * <p>
     * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return This is the current status for the backup index associated with the specified recovery point.</p>
     *         <p>
     *         Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     *         </p>
     *         <p>
     *         A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * @see IndexStatus
     */
    public final IndexStatus indexStatus() {
        return IndexStatus.fromValue(indexStatus);
    }

    /**
     * <p>
     * This is the current status for the backup index associated with the specified recovery point.
     * </p>
     * <p>
     * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     * </p>
     * <p>
     * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return This is the current status for the backup index associated with the specified recovery point.</p>
     *         <p>
     *         Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     *         </p>
     *         <p>
     *         A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * @see IndexStatus
     */
    public final String indexStatusAsString() {
        return indexStatus;
    }

    /**
     * <p>
     * A string in the form of a detailed message explaining the status of a backup index associated with the recovery
     * point.
     * </p>
     * 
     * @return A string in the form of a detailed message explaining the status of a backup index associated with the
     *         recovery point.
     */
    public final String indexStatusMessage() {
        return indexStatusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(backupSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(calculatedLifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(isEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastRestoreTime());
        hashCode = 31 * hashCode + Objects.hashCode(parentRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(compositeMemberIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(isParent());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(vaultTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecoveryPointResponse)) {
            return false;
        }
        DescribeRecoveryPointResponse other = (DescribeRecoveryPointResponse) obj;
        return Objects.equals(recoveryPointArn(), other.recoveryPointArn())
                && Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(backupVaultArn(), other.backupVaultArn())
                && Objects.equals(sourceBackupVaultArn(), other.sourceBackupVaultArn())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(completionDate(), other.completionDate())
                && Objects.equals(backupSizeInBytes(), other.backupSizeInBytes())
                && Objects.equals(calculatedLifecycle(), other.calculatedLifecycle())
                && Objects.equals(lifecycle(), other.lifecycle()) && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(isEncrypted(), other.isEncrypted())
                && Objects.equals(storageClassAsString(), other.storageClassAsString())
                && Objects.equals(lastRestoreTime(), other.lastRestoreTime())
                && Objects.equals(parentRecoveryPointArn(), other.parentRecoveryPointArn())
                && Objects.equals(compositeMemberIdentifier(), other.compositeMemberIdentifier())
                && Objects.equals(isParent(), other.isParent()) && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(vaultTypeAsString(), other.vaultTypeAsString())
                && Objects.equals(indexStatusAsString(), other.indexStatusAsString())
                && Objects.equals(indexStatusMessage(), other.indexStatusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRecoveryPointResponse").add("RecoveryPointArn", recoveryPointArn())
                .add("BackupVaultName", backupVaultName()).add("BackupVaultArn", backupVaultArn())
                .add("SourceBackupVaultArn", sourceBackupVaultArn()).add("ResourceArn", resourceArn())
                .add("ResourceType", resourceType()).add("CreatedBy", createdBy()).add("IamRoleArn", iamRoleArn())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).add("CreationDate", creationDate())
                .add("CompletionDate", completionDate()).add("BackupSizeInBytes", backupSizeInBytes())
                .add("CalculatedLifecycle", calculatedLifecycle()).add("Lifecycle", lifecycle())
                .add("EncryptionKeyArn", encryptionKeyArn()).add("IsEncrypted", isEncrypted())
                .add("StorageClass", storageClassAsString()).add("LastRestoreTime", lastRestoreTime())
                .add("ParentRecoveryPointArn", parentRecoveryPointArn())
                .add("CompositeMemberIdentifier", compositeMemberIdentifier()).add("IsParent", isParent())
                .add("ResourceName", resourceName()).add("VaultType", vaultTypeAsString())
                .add("IndexStatus", indexStatusAsString()).add("IndexStatusMessage", indexStatusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "BackupVaultArn":
            return Optional.ofNullable(clazz.cast(backupVaultArn()));
        case "SourceBackupVaultArn":
            return Optional.ofNullable(clazz.cast(sourceBackupVaultArn()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "CompletionDate":
            return Optional.ofNullable(clazz.cast(completionDate()));
        case "BackupSizeInBytes":
            return Optional.ofNullable(clazz.cast(backupSizeInBytes()));
        case "CalculatedLifecycle":
            return Optional.ofNullable(clazz.cast(calculatedLifecycle()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycle()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "IsEncrypted":
            return Optional.ofNullable(clazz.cast(isEncrypted()));
        case "StorageClass":
            return Optional.ofNullable(clazz.cast(storageClassAsString()));
        case "LastRestoreTime":
            return Optional.ofNullable(clazz.cast(lastRestoreTime()));
        case "ParentRecoveryPointArn":
            return Optional.ofNullable(clazz.cast(parentRecoveryPointArn()));
        case "CompositeMemberIdentifier":
            return Optional.ofNullable(clazz.cast(compositeMemberIdentifier()));
        case "IsParent":
            return Optional.ofNullable(clazz.cast(isParent()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "VaultType":
            return Optional.ofNullable(clazz.cast(vaultTypeAsString()));
        case "IndexStatus":
            return Optional.ofNullable(clazz.cast(indexStatusAsString()));
        case "IndexStatusMessage":
            return Optional.ofNullable(clazz.cast(indexStatusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("BackupVaultArn", BACKUP_VAULT_ARN_FIELD);
        map.put("SourceBackupVaultArn", SOURCE_BACKUP_VAULT_ARN_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("CompletionDate", COMPLETION_DATE_FIELD);
        map.put("BackupSizeInBytes", BACKUP_SIZE_IN_BYTES_FIELD);
        map.put("CalculatedLifecycle", CALCULATED_LIFECYCLE_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("IsEncrypted", IS_ENCRYPTED_FIELD);
        map.put("StorageClass", STORAGE_CLASS_FIELD);
        map.put("LastRestoreTime", LAST_RESTORE_TIME_FIELD);
        map.put("ParentRecoveryPointArn", PARENT_RECOVERY_POINT_ARN_FIELD);
        map.put("CompositeMemberIdentifier", COMPOSITE_MEMBER_IDENTIFIER_FIELD);
        map.put("IsParent", IS_PARENT_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("VaultType", VAULT_TYPE_FIELD);
        map.put("IndexStatus", INDEX_STATUS_FIELD);
        map.put("IndexStatusMessage", INDEX_STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecoveryPointResponse, T> g) {
        return obj -> g.apply((DescribeRecoveryPointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRecoveryPointResponse> {
        /**
         * <p>
         * An ARN that uniquely identifies a recovery point; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param recoveryPointArn
         *        An ARN that uniquely identifies a recovery point; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the account used to create them and the Region where they are created.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the account used to create them and the Region where they are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * An ARN that uniquely identifies a backup vault; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>.
         * </p>
         * 
         * @param backupVaultArn
         *        An ARN that uniquely identifies a backup vault; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultArn(String backupVaultArn);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally
         * backed up in; for example, <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>. If
         * the recovery is restored to the same Amazon Web Services account or Region, this value will be
         * <code>null</code>.
         * </p>
         * 
         * @param sourceBackupVaultArn
         *        An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was
         *        originally backed up in; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>. If the recovery is
         *        restored to the same Amazon Web Services account or Region, this value will be <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBackupVaultArn(String sourceBackupVaultArn);

        /**
         * <p>
         * An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
         * </p>
         * 
         * @param resourceArn
         *        An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block
         * Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
         * </p>
         * 
         * @param resourceType
         *        The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic
         *        Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Contains identifying information about the creation of a recovery point, including the
         * <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
         * <code>BackupRuleId</code> of the backup plan used to create it.
         * </p>
         * 
         * @param createdBy
         *        Contains identifying information about the creation of a recovery point, including the
         *        <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
         *        <code>BackupRuleId</code> of the backup plan used to create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(RecoveryPointCreator createdBy);

        /**
         * <p>
         * Contains identifying information about the creation of a recovery point, including the
         * <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
         * <code>BackupRuleId</code> of the backup plan used to create it.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecoveryPointCreator.Builder} avoiding
         * the need to create one manually via {@link RecoveryPointCreator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecoveryPointCreator.Builder#build()} is called immediately and
         * its result is passed to {@link #createdBy(RecoveryPointCreator)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link RecoveryPointCreator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(RecoveryPointCreator)
         */
        default Builder createdBy(Consumer<RecoveryPointCreator.Builder> createdBy) {
            return createdBy(RecoveryPointCreator.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * Specifies the IAM role ARN used to create the target recovery point; for example,
         * <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * </p>
         * 
         * @param iamRoleArn
         *        Specifies the IAM role ARN used to create the target recovery point; for example,
         *        <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * A status code specifying the state of the recovery point.
         * </p>
         * <p>
         * <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window
         * closed. To increase your backup plan window using the API, see <a
         * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>.
         * You can also increase your backup plan window using the Console by choosing and editing your backup plan.
         * </p>
         * <p>
         * <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup
         * lacks permission or is otherwise unable to delete it. To manually delete these recovery points, see <a
         * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step
         * 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.
         * </p>
         * <p>
         * <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes the
         * continuous backup to be disabled. This can be caused by the removal of permissions, turning off versioning,
         * turning off events being sent to EventBridge, or disabling the EventBridge rules that are put in place by
         * Backup. For recovery points of Amazon S3, Amazon RDS, and Amazon Aurora resources, this status occurs when
         * the retention period of a continuous backup rule is changed.
         * </p>
         * <p>
         * To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that
         * versioning is enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule
         * running will result in a new continuous recovery point being created. The recovery points with STOPPED status
         * do not need to be deleted.
         * </p>
         * <p>
         * For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application
         * misconfiguration, or backup failure. To ensure that future continuous backups succeed, refer to the recovery
         * point status and check SAP HANA for details.
         * </p>
         * 
         * @param status
         *        A status code specifying the state of the recovery point.</p>
         *        <p>
         *        <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup
         *        window closed. To increase your backup plan window using the API, see <a
         *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html"
         *        >UpdateBackupPlan</a>. You can also increase your backup plan window using the Console by choosing and
         *        editing your backup plan.
         *        </p>
         *        <p>
         *        <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but
         *        Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points,
         *        see <a href=
         *        "https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups">
         *        Step 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting
         *        started</i>.
         *        </p>
         *        <p>
         *        <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that
         *        causes the continuous backup to be disabled. This can be caused by the removal of permissions, turning
         *        off versioning, turning off events being sent to EventBridge, or disabling the EventBridge rules that
         *        are put in place by Backup. For recovery points of Amazon S3, Amazon RDS, and Amazon Aurora resources,
         *        this status occurs when the retention period of a continuous backup rule is changed.
         *        </p>
         *        <p>
         *        To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that
         *        versioning is enabled on the S3 bucket. Once these conditions are met, the next instance of a backup
         *        rule running will result in a new continuous recovery point being created. The recovery points with
         *        STOPPED status do not need to be deleted.
         *        </p>
         *        <p>
         *        For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application
         *        misconfiguration, or backup failure. To ensure that future continuous backups succeed, refer to the
         *        recovery point status and check SAP HANA for details.
         * @see RecoveryPointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryPointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A status code specifying the state of the recovery point.
         * </p>
         * <p>
         * <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window
         * closed. To increase your backup plan window using the API, see <a
         * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>.
         * You can also increase your backup plan window using the Console by choosing and editing your backup plan.
         * </p>
         * <p>
         * <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup
         * lacks permission or is otherwise unable to delete it. To manually delete these recovery points, see <a
         * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step
         * 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.
         * </p>
         * <p>
         * <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes the
         * continuous backup to be disabled. This can be caused by the removal of permissions, turning off versioning,
         * turning off events being sent to EventBridge, or disabling the EventBridge rules that are put in place by
         * Backup. For recovery points of Amazon S3, Amazon RDS, and Amazon Aurora resources, this status occurs when
         * the retention period of a continuous backup rule is changed.
         * </p>
         * <p>
         * To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that
         * versioning is enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule
         * running will result in a new continuous recovery point being created. The recovery points with STOPPED status
         * do not need to be deleted.
         * </p>
         * <p>
         * For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application
         * misconfiguration, or backup failure. To ensure that future continuous backups succeed, refer to the recovery
         * point status and check SAP HANA for details.
         * </p>
         * 
         * @param status
         *        A status code specifying the state of the recovery point.</p>
         *        <p>
         *        <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup
         *        window closed. To increase your backup plan window using the API, see <a
         *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html"
         *        >UpdateBackupPlan</a>. You can also increase your backup plan window using the Console by choosing and
         *        editing your backup plan.
         *        </p>
         *        <p>
         *        <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but
         *        Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points,
         *        see <a href=
         *        "https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups">
         *        Step 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting
         *        started</i>.
         *        </p>
         *        <p>
         *        <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that
         *        causes the continuous backup to be disabled. This can be caused by the removal of permissions, turning
         *        off versioning, turning off events being sent to EventBridge, or disabling the EventBridge rules that
         *        are put in place by Backup. For recovery points of Amazon S3, Amazon RDS, and Amazon Aurora resources,
         *        this status occurs when the retention period of a continuous backup rule is changed.
         *        </p>
         *        <p>
         *        To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that
         *        versioning is enabled on the S3 bucket. Once these conditions are met, the next instance of a backup
         *        rule running will result in a new continuous recovery point being created. The recovery points with
         *        STOPPED status do not need to be deleted.
         *        </p>
         *        <p>
         *        For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application
         *        misconfiguration, or backup failure. To ensure that future continuous backups succeed, refer to the
         *        recovery point status and check SAP HANA for details.
         * @see RecoveryPointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryPointStatus
         */
        Builder status(RecoveryPointStatus status);

        /**
         * <p>
         * A status message explaining the status of the recovery point.
         * </p>
         * 
         * @param statusMessage
         *        A status message explaining the status of the recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationDate
         *        The date and time that a recovery point is created, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time that a job to create a recovery point is completed, in Unix format and Coordinated
         * Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the
         * value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param completionDate
         *        The date and time that a job to create a recovery point is completed, in Unix format and Coordinated
         *        Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For
         *        example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionDate(Instant completionDate);

        /**
         * <p>
         * The size, in bytes, of a backup.
         * </p>
         * 
         * @param backupSizeInBytes
         *        The size, in bytes, of a backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSizeInBytes(Long backupSizeInBytes);

        /**
         * <p>
         * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
         * <code>MoveToColdStorageAt</code> timestamps.
         * </p>
         * 
         * @param calculatedLifecycle
         *        A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
         *        <code>MoveToColdStorageAt</code> timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedLifecycle(CalculatedLifecycle calculatedLifecycle);

        /**
         * <p>
         * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
         * <code>MoveToColdStorageAt</code> timestamps.
         * </p>
         * This is a convenience method that creates an instance of the {@link CalculatedLifecycle.Builder} avoiding the
         * need to create one manually via {@link CalculatedLifecycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CalculatedLifecycle.Builder#build()} is called immediately and
         * its result is passed to {@link #calculatedLifecycle(CalculatedLifecycle)}.
         * 
         * @param calculatedLifecycle
         *        a consumer that will call methods on {@link CalculatedLifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #calculatedLifecycle(CalculatedLifecycle)
         */
        default Builder calculatedLifecycle(Consumer<CalculatedLifecycle.Builder> calculatedLifecycle) {
            return calculatedLifecycle(CalculatedLifecycle.builder().applyMutation(calculatedLifecycle).build());
        }

        /**
         * <p>
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
         * transitions and expires backups automatically according to the lifecycle that you define.
         * </p>
         * <p>
         * Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
         * Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting.
         * The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         * </p>
         * <p>
         * Resource types that can transition to cold storage are listed in the <a href=
         * "https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource"
         * >Feature availability by resource</a> table. Backup ignores this expression for other resource types.
         * </p>
         * 
         * @param lifecycle
         *        The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.
         *        Backup transitions and expires backups automatically according to the lifecycle that you define.</p>
         *        <p>
         *        Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
         *        Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days”
         *        setting. The “transition to cold after days” setting cannot be changed after a backup has been
         *        transitioned to cold.
         *        </p>
         *        <p>
         *        Resource types that can transition to cold storage are listed in the <a href=
         *        "https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource"
         *        >Feature availability by resource</a> table. Backup ignores this expression for other resource types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycle(Lifecycle lifecycle);

        /**
         * <p>
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
         * transitions and expires backups automatically according to the lifecycle that you define.
         * </p>
         * <p>
         * Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
         * Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting.
         * The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         * </p>
         * <p>
         * Resource types that can transition to cold storage are listed in the <a href=
         * "https://docs.aws.amazon.com/aws-backup/latest/devguide/backup-feature-availability.html#features-by-resource"
         * >Feature availability by resource</a> table. Backup ignores this expression for other resource types.
         * </p>
         * This is a convenience method that creates an instance of the {@link Lifecycle.Builder} avoiding the need to
         * create one manually via {@link Lifecycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Lifecycle.Builder#build()} is called immediately and its result
         * is passed to {@link #lifecycle(Lifecycle)}.
         * 
         * @param lifecycle
         *        a consumer that will call methods on {@link Lifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycle(Lifecycle)
         */
        default Builder lifecycle(Consumer<Lifecycle.Builder> lifecycle) {
            return lifecycle(Lifecycle.builder().applyMutation(lifecycle).build());
        }

        /**
         * <p>
         * The server-side encryption key used to protect your backups; for example,
         * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The server-side encryption key used to protect your backups; for example,
         *        <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
         * <code>FALSE</code> if the recovery point is not encrypted.
         * </p>
         * 
         * @param isEncrypted
         *        A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
         *        <code>FALSE</code> if the recovery point is not encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEncrypted(Boolean isEncrypted);

        /**
         * <p>
         * Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.
         * </p>
         * 
         * @param storageClass
         *        Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or
         *        <code>COLD</code>.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * <p>
         * Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.
         * </p>
         * 
         * @param storageClass
         *        Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or
         *        <code>COLD</code>.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(StorageClass storageClass);

        /**
         * <p>
         * The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time
         * (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value
         * 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param lastRestoreTime
         *        The date and time that a recovery point was last restored, in Unix format and Coordinated Universal
         *        Time (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the
         *        value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRestoreTime(Instant lastRestoreTime);

        /**
         * <p>
         * This is an ARN that uniquely identifies a parent (composite) recovery point; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param parentRecoveryPointArn
         *        This is an ARN that uniquely identifies a parent (composite) recovery point; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentRecoveryPointArn(String parentRecoveryPointArn);

        /**
         * <p>
         * The identifier of a resource within a composite group, such as nested (child) recovery point belonging to a
         * composite (parent) stack. The ID is transferred from the <a href=
         * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax"
         * > logical ID</a> within a stack.
         * </p>
         * 
         * @param compositeMemberIdentifier
         *        The identifier of a resource within a composite group, such as nested (child) recovery point belonging
         *        to a composite (parent) stack. The ID is transferred from the <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax"
         *        > logical ID</a> within a stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositeMemberIdentifier(String compositeMemberIdentifier);

        /**
         * <p>
         * This returns the boolean value that a recovery point is a parent (composite) job.
         * </p>
         * 
         * @param isParent
         *        This returns the boolean value that a recovery point is a parent (composite) job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isParent(Boolean isParent);

        /**
         * <p>
         * The name of the resource that belongs to the specified backup.
         * </p>
         * 
         * @param resourceName
         *        The name of the resource that belongs to the specified backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The type of vault in which the described recovery point is stored.
         * </p>
         * 
         * @param vaultType
         *        The type of vault in which the described recovery point is stored.
         * @see VaultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VaultType
         */
        Builder vaultType(String vaultType);

        /**
         * <p>
         * The type of vault in which the described recovery point is stored.
         * </p>
         * 
         * @param vaultType
         *        The type of vault in which the described recovery point is stored.
         * @see VaultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VaultType
         */
        Builder vaultType(VaultType vaultType);

        /**
         * <p>
         * This is the current status for the backup index associated with the specified recovery point.
         * </p>
         * <p>
         * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         * </p>
         * <p>
         * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * </p>
         * 
         * @param indexStatus
         *        This is the current status for the backup index associated with the specified recovery point.</p>
         *        <p>
         *        Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         *        </p>
         *        <p>
         *        A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(String indexStatus);

        /**
         * <p>
         * This is the current status for the backup index associated with the specified recovery point.
         * </p>
         * <p>
         * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         * </p>
         * <p>
         * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * </p>
         * 
         * @param indexStatus
         *        This is the current status for the backup index associated with the specified recovery point.</p>
         *        <p>
         *        Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         *        </p>
         *        <p>
         *        A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(IndexStatus indexStatus);

        /**
         * <p>
         * A string in the form of a detailed message explaining the status of a backup index associated with the
         * recovery point.
         * </p>
         * 
         * @param indexStatusMessage
         *        A string in the form of a detailed message explaining the status of a backup index associated with the
         *        recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexStatusMessage(String indexStatusMessage);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String recoveryPointArn;

        private String backupVaultName;

        private String backupVaultArn;

        private String sourceBackupVaultArn;

        private String resourceArn;

        private String resourceType;

        private RecoveryPointCreator createdBy;

        private String iamRoleArn;

        private String status;

        private String statusMessage;

        private Instant creationDate;

        private Instant completionDate;

        private Long backupSizeInBytes;

        private CalculatedLifecycle calculatedLifecycle;

        private Lifecycle lifecycle;

        private String encryptionKeyArn;

        private Boolean isEncrypted;

        private String storageClass;

        private Instant lastRestoreTime;

        private String parentRecoveryPointArn;

        private String compositeMemberIdentifier;

        private Boolean isParent;

        private String resourceName;

        private String vaultType;

        private String indexStatus;

        private String indexStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecoveryPointResponse model) {
            super(model);
            recoveryPointArn(model.recoveryPointArn);
            backupVaultName(model.backupVaultName);
            backupVaultArn(model.backupVaultArn);
            sourceBackupVaultArn(model.sourceBackupVaultArn);
            resourceArn(model.resourceArn);
            resourceType(model.resourceType);
            createdBy(model.createdBy);
            iamRoleArn(model.iamRoleArn);
            status(model.status);
            statusMessage(model.statusMessage);
            creationDate(model.creationDate);
            completionDate(model.completionDate);
            backupSizeInBytes(model.backupSizeInBytes);
            calculatedLifecycle(model.calculatedLifecycle);
            lifecycle(model.lifecycle);
            encryptionKeyArn(model.encryptionKeyArn);
            isEncrypted(model.isEncrypted);
            storageClass(model.storageClass);
            lastRestoreTime(model.lastRestoreTime);
            parentRecoveryPointArn(model.parentRecoveryPointArn);
            compositeMemberIdentifier(model.compositeMemberIdentifier);
            isParent(model.isParent);
            resourceName(model.resourceName);
            vaultType(model.vaultType);
            indexStatus(model.indexStatus);
            indexStatusMessage(model.indexStatusMessage);
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getBackupVaultArn() {
            return backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getSourceBackupVaultArn() {
            return sourceBackupVaultArn;
        }

        public final void setSourceBackupVaultArn(String sourceBackupVaultArn) {
            this.sourceBackupVaultArn = sourceBackupVaultArn;
        }

        @Override
        public final Builder sourceBackupVaultArn(String sourceBackupVaultArn) {
            this.sourceBackupVaultArn = sourceBackupVaultArn;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final RecoveryPointCreator.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(RecoveryPointCreator.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(RecoveryPointCreator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecoveryPointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getCompletionDate() {
            return completionDate;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final Long getBackupSizeInBytes() {
            return backupSizeInBytes;
        }

        public final void setBackupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
        }

        @Override
        public final Builder backupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
            return this;
        }

        public final CalculatedLifecycle.Builder getCalculatedLifecycle() {
            return calculatedLifecycle != null ? calculatedLifecycle.toBuilder() : null;
        }

        public final void setCalculatedLifecycle(CalculatedLifecycle.BuilderImpl calculatedLifecycle) {
            this.calculatedLifecycle = calculatedLifecycle != null ? calculatedLifecycle.build() : null;
        }

        @Override
        public final Builder calculatedLifecycle(CalculatedLifecycle calculatedLifecycle) {
            this.calculatedLifecycle = calculatedLifecycle;
            return this;
        }

        public final Lifecycle.Builder getLifecycle() {
            return lifecycle != null ? lifecycle.toBuilder() : null;
        }

        public final void setLifecycle(Lifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        @Override
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final Boolean getIsEncrypted() {
            return isEncrypted;
        }

        public final void setIsEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
        }

        @Override
        public final Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            return this;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        public final Instant getLastRestoreTime() {
            return lastRestoreTime;
        }

        public final void setLastRestoreTime(Instant lastRestoreTime) {
            this.lastRestoreTime = lastRestoreTime;
        }

        @Override
        public final Builder lastRestoreTime(Instant lastRestoreTime) {
            this.lastRestoreTime = lastRestoreTime;
            return this;
        }

        public final String getParentRecoveryPointArn() {
            return parentRecoveryPointArn;
        }

        public final void setParentRecoveryPointArn(String parentRecoveryPointArn) {
            this.parentRecoveryPointArn = parentRecoveryPointArn;
        }

        @Override
        public final Builder parentRecoveryPointArn(String parentRecoveryPointArn) {
            this.parentRecoveryPointArn = parentRecoveryPointArn;
            return this;
        }

        public final String getCompositeMemberIdentifier() {
            return compositeMemberIdentifier;
        }

        public final void setCompositeMemberIdentifier(String compositeMemberIdentifier) {
            this.compositeMemberIdentifier = compositeMemberIdentifier;
        }

        @Override
        public final Builder compositeMemberIdentifier(String compositeMemberIdentifier) {
            this.compositeMemberIdentifier = compositeMemberIdentifier;
            return this;
        }

        public final Boolean getIsParent() {
            return isParent;
        }

        public final void setIsParent(Boolean isParent) {
            this.isParent = isParent;
        }

        @Override
        public final Builder isParent(Boolean isParent) {
            this.isParent = isParent;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getVaultType() {
            return vaultType;
        }

        public final void setVaultType(String vaultType) {
            this.vaultType = vaultType;
        }

        @Override
        public final Builder vaultType(String vaultType) {
            this.vaultType = vaultType;
            return this;
        }

        @Override
        public final Builder vaultType(VaultType vaultType) {
            this.vaultType(vaultType == null ? null : vaultType.toString());
            return this;
        }

        public final String getIndexStatus() {
            return indexStatus;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final String getIndexStatusMessage() {
            return indexStatusMessage;
        }

        public final void setIndexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
        }

        @Override
        public final Builder indexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
            return this;
        }

        @Override
        public DescribeRecoveryPointResponse build() {
            return new DescribeRecoveryPointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
