/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReportJobRequest extends BackupRequest implements
        ToCopyableBuilder<DescribeReportJobRequest.Builder, DescribeReportJobRequest> {
    private static final SdkField<String> REPORT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportJobId").getter(getter(DescribeReportJobRequest::reportJobId)).setter(setter(Builder::reportJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("reportJobId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_JOB_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String reportJobId;

    private DescribeReportJobRequest(BuilderImpl builder) {
        super(builder);
        this.reportJobId = builder.reportJobId;
    }

    /**
     * <p>
     * The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most
     * 1,024 bytes long. The report job ID cannot be edited.
     * </p>
     * 
     * @return The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at
     *         most 1,024 bytes long. The report job ID cannot be edited.
     */
    public final String reportJobId() {
        return reportJobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportJobId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReportJobRequest)) {
            return false;
        }
        DescribeReportJobRequest other = (DescribeReportJobRequest) obj;
        return Objects.equals(reportJobId(), other.reportJobId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReportJobRequest").add("ReportJobId", reportJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportJobId":
            return Optional.ofNullable(clazz.cast(reportJobId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reportJobId", REPORT_JOB_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReportJobRequest, T> g) {
        return obj -> g.apply((DescribeReportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReportJobRequest> {
        /**
         * <p>
         * The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most
         * 1,024 bytes long. The report job ID cannot be edited.
         * </p>
         * 
         * @param reportJobId
         *        The identifier of the report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is
         *        at most 1,024 bytes long. The report job ID cannot be edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportJobId(String reportJobId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String reportJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReportJobRequest model) {
            super(model);
            reportJobId(model.reportJobId);
        }

        public final String getReportJobId() {
            return reportJobId;
        }

        public final void setReportJobId(String reportJobId) {
            this.reportJobId = reportJobId;
        }

        @Override
        public final Builder reportJobId(String reportJobId) {
            this.reportJobId = reportJobId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReportJobRequest build() {
            return new DescribeReportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
