/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBackupPlanFromTemplateResponse extends BackupResponse implements
        ToCopyableBuilder<GetBackupPlanFromTemplateResponse.Builder, GetBackupPlanFromTemplateResponse> {
    private static final SdkField<BackupPlan> BACKUP_PLAN_DOCUMENT_FIELD = SdkField
            .<BackupPlan> builder(MarshallingType.SDK_POJO).memberName("BackupPlanDocument")
            .getter(getter(GetBackupPlanFromTemplateResponse::backupPlanDocument)).setter(setter(Builder::backupPlanDocument))
            .constructor(BackupPlan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanDocument").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_DOCUMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final BackupPlan backupPlanDocument;

    private GetBackupPlanFromTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.backupPlanDocument = builder.backupPlanDocument;
    }

    /**
     * <p>
     * Returns the body of a backup plan based on the target template, including the name, rules, and backup vault of
     * the plan.
     * </p>
     * 
     * @return Returns the body of a backup plan based on the target template, including the name, rules, and backup
     *         vault of the plan.
     */
    public final BackupPlan backupPlanDocument() {
        return backupPlanDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanDocument());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackupPlanFromTemplateResponse)) {
            return false;
        }
        GetBackupPlanFromTemplateResponse other = (GetBackupPlanFromTemplateResponse) obj;
        return Objects.equals(backupPlanDocument(), other.backupPlanDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBackupPlanFromTemplateResponse").add("BackupPlanDocument", backupPlanDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanDocument":
            return Optional.ofNullable(clazz.cast(backupPlanDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupPlanDocument", BACKUP_PLAN_DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBackupPlanFromTemplateResponse, T> g) {
        return obj -> g.apply((GetBackupPlanFromTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBackupPlanFromTemplateResponse> {
        /**
         * <p>
         * Returns the body of a backup plan based on the target template, including the name, rules, and backup vault
         * of the plan.
         * </p>
         * 
         * @param backupPlanDocument
         *        Returns the body of a backup plan based on the target template, including the name, rules, and backup
         *        vault of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanDocument(BackupPlan backupPlanDocument);

        /**
         * <p>
         * Returns the body of a backup plan based on the target template, including the name, rules, and backup vault
         * of the plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link BackupPlan.Builder} avoiding the need to
         * create one manually via {@link BackupPlan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BackupPlan.Builder#build()} is called immediately and its result
         * is passed to {@link #backupPlanDocument(BackupPlan)}.
         * 
         * @param backupPlanDocument
         *        a consumer that will call methods on {@link BackupPlan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupPlanDocument(BackupPlan)
         */
        default Builder backupPlanDocument(Consumer<BackupPlan.Builder> backupPlanDocument) {
            return backupPlanDocument(BackupPlan.builder().applyMutation(backupPlanDocument).build());
        }
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private BackupPlan backupPlanDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackupPlanFromTemplateResponse model) {
            super(model);
            backupPlanDocument(model.backupPlanDocument);
        }

        public final BackupPlan.Builder getBackupPlanDocument() {
            return backupPlanDocument != null ? backupPlanDocument.toBuilder() : null;
        }

        public final void setBackupPlanDocument(BackupPlan.BuilderImpl backupPlanDocument) {
            this.backupPlanDocument = backupPlanDocument != null ? backupPlanDocument.build() : null;
        }

        @Override
        public final Builder backupPlanDocument(BackupPlan backupPlanDocument) {
            this.backupPlanDocument = backupPlanDocument;
            return this;
        }

        @Override
        public GetBackupPlanFromTemplateResponse build() {
            return new GetBackupPlanFromTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
