/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLegalHoldResponse extends BackupResponse implements
        ToCopyableBuilder<GetLegalHoldResponse.Builder, GetLegalHoldResponse> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(GetLegalHoldResponse::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetLegalHoldResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetLegalHoldResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CANCEL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CancelDescription").getter(getter(GetLegalHoldResponse::cancelDescription))
            .setter(setter(Builder::cancelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancelDescription").build()).build();

    private static final SdkField<String> LEGAL_HOLD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LegalHoldId").getter(getter(GetLegalHoldResponse::legalHoldId)).setter(setter(Builder::legalHoldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegalHoldId").build()).build();

    private static final SdkField<String> LEGAL_HOLD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LegalHoldArn").getter(getter(GetLegalHoldResponse::legalHoldArn)).setter(setter(Builder::legalHoldArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegalHoldArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(GetLegalHoldResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> CANCELLATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CancellationDate").getter(getter(GetLegalHoldResponse::cancellationDate))
            .setter(setter(Builder::cancellationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancellationDate").build()).build();

    private static final SdkField<Instant> RETAIN_RECORD_UNTIL_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RetainRecordUntil").getter(getter(GetLegalHoldResponse::retainRecordUntil))
            .setter(setter(Builder::retainRecordUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainRecordUntil").build()).build();

    private static final SdkField<RecoveryPointSelection> RECOVERY_POINT_SELECTION_FIELD = SdkField
            .<RecoveryPointSelection> builder(MarshallingType.SDK_POJO).memberName("RecoveryPointSelection")
            .getter(getter(GetLegalHoldResponse::recoveryPointSelection)).setter(setter(Builder::recoveryPointSelection))
            .constructor(RecoveryPointSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointSelection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, STATUS_FIELD,
            DESCRIPTION_FIELD, CANCEL_DESCRIPTION_FIELD, LEGAL_HOLD_ID_FIELD, LEGAL_HOLD_ARN_FIELD, CREATION_DATE_FIELD,
            CANCELLATION_DATE_FIELD, RETAIN_RECORD_UNTIL_FIELD, RECOVERY_POINT_SELECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String title;

    private final String status;

    private final String description;

    private final String cancelDescription;

    private final String legalHoldId;

    private final String legalHoldArn;

    private final Instant creationDate;

    private final Instant cancellationDate;

    private final Instant retainRecordUntil;

    private final RecoveryPointSelection recoveryPointSelection;

    private GetLegalHoldResponse(BuilderImpl builder) {
        super(builder);
        this.title = builder.title;
        this.status = builder.status;
        this.description = builder.description;
        this.cancelDescription = builder.cancelDescription;
        this.legalHoldId = builder.legalHoldId;
        this.legalHoldArn = builder.legalHoldArn;
        this.creationDate = builder.creationDate;
        this.cancellationDate = builder.cancellationDate;
        this.retainRecordUntil = builder.retainRecordUntil;
        this.recoveryPointSelection = builder.recoveryPointSelection;
    }

    /**
     * <p>
     * The title of the legal hold.
     * </p>
     * 
     * @return The title of the legal hold.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The status of the legal hold.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LegalHoldStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the legal hold.
     * @see LegalHoldStatus
     */
    public final LegalHoldStatus status() {
        return LegalHoldStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the legal hold.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LegalHoldStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the legal hold.
     * @see LegalHoldStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The description of the legal hold.
     * </p>
     * 
     * @return The description of the legal hold.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The reason for removing the legal hold.
     * </p>
     * 
     * @return The reason for removing the legal hold.
     */
    public final String cancelDescription() {
        return cancelDescription;
    }

    /**
     * <p>
     * The ID of the legal hold.
     * </p>
     * 
     * @return The ID of the legal hold.
     */
    public final String legalHoldId() {
        return legalHoldId;
    }

    /**
     * <p>
     * The framework ARN for the specified legal hold. The format of the ARN depends on the resource type.
     * </p>
     * 
     * @return The framework ARN for the specified legal hold. The format of the ARN depends on the resource type.
     */
    public final String legalHoldArn() {
        return legalHoldArn;
    }

    /**
     * <p>
     * The time when the legal hold was created.
     * </p>
     * 
     * @return The time when the legal hold was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The time when the legal hold was cancelled.
     * </p>
     * 
     * @return The time when the legal hold was cancelled.
     */
    public final Instant cancellationDate() {
        return cancellationDate;
    }

    /**
     * <p>
     * The date and time until which the legal hold record is retained.
     * </p>
     * 
     * @return The date and time until which the legal hold record is retained.
     */
    public final Instant retainRecordUntil() {
        return retainRecordUntil;
    }

    /**
     * <p>
     * The criteria to assign a set of resources, such as resource types or backup vaults.
     * </p>
     * 
     * @return The criteria to assign a set of resources, such as resource types or backup vaults.
     */
    public final RecoveryPointSelection recoveryPointSelection() {
        return recoveryPointSelection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(cancelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(legalHoldId());
        hashCode = 31 * hashCode + Objects.hashCode(legalHoldArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(cancellationDate());
        hashCode = 31 * hashCode + Objects.hashCode(retainRecordUntil());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointSelection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLegalHoldResponse)) {
            return false;
        }
        GetLegalHoldResponse other = (GetLegalHoldResponse) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(cancelDescription(), other.cancelDescription())
                && Objects.equals(legalHoldId(), other.legalHoldId()) && Objects.equals(legalHoldArn(), other.legalHoldArn())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(cancellationDate(), other.cancellationDate())
                && Objects.equals(retainRecordUntil(), other.retainRecordUntil())
                && Objects.equals(recoveryPointSelection(), other.recoveryPointSelection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLegalHoldResponse").add("Title", title()).add("Status", statusAsString())
                .add("Description", description()).add("CancelDescription", cancelDescription())
                .add("LegalHoldId", legalHoldId()).add("LegalHoldArn", legalHoldArn()).add("CreationDate", creationDate())
                .add("CancellationDate", cancellationDate()).add("RetainRecordUntil", retainRecordUntil())
                .add("RecoveryPointSelection", recoveryPointSelection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CancelDescription":
            return Optional.ofNullable(clazz.cast(cancelDescription()));
        case "LegalHoldId":
            return Optional.ofNullable(clazz.cast(legalHoldId()));
        case "LegalHoldArn":
            return Optional.ofNullable(clazz.cast(legalHoldArn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "CancellationDate":
            return Optional.ofNullable(clazz.cast(cancellationDate()));
        case "RetainRecordUntil":
            return Optional.ofNullable(clazz.cast(retainRecordUntil()));
        case "RecoveryPointSelection":
            return Optional.ofNullable(clazz.cast(recoveryPointSelection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Title", TITLE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CancelDescription", CANCEL_DESCRIPTION_FIELD);
        map.put("LegalHoldId", LEGAL_HOLD_ID_FIELD);
        map.put("LegalHoldArn", LEGAL_HOLD_ARN_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("CancellationDate", CANCELLATION_DATE_FIELD);
        map.put("RetainRecordUntil", RETAIN_RECORD_UNTIL_FIELD);
        map.put("RecoveryPointSelection", RECOVERY_POINT_SELECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLegalHoldResponse, T> g) {
        return obj -> g.apply((GetLegalHoldResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLegalHoldResponse> {
        /**
         * <p>
         * The title of the legal hold.
         * </p>
         * 
         * @param title
         *        The title of the legal hold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The status of the legal hold.
         * </p>
         * 
         * @param status
         *        The status of the legal hold.
         * @see LegalHoldStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LegalHoldStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the legal hold.
         * </p>
         * 
         * @param status
         *        The status of the legal hold.
         * @see LegalHoldStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LegalHoldStatus
         */
        Builder status(LegalHoldStatus status);

        /**
         * <p>
         * The description of the legal hold.
         * </p>
         * 
         * @param description
         *        The description of the legal hold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The reason for removing the legal hold.
         * </p>
         * 
         * @param cancelDescription
         *        The reason for removing the legal hold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelDescription(String cancelDescription);

        /**
         * <p>
         * The ID of the legal hold.
         * </p>
         * 
         * @param legalHoldId
         *        The ID of the legal hold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalHoldId(String legalHoldId);

        /**
         * <p>
         * The framework ARN for the specified legal hold. The format of the ARN depends on the resource type.
         * </p>
         * 
         * @param legalHoldArn
         *        The framework ARN for the specified legal hold. The format of the ARN depends on the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legalHoldArn(String legalHoldArn);

        /**
         * <p>
         * The time when the legal hold was created.
         * </p>
         * 
         * @param creationDate
         *        The time when the legal hold was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The time when the legal hold was cancelled.
         * </p>
         * 
         * @param cancellationDate
         *        The time when the legal hold was cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancellationDate(Instant cancellationDate);

        /**
         * <p>
         * The date and time until which the legal hold record is retained.
         * </p>
         * 
         * @param retainRecordUntil
         *        The date and time until which the legal hold record is retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainRecordUntil(Instant retainRecordUntil);

        /**
         * <p>
         * The criteria to assign a set of resources, such as resource types or backup vaults.
         * </p>
         * 
         * @param recoveryPointSelection
         *        The criteria to assign a set of resources, such as resource types or backup vaults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointSelection(RecoveryPointSelection recoveryPointSelection);

        /**
         * <p>
         * The criteria to assign a set of resources, such as resource types or backup vaults.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecoveryPointSelection.Builder} avoiding
         * the need to create one manually via {@link RecoveryPointSelection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecoveryPointSelection.Builder#build()} is called immediately and
         * its result is passed to {@link #recoveryPointSelection(RecoveryPointSelection)}.
         * 
         * @param recoveryPointSelection
         *        a consumer that will call methods on {@link RecoveryPointSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recoveryPointSelection(RecoveryPointSelection)
         */
        default Builder recoveryPointSelection(Consumer<RecoveryPointSelection.Builder> recoveryPointSelection) {
            return recoveryPointSelection(RecoveryPointSelection.builder().applyMutation(recoveryPointSelection).build());
        }
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String title;

        private String status;

        private String description;

        private String cancelDescription;

        private String legalHoldId;

        private String legalHoldArn;

        private Instant creationDate;

        private Instant cancellationDate;

        private Instant retainRecordUntil;

        private RecoveryPointSelection recoveryPointSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLegalHoldResponse model) {
            super(model);
            title(model.title);
            status(model.status);
            description(model.description);
            cancelDescription(model.cancelDescription);
            legalHoldId(model.legalHoldId);
            legalHoldArn(model.legalHoldArn);
            creationDate(model.creationDate);
            cancellationDate(model.cancellationDate);
            retainRecordUntil(model.retainRecordUntil);
            recoveryPointSelection(model.recoveryPointSelection);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LegalHoldStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCancelDescription() {
            return cancelDescription;
        }

        public final void setCancelDescription(String cancelDescription) {
            this.cancelDescription = cancelDescription;
        }

        @Override
        public final Builder cancelDescription(String cancelDescription) {
            this.cancelDescription = cancelDescription;
            return this;
        }

        public final String getLegalHoldId() {
            return legalHoldId;
        }

        public final void setLegalHoldId(String legalHoldId) {
            this.legalHoldId = legalHoldId;
        }

        @Override
        public final Builder legalHoldId(String legalHoldId) {
            this.legalHoldId = legalHoldId;
            return this;
        }

        public final String getLegalHoldArn() {
            return legalHoldArn;
        }

        public final void setLegalHoldArn(String legalHoldArn) {
            this.legalHoldArn = legalHoldArn;
        }

        @Override
        public final Builder legalHoldArn(String legalHoldArn) {
            this.legalHoldArn = legalHoldArn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getCancellationDate() {
            return cancellationDate;
        }

        public final void setCancellationDate(Instant cancellationDate) {
            this.cancellationDate = cancellationDate;
        }

        @Override
        public final Builder cancellationDate(Instant cancellationDate) {
            this.cancellationDate = cancellationDate;
            return this;
        }

        public final Instant getRetainRecordUntil() {
            return retainRecordUntil;
        }

        public final void setRetainRecordUntil(Instant retainRecordUntil) {
            this.retainRecordUntil = retainRecordUntil;
        }

        @Override
        public final Builder retainRecordUntil(Instant retainRecordUntil) {
            this.retainRecordUntil = retainRecordUntil;
            return this;
        }

        public final RecoveryPointSelection.Builder getRecoveryPointSelection() {
            return recoveryPointSelection != null ? recoveryPointSelection.toBuilder() : null;
        }

        public final void setRecoveryPointSelection(RecoveryPointSelection.BuilderImpl recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection != null ? recoveryPointSelection.build() : null;
        }

        @Override
        public final Builder recoveryPointSelection(RecoveryPointSelection recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection;
            return this;
        }

        @Override
        public GetLegalHoldResponse build() {
            return new GetLegalHoldResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
