/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRestoreTestingInferredMetadataResponse extends BackupResponse implements
        ToCopyableBuilder<GetRestoreTestingInferredMetadataResponse.Builder, GetRestoreTestingInferredMetadataResponse> {
    private static final SdkField<Map<String, String>> INFERRED_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("InferredMetadata")
            .getter(getter(GetRestoreTestingInferredMetadataResponse::inferredMetadata))
            .setter(setter(Builder::inferredMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferredMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERRED_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, String> inferredMetadata;

    private GetRestoreTestingInferredMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.inferredMetadata = builder.inferredMetadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the InferredMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInferredMetadata() {
        return inferredMetadata != null && !(inferredMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is a string map of the metadata inferred from the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferredMetadata} method.
     * </p>
     * 
     * @return This is a string map of the metadata inferred from the request.
     */
    public final Map<String, String> inferredMetadata() {
        return inferredMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInferredMetadata() ? inferredMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRestoreTestingInferredMetadataResponse)) {
            return false;
        }
        GetRestoreTestingInferredMetadataResponse other = (GetRestoreTestingInferredMetadataResponse) obj;
        return hasInferredMetadata() == other.hasInferredMetadata()
                && Objects.equals(inferredMetadata(), other.inferredMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRestoreTestingInferredMetadataResponse")
                .add("InferredMetadata", hasInferredMetadata() ? inferredMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferredMetadata":
            return Optional.ofNullable(clazz.cast(inferredMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InferredMetadata", INFERRED_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRestoreTestingInferredMetadataResponse, T> g) {
        return obj -> g.apply((GetRestoreTestingInferredMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRestoreTestingInferredMetadataResponse> {
        /**
         * <p>
         * This is a string map of the metadata inferred from the request.
         * </p>
         * 
         * @param inferredMetadata
         *        This is a string map of the metadata inferred from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferredMetadata(Map<String, String> inferredMetadata);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private Map<String, String> inferredMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRestoreTestingInferredMetadataResponse model) {
            super(model);
            inferredMetadata(model.inferredMetadata);
        }

        public final Map<String, String> getInferredMetadata() {
            if (inferredMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return inferredMetadata;
        }

        public final void setInferredMetadata(Map<String, String> inferredMetadata) {
            this.inferredMetadata = _stringMapCopier.copy(inferredMetadata);
        }

        @Override
        public final Builder inferredMetadata(Map<String, String> inferredMetadata) {
            this.inferredMetadata = _stringMapCopier.copy(inferredMetadata);
            return this;
        }

        @Override
        public GetRestoreTestingInferredMetadataResponse build() {
            return new GetRestoreTestingInferredMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
