/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRestoreTestingPlanResponse extends BackupResponse implements
        ToCopyableBuilder<GetRestoreTestingPlanResponse.Builder, GetRestoreTestingPlanResponse> {
    private static final SdkField<RestoreTestingPlanForGet> RESTORE_TESTING_PLAN_FIELD = SdkField
            .<RestoreTestingPlanForGet> builder(MarshallingType.SDK_POJO).memberName("RestoreTestingPlan")
            .getter(getter(GetRestoreTestingPlanResponse::restoreTestingPlan)).setter(setter(Builder::restoreTestingPlan))
            .constructor(RestoreTestingPlanForGet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlan").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTORE_TESTING_PLAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RestoreTestingPlanForGet restoreTestingPlan;

    private GetRestoreTestingPlanResponse(BuilderImpl builder) {
        super(builder);
        this.restoreTestingPlan = builder.restoreTestingPlan;
    }

    /**
     * <p>
     * Specifies the body of a restore testing plan. Includes <code>RestoreTestingPlanName</code>.
     * </p>
     * 
     * @return Specifies the body of a restore testing plan. Includes <code>RestoreTestingPlanName</code>.
     */
    public final RestoreTestingPlanForGet restoreTestingPlan() {
        return restoreTestingPlan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRestoreTestingPlanResponse)) {
            return false;
        }
        GetRestoreTestingPlanResponse other = (GetRestoreTestingPlanResponse) obj;
        return Objects.equals(restoreTestingPlan(), other.restoreTestingPlan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRestoreTestingPlanResponse").add("RestoreTestingPlan", restoreTestingPlan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestoreTestingPlan":
            return Optional.ofNullable(clazz.cast(restoreTestingPlan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RestoreTestingPlan", RESTORE_TESTING_PLAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRestoreTestingPlanResponse, T> g) {
        return obj -> g.apply((GetRestoreTestingPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRestoreTestingPlanResponse> {
        /**
         * <p>
         * Specifies the body of a restore testing plan. Includes <code>RestoreTestingPlanName</code>.
         * </p>
         * 
         * @param restoreTestingPlan
         *        Specifies the body of a restore testing plan. Includes <code>RestoreTestingPlanName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlan(RestoreTestingPlanForGet restoreTestingPlan);

        /**
         * <p>
         * Specifies the body of a restore testing plan. Includes <code>RestoreTestingPlanName</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RestoreTestingPlanForGet.Builder}
         * avoiding the need to create one manually via {@link RestoreTestingPlanForGet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RestoreTestingPlanForGet.Builder#build()} is called immediately
         * and its result is passed to {@link #restoreTestingPlan(RestoreTestingPlanForGet)}.
         * 
         * @param restoreTestingPlan
         *        a consumer that will call methods on {@link RestoreTestingPlanForGet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreTestingPlan(RestoreTestingPlanForGet)
         */
        default Builder restoreTestingPlan(Consumer<RestoreTestingPlanForGet.Builder> restoreTestingPlan) {
            return restoreTestingPlan(RestoreTestingPlanForGet.builder().applyMutation(restoreTestingPlan).build());
        }
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private RestoreTestingPlanForGet restoreTestingPlan;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRestoreTestingPlanResponse model) {
            super(model);
            restoreTestingPlan(model.restoreTestingPlan);
        }

        public final RestoreTestingPlanForGet.Builder getRestoreTestingPlan() {
            return restoreTestingPlan != null ? restoreTestingPlan.toBuilder() : null;
        }

        public final void setRestoreTestingPlan(RestoreTestingPlanForGet.BuilderImpl restoreTestingPlan) {
            this.restoreTestingPlan = restoreTestingPlan != null ? restoreTestingPlan.build() : null;
        }

        @Override
        public final Builder restoreTestingPlan(RestoreTestingPlanForGet restoreTestingPlan) {
            this.restoreTestingPlan = restoreTestingPlan;
            return this;
        }

        @Override
        public GetRestoreTestingPlanResponse build() {
            return new GetRestoreTestingPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
