/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRestoreTestingSelectionResponse extends BackupResponse implements
        ToCopyableBuilder<GetRestoreTestingSelectionResponse.Builder, GetRestoreTestingSelectionResponse> {
    private static final SdkField<RestoreTestingSelectionForGet> RESTORE_TESTING_SELECTION_FIELD = SdkField
            .<RestoreTestingSelectionForGet> builder(MarshallingType.SDK_POJO).memberName("RestoreTestingSelection")
            .getter(getter(GetRestoreTestingSelectionResponse::restoreTestingSelection))
            .setter(setter(Builder::restoreTestingSelection)).constructor(RestoreTestingSelectionForGet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingSelection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESTORE_TESTING_SELECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RestoreTestingSelectionForGet restoreTestingSelection;

    private GetRestoreTestingSelectionResponse(BuilderImpl builder) {
        super(builder);
        this.restoreTestingSelection = builder.restoreTestingSelection;
    }

    /**
     * <p>
     * Unique name of the restore testing selection.
     * </p>
     * 
     * @return Unique name of the restore testing selection.
     */
    public final RestoreTestingSelectionForGet restoreTestingSelection() {
        return restoreTestingSelection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingSelection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRestoreTestingSelectionResponse)) {
            return false;
        }
        GetRestoreTestingSelectionResponse other = (GetRestoreTestingSelectionResponse) obj;
        return Objects.equals(restoreTestingSelection(), other.restoreTestingSelection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRestoreTestingSelectionResponse").add("RestoreTestingSelection", restoreTestingSelection())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestoreTestingSelection":
            return Optional.ofNullable(clazz.cast(restoreTestingSelection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RestoreTestingSelection", RESTORE_TESTING_SELECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRestoreTestingSelectionResponse, T> g) {
        return obj -> g.apply((GetRestoreTestingSelectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRestoreTestingSelectionResponse> {
        /**
         * <p>
         * Unique name of the restore testing selection.
         * </p>
         * 
         * @param restoreTestingSelection
         *        Unique name of the restore testing selection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingSelection(RestoreTestingSelectionForGet restoreTestingSelection);

        /**
         * <p>
         * Unique name of the restore testing selection.
         * </p>
         * This is a convenience method that creates an instance of the {@link RestoreTestingSelectionForGet.Builder}
         * avoiding the need to create one manually via {@link RestoreTestingSelectionForGet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RestoreTestingSelectionForGet.Builder#build()} is called
         * immediately and its result is passed to {@link #restoreTestingSelection(RestoreTestingSelectionForGet)}.
         * 
         * @param restoreTestingSelection
         *        a consumer that will call methods on {@link RestoreTestingSelectionForGet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreTestingSelection(RestoreTestingSelectionForGet)
         */
        default Builder restoreTestingSelection(Consumer<RestoreTestingSelectionForGet.Builder> restoreTestingSelection) {
            return restoreTestingSelection(RestoreTestingSelectionForGet.builder().applyMutation(restoreTestingSelection).build());
        }
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private RestoreTestingSelectionForGet restoreTestingSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRestoreTestingSelectionResponse model) {
            super(model);
            restoreTestingSelection(model.restoreTestingSelection);
        }

        public final RestoreTestingSelectionForGet.Builder getRestoreTestingSelection() {
            return restoreTestingSelection != null ? restoreTestingSelection.toBuilder() : null;
        }

        public final void setRestoreTestingSelection(RestoreTestingSelectionForGet.BuilderImpl restoreTestingSelection) {
            this.restoreTestingSelection = restoreTestingSelection != null ? restoreTestingSelection.build() : null;
        }

        @Override
        public final Builder restoreTestingSelection(RestoreTestingSelectionForGet restoreTestingSelection) {
            this.restoreTestingSelection = restoreTestingSelection;
            return this;
        }

        @Override
        public GetRestoreTestingSelectionResponse build() {
            return new GetRestoreTestingSelectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
