/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is an optional array within a BackupRule.
 * </p>
 * <p>
 * IndexAction consists of one ResourceTypes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexAction implements SdkPojo, Serializable, ToCopyableBuilder<IndexAction.Builder, IndexAction> {
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(IndexAction::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> resourceTypes;

    private IndexAction(BuilderImpl builder) {
        this.resourceTypes = builder.resourceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * 0 or 1 index action will be accepted for each BackupRule.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EBS</code> for Amazon Elastic Block Store
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return 0 or 1 index action will be accepted for each BackupRule.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EBS</code> for Amazon Elastic Block Store
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
     *         </p>
     *         </li>
     */
    public final List<String> resourceTypes() {
        return resourceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexAction)) {
            return false;
        }
        IndexAction other = (IndexAction) obj;
        return hasResourceTypes() == other.hasResourceTypes() && Objects.equals(resourceTypes(), other.resourceTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndexAction").add("ResourceTypes", hasResourceTypes() ? resourceTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndexAction, T> g) {
        return obj -> g.apply((IndexAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndexAction> {
        /**
         * <p>
         * 0 or 1 index action will be accepted for each BackupRule.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EBS</code> for Amazon Elastic Block Store
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTypes
         *        0 or 1 index action will be accepted for each BackupRule.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EBS</code> for Amazon Elastic Block Store
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * 0 or 1 index action will be accepted for each BackupRule.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EBS</code> for Amazon Elastic Block Store
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTypes
         *        0 or 1 index action will be accepted for each BackupRule.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EBS</code> for Amazon Elastic Block Store
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IndexAction model) {
            resourceTypes(model.resourceTypes);
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public IndexAction build() {
            return new IndexAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
