/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is a recovery point that has an associated backup index.
 * </p>
 * <p>
 * Only recovery points with a backup index can be included in a search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexedRecoveryPoint implements SdkPojo, Serializable,
        ToCopyableBuilder<IndexedRecoveryPoint.Builder, IndexedRecoveryPoint> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(IndexedRecoveryPoint::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<String> SOURCE_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceResourceArn").getter(getter(IndexedRecoveryPoint::sourceResourceArn))
            .setter(setter(Builder::sourceResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceArn").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(IndexedRecoveryPoint::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<Instant> BACKUP_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("BackupCreationDate").getter(getter(IndexedRecoveryPoint::backupCreationDate))
            .setter(setter(Builder::backupCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupCreationDate").build())
            .build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(IndexedRecoveryPoint::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Instant> INDEX_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("IndexCreationDate").getter(getter(IndexedRecoveryPoint::indexCreationDate))
            .setter(setter(Builder::indexCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexCreationDate").build()).build();

    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexStatus").getter(getter(IndexedRecoveryPoint::indexStatusAsString))
            .setter(setter(Builder::indexStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()).build();

    private static final SdkField<String> INDEX_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexStatusMessage").getter(getter(IndexedRecoveryPoint::indexStatusMessage))
            .setter(setter(Builder::indexStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatusMessage").build())
            .build();

    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultArn").getter(getter(IndexedRecoveryPoint::backupVaultArn))
            .setter(setter(Builder::backupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD,
            SOURCE_RESOURCE_ARN_FIELD, IAM_ROLE_ARN_FIELD, BACKUP_CREATION_DATE_FIELD, RESOURCE_TYPE_FIELD,
            INDEX_CREATION_DATE_FIELD, INDEX_STATUS_FIELD, INDEX_STATUS_MESSAGE_FIELD, BACKUP_VAULT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String recoveryPointArn;

    private final String sourceResourceArn;

    private final String iamRoleArn;

    private final Instant backupCreationDate;

    private final String resourceType;

    private final Instant indexCreationDate;

    private final String indexStatus;

    private final String indexStatusMessage;

    private final String backupVaultArn;

    private IndexedRecoveryPoint(BuilderImpl builder) {
        this.recoveryPointArn = builder.recoveryPointArn;
        this.sourceResourceArn = builder.sourceResourceArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.backupCreationDate = builder.backupCreationDate;
        this.resourceType = builder.resourceType;
        this.indexCreationDate = builder.indexCreationDate;
        this.indexStatus = builder.indexStatus;
        this.indexStatusMessage = builder.indexStatusMessage;
        this.backupVaultArn = builder.backupVaultArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
     * </p>
     * 
     * @return An ARN that uniquely identifies a recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * A string of the Amazon Resource Name (ARN) that uniquely identifies the source resource.
     * </p>
     * 
     * @return A string of the Amazon Resource Name (ARN) that uniquely identifies the source resource.
     */
    public final String sourceResourceArn() {
        return sourceResourceArn;
    }

    /**
     * <p>
     * This specifies the IAM role ARN used for this operation.
     * </p>
     * <p>
     * For example, arn:aws:iam::123456789012:role/S3Access
     * </p>
     * 
     * @return This specifies the IAM role ARN used for this operation.</p>
     *         <p>
     *         For example, arn:aws:iam::123456789012:role/S3Access
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The date and time that a backup was created, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a backup was created, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant backupCreationDate() {
        return backupCreationDate;
    }

    /**
     * <p>
     * The resource type of the indexed recovery point.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EBS</code> for Amazon Elastic Block Store
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
     * </p>
     * </li>
     * </ul>
     * 
     * @return The resource type of the indexed recovery point.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EBS</code> for Amazon Elastic Block Store
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
     *         </p>
     *         </li>
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The date and time that a backup index was created, in Unix format and Coordinated Universal Time (UTC). The value
     * of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a backup index was created, in Unix format and Coordinated Universal Time (UTC).
     *         The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant indexCreationDate() {
        return indexCreationDate;
    }

    /**
     * <p>
     * This is the current status for the backup index associated with the specified recovery point.
     * </p>
     * <p>
     * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     * </p>
     * <p>
     * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return This is the current status for the backup index associated with the specified recovery point.</p>
     *         <p>
     *         Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     *         </p>
     *         <p>
     *         A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * @see IndexStatus
     */
    public final IndexStatus indexStatus() {
        return IndexStatus.fromValue(indexStatus);
    }

    /**
     * <p>
     * This is the current status for the backup index associated with the specified recovery point.
     * </p>
     * <p>
     * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     * </p>
     * <p>
     * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return This is the current status for the backup index associated with the specified recovery point.</p>
     *         <p>
     *         Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     *         </p>
     *         <p>
     *         A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * @see IndexStatus
     */
    public final String indexStatusAsString() {
        return indexStatus;
    }

    /**
     * <p>
     * A string in the form of a detailed message explaining the status of a backup index associated with the recovery
     * point.
     * </p>
     * 
     * @return A string in the form of a detailed message explaining the status of a backup index associated with the
     *         recovery point.
     */
    public final String indexStatusMessage() {
        return indexStatusMessage;
    }

    /**
     * <p>
     * An ARN that uniquely identifies the backup vault where the recovery point index is stored.
     * </p>
     * <p>
     * For example, <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies the backup vault where the recovery point index is stored.</p>
     *         <p>
     *         For example, <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>.
     */
    public final String backupVaultArn() {
        return backupVaultArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(indexCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexedRecoveryPoint)) {
            return false;
        }
        IndexedRecoveryPoint other = (IndexedRecoveryPoint) obj;
        return Objects.equals(recoveryPointArn(), other.recoveryPointArn())
                && Objects.equals(sourceResourceArn(), other.sourceResourceArn())
                && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(backupCreationDate(), other.backupCreationDate())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(indexCreationDate(), other.indexCreationDate())
                && Objects.equals(indexStatusAsString(), other.indexStatusAsString())
                && Objects.equals(indexStatusMessage(), other.indexStatusMessage())
                && Objects.equals(backupVaultArn(), other.backupVaultArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndexedRecoveryPoint").add("RecoveryPointArn", recoveryPointArn())
                .add("SourceResourceArn", sourceResourceArn()).add("IamRoleArn", iamRoleArn())
                .add("BackupCreationDate", backupCreationDate()).add("ResourceType", resourceType())
                .add("IndexCreationDate", indexCreationDate()).add("IndexStatus", indexStatusAsString())
                .add("IndexStatusMessage", indexStatusMessage()).add("BackupVaultArn", backupVaultArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "SourceResourceArn":
            return Optional.ofNullable(clazz.cast(sourceResourceArn()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "BackupCreationDate":
            return Optional.ofNullable(clazz.cast(backupCreationDate()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "IndexCreationDate":
            return Optional.ofNullable(clazz.cast(indexCreationDate()));
        case "IndexStatus":
            return Optional.ofNullable(clazz.cast(indexStatusAsString()));
        case "IndexStatusMessage":
            return Optional.ofNullable(clazz.cast(indexStatusMessage()));
        case "BackupVaultArn":
            return Optional.ofNullable(clazz.cast(backupVaultArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("SourceResourceArn", SOURCE_RESOURCE_ARN_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("BackupCreationDate", BACKUP_CREATION_DATE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("IndexCreationDate", INDEX_CREATION_DATE_FIELD);
        map.put("IndexStatus", INDEX_STATUS_FIELD);
        map.put("IndexStatusMessage", INDEX_STATUS_MESSAGE_FIELD);
        map.put("BackupVaultArn", BACKUP_VAULT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndexedRecoveryPoint, T> g) {
        return obj -> g.apply((IndexedRecoveryPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndexedRecoveryPoint> {
        /**
         * <p>
         * An ARN that uniquely identifies a recovery point; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         * </p>
         * 
         * @param recoveryPointArn
         *        An ARN that uniquely identifies a recovery point; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * A string of the Amazon Resource Name (ARN) that uniquely identifies the source resource.
         * </p>
         * 
         * @param sourceResourceArn
         *        A string of the Amazon Resource Name (ARN) that uniquely identifies the source resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceResourceArn(String sourceResourceArn);

        /**
         * <p>
         * This specifies the IAM role ARN used for this operation.
         * </p>
         * <p>
         * For example, arn:aws:iam::123456789012:role/S3Access
         * </p>
         * 
         * @param iamRoleArn
         *        This specifies the IAM role ARN used for this operation.</p>
         *        <p>
         *        For example, arn:aws:iam::123456789012:role/S3Access
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The date and time that a backup was created, in Unix format and Coordinated Universal Time (UTC). The value
         * of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param backupCreationDate
         *        The date and time that a backup was created, in Unix format and Coordinated Universal Time (UTC). The
         *        value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         *        represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupCreationDate(Instant backupCreationDate);

        /**
         * <p>
         * The resource type of the indexed recovery point.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EBS</code> for Amazon Elastic Block Store
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The resource type of the indexed recovery point.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EBS</code> for Amazon Elastic Block Store
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The date and time that a backup index was created, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param indexCreationDate
         *        The date and time that a backup index was created, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexCreationDate(Instant indexCreationDate);

        /**
         * <p>
         * This is the current status for the backup index associated with the specified recovery point.
         * </p>
         * <p>
         * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         * </p>
         * <p>
         * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * </p>
         * 
         * @param indexStatus
         *        This is the current status for the backup index associated with the specified recovery point.</p>
         *        <p>
         *        Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         *        </p>
         *        <p>
         *        A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(String indexStatus);

        /**
         * <p>
         * This is the current status for the backup index associated with the specified recovery point.
         * </p>
         * <p>
         * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         * </p>
         * <p>
         * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * </p>
         * 
         * @param indexStatus
         *        This is the current status for the backup index associated with the specified recovery point.</p>
         *        <p>
         *        Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         *        </p>
         *        <p>
         *        A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(IndexStatus indexStatus);

        /**
         * <p>
         * A string in the form of a detailed message explaining the status of a backup index associated with the
         * recovery point.
         * </p>
         * 
         * @param indexStatusMessage
         *        A string in the form of a detailed message explaining the status of a backup index associated with the
         *        recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexStatusMessage(String indexStatusMessage);

        /**
         * <p>
         * An ARN that uniquely identifies the backup vault where the recovery point index is stored.
         * </p>
         * <p>
         * For example, <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>.
         * </p>
         * 
         * @param backupVaultArn
         *        An ARN that uniquely identifies the backup vault where the recovery point index is stored.</p>
         *        <p>
         *        For example, <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultArn(String backupVaultArn);
    }

    static final class BuilderImpl implements Builder {
        private String recoveryPointArn;

        private String sourceResourceArn;

        private String iamRoleArn;

        private Instant backupCreationDate;

        private String resourceType;

        private Instant indexCreationDate;

        private String indexStatus;

        private String indexStatusMessage;

        private String backupVaultArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexedRecoveryPoint model) {
            recoveryPointArn(model.recoveryPointArn);
            sourceResourceArn(model.sourceResourceArn);
            iamRoleArn(model.iamRoleArn);
            backupCreationDate(model.backupCreationDate);
            resourceType(model.resourceType);
            indexCreationDate(model.indexCreationDate);
            indexStatus(model.indexStatus);
            indexStatusMessage(model.indexStatusMessage);
            backupVaultArn(model.backupVaultArn);
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getSourceResourceArn() {
            return sourceResourceArn;
        }

        public final void setSourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
        }

        @Override
        public final Builder sourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Instant getBackupCreationDate() {
            return backupCreationDate;
        }

        public final void setBackupCreationDate(Instant backupCreationDate) {
            this.backupCreationDate = backupCreationDate;
        }

        @Override
        public final Builder backupCreationDate(Instant backupCreationDate) {
            this.backupCreationDate = backupCreationDate;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Instant getIndexCreationDate() {
            return indexCreationDate;
        }

        public final void setIndexCreationDate(Instant indexCreationDate) {
            this.indexCreationDate = indexCreationDate;
        }

        @Override
        public final Builder indexCreationDate(Instant indexCreationDate) {
            this.indexCreationDate = indexCreationDate;
            return this;
        }

        public final String getIndexStatus() {
            return indexStatus;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final String getIndexStatusMessage() {
            return indexStatusMessage;
        }

        public final void setIndexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
        }

        @Override
        public final Builder indexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
            return this;
        }

        public final String getBackupVaultArn() {
            return backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        @Override
        public IndexedRecoveryPoint build() {
            return new IndexedRecoveryPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
