/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBackupPlanVersionsResponse extends BackupResponse implements
        ToCopyableBuilder<ListBackupPlanVersionsResponse.Builder, ListBackupPlanVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBackupPlanVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<BackupPlansListMember>> BACKUP_PLAN_VERSIONS_LIST_FIELD = SdkField
            .<List<BackupPlansListMember>> builder(MarshallingType.LIST)
            .memberName("BackupPlanVersionsList")
            .getter(getter(ListBackupPlanVersionsResponse::backupPlanVersionsList))
            .setter(setter(Builder::backupPlanVersionsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanVersionsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackupPlansListMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackupPlansListMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            BACKUP_PLAN_VERSIONS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<BackupPlansListMember> backupPlanVersionsList;

    private ListBackupPlanVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.backupPlanVersionsList = builder.backupPlanVersionsList;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BackupPlanVersionsList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBackupPlanVersionsList() {
        return backupPlanVersionsList != null && !(backupPlanVersionsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of version list items containing metadata about your backup plans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupPlanVersionsList} method.
     * </p>
     * 
     * @return An array of version list items containing metadata about your backup plans.
     */
    public final List<BackupPlansListMember> backupPlanVersionsList() {
        return backupPlanVersionsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupPlanVersionsList() ? backupPlanVersionsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupPlanVersionsResponse)) {
            return false;
        }
        ListBackupPlanVersionsResponse other = (ListBackupPlanVersionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasBackupPlanVersionsList() == other.hasBackupPlanVersionsList()
                && Objects.equals(backupPlanVersionsList(), other.backupPlanVersionsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBackupPlanVersionsResponse").add("NextToken", nextToken())
                .add("BackupPlanVersionsList", hasBackupPlanVersionsList() ? backupPlanVersionsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "BackupPlanVersionsList":
            return Optional.ofNullable(clazz.cast(backupPlanVersionsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("BackupPlanVersionsList", BACKUP_PLAN_VERSIONS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBackupPlanVersionsResponse, T> g) {
        return obj -> g.apply((ListBackupPlanVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBackupPlanVersionsResponse> {
        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of version list items containing metadata about your backup plans.
         * </p>
         * 
         * @param backupPlanVersionsList
         *        An array of version list items containing metadata about your backup plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanVersionsList(Collection<BackupPlansListMember> backupPlanVersionsList);

        /**
         * <p>
         * An array of version list items containing metadata about your backup plans.
         * </p>
         * 
         * @param backupPlanVersionsList
         *        An array of version list items containing metadata about your backup plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanVersionsList(BackupPlansListMember... backupPlanVersionsList);

        /**
         * <p>
         * An array of version list items containing metadata about your backup plans.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.BackupPlansListMember.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.backup.model.BackupPlansListMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.BackupPlansListMember.Builder#build()} is called
         * immediately and its result is passed to {@link #backupPlanVersionsList(List<BackupPlansListMember>)}.
         * 
         * @param backupPlanVersionsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.BackupPlansListMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupPlanVersionsList(java.util.Collection<BackupPlansListMember>)
         */
        Builder backupPlanVersionsList(Consumer<BackupPlansListMember.Builder>... backupPlanVersionsList);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<BackupPlansListMember> backupPlanVersionsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupPlanVersionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            backupPlanVersionsList(model.backupPlanVersionsList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BackupPlansListMember.Builder> getBackupPlanVersionsList() {
            List<BackupPlansListMember.Builder> result = BackupPlanVersionsListCopier.copyToBuilder(this.backupPlanVersionsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackupPlanVersionsList(Collection<BackupPlansListMember.BuilderImpl> backupPlanVersionsList) {
            this.backupPlanVersionsList = BackupPlanVersionsListCopier.copyFromBuilder(backupPlanVersionsList);
        }

        @Override
        public final Builder backupPlanVersionsList(Collection<BackupPlansListMember> backupPlanVersionsList) {
            this.backupPlanVersionsList = BackupPlanVersionsListCopier.copy(backupPlanVersionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlanVersionsList(BackupPlansListMember... backupPlanVersionsList) {
            backupPlanVersionsList(Arrays.asList(backupPlanVersionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlanVersionsList(Consumer<BackupPlansListMember.Builder>... backupPlanVersionsList) {
            backupPlanVersionsList(Stream.of(backupPlanVersionsList)
                    .map(c -> BackupPlansListMember.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBackupPlanVersionsResponse build() {
            return new ListBackupPlanVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
