/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReportJobsResponse extends BackupResponse implements
        ToCopyableBuilder<ListReportJobsResponse.Builder, ListReportJobsResponse> {
    private static final SdkField<List<ReportJob>> REPORT_JOBS_FIELD = SdkField
            .<List<ReportJob>> builder(MarshallingType.LIST)
            .memberName("ReportJobs")
            .getter(getter(ListReportJobsResponse::reportJobs))
            .setter(setter(Builder::reportJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReportJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReportJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListReportJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ReportJob> reportJobs;

    private final String nextToken;

    private ListReportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.reportJobs = builder.reportJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReportJobs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReportJobs() {
        return reportJobs != null && !(reportJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about your report jobs in JSON format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReportJobs} method.
     * </p>
     * 
     * @return Details about your report jobs in JSON format.
     */
    public final List<ReportJob> reportJobs() {
        return reportJobs;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReportJobs() ? reportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportJobsResponse)) {
            return false;
        }
        ListReportJobsResponse other = (ListReportJobsResponse) obj;
        return hasReportJobs() == other.hasReportJobs() && Objects.equals(reportJobs(), other.reportJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReportJobsResponse").add("ReportJobs", hasReportJobs() ? reportJobs() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportJobs":
            return Optional.ofNullable(clazz.cast(reportJobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReportJobs", REPORT_JOBS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReportJobsResponse, T> g) {
        return obj -> g.apply((ListReportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListReportJobsResponse> {
        /**
         * <p>
         * Details about your report jobs in JSON format.
         * </p>
         * 
         * @param reportJobs
         *        Details about your report jobs in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportJobs(Collection<ReportJob> reportJobs);

        /**
         * <p>
         * Details about your report jobs in JSON format.
         * </p>
         * 
         * @param reportJobs
         *        Details about your report jobs in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportJobs(ReportJob... reportJobs);

        /**
         * <p>
         * Details about your report jobs in JSON format.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.ReportJob.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.backup.model.ReportJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.ReportJob.Builder#build()} is called immediately and its
         * result is passed to {@link #reportJobs(List<ReportJob>)}.
         * 
         * @param reportJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.ReportJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportJobs(java.util.Collection<ReportJob>)
         */
        Builder reportJobs(Consumer<ReportJob.Builder>... reportJobs);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private List<ReportJob> reportJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReportJobsResponse model) {
            super(model);
            reportJobs(model.reportJobs);
            nextToken(model.nextToken);
        }

        public final List<ReportJob.Builder> getReportJobs() {
            List<ReportJob.Builder> result = ReportJobListCopier.copyToBuilder(this.reportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReportJobs(Collection<ReportJob.BuilderImpl> reportJobs) {
            this.reportJobs = ReportJobListCopier.copyFromBuilder(reportJobs);
        }

        @Override
        public final Builder reportJobs(Collection<ReportJob> reportJobs) {
            this.reportJobs = ReportJobListCopier.copy(reportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportJobs(ReportJob... reportJobs) {
            reportJobs(Arrays.asList(reportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportJobs(Consumer<ReportJob.Builder>... reportJobs) {
            reportJobs(Stream.of(reportJobs).map(c -> ReportJob.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReportJobsResponse build() {
            return new ListReportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
