/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRestoreJobsByProtectedResourceRequest extends BackupRequest implements
        ToCopyableBuilder<ListRestoreJobsByProtectedResourceRequest.Builder, ListRestoreJobsByProtectedResourceRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(ListRestoreJobsByProtectedResourceRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceArn").build()).build();

    private static final SdkField<String> BY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByStatus").getter(getter(ListRestoreJobsByProtectedResourceRequest::byStatusAsString))
            .setter(setter(Builder::byStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<Instant> BY_RECOVERY_POINT_CREATION_DATE_AFTER_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ByRecoveryPointCreationDateAfter")
            .getter(getter(ListRestoreJobsByProtectedResourceRequest::byRecoveryPointCreationDateAfter))
            .setter(setter(Builder::byRecoveryPointCreationDateAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recoveryPointCreationDateAfter")
                    .build()).build();

    private static final SdkField<Instant> BY_RECOVERY_POINT_CREATION_DATE_BEFORE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ByRecoveryPointCreationDateBefore")
            .getter(getter(ListRestoreJobsByProtectedResourceRequest::byRecoveryPointCreationDateBefore))
            .setter(setter(Builder::byRecoveryPointCreationDateBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM)
                    .locationName("recoveryPointCreationDateBefore").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRestoreJobsByProtectedResourceRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListRestoreJobsByProtectedResourceRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            BY_STATUS_FIELD, BY_RECOVERY_POINT_CREATION_DATE_AFTER_FIELD, BY_RECOVERY_POINT_CREATION_DATE_BEFORE_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceArn;

    private final String byStatus;

    private final Instant byRecoveryPointCreationDateAfter;

    private final Instant byRecoveryPointCreationDateBefore;

    private final String nextToken;

    private final Integer maxResults;

    private ListRestoreJobsByProtectedResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.byStatus = builder.byStatus;
        this.byRecoveryPointCreationDateAfter = builder.byRecoveryPointCreationDateAfter;
        this.byRecoveryPointCreationDateBefore = builder.byRecoveryPointCreationDateBefore;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Returns only restore jobs that match the specified resource Amazon Resource Name (ARN).
     * </p>
     * 
     * @return Returns only restore jobs that match the specified resource Amazon Resource Name (ARN).
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Returns only restore jobs associated with the specified job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byStatus} will
     * return {@link RestoreJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byStatusAsString}.
     * </p>
     * 
     * @return Returns only restore jobs associated with the specified job status.
     * @see RestoreJobStatus
     */
    public final RestoreJobStatus byStatus() {
        return RestoreJobStatus.fromValue(byStatus);
    }

    /**
     * <p>
     * Returns only restore jobs associated with the specified job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byStatus} will
     * return {@link RestoreJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byStatusAsString}.
     * </p>
     * 
     * @return Returns only restore jobs associated with the specified job status.
     * @see RestoreJobStatus
     */
    public final String byStatusAsString() {
        return byStatus;
    }

    /**
     * <p>
     * Returns only restore jobs of recovery points that were created after the specified date.
     * </p>
     * 
     * @return Returns only restore jobs of recovery points that were created after the specified date.
     */
    public final Instant byRecoveryPointCreationDateAfter() {
        return byRecoveryPointCreationDateAfter;
    }

    /**
     * <p>
     * Returns only restore jobs of recovery points that were created before the specified date.
     * </p>
     * 
     * @return Returns only restore jobs of recovery points that were created before the specified date.
     */
    public final Instant byRecoveryPointCreationDateBefore() {
        return byRecoveryPointCreationDateBefore;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request ismade to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request ismade to return
     *         <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to be returned.
     * </p>
     * 
     * @return The maximum number of items to be returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(byStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(byRecoveryPointCreationDateAfter());
        hashCode = 31 * hashCode + Objects.hashCode(byRecoveryPointCreationDateBefore());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRestoreJobsByProtectedResourceRequest)) {
            return false;
        }
        ListRestoreJobsByProtectedResourceRequest other = (ListRestoreJobsByProtectedResourceRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(byStatusAsString(), other.byStatusAsString())
                && Objects.equals(byRecoveryPointCreationDateAfter(), other.byRecoveryPointCreationDateAfter())
                && Objects.equals(byRecoveryPointCreationDateBefore(), other.byRecoveryPointCreationDateBefore())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRestoreJobsByProtectedResourceRequest").add("ResourceArn", resourceArn())
                .add("ByStatus", byStatusAsString()).add("ByRecoveryPointCreationDateAfter", byRecoveryPointCreationDateAfter())
                .add("ByRecoveryPointCreationDateBefore", byRecoveryPointCreationDateBefore()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ByStatus":
            return Optional.ofNullable(clazz.cast(byStatusAsString()));
        case "ByRecoveryPointCreationDateAfter":
            return Optional.ofNullable(clazz.cast(byRecoveryPointCreationDateAfter()));
        case "ByRecoveryPointCreationDateBefore":
            return Optional.ofNullable(clazz.cast(byRecoveryPointCreationDateBefore()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("status", BY_STATUS_FIELD);
        map.put("recoveryPointCreationDateAfter", BY_RECOVERY_POINT_CREATION_DATE_AFTER_FIELD);
        map.put("recoveryPointCreationDateBefore", BY_RECOVERY_POINT_CREATION_DATE_BEFORE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRestoreJobsByProtectedResourceRequest, T> g) {
        return obj -> g.apply((ListRestoreJobsByProtectedResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRestoreJobsByProtectedResourceRequest> {
        /**
         * <p>
         * Returns only restore jobs that match the specified resource Amazon Resource Name (ARN).
         * </p>
         * 
         * @param resourceArn
         *        Returns only restore jobs that match the specified resource Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Returns only restore jobs associated with the specified job status.
         * </p>
         * 
         * @param byStatus
         *        Returns only restore jobs associated with the specified job status.
         * @see RestoreJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestoreJobStatus
         */
        Builder byStatus(String byStatus);

        /**
         * <p>
         * Returns only restore jobs associated with the specified job status.
         * </p>
         * 
         * @param byStatus
         *        Returns only restore jobs associated with the specified job status.
         * @see RestoreJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestoreJobStatus
         */
        Builder byStatus(RestoreJobStatus byStatus);

        /**
         * <p>
         * Returns only restore jobs of recovery points that were created after the specified date.
         * </p>
         * 
         * @param byRecoveryPointCreationDateAfter
         *        Returns only restore jobs of recovery points that were created after the specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byRecoveryPointCreationDateAfter(Instant byRecoveryPointCreationDateAfter);

        /**
         * <p>
         * Returns only restore jobs of recovery points that were created before the specified date.
         * </p>
         * 
         * @param byRecoveryPointCreationDateBefore
         *        Returns only restore jobs of recovery points that were created before the specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byRecoveryPointCreationDateBefore(Instant byRecoveryPointCreationDateBefore);

        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request ismade to return
         * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request ismade to return
         *        <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to be returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private String byStatus;

        private Instant byRecoveryPointCreationDateAfter;

        private Instant byRecoveryPointCreationDateBefore;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRestoreJobsByProtectedResourceRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            byStatus(model.byStatus);
            byRecoveryPointCreationDateAfter(model.byRecoveryPointCreationDateAfter);
            byRecoveryPointCreationDateBefore(model.byRecoveryPointCreationDateBefore);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getByStatus() {
            return byStatus;
        }

        public final void setByStatus(String byStatus) {
            this.byStatus = byStatus;
        }

        @Override
        public final Builder byStatus(String byStatus) {
            this.byStatus = byStatus;
            return this;
        }

        @Override
        public final Builder byStatus(RestoreJobStatus byStatus) {
            this.byStatus(byStatus == null ? null : byStatus.toString());
            return this;
        }

        public final Instant getByRecoveryPointCreationDateAfter() {
            return byRecoveryPointCreationDateAfter;
        }

        public final void setByRecoveryPointCreationDateAfter(Instant byRecoveryPointCreationDateAfter) {
            this.byRecoveryPointCreationDateAfter = byRecoveryPointCreationDateAfter;
        }

        @Override
        public final Builder byRecoveryPointCreationDateAfter(Instant byRecoveryPointCreationDateAfter) {
            this.byRecoveryPointCreationDateAfter = byRecoveryPointCreationDateAfter;
            return this;
        }

        public final Instant getByRecoveryPointCreationDateBefore() {
            return byRecoveryPointCreationDateBefore;
        }

        public final void setByRecoveryPointCreationDateBefore(Instant byRecoveryPointCreationDateBefore) {
            this.byRecoveryPointCreationDateBefore = byRecoveryPointCreationDateBefore;
        }

        @Override
        public final Builder byRecoveryPointCreationDateBefore(Instant byRecoveryPointCreationDateBefore) {
            this.byRecoveryPointCreationDateBefore = byRecoveryPointCreationDateBefore;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRestoreJobsByProtectedResourceRequest build() {
            return new ListRestoreJobsByProtectedResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
